/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.loan.Loan;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.verbisbox.VerbisboxSecurityActions;
import cz.kpsys.portaro.verbisbox.shipment.ShipmentApiController;
import cz.kpsys.portaro.verbisbox.state.ToViewableStationStateConverter;
import cz.kpsys.portaro.verbisbox.station.BoxStation;
import cz.kpsys.portaro.verbisbox.station.BoxStationApiController;
import cz.kpsys.portaro.verbisbox.station.BoxStationEntity;
import cz.kpsys.portaro.verbisbox.station.BoxStationFinder;
import cz.kpsys.portaro.verbisbox.station.EntitiesToBoxStationsConverter;
import cz.kpsys.portaro.verbisbox.station.FullScanningBoxStationFinder;
import cz.kpsys.portaro.verbisboxer.manager.ContextualVerbisboxerManagerApiClient;
import cz.kpsys.portaro.verbisboxer.manager.VerbisboxerManagerApiSettingKeys;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class BoxConfig {
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, Loan> loanSearchLoader;
    @NonNull
    private final ContextualVerbisboxerManagerApiClient<Department> contextualVerbisboxerManagerApiClient;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final DepartmentAccessor departmentAccessor;

    @Bean
    public BoxStationApiController boxStationApiController() {
        return new BoxStationApiController(this.boxStationCodebook(), this.contextualVerbisboxerManagerApiClient, (Converter)this.toViewableStationStateConverter(), this.securityManager);
    }

    @Bean
    public ShipmentApiController shipmentApiController() {
        return new ShipmentApiController(this.loanSearchLoader);
    }

    @Bean
    public BoxStationFinder boxStationFinder() {
        return new FullScanningBoxStationFinder((AllValuesProvider)this.boxStationCodebook());
    }

    @Bean
    public Codebook<BoxStation, UUID> boxStationCodebook() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(BoxStationEntity.class).converted((Converter)new EntitiesToBoxStationsConverter(this.departmentLoader)).staticCached(BoxStation.class.getSimpleName()).build();
    }

    @Bean
    ToViewableStationStateConverter toViewableStationStateConverter() {
        return new ToViewableStationStateConverter(this.loanSearchLoader);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForUuidId(BoxStation.class, (ByIdLoadable)this.boxStationCodebook());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(VerbisboxSecurityActions.BOX_STATIONS_SHOW, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.enabled(this.settingLoader.getDepartmentedProvider(VerbisboxerManagerApiSettingKeys.VERBISBOXER_ENABLED), Texts.ofNative((String)"Verbisbox is not enabled")), this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"})}));
        this.permissionRegistry.add(VerbisboxSecurityActions.BOX_STATION_SHOW, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.enabled(this.settingLoader.getDepartmentedProvider(VerbisboxerManagerApiSettingKeys.VERBISBOXER_ENABLED), Texts.ofNative((String)"Verbisbox is not enabled")), this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}), (auth, ctx, boxStation) -> PermissionResult.ifCan((boolean)this.departmentAccessor.getAllSubdepartmentsIncludingThis(ctx).contains(boxStation.getDepartment()))}));
    }

    @ConstructorProperties(value={"converterRegisterer", "codebookLoaderBuilderFactory", "departmentLoader", "loanSearchLoader", "contextualVerbisboxerManagerApiClient", "permissionRegistry", "securityManager", "settingLoader", "permissionFactory", "departmentAccessor"})
    @Generated
    public BoxConfig(@NonNull ConverterRegisterer converterRegisterer, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, Loan> loanSearchLoader, @NonNull ContextualVerbisboxerManagerApiClient<Department> contextualVerbisboxerManagerApiClient, @NonNull PermissionRegistry permissionRegistry, @NonNull SecurityManager securityManager, @NonNull SettingLoader settingLoader, @NonNull PermissionFactory permissionFactory, @NonNull DepartmentAccessor departmentAccessor) {
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(loanSearchLoader, "loanSearchLoader is marked non-null but is null");
        Objects.requireNonNull(contextualVerbisboxerManagerApiClient, "contextualVerbisboxerManagerApiClient is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        this.converterRegisterer = converterRegisterer;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.departmentLoader = departmentLoader;
        this.loanSearchLoader = loanSearchLoader;
        this.contextualVerbisboxerManagerApiClient = contextualVerbisboxerManagerApiClient;
        this.permissionRegistry = permissionRegistry;
        this.securityManager = securityManager;
        this.settingLoader = settingLoader;
        this.permissionFactory = permissionFactory;
        this.departmentAccessor = departmentAccessor;
    }
}

