/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.acquisition.EntitiesToOrderItemsConverter;
import cz.kpsys.portaro.acquisition.EntitiesToRecordDemandsConverter;
import cz.kpsys.portaro.acquisition.OrderItemLoader;
import cz.kpsys.portaro.acquisition.RecordDemand;
import cz.kpsys.portaro.acquisition.RecordDemandEntity;
import cz.kpsys.portaro.acquisition.RecordDemandToEntityConverter;
import cz.kpsys.portaro.acquisition.SpringDbOrderItemLoader;
import cz.kpsys.portaro.acquisition.SpringDbRecordDemandIdSearchLoader;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.DefaultProvider;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.exemplar.account.Account;
import cz.kpsys.portaro.exemplar.volume.Volume;
import cz.kpsys.portaro.finance.Currency;
import cz.kpsys.portaro.finance.CurrencyEntity;
import cz.kpsys.portaro.finance.EntityToCurrencyConverter;
import cz.kpsys.portaro.record.authority.RichAuthority;
import cz.kpsys.portaro.record.document.RichDocument;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.sec.SecurityActions;
import cz.kpsys.portaro.view.web.rest.OrderItemApiController;
import cz.kpsys.portaro.view.web.rest.RecordDemandApiController;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class AcquisitionConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AcquisitionConfig.class);
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final AllByIdsLoadable<RichDocument, Integer> nonDetailedDocumentByKindedIdLoader;
    @NonNull
    private final AllByIdsLoadable<RichDocument, UUID> nonDetailedDocumentLoader;
    @NonNull
    private final AllByIdsLoadable<Volume, Integer> volumeLoader;
    @NonNull
    private final AllByIdsLoadable<RichAuthority, Integer> authorityByKindedIdLoader;
    @NonNull
    private final IdAndIdsLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final ByIdLoadable<Account, String> accountLoader;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final SaverBuilderFactory saverBuilderFactory;

    @Bean
    public OrderItemApiController orderItemApiController() {
        return new OrderItemApiController((IdAndIdsLoadable)this.orderItemLoader());
    }

    @Bean
    public RecordDemandApiController recordDemandApiController() {
        return new RecordDemandApiController((ByIdLoadable)this.recordDemandLoader(), this.recordDemandSaver());
    }

    @Bean
    public OrderItemLoader orderItemLoader() {
        return new SpringDbOrderItemLoader(this.jdbcTemplate, this.queryFactory, (ByIdLoadable)this.currencyLoader(), (Converter)new EntitiesToOrderItemsConverter(this.nonDetailedDocumentByKindedIdLoader, this.authorityByKindedIdLoader, this.accountLoader, this.volumeLoader));
    }

    @Bean
    public Provider<Currency> defaultCurrencyProvider() {
        return DefaultProvider.byId((AllValuesProvider)this.currencyLoader(), (Object)"CZK");
    }

    @Bean
    public Codebook<Currency, String> currencyLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(CurrencyEntity.class).convertedEachBy((Converter)new EntityToCurrencyConverter()).staticCached(Currency.class.getSimpleName()).build();
    }

    @Bean
    public IdAndIdsLoadable<RecordDemand, UUID> recordDemandLoader() {
        EntitiesToRecordDemandsConverter modelsFromDtosConverter = new EntitiesToRecordDemandsConverter(this.nonDetailedDocumentLoader, this.departmentLoader, (AllByIdsLoadable)this.basicUserLoader, this.volumeLoader, (AllByIdsLoadable)this.orderItemLoader());
        return this.modelBeanBuilder.allByIdsLoader(RecordDemandEntity.class, (Converter)modelsFromDtosConverter).build();
    }

    @Bean
    public Saver<RecordDemand> recordDemandSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new RecordDemandToEntityConverter()).withClearedCacheName(RecordDemandEntity.class.getSimpleName()).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, UUID> recordDemandIdSearchLoader() {
        return this.modelBeanBuilder.idSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)new SpringDbRecordDemandIdSearchLoader(this.jdbcTemplate, this.queryFactory)).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, RecordDemand> recordDemandSearchLoader() {
        return this.modelBeanBuilder.modelSearchLoaderByIdSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)this.recordDemandIdSearchLoader(), (AllByIdsLoadable)this.recordDemandLoader()).build();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerExports() {
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(SecurityActions.TENDERS_USE, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_ADMIN", "ROLE_SUPPLIER"}));
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "permissionRegistry", "permissionFactory", "nonDetailedDocumentByKindedIdLoader", "nonDetailedDocumentLoader", "volumeLoader", "authorityByKindedIdLoader", "basicUserLoader", "departmentLoader", "accountLoader", "modelBeanBuilder", "codebookLoaderBuilderFactory", "saverBuilderFactory"})
    @Generated
    public AcquisitionConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull AllByIdsLoadable<RichDocument, Integer> nonDetailedDocumentByKindedIdLoader, @NonNull AllByIdsLoadable<RichDocument, UUID> nonDetailedDocumentLoader, @NonNull AllByIdsLoadable<Volume, Integer> volumeLoader, @NonNull AllByIdsLoadable<RichAuthority, Integer> authorityByKindedIdLoader, @NonNull IdAndIdsLoadable<BasicUser, Integer> basicUserLoader, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull ByIdLoadable<Account, String> accountLoader, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull SaverBuilderFactory saverBuilderFactory) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentByKindedIdLoader, "nonDetailedDocumentByKindedIdLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentLoader, "nonDetailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(volumeLoader, "volumeLoader is marked non-null but is null");
        Objects.requireNonNull(authorityByKindedIdLoader, "authorityByKindedIdLoader is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(accountLoader, "accountLoader is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(saverBuilderFactory, "saverBuilderFactory is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.nonDetailedDocumentByKindedIdLoader = nonDetailedDocumentByKindedIdLoader;
        this.nonDetailedDocumentLoader = nonDetailedDocumentLoader;
        this.volumeLoader = volumeLoader;
        this.authorityByKindedIdLoader = authorityByKindedIdLoader;
        this.basicUserLoader = basicUserLoader;
        this.departmentLoader = departmentLoader;
        this.accountLoader = accountLoader;
        this.modelBeanBuilder = modelBeanBuilder;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.saverBuilderFactory = saverBuilderFactory;
    }
}

