/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro;

import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.PortaroUpdaterApplication;
import cz.kpsys.portaro.PortaroWebApplication;
import cz.kpsys.portaro.cmd.RunConfiguration;
import cz.kpsys.portaro.resourcesupdate.TextualInteractiveUpdater;
import java.security.Security;
import java.util.Arrays;
import java.util.TimeZone;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class PortaroApplication {
    public static void main(String[] args) {
        System.out.println("================================================================================");
        System.out.println("Starting Portaro with args " + Arrays.toString(args));
        System.out.println("================================================================================");
        Security.setProperty("networkaddress.cache.ttl", "60");
        Security.setProperty("networkaddress.cache.negative.ttl", "10");
        TimeZone.setDefault(CoreConstants.CZECH_TIME_ZONE);
        RunConfiguration run = RunConfiguration.parseMainArgs((String[])args);
        if (run.isClassicServer()) {
            PortaroApplication.runClassicPortaro((String[])args);
        } else if (run.isUpdateGlobal()) {
            PortaroApplication.runUpdateGlobal((String[])args);
        } else if (run.isUpdateTo20()) {
            PortaroApplication.runUpdateTo20((String[])args);
        }
    }

    private static void runClassicPortaro(String[] args) {
        new SpringApplicationBuilder(new Class[0]).web(WebApplicationType.SERVLET).main(PortaroApplication.class).sources(new Class[]{PortaroWebApplication.class}).profiles(new String[]{"portaro-web", "embedded-server"}).run(args);
    }

    private static void runUpdateGlobal(String[] args) {
        ConfigurableApplicationContext ctx = new SpringApplicationBuilder(new Class[0]).web(WebApplicationType.NONE).main(PortaroApplication.class).sources(new Class[]{PortaroUpdaterApplication.class}).profiles(new String[]{"update", "update-global"}).run(args);
        TextualInteractiveUpdater textualInteractiveUpdater = (TextualInteractiveUpdater)ctx.getBean("textualInteractiveUpdaterGlobal", TextualInteractiveUpdater.class);
        textualInteractiveUpdater.update();
    }

    private static void runUpdateTo20(String[] args) {
        ConfigurableApplicationContext ctx = new SpringApplicationBuilder(new Class[0]).web(WebApplicationType.NONE).main(PortaroApplication.class).sources(new Class[]{PortaroUpdaterApplication.class}).profiles(new String[]{"update", "update2"}).run(args);
        TextualInteractiveUpdater textualInteractiveUpdater = (TextualInteractiveUpdater)ctx.getBean("textualInteractiveUpdaterTo2_0", TextualInteractiveUpdater.class);
        textualInteractiveUpdater.update();
    }
}

