<#ftl outputFormat="HTML">
<#import "../../../freemarker/_localization.ftl" as loc>

<div class="container util normalniContentSMezerouNahore">
    <div class="panel panel-default">
        <div class="panel-heading">
            <h2 class="panel-title">Utility buttons</h2>
        </div>
        <div class="panel-body">
            <div>
                <div class="row">
                    <div class="col-md-12">
                        <kp-action-request-button css-class="btn btn-primary btn-sm" path-on-context="true" path="api/cache/invalidate-all">${loc.loc("util.smazCache")?noEsc}</kp-action-request-button>
                        <kp-action-request-button css-class="btn btn-primary btn-sm" path-on-context="true" path="api/acme/renew">Refresh https cert</kp-action-request-button>
                        <kp-action-request-button css-class="btn btn-primary btn-sm" path-on-context="true" path="api/licence/update">Refresh licence</kp-action-request-button>
                        <kp-action-request-button css-class="btn btn-primary btn-sm" path-on-context="true" path="api/jobs/datacopy/start" request-method="post">Start datacopy</kp-action-request-button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="panel panel-default">
        <div class="panel-heading">
            <h2 class="panel-title">External systems synchronization</h2>
        </div>
        <div class="panel-body">
            <div>
                <kp-action-request-button css-class="btn btn-primary btn-sm" path-on-context="true" path="api/sync/edupage" request-method="post">Edupage users sync</kp-action-request-button>
                <kp-action-request-button css-class="btn btn-primary btn-sm" path-on-context="true" path="api/sync/bakalari" request-method="post">Bakalari users sync</kp-action-request-button>
                <kp-action-request-button css-class="btn btn-primary btn-sm" path-on-context="true" path="api/sync/edookit" request-method="post">Edookit users sync</kp-action-request-button>
                <kp-action-request-button css-class="btn btn-primary btn-sm" path-on-context="true" path="api/sync/sol" request-method="post">Šol users sync</kp-action-request-button>
                <kp-action-request-button css-class="btn btn-primary btn-sm" path-on-context="true" path="api/sync/unis" request-method="post">Unis users sync</kp-action-request-button>
                <kp-action-request-button css-class="btn btn-primary btn-sm" path-on-context="true" path="api/sync/unob" request-method="post">Unob users sync</kp-action-request-button>
                <kp-action-request-button css-class="btn btn-primary btn-sm" path-on-context="true" path="api/sync/shipment-items" request-method="post">Shipment items sync</kp-action-request-button>
            </div>
        </div>
    </div>

    <div class="panel panel-default">
        <div class="panel-heading">
            <h2 class="panel-title">Import data</h2>
        </div>
        <div class="panel-body">
            <div>
                <kp-action-request-button css-class="btn btn-primary btn-sm" path-on-context="true" path="api/import" request-method="post">Import data</kp-action-request-button>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">

            <h2></h2>
            <table class="table table-condensed table-hover">
                <tr>
                    <td>${loc.loc("util.VerzePortara")?noEsc}</td>
                    <td colspan="2">
                        {{utilCtrl.state.version}} <br>
                        {{utilCtrl.state.versionDetail}}
                    </td>
                </tr>
                <tr>
                    <td>${loc.loc("util.VerzeAplikacnihoServeru")?noEsc}</td>
                    <td colspan="2">{{utilCtrl.state.appserverVersion}}</td>
                </tr>
                <tr>
                    <td>Licence</td>
                    <td>
                        url<br>
                        testing<br>
                        maintenance to<br>
                        licence version<br>
                        editorLimit<br>
                        documentLimit<br>
                        enabledModules
                    </td>
                    <td>
                        {{utilCtrl.state.licence.rootUrl}}<br>
                        {{utilCtrl.state.licence.testing && '✔' || '✘'}}<br>
                        {{utilCtrl.state.licence.maintenanceExpirationDate | jpDate:'d.M.yyyy'}}<br>
                        {{utilCtrl.state.licence.licenceVersion}}<br>
                        {{utilCtrl.state.licence.editorLimit || '✘'}}<br>
                        {{utilCtrl.state.licence.documentLimit || '✘'}}<br>
                        {{utilCtrl.state.licence.enabledModules | inline}}
                    </td>
                </tr>
                <tr>
                    <td>start time</td>
                    <td colspan="2">{{utilCtrl.state.startTime | date:'dd.MM.yyyy HH:mm:ss'}} ({{utilCtrl.state.runningDays | number:1}} dní provozu)</td>
                </tr>
                <tr>
                    <td>Database URL</td>
                    <td colspan="2">{{utilCtrl.state.databaseUrl}}</td>
                </tr>
                <tr>
                    <td>Appserver URL</td>
                    <td colspan="2">{{utilCtrl.state.appserverUrl}}</td>
                </tr>
                <tr>
                    <td>${loc.loc("util.maxPamet")?noEsc}</td>
                    <td colspan="2">{{utilCtrl.state.maxMemory | bytes}}</td>
                </tr>
                <tr>
                    <td>${loc.loc("util.alokovanaPamet")?noEsc}</td>
                    <td colspan="2">{{utilCtrl.state.totalMemory | bytes}}</td>
                </tr>
                <tr>
                    <td>${loc.loc("util.vyuzitaPamet")?noEsc}</td>
                    <td colspan="2">{{utilCtrl.state.usedMemory | bytes}}</td>
                </tr>
                <tr>
                    <td>${loc.loc("util.pocetProcesoru")?noEsc}</td>
                    <td colspan="2">{{utilCtrl.state.procesorsCount}}</td>
                </tr>
                <tr>
                    <td>OS</td>
                    <td colspan="2">{{utilCtrl.state.operatingSystem}}, arch {{utilCtrl.state.operatingSystemArchitecture}}</td>
                </tr>
                <tr>
                    <td>OS username</td>
                    <td colspan="2">{{utilCtrl.state.operatingSystemUsername}}</td>
                </tr>
                <tr>
                    <td>PID</td>
                    <td colspan="2">{{utilCtrl.state.processId}}</td>
                </tr>
                <tr>
                    <td>Java</td>
                    <td colspan="2">{{utilCtrl.state.javaVersion}} at {{utilCtrl.state.javaHome}}</td>
                </tr>
            </table>
        </div>
    </div>


    <div class="panel panel-default">
        <div class="panel-heading">
            <h2 class="panel-title">Updates</h2>
        </div>
        <div class="panel-body">
            <div>
                <kp-action-request-button path-on-context="true" path="/api/restart">Restart app</kp-action-request-button>
                <span class="text-muted">on Windows will also perform an update</span>
            </div>
        </div>
    </div>


    <div class="panel panel-default">
        <div class="panel-heading">
            <h2 class="panel-title">Cover searching</h2>
        </div>
        <div class="panel-body">
            <table class="table table-condensed table-hover">
                <thead>
                    <tr>
                        <th>Service</th>
                        <th>status</th>
                        <th>searched last time</th>
                        <th>found last time</th>
                        <th>last search start time</th>
                        <th>last search stop time</th>
                    </tr>
                </thead>
                <tbody>
                    <tr ng-repeat="state in utilCtrl.state.coverSearchState">
                        <td>{{state[0]}}</td>
                        <td>{{state[1]}}</td>
                        <td>{{state[2]}}</td>
                        <td>{{state[3]}}</td>
                        <td>{{state[4] | date:'dd.MM.yyyy HH:mm:ss'}}</td>
                        <td>{{state[5] | date:'dd.MM.yyyy HH:mm:ss'}}</td>
                    </tr>
                </tbody>
            </table>
            <div class="pull-right">
                <kp-action-request-button path-on-context="true" path="/api/cover-search/delete-unfound">Delete all unfound</kp-action-request-button>
            </div>
            <div class="btn-group">
                <kp-action-request-button path-on-context="true" path="/api/cover-search/run">Run cover searching</kp-action-request-button>
                <kp-action-request-button path-on-context="true" path="/api/cover-search/stop">Stop cover searching</kp-action-request-button>
            </div>
        </div>
    </div>


    <div class="panel panel-default" ng-if="utilCtrl.currentAuthService.hasRole('ROLE_ADMIN')">
        <div class="panel-heading">
            <h2 class="panel-title">Logging</h2>
        </div>
        <table class="table table-condensed table-hover">
            <tr ng-repeat="logger in utilCtrl.loggers">
                <td>{{logger.id}}</td>
                <td>
                    <label ng-repeat="level in ['TRACE', 'DEBUG', 'INFO', 'WARN']">
                        {{level}}
                        <input type="radio" ng-model="logger.level" ng-value="level" ng-change="utilCtrl.saveLogger(logger)">
                        &nbsp;&nbsp;
                    </label>
                </td>
                <td>
                    <span jp-loading="xs" ng-class="{'jp-hidden': logger.state !== 'PROCESSING'}"></span>
                </td>
            </tr>
        </table>
    </div>

    <div ng-if="utilCtrl.currentAuthService.hasRole('ROLE_ADMIN')">
        <div class="panel panel-default" ng-repeat="session in utilCtrl.activeClientSessions">
            <div class="panel-heading">
                <div class="pull-right">
                    {{session.currentDepartment | loc}}
                    |
                    {{session.creationDate | jpDate:'d.M. HH:mm:ss'}}
                </div>
                <div>
                    {{session.bot ? "BOT" : "NOTBOT"}} {{session.ipAdress.loopback ? "localhost" : session.ipAdress.value}}
                    <br>
                    {{session.userAgent}}
                </div>
            </div>
            <div class="panel-body">
                <p>
                    {{session.internalAccess ? "Uvnitř" : "Mimo"}}
                    <br>
                    http session {{session.httpSessionId}}
                    <br>
                    id {{session.httpSessionId}}
                </p>
            </div>
            <kp-collapser>
                <table class="table table-condensed table-hover">
                    <tr ng-repeat="requestEvent in session.requestEvents">
                        <td>{{requestEvent.url}}</td>
                        <td>{{requestEvent.ipAddress.value}}</td>
                        <td><strong>{{requestEvent.initiatorUser.id}}</strong> <a ui-sref="user({userId: requestEvent.initiatorUser.id})">{{requestEvent.initiatorUser | loc}}</a></td>
                        <td>{{requestEvent.currentDepartment | loc}}</td>
                        <td>{{requestEvent.creationDate | jpDate:'d.M. HH:mm:ss'}}</td>
                    </tr>
                </table>
            </kp-collapser>
        </div>
    </div>


    <div class="panel panel-default">
        <div class="panel-heading">
            <h2 class="panel-title">Covers import</h2>
        </div>
        <div class="panel-body">
            <form>
                <div class="form-group">
                    <label>
                        From directory:
                        <input type="text" class="form-control" ng-model="utilCtrl.coverTransferSetting.folder">
                    </label>
                </div>
                <div class="form-group">
                    <label>
                        Filename pattern (e.g. "{recordId}" nebo "obalka_1_{recordId}"):
                        <input type="text" class="form-control" ng-model="utilCtrl.coverTransferSetting.filenamePattern">
                    </label>
                </div>
                <kp-action-request-button css-class="btn btn-primary btn-sm" path-on-context="true"
                                          path="api/cover-transfer?folder={{utilCtrl.coverTransferSetting.folder| encodeUri}}&filenamePattern={{(utilCtrl.coverTransferSetting.filenamePattern|| '') | encodeUri}}">Transfer
                </kp-action-request-button>
            </form>
        </div>
    </div>


</div>
