<#ftl outputFormat="HTML">


<ul>
    <li class="clearfix" ng-repeat="chainItem in $ctrl.setting.chain">
        <div ng-show="$index === 1">
            <span class="glyphicon glyphicon-arrow-down"></span>
        </div>

        <div class="pull-right" ng-hide="chainItem.temporary">
            <button type="button" class="btn btn-default btn-xs" ng-show="chainItem.editable" title="Upraví nastavení daného oddělení" ng-click="$ctrl.edit(chainItem)">Edit</button>
            <button type="button" class="btn btn-default btn-xs" ng-show="chainItem.overridable" title="Předefinuje nastavení nastavením na tomto oddělení" ng-click="$ctrl.override(chainItem)">Předefinovat</button>
            <button type="button" class="btn btn-default btn-xs" ng-hide="chainItem.default" ng-click="$ctrl.deleteCustom(chainItem)">Smazat</button>
        </div>
        <div>
            <span ng-show="chainItem.state !== $ctrl.State.EDITING && !chainItem.temporary" ng-class="{'text-muted overwritten-value': !chainItem.effective}" style="word-break: break-all;">
                <span style="margin-right: 5px;">
                    <span ng-show="chainItem.default">Default: </span>
                    <strong ng-show="chainItem.department !== null">{{chainItem.department | loc}}: </strong>
                    <strong ng-show="chainItem.fond !== null">Fond {{chainItem.fond | loc}}</strong>
                </span>
                <span>
                    <kp-svelte-component-wrapper
                                component="::$ctrl.kpDatatypedValue"
                                props="{
                                        value: chainItem.value,
                                        datatype: $ctrl.setting.datatype
                                    }"
                        >
                    </kp-svelte-component-wrapper>
                    <small class="text-muted" ng-show="chainItem.note"> ({{chainItem.note}})</small>
                </span>
            </span>

            <div ng-if="chainItem.state === $ctrl.State.EDITING">
                <form class="form-vertical" ng-submit="$ctrl.saveCustom(chainItem)">
                    <div class="form-group">
                        <strong>{{chainItem.department | loc}}</strong>
                    </div>
                    <div class="form-group">
                        <kp-svelte-component-wrapper
                                component="::$ctrl.kpValueEditorComponent"
                                props="{
                                        type: $ctrl.setting.editor.type,
                                        options: $ctrl.setting.editor.options,
                                        validations: $ctrl.setting.editor.validations,
                                        model: chainItem.value
                                    }"
                                ng-on-model-change="chainItem.value = $event.originalEvent.detail">
                        </kp-svelte-component-wrapper>
                    </div>
                    <button type="submit" class="btn btn-primary btn-sm">OK</button>
                    <button type="button" class="btn btn-default btn-sm" ng-click="chainItem.state = 'NORMAL'">Zrušit</button>
                </form>
            </div>
            <div ng-show="chainItem.state === $ctrl.State.PROCESSING"><span jp-loading="xs"></span></div>
        </div>
    </li>
</ul>

