<#ftl outputFormat="HTML">
<#import "../../../../../../freemarker/_localization.ftl" as loc>

<div jp-visible-on-hover-parent=".zaznamListItem">
    <span class="pull-right" ng-show="$ctrl.canEdit === true">
        <button type="button" class="btn btn-default btn-sm" ng-click="$ctrl.editUser($ctrl.user)">
            ${loc.loc("commons.editovat")?noEsc}
        </button>
        <button type="button" class="btn btn-default btn-sm" ng-click="$ctrl.deleteUser($ctrl.user)">
            ${loc.loc("commons.Smazat")?noEsc}
        </button>
    </span>
</div>

<div>
    <span class="nazevZaznamu">
        <a ui-sref="user({userId: $ctrl.user.id})">
            <span>{{$ctrl.user.printableName}}</span>
        </a>
        <code ng-show="$ctrl.user.username">{{$ctrl.user.username}}</code>
    </span>

    <span class="label label-danger" ng-show="$ctrl.user.readerRole.blocked">${loc.loc("ctenar.TransactionsBlocked")?noEsc}</span>
    <span class="label label-danger" ng-show="$ctrl.user.readerRole.registrationExpired">${loc.loc("ctenar.RegistrationExpired")?noEsc}</span>
    <span class="label label-info reader-tag" ng-show="$ctrl.user.role.includes('ROLE_READER')">${loc.loc("user.Reader")?noEsc}</span>
    <span class="label label-info reader-tag" ng-show="$ctrl.user.role.includes('ROLE_LIBRARIAN')">${loc.loc("user.Librarian")?noEsc}</span>
    <span class="label label-info" ng-show="$ctrl.user.role.includes('ROLE_LIBRARY')">${loc.loc("user.MvsLibrary")?noEsc}</span>
    <span class="label label-info" ng-show="$ctrl.user.role.includes('ROLE_SUPPLIER')">${loc.loc("user.Supplier")?noEsc}</span>
    <div class="cleaner"></div>
</div>

<div class="detail">
    <span ng-repeat="role in $ctrl.user.userRoles track by $index">
        <span ng-show="role.cardNumber">
            <span class="text-muted">${loc.loc("ctenar.cardNumber")?noEsc} </span>{{role.cardNumber | loc}},
        </span>
        <span ng-show="role.barCode">
            <span class="text-muted">${loc.loc("ctenar.barCode")?noEsc} </span>{{role.barCode | loc}},
        </span>
        <span ng-show="role.readerCategory">
            <span class="text-muted">${loc.loc("commons.kategorie")?noEsc} </span>{{role.readerCategory | loc}},
        </span>
        <span ng-show="role.editLevel > -1">
            <span class="text-muted">${loc.loc("user.LibrarianEditLevel")?noEsc} </span>{{role.editLevel}},
        </span>
        <span ng-show="role.group">
            <span class="text-muted">${loc.loc("user.UserGroup")?noEsc} </span>{{role.group | loc}},
        </span>
        <span ng-show="role.validationCode">
            <span class="text-muted">${loc.loc("user.ValidationCode")?noEsc} </span>{{role.validationCode}},
        </span>
        <span ng-show="role.withServicePrivileges">
            se servisními právy,
        </span>
    </span>

    <div>
        <span ng-show="$ctrl.user.readableDepartments.length > 0">
            <span class="text-muted">${loc.loc("user.ReadableDepartments")?noEsc} </span>{{$ctrl.user.readableDepartments | prop:'text' | inline:', ' | characters:100}}
        </span>
    </div>
</div>