<#ftl outputFormat="HTML">
<#import "../../../../freemarker/_localization.ftl" as loc>

<div class="detail-blok volume-list">

    <jp-loading size="xs" ng-show="$ctrl.volumes && !$ctrl.volumesResolved"></jp-loading>

    <div class="volumes-heading">
        <h3 ng-if="$ctrl.capabilities.canCreateAnyExemplar || $ctrl.capabilities.canCreateAnyVolume || $ctrl.volumesResolved && $ctrl.volumes.length > 0 && $ctrl.haveVolumesAnyIssue()">${loc.loc("commons.rocniky")?noEsc}</h3>

        <div ng-if="$ctrl.capabilities.canCreateAnyVolume">
            <button type="button" class="btn btn-default btn-sm" ng-click="$ctrl.showVolumeCreation($ctrl.document)">
                <i class="glyphicon glyphicon-plus"></i>
                <span>${loc.loc("volume.NovyRocnik")?noEsc}</span>
            </button>
        </div>
    </div>

    <uib-accordion close-others="false">
        <div class="panel panel-default"
             uib-accordion-group ng-click="$ctrl.loadIssues(volume)"
             ng-repeat="volume in $ctrl.volumes"
             ng-if="volume.withIssues || $ctrl.capabilities.canCreateAnyExemplar || $ctrl.capabilities.canEditAnyExemplar">

            <uib-accordion-heading>
                <div>
                    <span class="caret"></span>

                    <span ng-class="{'text-muted': !volume.withIssues}">
                        ${loc.loc("commons.rocnik")?noEsc} {{volume | loc}}
                        (${loc.loc("commons.rok")?noEsc} {{volume.year}})
                    </span>

                    <span class="pull-right" ng-if="$ctrl.capabilities.canEditAnyVolume">
                        <small>${loc.loc("volume.pocetKusu")?noEsc}: {{volume.issueQuantity}}</small>
                        <small ng-if="volume.description">, ${loc.loc("volume.poznamka")?noEsc}: {{volume.description}}</small>
                    </span>
                </div>
            </uib-accordion-heading>

            <jp-loading size="xs" ng-if="volume.issues && !volume.issues.$resolved"></jp-loading>

            <kp-exemplar-list exemplars="volume.issues"
                              document="$ctrl.document"
                              properties="$ctrl.properties">
            </kp-exemplar-list>

            <div class="text-center panel-body" ng-if="$ctrl.capabilities.canEditAnyVolume || $ctrl.capabilities.canCreateAnyExemplar">
                <div class="btn-group">
                    <button type="button" class="btn btn-default btn-sm" ng-click="$ctrl.showVolumeEditation(volume)">${loc.loc("exemplar.EditVolume")?noEsc}</button>
                    <button type="button" class="btn btn-default btn-sm" ng-click="$ctrl.createIssue($ctrl.document, volume)">${loc.loc("commons.pridatExemplar")?noEsc}</button>
                </div>
            </div>
        </div>
    </uib-accordion>
</div>
