<#ftl outputFormat="HTML">
<#import "../../../../freemarker/_localization.ftl" as loc>


<div style="overflow-y: auto">

    <div class="panel-body text-center text-muted" ng-if="$ctrl.exemplars.length === 0">
        ${loc.loc("detail.ZadneExemplareKDispozici")?noEsc}
    </div>

    <table class="exemplar-table greenHeaderTable table-striped table-hover" ng-if="$ctrl.exemplars.length > 0" jp-hide-alone-headers="$ctrl.exemplars">
        <thead>
            <tr>
                <th class="col_{{property.id || property}}" ng-repeat="property in $ctrl.properties">{{property | loc}}</th>
                <th class="col_loanRequest">${loc.loc("loan.Vypujcit")?noEsc}</th>
                <th class="col_edit"></th>
            </tr>
        </thead>

        <tbody>
            <tr ng-class="{'text-muted': !$ctrl.exemplarFilter.anonymous(exemplar)}" ng-repeat-start="exemplar in $ctrl.exemplars" ng-init="exemplar.showMore = false" data-exemplar-id="{{exemplar.id}}" title="${loc.loc("exemplar.signature")?noEsc}:{{exemplar.signature}},  ${loc.loc("exemplar.barCode")?noEsc}:{{exemplar.barCode}},  ${loc.loc("exemplar.accessNumber")?noEsc}:{{exemplar.accessNumber}}">
                <td class="col_{{property.id || property}}" ng-repeat="property in $ctrl.properties" ng-switch="property.id || property">
                    <button class="btn btn-default btn-xs" ng-switch-when="placement" ng-click="exemplar.showMore = !exemplar.showMore; $ctrl.loadPlacement(exemplar)">
                        <span class="glyphicon" ng-class="{'glyphicon-zoom-in': !exemplar.showMore, 'glyphicon-zoom-out': exemplar.showMore}"></span>
                    </button>

                    <a ng-switch-when="fileDirectory" ng-if="exemplar.fileDirectory" kp-href="/media-viewer?rootDirectory={{$ctrl.document.directoryId}}&back={{$ctrl.$window.location.href | encodeUri}}#!?directory={{exemplar.fileDirectory.id}}">
                        {{exemplar.fileDirectory | loc}}
                    </a>

                    <span ng-switch-when="holder">
                        <a ng-if="exemplar.holderDetailShowable && exemplar.holder" ui-sref="user({userId: exemplar.holder.id})">
                            {{exemplar.holder | loc}}
                        </a>
                        <span ng-if="!exemplar.holderDetailShowable && exemplar.holderShowable && exemplar.holder">
                            {{exemplar.holder | loc}}
                        </span>
                    </span>

                    <span ng-switch-when="creationDate">
                        {{exemplar.creationDate | jpDate: 'd.M.yyyy'}}
                    </span>

                    <span ng-switch-default>
                        {{exemplar[property.id] | loc}}
                    </span>
                </td>

                <td class="col_loanRequest">
                    <#-- TLACITKO OBJEDNAT/REZERVOVAT NG -->
                    <kp-availability-button kp-availability="exemplar.availability" kp-on-request="$ctrl.requestExemplar(exemplar)" kp-for-exemplar="true" kp-size="xs"></kp-availability-button>
                </td>

                <td class="col_edit">
                    <button class="btn btn-default btn-xs" type="button" ng-if="exemplar.editable" ng-click="$ctrl.editExemplar(exemplar)" data-qa="edit-exemplar-button">
                        ${loc.loc("commons.editovat")?noEsc}
                    </button>
                    <button class="btn btn-default btn-xs" type="button" ng-if="exemplar.discardable" ng-click="$ctrl.discardExemplar(exemplar)" data-qa="discard-exemplar-button">
                        ${loc.loc("commons.vyradit")?noEsc}
                    </button>
                    <button class="btn btn-default btn-xs" type="button" ng-if="exemplar.discardionRestorable" ng-click="$ctrl.restoreExemplar(exemplar)" data-qa="restore-exemplar-button">
                        ${loc.loc("commons.Restore")?noEsc}
                    </button>
                    <button class="btn btn-default btn-xs" type="button" ng-if="exemplar.deletable" ng-click="$ctrl.deleteExemplar(exemplar)" data-qa="delete-exemplar-button">
                        ${loc.loc("commons.Smazat")?noEsc}
                    </button>
                </td>
            </tr>

            <tr ng-repeat-end ng-if="exemplar.showMore">
                <td class="text-center" colspan="100%">
                    <div ng-if="!exemplar.placement">
                        <div class="panel-body">
                            ${loc.loc("exemplar.DataOUmisteniExNejsouKDispozici")?noEsc}
                        </div>
                    </div>

                    <jp-loading size="xs" ng-if="exemplar.placement && exemplar.loadingPlacement"></jp-loading>

                    <div ng-if="exemplar.placement && !exemplar.loadingPlacement">
                        <div class="panel-body">
                            <div class="map-image-container" ng-if="exemplar.placement.withMap">
                                <img class="map-image" ng-src="data:image/jpeg;base64,{{exemplar.placement.map}}" width="{{exemplar.placement.dimensions.width}}" height="{{exemplar.placement.dimensions.height}}" alt="Exemplar placement">
                            </div>
                            <div class="map-info" ng-bind-html="exemplar.placement.information | loc"></div>
                        </div>
                    </div>
                </td>
            </tr>
        </tbody>
    </table>

</div>
