<#ftl outputFormat="HTML">
<#import "../../../../../../freemarker/_localization.ftl" as loc>

<div class="internal-login-system loginDiv loginDiv-internal login-system-panel-top-border">

    <h4>${loc.loc("login.prihlaseniVnitrnimSystemem")?noEsc}</h4>

    <form id="loginForm" ng-submit="$ctrl.submitLoginForm()">

        <div class="form-group">
            <label for="internal-login-username-input">${loc.loc("login.usernameLabel")?noEsc}</label>
            <input type="text" id="internal-login-username-input" class="form-control input-sm" name="username" ng-model="$ctrl.credentials.username" kp-auto-fill-sync data-qa="internal-login-username-input">
        </div>
        <div ng-show="$ctrl.authSystemView.secondFieldEnabled" class="form-group">
            <label for="internal-login-password-input">${loc.loc("login.passwordLabel")?noEsc}</label>
            <input type="password" id="internal-login-password-input" class="form-control input-sm" name="password" ng-model="$ctrl.credentials.password" kp-auto-fill-sync data-qa="internal-login-password-input">
        </div>

        <div class="row align-items-start">
            <div class="col-xs-12 text-center">
                <button type="submit" id="internal-login-submit-button" class="btn btn-primary btn-block" data-qa="internal-login-submit-button">${loc.loc("login.loginButton")?noEsc}</button>
            </div>
        </div>

        <div class="row align-items-end registration-section">
            <div class="col-xs-6 text-left">
                <span ng-if="$ctrl.registrationOptions.isAny()">
                    <a id="internal-login-new-registration-button" href="" ng-click="$ctrl.showRegistration()" ng-switch="$ctrl.registrationOptions.isOnlyOne() && $ctrl.registrationOptions.get('credentialsRegistration').isEnabled()" data-qa="internal-login-new-registration-button">
                        <span ng-switch-when="true">${loc.loc("login.NastavitPrihlaseni")?noEsc}</span>
                        <span ng-switch-default>${loc.loc("login.NotRegistered")?noEsc}</span>
                    </a>
                </span>
            </div>
            <div class="col-xs-6 text-right">
                <span ng-if="$ctrl.loginView.showForgottenCredentials">
                    <a href="" ng-click="$ctrl.showForgottenCredentials()">${loc.loc("login.resetPassword.ForgottenPassword")?noEsc}</a>
                </span>
            </div>
        </div>

    </form>

</div>
