<#ftl outputFormat="HTML">

<div class="file-content">

    <div class="panel panel-default">
        <div class="code-editor" ng-show="$ctrl.file && $ctrl.file.viewForms.includes('PLAIN_TEXT')">
            <div ng-model="$ctrl.contentHolder.value" ui-ace="$ctrl.aceOptions"></div>
        </div>

        <div class="panel-body" ng-if="$ctrl.file && $ctrl.file.viewForms.includes('IMAGE')">
            <img class="image-edit-view" ng-src="{{$ctrl.CONTEXT_PATH + $ctrl.file.urlPath}}">
        </div>

        <div class="panel-body" ng-if="$ctrl.file && !$ctrl.file.viewForms.includes('PLAIN_TEXT') && !$ctrl.file.viewForms.includes('IMAGE')">
            <a kp-href="{{$ctrl.file.urlPath}}">
                <span class="glyphicon glyphicon-cloud-download"></span>
                Download
            </a>
        </div>

        <div class="panel-footer">
            <span class="pull-right text-muted">
                URL: <code>{{$ctrl.SERVER_URL}}/files/{{$ctrl.file.id}}</code>
                <br />
                URL path: <code>{{$ctrl.CONTEXT_PATH}}/files/{{$ctrl.file.id}}</code>
                <br />
                Custom file template (if exists): <code>&dollar;{serverUrl}/custom/{{$ctrl.file.directory.name}}/{{$ctrl.file.filename}}</code>
            </span>

            <button type="button" class="btn btn-primary btn-sm" title="CTRL+S" ng-show="$ctrl.file.viewForms.includes('PLAIN_TEXT')"
                    ng-click="$ctrl.saveContent()" ng-disabled="!$ctrl.isUnsaved()">
                <span ng-show="$ctrl.state === 'NORMAL' && !$ctrl.isUnsaved()">
                    <span class="glyphicon glyphicon-floppy-saved"></span>
                    All saved
                </span>

                <span ng-show="$ctrl.state === 'NORMAL' && $ctrl.isUnsaved()">
                    <span class="glyphicon glyphicon-floppy-save"></span>
                    Save [CTRL+S]
                </span>

                <span ng-show="$ctrl.state === 'PROCESSING'">
                    <span class="glyphicon glyphicon-floppy-save"></span>
                    Saving
                </span>
            </button>

            <div class="clearfix"></div>
        </div>
    </div>

    <div class="file-content-preview" ng-show="$ctrl.file.viewForms.includes('RICH_DOCUMENT') && $ctrl.contentHolder.value && $ctrl.wysiwygCapable" ng-bind-html="$ctrl.renderHtml($ctrl.contentHolder.value)"></div>

</div>