module.exports = (grunt) => {

    grunt.initConfig({
        portaroVersion: process.env.PORTARO_VERSION || grunt.file.readJSON("package.json").version,

        'extract-comments': {
            'docs/comments.js': ['src/**/*.ts', 'src/**/*.js']
        },

        watch: {
            files: ['src/**/*.ts', 'src/**/*.ts', 'src/**/*.ngdoc'],
            tasks: ['docs:build'],
            options: {
                atBegin: true,
                interrupt: true
            }
        },

        'dgeni-alive': {
            options: {
                packages: [
                    'dgeni-packages/jsdoc',
                    'dgeni-packages/ngdoc',
                    'dgeni-packages/links',
                    'dgeni-packages/examples',
                    './packages/jsdoc-ext',
                    './packages/ngdoc-ext',
                    './packages/links-ext',
                    './packages/examples-ext',
                    require('./dgeni/packages/ng-constants')
                ],
                deployments: [{
                    name: 'default',
                    examples: {
                        commonFiles: {
                            scripts: [
                                'https://cdnjs.cloudflare.com/ajax/libs/angular.js/1.6.5/angular.js',
                                'https://cdnjs.cloudflare.com/ajax/libs/angular.js/1.6.5/angular-animate.js',
                                'https://cdnjs.cloudflare.com/ajax/libs/angular-ui-bootstrap/2.5.0/ui-bootstrap-tpls.js',
                                'https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.js',
                                'https://cdnjs.cloudflare.com/ajax/libs/angular-messages/1.6.9/angular-messages.js',
	                            '/portaro.documentation.js',
	                            '/scripts/vendors.js'
                            ],
                            stylesheets: [
                                'https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.4.1/css/bootstrap.min.css',
                                '/assets/styles/portaro.documentation.css',
                                '/assets/styles/vendors.css'
                            ]
                        }
                    }
                }],
                deploymentTarget: 'default'
            },
            api: {
                title: 'Portaro Doc',
                version: '<%= portaroVersion %>',
                expand: false,
                dest: 'docs',
                src: [
                    'docs/comments.js',
                    'src/**/*.ngdoc'
                ]
            }
        },

        plato: {
            options:{
                eslintrc: '.eslintrc',
                exclude: /src[\/\\]modules/
            },
            analyse: {
                files: {
	                'reports/quality': 'src/**/*.js'
                }
            }
        }
    });

    grunt.loadNpmTasks('grunt-extract-comments');
    grunt.loadNpmTasks('grunt-contrib-watch');
    grunt.loadNpmTasks('dgeni-alive');
    grunt.loadNpmTasks('grunt-plato');

    grunt.registerTask('docs:build', ['extract-comments', 'dgeni-alive']);
    grunt.registerTask('docs:watch', ['watch']);
};