<#ftl outputFormat="HTML">
<#import "_layouts.ftl" as layouts>
<#import "_localization.ftl" as loc>


<@layouts.full>
    <div class="container account_pairing" ng-controller="AuthPairingCtrl as $ctrl">

        <div class="row" style="margin-bottom: 20px">
            <div class="col-xs-12">
                <h1>Propojení mojeID s účtem v knihovně</h1>
                <div>
                    Přihlášení systémem mojeID proběhlo úspěšně, nicméně ještě nemáte účet v mojeID propojen s účtem v knihovně.
                    Pokud účet v knihovně ještě nemáte, můžete založit nový.
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-xs-{{$ctrl.showFullRegistration && '4' || '6'}}">
                <div class="panel panel-default">
                    <div class="panel-heading panel-heading-strong">Účet v knihovně již mám</div>
                    <div class="panel-body">
                        <div>
                            Pro propojení s účtem v knihovně se přihlašte ještě běžným způsobem.<br/><br/>
                            Příští přihlášení bude již "na jeden klik" tlačítkem "Přihlásit přes mojeID".
                        </div>
                        <div style="margin-top: 20px">
                            <button ng-click="$ctrl.mergeToAuthenticatedInternalUser()" type="button" class="btn btn-primary btn-sm">Přihlásit se běžným způsobem</button>
                        </div>
                    </div>
                </div>
            </div>

            <div ng-if="$ctrl.showFullRegistration" class="col-xs-4">
                <div class="panel panel-default">
                    <div class="panel-heading panel-heading-strong">Chci založit nový účet v knihovně</div>
                    <div class="panel-body">
                        <div>
                            Pokud ještě nemáte účet v knihovně, je třeba ho založit. Použijeme přitom údaje předané z mojeID.<br/>
                            Po vytvoření účtu ho automaticky propojíme s vašim mojeID.<br/><br/>
                            Příští přihlášení bude již "na jeden klik" tlačítkem "Přihlásit přes mojeID".
                        </div>
                        <div style="margin-top: 20px">
                            <button ng-click="$ctrl.saveNewReader()" type="button" class="btn btn-primary btn-sm">Vytvořit účet</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xs-{{$ctrl.showFullRegistration && '4' || '6'}}">
                <div class="panel panel-default">
                    <div class="panel-heading panel-heading-strong">Zrušit</div>
                    <div class="panel-body">
                        <div>
                            Nebo můžete celou akci zrušit
                        </div>
                        <div style="margin-top: 20px">
                            <button ng-click="$ctrl.logout()" type="button" class="btn btn-primary btn-sm">Zrušit celou akci</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</@layouts.full>