<#ftl outputFormat="HTML">
<#import "_layouts.ftl" as layouts>
<#import "_localization.ftl" as loc>


<@layouts.full>
    <div class="container pops-tenders" ng-controller="TenderListCtrl" ng-init="init()">

        <div class="row">
            <div class="col-xs-12">
                <h1>Veřejné zakázky na nákup knih a časopisů</h1>
            </div>
        </div>


        <div class="row">
            <div class="col-xs-8">

                <p ng-show="!currentAuth.evided">
                    Seznamy titulů v jendnotlivých řízeních jsou pro nepřihlášené uživatele pouze k nahlédnutí. Pro zadávání nabídek se prosím přihlaste.
                </p>

                <p ng-show="currentAuth.evided && !currentAuth.role.includes('ROLE_LIBRARIAN') && !currentAuth.role.includes('ROLE_ADMIN') && !currentAuth.role.includes('ROLE_LIBRARIAN')">
                    Seznamy titulů v jendnotlivých řízeních jsou pro běžné uživatele pouze k nahlédnutí.
                </p>

                <p ng-show="currentAuth.role.includes('ROLE_LIBRARIAN') || currentAuth.role.includes('ROLE_ADMIN')">
                    Jste přihlášen jako správce řízení.
                </p>

                <p ng-show="currentAuth.role.includes('ROLE_SUPPLIER')">
                    Jste přihlášen jako dodavatel <strong>{{currentAuth.activeUser.printableName}}</strong>.
                </p>

                <p>
                    Ke stažení:
                    <a ng-href="{{CONTEXT_PATH}}/custom/pops/zakonne_podminky.pdf" download>zákonné podmínky</a> |
                    <a ng-href="{{CONTEXT_PATH}}/custom/pops/zadavaci_dokumentace.pdf" download>zadávací dokumentace</a> |
                    <a ng-href="{{CONTEXT_PATH}}/custom/pops/obchodni_podminky.pdf" download>obchodní podmínky nebo smlouva</a>
                </p>
                <p>
                    Kontaktní email pro dotazy: <a href="mailto:vzknihy@mendelu.cz"><code>vzknihy@mendelu.cz</code></a>, <a href="mailto:vzcasopisy@mendelu.cz"><code>vzcasopisy@mendelu.cz</code></a>
                </p>

            </div>

            <div class="col-xs-4">
                <button ng-if="!currentAuth.evided" type="button" class="btn btn-primary pull-right" onclick="window.location = contextPath+'/login/ezak/login?redirect='+encodeURIComponent(window.location.href)">
                    ${loc.loc("login.PrihlasitSeEzakem")?noEsc}
                </button>
            </div>
        </div>


        <hr/>


        <div class="row">
            <div class="col-xs-12">

                <p>Momentálně probíhají následující poptávková řízení:</p>


                <div ng-repeat="t in tenders" class="panel" ng-class="{'panel-warning': t.phase === 'OPENED', 'panel-success': t.phase === 'STARTED', 'panel-danger': t.phase === 'FINISHED'}">
                    <div class="panel-heading">
                        <div>Veřejná zakázka {{t|loc}}</div>
                    </div>

                    <div class="panel-body">
                        <div class="pull-right" style="font-size: 1.3em; text-transform: uppercase;">
                            <span ng-show="t.phase === 'OPENED'" class="label label-warning">
                                Řízení se připravuje
                            </span>
                            <span ng-show="t.phase === 'STARTED'" class="label label-success">
                                Probíhá příjem nabídek
                            </span>
                            <span ng-show="t.phase === 'FINISHED'" class="label label-danger">
                                Řízení ukončeno
                            </span>
                        </div>

                        <ul>
                            <li>Přístupné k zobrazení od <strong>{{t.openDate | jpDate:'d.M.yyyy HH:mm:ss'}}</strong></li>
                            <li>Začátek řízení <strong>{{t.startDate | jpDate:'d.M.yyyy HH:mm:ss'}}</strong></li>
                            <li>konec <strong>{{t.endDate | jpDate:'d.M.yyyy HH:mm:ss'}}</strong></li>
                        </ul>

                        <p ng-switch="t.phase">
                            <span ng-switch-when="OPENED">Řízení je zatím pouze k zobrazení</span>
                            <span ng-switch-when="STARTED">Řízení je otevřeno k zadávaní nabídek</span>
                            <span ng-switch-when="FINISHED">Řízení je ukončeno</span>
                        </p>

                        <p><a ng-href="{{CONTEXT_PATH}}/tenders/{{t.id}}" class="btn btn-primary btn-sm">Zobrazit řízení</a></p>
                    </div>
                </div>


            </div>
        </div>

    </div>
</@layouts.full>