<#ftl outputFormat="HTML">
<#import "_layouts.ftl" as layouts>
<#import "_localization.ftl" as loc>


<@layouts.full>
    <script type="text/javascript">
        window.model.tenderId = ${objectMapper.writeValueAsString(tenderId)?noEsc};
        window.model.quantitySelection = false;
        window.model.dph = 0.21;
    </script>

    <style>
        .pops-tender .panel {
            margin-bottom: 50px;
        }
    </style>


    <div class="container pops-tender" ng-controller="TenderCtrl" ng-init="init()">

        <div class="row">
            <div class="col-xs-12">
                <h1>
                    <span>Veřejná zakázka malého rozsahu {{tender|loc}}</span>

                    <span style="text-transform: uppercase; font-size: 0.8em;">
                        <span ng-show="tender.phase === 'CREATED'" class="label label-danger" title="Řízení zatím není pro veřejnost přístupné">
                            Řízení zatím není přístupné
                        </span>
                        <span ng-show="tender.phase === 'OPENED'" class="label label-warning" title="Řízení je v přípravné fázi, zatím nelze zadávat ani rušit nabídky">
                            Řízení se připravuje
                        </span>
                        <span ng-show="tender.phase === 'STARTED'" class="label label-success" title="Probíhá příjem nabídek">
                            Probíhá příjem nabídek
                        </span>
                        <span ng-show="tender.phase === 'FINISHED'" class="label label-danger" title="Řízení skončilo, již nelze zadávat nabídky">
                            Řízení ukončeno
                        </span>
                    </span>
                </h1>
            </div>
        </div>


        <div class="row" style="margin-bottom: 50px;">
            <div class="col-xs-8">
                <p class="text-muted">
                    celkem částí: <strong>{{demands.length}}</strong>
                </p>
                <p>
                    <ul>
                        <li>Začátek řízení <strong>{{tender.startDate | jpDate:'d.M.yyyy HH:mm:ss'}}</strong></li>
                        <li>Konec řízení <strong>{{tender.endDate | jpDate:'d.M.yyyy HH:mm:ss'}}</strong></li>
                        <li ng-show="tender.evaluationDate">Vyhodnocení je plánováno na <strong>{{tender.evaluationDate | jpDate:'d.M.yyyy'}}</strong></li>
                    </ul>
                </p>
                <p>
                    Kontaktní email pro dotazy: <a href="mailto:vzknihy@mendelu.cz"><code>vzknihy@mendelu.cz</code></a>, <a href="mailto:vzcasopisy@mendelu.cz"><code>vzcasopisy@mendelu.cz</code></a>
                </p>
                <p ng-show="true">
                    <a ng-href="{{CONTEXT_PATH}}/export?target=XlsFileTenderDemands&object={{tender.id}}">${loc.loc("commons.Stahnout")?noEsc}</a> xls soubor s poptávkami
                </p>
            </div>
            <div class="col-xs-4 text-center">

                <#-- prihlaseni pres ezak -->
                <div ng-if="!currentAuth.evided" class="">
                    <button type="button" class="btn btn-primary" onclick="window.location = contextPath+'/login/ezak/login?redirect='+encodeURIComponent(window.location.href)">
                        ${loc.loc("login.PrihlasitSeEzakem")?noEsc}
                    </button>
                </div>

                <#-- nacitani agreementu -->
                <div ng-if="!offeringStates">
                    <div class="panel-body">
                        <div jp-loading></div>
                    </div>
                </div>


                <div ng-if="offeringStates" ng-repeat="offeringState in offeringStates" class="panel" ng-class="{'panel-success': offeringState.getStepOfType('AGREEMENT_CONFIRM').isDone(), 'panel-warning': !offeringState.getStepOfType('AGREEMENT_CONFIRM').isDone()}">

                    <div class="panel-heading text-uppercase">
                        <div ng-if="offeringState.getStepOfType('AGREEMENT_CONFIRM').isDone()">
                            <span class="glyphicon glyphicon-ok"></span>
                            <strong>Zakázka je potvrzena</strong>
                        </div>
                        <div ng-if="!offeringState.getStepOfType('AGREEMENT_CONFIRM').isDone()">
                            <div ng-if="!offeringState.getStepOfType('AGREEMENT_CONFIRM').isFeasible()">
                                <span class="glyphicon glyphicon-warning-sign"></span>
                                <strong>Řízení je ukončeno</strong>
                            </div>
                            <div ng-if="offeringState.getStepOfType('AGREEMENT_CONFIRM').isFeasible()" ng-switch="offeringState.getRemainingSteps()[0].type">
                                <div ng-switch-when="TENDER_START">
                                    <span class="glyphicon glyphicon-warning-sign"></span>
                                    <strong>Řízení se připravuje</strong>
                                </div>
                                <div ng-switch-when="OFFER_ADD">
                                    <span class="glyphicon glyphicon-warning-sign"></span>
                                    <strong>Zadávejte nabídky</strong>
                                </div>
                                <div ng-switch-when="TERMS_AND_CONDITIONS_ACCEPT">
                                    <span class="glyphicon glyphicon-warning-sign"></span>
                                    <strong>Nabídky je třeba odsouhlasit</strong>
                                </div>
                                <div ng-switch-when="AGREEMENT_FILE_DOWNLOAD|SIGNED_AGREEMENT_FILE_UPLOAD" ng-switch-when-separator="|">
                                    <span class="glyphicon glyphicon-warning-sign"></span>
                                    <strong>Nabídky je třeba podepsat</strong>
                                </div>
                                <div ng-switch-when="AGREEMENT_CONFIRM">
                                    <span class="glyphicon glyphicon-warning-sign"></span>
                                    <strong>Podat nabídku</strong>
                                </div>
                                <div ng-switch-when="TENDER_EVALUATION">
                                    <span class="glyphicon glyphicon-ok"></span>
                                    <strong>Zakázka je potvrzena</strong>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="panel-body">
                        <div ng-if="offeringState.getStepOfType('AGREEMENT_CONFIRM').isDone()">
                            <div ng-if="offeringState.getStepOfType('TENDER_EVALUATION').isDone()">
                                <p>
                                    Všechny vaše nabídky jsou potvrzeny.
                                </p>
                            </div>
                            <div ng-if="!offeringState.getStepOfType('TENDER_EVALUATION').isDone()">
                                <p>
                                    Všechny vaše nabídky jsou potvrzeny.
                                </p>
                                <p class="text-muted">
                                    Po úpravě jakékoliv nabídky bude třeba nabídky znovu potvrdit tlačítkem Podat nabídku.
                                </p>
                            </div>
                        </div>
                        <div ng-if="!offeringState.getStepOfType('AGREEMENT_CONFIRM').isDone()">
                            <div ng-if="!offeringState.getStepOfType('AGREEMENT_CONFIRM').isFeasible()">
                                <p>Nabídky již nelze zadávat.</p>
                            </div>
                            <div ng-if="offeringState.getStepOfType('AGREEMENT_CONFIRM').isFeasible()" ng-repeat="step in offeringState.steps" ng-switch="step.type" ng-class="{'text-muted': !step.isActive()}">

                                <div ng-switch-when="TENDER_START">
                                    <p>
                                        Vyčkejte na zahájení řízení
                                    </p>
                                </div>

                                <div ng-switch-when="OFFER_ADD">
                                    <p>
                                        <span class="glyphicon glyphicon-arrow-down"></span>
                                    </p>
                                    <p>
                                        Zadávejte nabídky
                                    </p>
                                </div>

                                <div ng-switch-when="TERMS_AND_CONDITIONS_ACCEPT">
                                    <p>
                                        <span class="glyphicon glyphicon-arrow-down"></span>
                                    </p>
                                    <p style="text-align: left;">
                                        <label>
                                            <input type="checkbox" ng-model="step.checks[0]" ng-disabled="!step.isActive()" />
                                            Souhlasím se <a ng-href="{{CONTEXT_PATH}}/custom/pops/zakonne_podminky.pdf" download>zákonnými podmínkami</a>
                                        </label>
                                        <br/>
                                        <label>
                                            <input type="checkbox" ng-model="step.checks[1]" ng-disabled="!step.isActive()" />
                                            Souhlasím se <a ng-href="{{CONTEXT_PATH}}/custom/pops/zadavaci_dokumentace.pdf" download>zadávací dokumentací</a>
                                        </label>
                                        <br/>
                                        <label>
                                            <input type="checkbox" ng-model="step.checks[2]" ng-disabled="!step.isActive()" />
                                            Souhlasím s <a ng-href="{{CONTEXT_PATH}}/custom/pops/obchodni_podminky.pdf" download>obchodními podmínkami / smlouvou</a>
                                        </label>
                                    </p>
                                </div>

                                <div ng-switch-when="AGREEMENT_FILE_DOWNLOAD">
                                    <p>
                                        <span class="glyphicon glyphicon-arrow-down"></span>
                                    </p>
                                    <p>
                                        <a ng-href="{{CONTEXT_PATH}}/api/tenders/{{tender.id}}/agreements/original?supplier={{currentAuth.activeUser.id}}" ng-class="{disabled: !step.isActive()}" ng-click="step.clicked = true" class="btn btn-primary btn-sm">
                                            Stáhnout dokument k podepsání
                                        </a>
                                    </p>
                                    <p class="text-muted">
                                        Kliknutím stáhnete dokument s potvrzením nabídek, který je třeba elektronicky podepsat a nahrát zpět.
                                        <br/>
                                        Nepodepsané nabídky jsou neplatné.
                                    </p>
                                </div>

                                <div ng-switch-when="SIGNED_AGREEMENT_FILE_UPLOAD">
                                    <p>
                                        <span class="glyphicon glyphicon-arrow-down"></span>
                                    </p>
                                    <p>
                                    <form class="form-inline" style="display: inline-block;" ng-submit="onAgreementFileSelect($files)">
                                        <label>
                                            Nahrát podepsaný dokument
                                            <input class="form-control" ngf-select="onAgreementFileSelect($files)" type="file" name="fileData" ng-disabled="!step.isActive()" accept="application/pdf" />
                                        </label>
                                    </form>
                                    </p>
                                </div>

                                <div ng-switch-when="AGREEMENT_CONFIRM">
                                    <p>
                                        <span class="glyphicon glyphicon-arrow-down"></span>
                                    </p>
                                    <p>
                                        <button type="button" ng-click="confirmAgreement(); step.clicked = true" ng-disabled="!step.isActive()" class="btn btn-primary btn-sm">
                                            Podat nabídku
                                        </button>
                                    </p>
                                    <p class="text-muted">
                                        <a ng-href="{{CONTEXT_PATH}}/api/tenders/{{tender.id}}/agreements/original?supplier={{currentAuth.activeUser.id}}" ng-show="step.isActive()">
                                            Přehled podané nabídky
                                        </a>
                                    </p>
                                </div>

                            </div>
                        </div>
                    </div>

                </div>

            </div>
        </div>


        <div class="row">
            <div class="col-xs-12">

                <jp-loading ng-if="!demands"></jp-loading>

                <div ng-repeat="d in ::demands" class="panel" ng-class="{'panel-success': d.offers.length > 0, 'panel-info': d.offers.length === 0}">


                    <div class="demand-header panel-heading">
                        <div>
                            Poptávka na
                            <span ng-if="d.volume">
                                předplatné <span style="font-size: 1.2em;"><strong>{{d.desiredQuantity}}ks</strong></span> časopisu
                            </span>
                            <span ng-if="!d.volume">
                                <span style="font-size: 1.2em;"><strong>{{d.desiredQuantity}}ks</strong></span> knihy
                            </span>
                            <strong><a ng-href="{{CONTEXT_PATH}}/records/{{d.document.id}}">{{d.document|loc}}</a></strong>
                        </div>
                        <div>
                            <span ng-show="d.document.author"><span class="text-muted">Autor</span> {{d.document.author}}; </span>
                            <span ng-show="!d.volume && d.document.publisher"><span class="text-muted">Nakl:</span> {{d.document.publisher}}; </span>
                            <span ng-show="d.document.isbn"><span class="text-muted">{{d.volume && 'ISSN' || 'ISBN'}}</span> {{d.document.isbn.value}}</span>
                        </div>
                        <div>
                            <strong ng-show="d.electronicForm">V elektronické formě</strong>
                            <span ng-show="!d.electronicForm" class="text-muted">V tištěné formě</span>
                            <span ng-show="d.volume" class="text-muted">pro rok {{d.volume.year}}</span>
                        </div>
                    </div>


                    <div ng-if="d.offers.length === 0" class="text-muted text-center">
                        <button type="button" ng-if="tender.phase === 'STARTED' && currentAuth.role.includes('ROLE_SUPPLIER') && d.offerCreation.state === 'NORMAL'" ng-click="d.offerCreation.open()" class="btn btn-default btn-sm btn-block">
                            <span class="glyphicon glyphicon-plus"></span>
                            Zadat nabídku
                        </button>
                        <span ng-show="currentAuth.role.includes('ROLE_ADMIN') || currentAuth.role.includes('ROLE_LIBRARIAN')">Bez nabídky</span>
                        <span ng-show="currentAuth.role.includes('ROLE_SUPPLIER') && tender.phase === 'FINISHED'">Řízení skončilo, již nelze zadávat nabídky</span>
                    </div>


                    <div ng-if="tender.phase === 'STARTED' && d.offerCreation.state === 'EDITING'" class="demand-offers panel-body" style="padding: 40px 15px; font-size: 1.2em;">
                        <form ng-submit="d.offerCreation.send()" name="offerCreationForm">
                            <div class="form-group">
                                Mohu dodat
                                <span ng-if="d.desiredQuantity > 1">
                                    <span ng-if="quantitySelection">
                                        <input type="number" ng-model="d.offerCreation.offer.quantity" name="quantity" class="form-control" size="5" ng-required="true" min="1" max="{{d.desiredQuantity}}" style="width: 70px; display: inline-block;" />
                                        <strong>kusů</strong>,
                                    </span>
                                    <span ng-if="!quantitySelection">
                                        všechny ({{d.desiredQuantity}}) kusy,
                                    </span>
                                </span>
                                s cenou
                                <input type="text" ng-model="d.offerCreation.offer.price" jp-price-input name="price" class="form-control" size="10" ng-required="true" min="0" max="99999" style="width: 80px; display: inline-block;" /> <!-- we cannot use input type number because of miss interpreting it in edge (no value passed to ng-model) -->
                                <strong>{{d.offerCreation.offer.currency.text}}</strong> za kus bez DPH.

                                <span ng-show="d.offerCreation.offer.quantity > 1 && d.offerCreation.offer.price">
                                    Celkem <strong>{{(d.offerCreation.offer.quantity*d.offerCreation.offer.price) | decimal2comma}}{{d.offerCreation.offer.currency.text}}</strong>
                                </span>
                            </div>
                            <div class="form-group">
                                <label for="exampleInputFile">Poznámka
                                    <textarea ng-model="d.offerCreation.offer.note" class="form-control" rows="3" style="width: 100%"></textarea>
                                </label>
                            </div>
                            <button type="submit" class="btn btn-primary" ng-disabled="offerCreationForm.$invalid">Uložit nabídku</button>
                            <button type="button" ng-click="d.offerCreation.close()" class="btn btn-default">Zrušit</button>
                        </form>
                    </div>


                    <div jp-loading="xs" ng-show="d.offerCreation.state === 'PROCESSING'" class="panel-body"></div>


                    <ul ng-if="d.offers.length > 0" class="demand-offers list-group">
                        <li ng-repeat="o in d.offers" class="demand-offer list-group-item">
                            <div class="row">
                                <div class="col-xs-6">
                                    <div>
                                        Nabídka dodavatele
                                        <strong><a ng-href="{{CONTEXT_PATH}}/authorities/{{o.supplierAuthority.id}}">{{o.supplierAuthority|loc}}</a></strong>
                                    </div>
                                    <div>
                                        Vytvořena uživatelem
                                        <strong><a ng-href="{{CONTEXT_PATH}}/#!/users/{{o.supplierRepresentative.id}}">{{o.supplierRepresentative|loc}}</a></strong>
                                    </div>
                                    <div>Zadána {{o.createDate | jpDate:'d.M.yyyy HH:mm'}}</div>
                                    <div class="text-muted">{{o.note}}</div>
                                </div>
                                <div class="col-xs-2">
                                    <div ng-if="tender.phase === 'STARTED' && currentAuth.role.includes('ROLE_SUPPLIER') && d.offers.length > 0">
                                        <button type="button" ng-click="d.removeOffer(o)" class="btn btn-default pull-right">Zrušit nabídku</button>
                                    </div>
                                </div>
                                <div class="col-xs-4 text-right">
                                    <div>
                                        <span style="font-size: 1.6em; font-weight: bold;">{{o.price.amount | decimal2comma}} {{o.price.currency|loc}}</span>
                                        <small class="text-muted"> / ks</small>
                                    </div>
                                    <div ng-if="o.quantity < d.desiredQuantity" class="text-danger">
                                        Nabízí pouze {{o.quantity}} kus
                                    </div>
                                </div>
                            </div>
                        </li>
                    </ul>


                </div>
            </div>
        </div>

    </div>
</@layouts.full>