<#ftl outputFormat="HTML">
<#import "_layouts.ftl" as layouts>
<#import "_localization.ftl" as loc>


<@layouts.full>
    <div class="container">

        <div class="row">
            <div class="col-xs-12">
                <h1>Seznam map</h1>
            </div>
        </div>

        <div class="row" style="margin-bottom: 40px;">
            <div class="col-xs-12" ng-init="addMapFormVisible = false;">

                <button type="button" class="btn btn-primary" ng-click="addMapFormVisible = !addMapFormVisible">Přidat mapu</button>

                <div ng-show="addMapFormVisible" style="margin-top: 26px;">
                    <form class="form-horizontal" action="${currentPage.contextPath}/exemplar-placements/add" enctype="multipart/form-data" method="post">
                        <div class="form-group">
                            <label for="idMapyInput" class="col-sm-2 control-label">identifikátor mapy (${propertyProMapuRegalu})</label>
                            <div class="col-sm-10">
                                <input id="idMapyInput" type="text" name="idMapy" required class="form-control" />
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="informaceInput" class="col-sm-2 control-label">Další zobrazované informace</label>
                            <div class="col-sm-10">
                                <textarea id="informaceInput" name="information" cols="50" rows="4" class="form-control"></textarea>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="fileInput" class="col-sm-2 control-label">Mapa</label>
                            <div class="col-sm-10">
                                <input id="fileInput" type="file" name="fileData" required accept="image/*" class="form-control" />
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-sm-offset-2 col-sm-10">
                                <button type="submit" class="btn btn-primary">Uložit</button>
                            </div>
                        </div>
                    </form>
                </div>

            </div>
        </div>


        <div>
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th style="width: 100px">Identifikátor mapy (${propertyProMapuRegalu})</th>
                        <th>Další zobrazované informace</th>
                        <th>Mapa</th>
                        <th>Editovat</th>
                    </tr>
                </thead>
                <tbody>
                    <#list maps as map>
                        <tr>
                            <td>${map.id}</td>
                            <td>
                                <div class="row">
                                    <div class="col-xs-12">
                                        <form action="${currentPage.contextPath}/exemplar-placements/${map.id}/information" class="form-inline">
                                            <div class="form-group">
                                                <textarea name="information" rows="1" cols="50" class="control-label">
                                                    <#if map.information??>
                                                        ${map.information?esc}
                                                    </#if>
                                                </textarea>
                                            </div>
                                            <button type="submit" class="btn btn-xs btn-default">Uložit</button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <#if map.map??>
                                    <img src="data:image/jpeg;base64,${map.encodedMapData}" alt="map" width="100" height="80" />
                                </#if>
                            </td>
                            <td>
                                <a href="${currentPage.contextPath}/exemplar-placements/${map.id}/delete" class="btn btn-xs btn-default">Smazat</a>
                            </td>
                        </tr>
                    </#list>
                </tbody>
            </table>
        </div>

    </div>
</@layouts.full>