<#ftl outputFormat="HTML">
<#import "../_localization.ftl" as loc>


<div ng-controller="SearchedDocumentCtrl" ng-init="init(record, pagination.items); display = {moreParagraph: false}" class="list-item-document" ng-class="{'orderable': record.availability && isOrderable, 'not-orderable': record.availability && !isOrderable}">

    <div class="list-item-document-left">
        <div class="cover-container cover-container-document-search">
            <kp-svelte-component-wrapper component="::kpCoverComponent" props="::{record: record, href: documentLink, fillTo: 'width'}"></kp-svelte-component-wrapper>
        </div>
    </div>

    <div class="list-item-document-main">

        <h2 class="unset-style nazevZaznamu">
            <a ng-href="{{::documentLink}}">{{::record.name}}</a>
            <img ng-if="::record.downloadable" ng-src="{{::CONTEXT_PATH}}/resources/img/icons/ebook.png" width="18" height="18" alt="${loc.loc('record.ElektronickaForma')?noEsc} title="${loc.loc("record.ElektronickaForma")?noEsc}"/>
        </h2>

        <div class="record-subtitle" ng-bind-html="::record.subTitle | urlToLink"></div>

        <div class="list-item-document-autor">
            <span ng-repeat="author in record.mainAuthors" ng-show="author.id">
                <a ng-href="{{::CONTEXT_PATH}}/records/{{::author.id}}">{{::author|loc}}</a>
                <span ng-if="!$last"> - </span>
            </span>
        </div>

        <#-- defaultne vypnute v default.less (display: none), puziva se v artotece (artoteka.moravska-galerie.cz), zapnuto a nastylovano v custom stylech (nalepka-vypujceno.css) -->
        <div class="document-unavailable-badge" ng-if="availability.freeItemsCount < 1">${loc.loc("loan.Borrowed")?noEsc}</div>

        <jp-custom-paragraph content="record.exports.portaroSearchItemParagraph" class="paragraph-template list-item-document-paragraph-template"></jp-custom-paragraph>

        <#-- here used to be rating, it was removed because it was not working (and displayed) for a long time -->

        <div class="dostupnost" style="margin-top: 5px;">
            <#-- INFORMACE O POCTU EXEMPLARU NG -->
            <#-- ng-if == await for availability promise to resolve -->
            <kp-svelte-component-wrapper ng-if="availability" component="::kpAvailabilityInfoComponent" props="::{availability: availability}"></kp-svelte-component-wrapper>
        </div>

        <kp-find-in-databases record-id="record.id" ng-if="::record.withForeignOccurrences"></kp-find-in-databases>
    </div>

    <div class="buttonsPanel" jp-visible-on-hover-parent=".zaznamListItem" ng-cloak>

        <div class="jp-favourites-button-container">
            <kp-svelte-component-wrapper component="::kpFavouritesButtonComponent" props="::{record: record}"></kp-svelte-component-wrapper>
        </div>

        <div class="jp-clipboard-button-container everbis-hidden" ng-if="::currentAuth.role.includes('ROLE_LIBRARIAN')">
            <kp-svelte-component-wrapper component="::kpRecordClipboardButtonComponent" props="::{record: record}"></kp-svelte-component-wrapper>
        </div>

        <div ng-if="currentAuth.role.includes('ROLE_LIBRARIAN') && !recordClipboardService.isEmpty()" class="everbis-hidden">
            <button class="btn btn-default btn-xs btn-block" ng-click="mergeToThis(recordClipboardService.getAll())">${loc.loc("record.MergeSelectedToThis")?noEsc} ({{clipboard.size()}})</button>
        </div>

        <#-- TLACITKO OBJEDNAT/REZERVOVAT -->
        <kp-availability-button kp-availability="availability" kp-on-request="requestDocument()" kp-for-exemplar="false" kp-block="true"></kp-availability-button>

        <div ng-if="::currentAuth.role.includes('ROLE_LIBRARIAN')" class="everbis-hidden">
            <a class="btn btn-primary btn-xs btn-block" ng-href="{{::CONTEXT_PATH}}/records/{{::record.id}}/edit">${loc.loc("commons.editovat")?noEsc}</a>
        </div>

        <div ng-if="record.exports.portaroSearchItemMoreParagraph">
            <button class="btn btn-default btn-block btn-xs" ng-click="display.moreParagraph = !display.moreParagraph">${loc.loc("commons.more")?noEsc}</button>
        </div>
    </div>

    <jp-custom-paragraph class="paragraph-template list-item-document-paragraph-template-moreInfo" ng-if="display.moreParagraph && record.exports.portaroSearchItemMoreParagraph" content="record.exports.portaroSearchItemMoreParagraph"></jp-custom-paragraph>
</div>
