<#ftl outputFormat="HTML">
<#import "../_localization.ftl" as loc>


<div ng-controller="SearchedAuthorityCtrl" ng-init="init(record)" class="autoritaListItem" ng-class="{'no-related-documents-record': relatedRecordsCount === 0}">

    <div ng-if="record.cover" class="list-item-authority-left">
        <div class="cover-container cover-container-authority-search">
            <kp-svelte-component-wrapper component="::kpCoverComponent" props="::{record: record, href: getRecordLink(record.id), fillTo: 'width'}"></kp-svelte-component-wrapper>
        </div>
    </div>

    <div class="list-item-authority-main">

        <div>
            <h2 class="unset-style nazevZaznamu">
                <a ng-href="{{::getRecordLink(record.id)}}">{{record.name}}</a>
            </h2>
            <span ng-if="relatedRecordsCount !== undefined" class="dodatkovyText" title="${loc.loc("rejstrik.pocetDokumentuObsahujicichTutoAutoritu")?noEsc}">
                ({{relatedRecordsCount}}x)
            </span>

            <jp-custom-paragraph content="record.exports.portaroSearchItemParagraph" class="paragraph-template list-item-authority-paragraph-template"></jp-custom-paragraph>
        </div>

        <#-- VIZ TEZ AUTORITY -->
        <div ng-repeat="seeAlso in record.seeAlsos">
            <span style="margin-left: 15px;">
                ${loc.loc("commons.vizTez")?noEsc}:
                <a ng-href="{{::getRecordLink(seeAlso.id)}}">{{seeAlso|loc}}</a>
            </span>
        </div>

    </div>

    <div class="buttonsPanel" jp-visible-on-hover-parent=".zaznamListItem" ng-cloak>

        <div class="jp-clipboard-button-container everbis-hidden" ng-if="::currentAuth.role.includes('ROLE_LIBRARIAN')">
            <kp-svelte-component-wrapper component="::kpRecordClipboardButtonComponent" props="::{record: record}"></kp-svelte-component-wrapper>
        </div>

        <div ng-if="currentAuth.role.includes('ROLE_LIBRARIAN') && !recordClipboardService.isEmpty()" class="everbis-hidden">
            <button class="btn btn-default btn-xs btn-block" ng-click="mergeToThis(recordClipboardService.getAll())">${loc.loc("record.MergeSelectedToThis")?noEsc} ({{clipboard.size()}})</button>
        </div>

        <div ng-if="::currentAuth.role.includes('ROLE_LIBRARIAN')" class="everbis-hidden">
            <a ng-href="{{CONTEXT_PATH}}/records/{{record.id}}/edit" class="btn btn-primary btn-xs btn-block">${loc.loc("commons.editovat")?noEsc}</a>
        </div>

    </div>

    <div class="cleaner"></div>

</div>