<#ftl outputFormat="HTML">
<#import "../_localization.ftl" as loc>


<div class="container search type-{{searchManager.lastSearch().type}}" style="margin-top: 20px;">

    <#-- nazev hledani -->
    <div class="row" ng-if="searchManager.lastSearch().type !== 'catalog'">
        <div class="col-xs-12">
            <h1>
                <span class="search-header">{{searchManager.lastSearch().title|loc|characters:200}}</span>
                <small class="search-subheader">{{searchManager.lastSearch().subtitle|loc|characters:200}}</small>
            </h1>
        </div>
    </div>

    <#-- vypis hlavicky rejstriku -->
    <div class="row" style="margin-bottom: 5px;" ng-if="searchManager.lastSearch().features && searchManager.lastSearch().features.includes('alphabet')">
        <div class="col-xs-12">

            <div class="pismena alphabet {{searchManager.lastResult().params.fond | prop:'id' | inline:' ':'fond_'}}" ng-init="alphabet = ['START', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z']">
                <!-- SEZNAM PÍSMEN -->
                <ul>
                    <li ng-repeat="letter in alphabet" class="letter-{{letter}}">
                        <a href="" ng-click="searchManager.params().prefix = (letter === 'START' ? '' : letter); newSearch()" ng-class="{'active': searchManager.lastResult().params.prefix === letter || (letter === 'START' && !searchManager.lastResult().params.prefix)}">{{letter}}</a>
                    </li>
                </ul>
            </div>

            <h1 ng-show="searchManager.lastResult().params.prefix" class="rejstrik-startPosHeader">{{searchManager.lastResult().params.prefix}}</h1>

        </div>
    </div>

    <div class="search-result-info" ng-if="searchManager.lastSearch().type !== 'catalog'">
        <#-- vypis prubehu hledani -->
        <div class="row" ng-if="searchManager.lastResult().searchProcess.attemptsCount > 1">
            <div class="col-xs-12">
                <div class="informaceORozsireniHledaniOPodobnost">${loc.loc("hledani.prubeh.podobnostSlov")?noEsc}</div>
            </div>
        </div>

        <#-- vypis poctu vyhledanych -->
        <div class="row dodatkovyText" id="search-result-records-count-info" ng-if="searchManager.lastResult()">
            <div class="col-xs-12">

                {{searchManager.lastResult().totalElements}}
                <kp-svelte-component-wrapper
                        component="::kpPluralizeTextComponent"
                        props="::{
                                count: searchManager.lastResult().totalElements,
                                zeroCountText: '${loc.loc("vysledky.nalezenychZaznamu")?esc}',
                                oneCountText: '${loc.loc("vysledky.nalezenyZaznam")?esc}',
                                twoThreeFourCountText: '${loc.loc("vysledky.nalezeneZaznamy")?esc}',
                                moreText: '${loc.loc("vysledky.nalezenychZaznamu")?esc}'}">
                </kp-svelte-component-wrapper>,
                ${springMacroRequestContext.getMessage("vysledky.hledaniTrvaloXms", ["{{searchManager.lastResult().duration}}"])?noEsc}
            </div>
        </div>
    </div>

    <div class="row">
        <div class="main-panel-hlavni" ng-class="{'col-sm-8': searchManager.lastSearch().type !== 'catalog', 'col-sm-12': searchManager.lastSearch().type === 'catalog'}">

            <div ng-if="searchManager.lastSearch().type === 'catalog' && searchManager.lastSearch().features && searchManager.lastSearch().features.includes('faceting') && searchManager.lastResult().availableFacets">
                <#-- this is special case for catalog search used in ARTOTEKA -->
                <kp-svelte-component-wrapper component="::kpSearchFacetsComponent"
                                             props="{
                                                availableFacets: searchManager.lastResult().availableFacets,
                                                selectedFacetConjunction: searchManager.params().facetRestriction,
                                                defaultExpandedFacets: searchManager.lastSearch().defaultExpandedFacets}"
                                             ng-on-restrictions-change="facetRestrictionChanged($event.originalEvent.detail)">
                </kp-svelte-component-wrapper>
            </div>

            <div ng-if="searchManager.lastSearch().type !== 'catalog'" class="clearfix" style="margin-top: 20px;">
                <jp-search-page-size ng-if="searchManager.lastSearch().features && searchManager.lastSearch().features.includes('pageSizeChanging')"
                                     current-size="searchManager.lastSearch().result.pageSize"
                                     on-change="onPageSizeChange"
                                     available-sizes="[10,20,30]"
                                     style="float: right"></jp-search-page-size>

                <kp-svelte-component-wrapper component="::kpSearchSortingComponent" props="::{searchManager: searchManager}"></kp-svelte-component-wrapper>
            </div>

            <#-- vodorovna cara nad vyhledanymi zaznamy -->
            <div class="hrDiv" style="margin-top: 5px; margin-bottom: 5px;"></div>

            <jp-pagination jp-pagination="searchManager.getPagination()">
                <ol ng-if="searchManager.lastSearch().type !== 'exemplar-search'" style="list-style-type: none; margin: 0; padding: 0;">
                    <li ng-repeat="page in $parent.$parent.pagination.pages track by $index" class="search-page search-page-{{page.pageNumber}}" aria-label="{{'${loc.loc("vysledky.PageX")?noEsc}' | strParams : page.pageNumber}}" value="{{page.pageNumber}}">
                        <ul style="list-style-type: none; margin: 0; padding: 0;">
                            <li ng-repeat="record in page.items track by record.id" class="search-item search-item-{{$index}}">

                                <div ng-if="record.type === 'authority'" class="row zaznamListItem">
                                    <div ng-include="TEMPLATES_PATH + 'search-item-authority.html'"></div>
                                </div>
                                <div ng-if="record.type === 'document'" class="row zaznamListItem">
                                    <div ng-include="TEMPLATES_PATH + 'search-item-document.html'" ng-init="pagination = searchManager.getPagination()"></div>
                                </div>
                                <div ng-if="record.role" class="row zaznamListItem vyhledanyCtenar"> <!-- user has role property -->
                                    <kp-search-item-user user="record" search-manager="searchManager" can-edit="true"></kp-search-item-user>
                                </div>
                                <div ng-if="record.viewForms" class="row zaznamListItem searched-file"> <!-- file has viewForms property -->
                                    <div ng-include="TEMPLATES_PATH + 'search-item-file.html'" class="col-xs-12"></div>
                                </div>
                                <div ng-if="record.sumToPay" class="row zaznamListItem searched-payment"> <!-- payment has sumToPay property -->
                                    <div ng-include="TEMPLATES_PATH + 'search-item-payment.html'" class="col-xs-12"></div>
                                </div>
                                <div ng-if="record.recordOperationType" class="row zaznamListItem searched-record-operation">
                                    <!-- record operation has recordOperationType property -->
                                    <div ng-include="TEMPLATES_PATH + 'search-item-record-operation.html'" class="col-xs-12"></div>
                                </div>
                                <div ng-if="record.inventoryStatusId" class="row zaznamListItem searched-inventory"> <!-- inventory has inventoryStatusId property -->
                                    <div ng-include="TEMPLATES_PATH + 'search-item-inventory.html'" class="col-xs-12"></div>
                                </div>
                                <div ng-if="record.captureWay" class="row zaznamListItem searched-catch"> <!-- catch has captureWay property -->
                                    <div ng-include="TEMPLATES_PATH + 'search-item-catch.html'" class="col-xs-12"></div>
                                </div>
                                <div ng-if="record.matchState" class="row zaznamListItem searched-match"> <!-- match has matchState property -->
                                    <div ng-include="TEMPLATES_PATH + 'search-item-match.html'" class="col-xs-12"></div>
                                </div>

                            </li>
                        </ul>
                    </li>
                </ol>
                <div ng-if="searchManager.lastSearch().type === 'exemplar-search'" style="overflow-y: auto">
                    <table class="table table-hover table-condensed table-responsive exemplar-table">
                        <thead>
                            <tr>
                                <th class="col_accessNumber">${loc.loc('exemplar.AccessNumber.abbr')}</th>
                                <th class="col_signature">${loc.loc('exemplar.Signature.abbr')}</th>
                                <th class="col_documentIsbn">ISBN</th>
                                <th class="col_documentName">${loc.loc('commons.nazev')}</th>
                                <th class="col_documentAuthor">${loc.loc('commons.autor')}</th>
                                <th class="col_department">${loc.loc('exemplar.department')}</th>
                                <th class="col_location">${loc.loc('exemplar.location')}</th>
                                <th class="col_acquisitionYear"></th>
                                <th class="col_fond">Fond</th>
                                <th class="col_discardionDiscardNumber">${loc.loc('exemplar.ubytek')}</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr ng-repeat="e in $parent.$parent.pagination.items track by e.id" class="searched-exemplar">
                                <td class="col_accessNumber">{{e.accessNumber}}</td>
                                <td class="col_signature">{{e.signature}}</td>
                                <td class="col_documentIsbn">{{e.documentIsbn.value}}</td>
                                <td class="col_documentName"><a ng-href="{{CONTEXT_PATH}}/records/{{e.recordId}}">{{e.documentName}}</a></td>
                                <td class="col_documentAuthor">{{e.documentAuthor}}</td>
                                <td class="col_department">{{e.department|loc}}</td>
                                <td class="col_location">{{e.location|loc}}</td>
                                <td class="col_acquisitionYear">{{e.acquisitionYear}}</td>
                                <td class="col_fond">{{e.fond|loc}}</td>
                                <td class="col_discardionDiscardNumber">{{e.discardionDiscardNumber}}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div ng-if="searchManager.lastSearch().type === 'loan-search'" style="overflow-y: auto">
                    <table class="table table-hover table-condensed table-responsive loan-table">
                        <thead>
                            <tr>
                                <th class="col_id">#</th>
                                <th class="col_documentName">${loc.loc('commons.nazev')}</th>
                                <th class="col_lender">${loc.loc('loan.Lender')}</th>
                                <th class="col_exemplarName">${loc.loc('exemplar.Exemplar.abbr')}</th>
                                <th class="col_state">${loc.loc("commons.stav")?noEsc}</th>
                                <th class="col_department">${loc.loc('department.Department.abbr')}</th>
                                <th class="col_desiredDepartment">${loc.loc('loan.DesiredDepartment.abbr')}</th>
                                <th class="col_lendDate">${loc.loc('loan.LoanDate.abbr')}</th>
                                <th class="col_endDate">${loc.loc('loan.EndDate.abbr')}</th>
                                <th class="delete"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr ng-repeat="li in $parent.$parent.pagination.items track by li.id" class="searched-loan">
                                <td class="col_id">{{li.loanRealizationId}}</td>
                                <td class="col_documentName"><a ng-href="{{CONTEXT_PATH}}/records/{{li.document.id}}">{{li.document|loc}}</a></td>
                                <td class="col_lender"><a ng-href="{{CONTEXT_PATH}}/#!/users/{{li.user.id}}">{{li.user|loc}}</a></td>
                                <td class="col_exemplarName">
                                    <div ng-show="li.exemplar.accessNumber"><small class="text-muted">${loc.loc('exemplar.AccessNumber.abbr')}</small> <small>{{li.exemplar.accessNumber}}</small></div>
                                    <div ng-show="li.exemplar.barCode"><small class="text-muted">${loc.loc('exemplar.BarCode.abbr')}</small> <small>{{li.exemplar.barCode}}</small></div>
                                    <div ng-show="li.exemplar.signature"><small class="text-muted">${loc.loc('exemplar.Signature.abbr')}</small> <small>{{li.exemplar.signature}}</small></div>
                                </td>
                                <td class="col_state">{{li.state|loc}}</td>
                                <td class="col_department">{{li.department|loc}}</td>
                                <td class="col_desiredDepartment">
                                    <div ng-repeat="d in li.desiredDepartments track by d.id">{{d|loc}}</div>
                                </td>
                                <td class="col_lendDate">{{li.lendDate|jpDate:'d.M.yyyy'}}</td>
                                <td class="col_endDate">{{li.endDate|jpDate:'d.M.yyyy'}}</td>
                                <td class="delete" ng-if="li.state.id !== 'LENT' && !['PROCESSED_ORDER', 'SENT_RESERVATION'].includes(li.state.id)">
                                    <button class="btn btn-default" type="button" ng-click="cancelLoan(li)">
                                        <i class="glyphicon glyphicon-trash"></i>
                                    </button>
                                </td>
                                <td class="more" ng-if="['PROCESSED_ORDER', 'SENT_RESERVATION'].includes(li.state.id)">
                                    <div class="btn-group" uib-dropdown dropdown-append-to-body="true">
                                        <button type="button" class="btn btn-default" uib-dropdown-toggle>
                                            <i class="glyphicon glyphicon-option-horizontal"></i>
                                        </button>
                                        <ul class="dropdown-menu" uib-dropdown-menu role="menu" aria-labelledby="single-button">
                                            <li role="menuitem"><a href="javascript:void(0)" ng-click="cancelLoan(li)"><i class="glyphicon glyphicon-trash"></i> <span>Smazat</span></a></li>
                                            <li role="menuitem"><kp-action-request-button display-as-link="true" path="/api/loan-items/{{li.id}}/notify" request-method="post">Znovu odeslat upozornění</kp-action-request-button></li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div ng-if="searchManager.lastSearch().type === 'loan-reminder-search'" style="overflow-y: auto">
                    <table class="table table-hover table-condensed table-responsive loan-table">
                        <thead>
                            <tr>
                                <th class="col_reminderType">${loc.loc('loan.reminder.ReminderType')}</th>
                                <th class="col_reader">${loc.loc('user.Reader')}</th>
                                <th class="col_document">${loc.loc('commons.Record')}</th>
                                <th class="col_exemplar">${loc.loc('commons.Exemplar')}</th>
                                <th class="col_loanInfo">${loc.loc('loan.Loan')}</th>
                                <th class="col_loanReminderInfo">${loc.loc('commons.datum')}</th>
                                <th class="col_department">${loc.loc('commons.Department')}</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr ng-repeat="li in $parent.$parent.pagination.items track by li.id" class="searched-loan-reminder">
                                <td>{{li.type | loc}}</td>
                                <td><a ng-href="{{CONTEXT_PATH}}/#!/users/{{li.loan.user.id}}" target="_blank">{{li.loan.user | loc}}</a></td>
                                <td><a ng-href="{{CONTEXT_PATH}}/records/{{li.loan.document.id}}" target="_blank">{{li.loan.document | loc}}</a></td>
                                <td>
                                    <div ng-show="li.loan.exemplar.accessNumber"><small class="text-muted">${loc.loc('exemplar.AccessNumber.abbr')}</small> <small>{{li.loan.exemplar.accessNumber}}</small></div>
                                    <div ng-show="li.loan.exemplar.barCode"><small class="text-muted">${loc.loc('exemplar.barCode')}</small> <small>{{li.loan.exemplar.barCode}}</small></div>
                                    <div ng-show="li.loan.exemplar.signature"><small class="text-muted">${loc.loc('exemplar.Signature.abbr')}</small> <small>{{li.loan.exemplar.signature}}</small></div>
                                </td>
                                <td>
                                    <div ng-show="li.loan.loanCategory"><small class="text-muted">${loc.loc('loan.LoanCategoryAbbr')}</small> <small>{{li.loan.loanCategory | loc}}</small></div>
                                    <div ng-show="li.loan.lendDate"><small class="text-muted">${loc.loc('loan.LentFromAbbr')}</small> <small>{{li.loan.lendDate | jpDate:'d.M.yyyy'}}</small></div>
                                    <div ng-show="li.loan.dueDate"><small class="text-muted">${loc.loc('loan.LentToAbbr')}</small> <small>{{li.loan.dueDate | jpDate:'d.M.yyyy'}}</small></div>
                                </td>
                                <td>
                                    <div ng-show="li.generationDate"><small class="text-muted">${loc.loc('loan.reminder.Generated')}</small> <small>{{li.generationDate | jpDate:'d.M.yyyy'}}</small></div>
                                    <div ng-show="li.sentDate"><small class="text-muted">${loc.loc('loan.reminder.Sent')}</small> <small>{{li.sentDate | jpDate:'d.M.yyyy'}}</small></div>
                                </td>
                                <td>{{li.loan.department | loc}}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div ng-if="searchManager.lastSearch().type === 'message-search'" style="overflow-y: auto">
                    <table class="table table-hover table-condensed table-responsive loan-table">
                        <thead>
                            <tr>
                                <th class="col_target">${loc.loc('message.TargetUser')}</th>
                                <th class="col_created">${loc.loc('message.DateCreated')}</th>
                                <th class="col_topic">${loc.loc('message.Topic')}</th>
                                <th class="col_severity">${loc.loc('message.Severity')}</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="searched-loan-reminder" ng-repeat-start="li in $parent.$parent.pagination.items track by li.id" ng-init="open = false; opened = false; detail = null">
                                <td><a ng-href="{{CONTEXT_PATH}}/#!/users/{{li.targetUser.id}}" target="_blank">{{li.targetUser | loc}}</a></td>
                                <td>{{li.creationEvent.createDate | jpDate:'d.M.yyyy'}}</td>
                                <td>{{li.topic | loc}}</td>
                                <td class="col_severity">
                                    <div ng-class="li.severity.id">{{li.severity | loc}}</div>
                                </td>
                                <td>
                                    <button class="btn btn-default btn-xs" ng-click="open = !open; (open && !opened && (detail = loadMessageSendings(li.id))); opened = true">
                                        <i class="glyphicon glyphicon-zoom-in" ng-hide="open"></i>
                                        <i class="glyphicon glyphicon-zoom-out" ng-show="open"></i>
                                    </button>
                                </td>
                            </tr>
                            <tr ng-repeat-end ng-if="open">
                                <td class="message-detail-row" colspan="5">
                                    <kp-message-sending message-sending="messageSending" ng-repeat="messageSending in detail | async"></kp-message-sending>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </jp-pagination>

            <#-- search intents -->
            <kp-available-intents available-intents="searchManager.lastSearch().availableIntents"
                                  new-search-with-params-callback="newSearchWithParams"
                                  defined-action-returned-value-handler="goToRecord"
                                  ng-show="searchManager.getPagination().state.page === 'NORMAL'">
            </kp-available-intents>

        </div>

        <aside class="main-panel-pravy" ng-class="{'col-sm-4': searchManager.lastSearch().type !== 'catalog'}"
             ng-show="searchManager.lastSearch().type !== 'catalog'">

            <div>
                <kp-svelte-component-wrapper component="::kpRecordClipboardPanelComponent"></kp-svelte-component-wrapper>
            </div>
            <kp-svelte-component-wrapper ng-if="searchManager.lastSearch()"
                                         component="::kpSearchAdditionalFiltersComponent"
                                         props="getSearchFiltersComponentProps(searchManager.lastSearch().forms, searchManager.params())"
                                         ng-on-params-change="searchManager.setParams($event.originalEvent.detail)"
                                         ng-on-submit-search="newSearch()">
            </kp-svelte-component-wrapper>

            <section ng-if="searchManager.lastSearch().features && searchManager.lastSearch().features.includes('faceting') && searchManager.lastResult().availableFacets"
                     aria-label="${loc.loc("hledani.vybratZVyhledanych")?noEsc}">
                    <kp-svelte-component-wrapper component="::kpSearchFacetsComponent"
                                                 props="{
                                                    availableFacets: searchManager.lastResult().availableFacets,
                                                    selectedFacetConjunction: searchManager.params().facetRestriction,
                                                    defaultExpandedFacets: searchManager.lastSearch().defaultExpandedFacets}"
                                                 ng-on-restrictions-change="facetRestrictionChanged($event.originalEvent.detail)"
                                                 class="panel panel-default search-facet-panel" style="display: block">
                    </kp-svelte-component-wrapper>
            </section>


            <form ng-if="searchManager.lastSearch().type === 'authority-index'" action="{{CONTEXT_PATH + '/search'}}" class="panel panel-default">
                <div class="panel-heading">
                    ${loc.loc("hledani.vyhledavaniAutort")?noEsc}
                </div>
                <div class="panel-body">
                    <input type="hidden" name="kind" value="authority" />
                    <div class="input-group">
                        <input type="text" class="form-control" name="q" value="" />
                        <span class="input-group-btn">
                        <button type="submit" class="btn btn-primary">${loc.loc("commons.hledat")?noEsc}</button>
                    </span>
                    </div>
                </div>
            </form>


            <div>
                <kp-svelte-component-wrapper component="::kpFavouritesPanelComponent"></kp-svelte-component-wrapper>
            </div>


            <div>
                <kp-svelte-component-wrapper component="::kpVisitedPanelComponent"></kp-svelte-component-wrapper>
            </div>

        </aside>
    </div>

    <div class="row">
        <div class="upperFooter row col-sm-12">
            <jp-links class="search-export"
                      links="searchManager.lastSearch().availableExports"
                      jp-show-if-empty="false"
                      jp-dropdown-button-text="'${loc.loc("export.ExportVsechVyhledanych")?noEsc}'"
                      jp-button-size="xs">
            </jp-links>
            ${" | "}
            <button type="button" class="btn btn-default btn-xs" ng-click="addSdiRequest()">${loc.loc("sdi.PosilatNovinkyZTohotoHledani")?noEsc}</button>
            ${" | "}
            <a ng-href="{{CONTEXT_PATH}}/search-history">${loc.loc("hledani.ZobrazitHledaneDotazy")?noEsc}</a>
        </div>
    </div>

</div>
