/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.web;

import cz.kpsys.portaro.commons.crypto.CertificateAndKeyResourcesKeystoreProvider;
import cz.kpsys.portaro.commons.crypto.KeystoreSuppliedUrlStreamHandlerFactory;
import cz.kpsys.portaro.commons.crypto.ResourceKeystoreProvider;
import cz.kpsys.portaro.commons.io.ResourceProviderByResourceLoader;
import cz.kpsys.portaro.commons.net.ResourceLoaderUrlStreamHandlerFactory;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.util.StringUtil;
import java.beans.ConstructorProperties;
import java.net.InetAddress;
import java.net.URLStreamHandlerFactory;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.webresources.TomcatURLStreamHandlerFactory;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.Nullable;

public class TomcatHttpsConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TomcatHttpsConfigurer.class);
    private static final String GENERATED_KEYSTORE_PASSWORD = "";
    private static final String GENERATED_KEYSTORE_KEY_ALIAS = "tomcat";
    public static final String AUTOMATIC_KEYSTORE_KEY_ALIAS = "auto";
    @NonNull
    private final ResourceLoader keystoreResourceLoader;
    @NonNull
    private final Optional<InetAddress> serverListenIp;
    private static boolean userFactoryAddedToTomcatURLStreamHandlerFactory = false;

    public void configureByCertificateAndKey(TomcatServletWebServerFactory factory, int port, String certificateLocation, @Nullable String caCertificateLocation, String privateKeyLocation, @Nullable String privateKeyPassword) {
        log.info("Configuring HTTPS with certificate in {} and private key in {}" + (String)(caCertificateLocation != null ? " and CA in " + caCertificateLocation : GENERATED_KEYSTORE_PASSWORD), (Object)certificateLocation, (Object)privateKeyLocation);
        CertificateAndKeyResourcesKeystoreProvider keystoreProvider = new CertificateAndKeyResourcesKeystoreProvider(certificateLocation, caCertificateLocation, privateKeyLocation, privateKeyPassword, GENERATED_KEYSTORE_PASSWORD, GENERATED_KEYSTORE_KEY_ALIAS, this.keystoreResourceLoader);
        this.configureByKeystore(factory, port, "inmemory:keyStore", GENERATED_KEYSTORE_PASSWORD, GENERATED_KEYSTORE_KEY_ALIAS, (Supplier)keystoreProvider);
    }

    public void configureByKeystore(TomcatServletWebServerFactory factory, int port, String keystoreResourceLocation, String keystorePassword, String keystoreKeyAlias) {
        log.info("Configuring HTTPS with keystore in {} with {} alias", (Object)keystoreResourceLocation, (Object)keystoreKeyAlias);
        ResourceKeystoreProvider keystoreProvider = ResourceKeystoreProvider.ofJks((Provider)ResourceProviderByResourceLoader.ofStaticLocation((ResourceLoader)this.keystoreResourceLoader, (String)keystoreResourceLocation), (String)keystorePassword);
        this.configureByKeystore(factory, port, keystoreResourceLocation, keystorePassword, keystoreKeyAlias, (Supplier)keystoreProvider);
    }

    public void configureByKeystore(TomcatServletWebServerFactory factory, int port, String keystoreResourceLocation, String keystorePassword, String keystoreKeyAlias, Supplier<KeyStore> keyStoreSupplier) {
        log.info("Configuring HTTPS with keystore supplier as keystore {} with {} alias", (Object)keystoreResourceLocation, (Object)keystoreKeyAlias);
        Connector httpsConnector = new Connector(Http11NioProtocol.class.getName());
        httpsConnector.setScheme("https");
        httpsConnector.setSecure(true);
        httpsConnector.setPort(port);
        Http11NioProtocol protocol = (Http11NioProtocol)httpsConnector.getProtocolHandler();
        this.serverListenIp.ifPresent(arg_0 -> ((Http11NioProtocol)protocol).setAddress(arg_0));
        protocol.setSSLEnabled(true);
        SSLHostConfig sslHostConfig = new SSLHostConfig();
        sslHostConfig.setHostName(protocol.getDefaultSSLHostConfigName());
        protocol.addSslHostConfig(sslHostConfig);
        SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(sslHostConfig, SSLHostConfigCertificate.Type.UNDEFINED);
        certificate.setCertificateKeystoreFile(keystoreResourceLocation);
        certificate.setCertificateKeystorePassword(keystorePassword);
        certificate.setCertificateKeystoreType("jks");
        sslHostConfig.addCertificate(certificate);
        Arrays.stream(protocol.findSslHostConfigs()).forEach(sslHostConf -> sslHostConf.setProtocols(StringUtil.joinSkippingBlanksAndNulls((String)",", (String[])new String[]{"TLSv1.2", "TLSv1.3"})));
        if (!AUTOMATIC_KEYSTORE_KEY_ALIAS.equals(keystoreKeyAlias)) {
            certificate.setCertificateKeyAlias(keystoreKeyAlias);
        }
        this.configureResourceLoaderUrlStreamHandlerFactory(keyStoreSupplier);
        factory.addAdditionalTomcatConnectors(new Connector[]{httpsConnector});
    }

    public void configureResourceLoaderUrlStreamHandlerFactory(Supplier<KeyStore> keyStoreSupplier) {
        if (!userFactoryAddedToTomcatURLStreamHandlerFactory) {
            TomcatURLStreamHandlerFactory instance = TomcatURLStreamHandlerFactory.getInstance();
            instance.addUserFactory((URLStreamHandlerFactory)new ResourceLoaderUrlStreamHandlerFactory(this.keystoreResourceLoader, Set.of("custom", "db")));
            instance.addUserFactory((URLStreamHandlerFactory)new KeystoreSuppliedUrlStreamHandlerFactory(keyStoreSupplier));
            userFactoryAddedToTomcatURLStreamHandlerFactory = true;
        } else {
            log.warn("Tomcat url stream handler factory already have our custom ResourceLoaderUrlStreamHandlerFactory");
        }
    }

    @ConstructorProperties(value={"keystoreResourceLoader", "serverListenIp"})
    @Generated
    public TomcatHttpsConfigurer(@NonNull ResourceLoader keystoreResourceLoader, @NonNull Optional<InetAddress> serverListenIp) {
        Objects.requireNonNull(keystoreResourceLoader, "keystoreResourceLoader is marked non-null but is null");
        Objects.requireNonNull(serverListenIp, "serverListenIp is marked non-null but is null");
        this.keystoreResourceLoader = keystoreResourceLoader;
        this.serverListenIp = serverListenIp;
    }
}

