/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.app.CatalogConstants;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.FilteredAndSortedAllValuesContextualProvider;
import cz.kpsys.portaro.commons.convert.ListToModifiedListConverter;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.ConvertingAllValuesProvider;
import cz.kpsys.portaro.commons.object.LabeledIdentified;
import cz.kpsys.portaro.commons.object.filter.EqualsPredicate;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.record.detail.FieldTypeLoader;
import cz.kpsys.portaro.record.detail.IndicatorTypeLoader;
import cz.kpsys.portaro.record.detail.appservermarc.MarcXmlToDetailConverterImpl;
import cz.kpsys.portaro.record.detail.convert.MarcXmlToDetailConverter;
import cz.kpsys.portaro.record.edit.RecordEntryElementResolver;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.search.field.QueryFieldsBySearchFieldLoader;
import cz.kpsys.portaro.search.field.SearchField;
import cz.kpsys.portaro.search.restriction.Restriction;
import cz.kpsys.portaro.search.z.RestrictionToZServerQueryConverter;
import cz.kpsys.portaro.search.z.SpringDbZServerLoader;
import cz.kpsys.portaro.search.z.ZServer;
import cz.kpsys.portaro.search.z.ZServerDatasource;
import cz.kpsys.portaro.search.z.ZServerQueryBuilder;
import cz.kpsys.portaro.search.z.ZServerQueryFieldLoaderInMemory;
import cz.kpsys.portaro.search.z.ZServerService;
import cz.kpsys.portaro.search.z.ZServerServiceAppserver;
import cz.kpsys.portaro.search.z.ZServerToZServerDatasetConverter;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class ZServerConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZServerConfig.class);
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final Codebook<Fond, Integer> fondLoader;
    @NonNull
    private final FieldTypeLoader fieldTypeLoader;
    @NonNull
    private final IndicatorTypeLoader defaultableDocumentIndicatorTypeLoader;
    @NonNull
    private final IndicatorTypeLoader defaultableAuthorityIndicatorTypeLoader;
    @NonNull
    private final RecordEntryElementResolver recordEntryElementResolver;
    @NonNull
    private final LinkedHashMap<Predicate<String>, AllValuesProvider<? extends LabeledIdentified<?>>> allDatatypeToAllValuesProviderMap;

    @Bean
    public Codebook<ZServer, Integer> zServerLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbZServerLoader(this.jdbcTemplate, this.queryFactory, this.fondLoader)).staticCached(ZServer.class.getSimpleName()).build();
    }

    @Bean
    public ContextualProvider<Department, List<ZServer>> allowedZServersDepartmentedProvider() {
        return new FilteredAndSortedAllValuesContextualProvider((AllValuesProvider)this.zServerLoader(), this.settingLoader.getDepartmentedProvider(SettingKeys.ENABLED_ZSERVERS)).withConditionallyShowAll(this.settingLoader.getDepartmentedProvider(SettingKeys.SHOW_ALL_ZSERVERS));
    }

    @Bean
    public AllValuesProvider<ZServerDatasource> allZServerDatasetsProvider() {
        return ConvertingAllValuesProvider.byItemConverter((AllValuesProvider)this.zServerLoader(), (Converter)new ZServerToZServerDatasetConverter());
    }

    @Bean
    public ContextualProvider<Department, List<ZServerDatasource>> allowedZServerDatasetsProvider() {
        return this.allowedZServersDepartmentedProvider().andThen(arg_0 -> ((ListToModifiedListConverter)new ListToModifiedListConverter((Converter)new ZServerToZServerDatasetConverter())).convert(arg_0));
    }

    @Bean
    public ZServerService zServerService() {
        return new ZServerServiceAppserver(this.mappingAppserver, (ByIdLoadable)this.zServerLoader(), new ZServerQueryBuilder(this.restrictionToZServerQueryConverter()), (MarcXmlToDetailConverter)new MarcXmlToDetailConverterImpl(true, this.fieldTypeLoader, this.defaultableAuthorityIndicatorTypeLoader, this.defaultableDocumentIndicatorTypeLoader, (ByIdLoadable)this.fondLoader), (AllValuesProvider)this.fondLoader, this.recordEntryElementResolver);
    }

    @Bean
    public Converter<Restriction<? extends SearchField>, String> restrictionToZServerQueryConverter() {
        return new RestrictionToZServerQueryConverter((QueryFieldsBySearchFieldLoader)new ZServerQueryFieldLoaderInMemory());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerAcceptableValuesProviders() {
        this.allDatatypeToAllValuesProviderMap.put(new EqualsPredicate((Object)CatalogConstants.Datatype.Z_SERVER.getName()), this.zServerLoader());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForIntegerId(ZServer.class, (ByIdLoadable)this.zServerLoader());
    }

    @ConstructorProperties(value={"codebookLoaderBuilderFactory", "jdbcTemplate", "queryFactory", "converterRegisterer", "settingLoader", "mappingAppserver", "fondLoader", "fieldTypeLoader", "defaultableDocumentIndicatorTypeLoader", "defaultableAuthorityIndicatorTypeLoader", "recordEntryElementResolver", "allDatatypeToAllValuesProviderMap"})
    @Generated
    public ZServerConfig(@NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull ConverterRegisterer converterRegisterer, @NonNull SettingLoader settingLoader, @NonNull MappingAppserverService mappingAppserver, @NonNull Codebook<Fond, Integer> fondLoader, @NonNull FieldTypeLoader fieldTypeLoader, @NonNull IndicatorTypeLoader defaultableDocumentIndicatorTypeLoader, @NonNull IndicatorTypeLoader defaultableAuthorityIndicatorTypeLoader, @NonNull RecordEntryElementResolver recordEntryElementResolver, @NonNull LinkedHashMap<Predicate<String>, AllValuesProvider<? extends LabeledIdentified<?>>> allDatatypeToAllValuesProviderMap) {
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        Objects.requireNonNull(fieldTypeLoader, "fieldTypeLoader is marked non-null but is null");
        Objects.requireNonNull(defaultableDocumentIndicatorTypeLoader, "defaultableDocumentIndicatorTypeLoader is marked non-null but is null");
        Objects.requireNonNull(defaultableAuthorityIndicatorTypeLoader, "defaultableAuthorityIndicatorTypeLoader is marked non-null but is null");
        Objects.requireNonNull(recordEntryElementResolver, "recordEntryElementResolver is marked non-null but is null");
        Objects.requireNonNull(allDatatypeToAllValuesProviderMap, "allDatatypeToAllValuesProviderMap is marked non-null but is null");
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.converterRegisterer = converterRegisterer;
        this.settingLoader = settingLoader;
        this.mappingAppserver = mappingAppserver;
        this.fondLoader = fondLoader;
        this.fieldTypeLoader = fieldTypeLoader;
        this.defaultableDocumentIndicatorTypeLoader = defaultableDocumentIndicatorTypeLoader;
        this.defaultableAuthorityIndicatorTypeLoader = defaultableAuthorityIndicatorTypeLoader;
        this.recordEntryElementResolver = recordEntryElementResolver;
        this.allDatatypeToAllValuesProviderMap = allDatatypeToAllValuesProviderMap;
    }
}

