/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.LabeledIdentified;
import cz.kpsys.portaro.commons.object.LabeledValuesGroup;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.setting.AllBySectionsLoader;
import cz.kpsys.portaro.setting.AllCustomSettingLoaderEnvironmentVariables;
import cz.kpsys.portaro.setting.CustomSetting;
import cz.kpsys.portaro.setting.CustomSettingLoader;
import cz.kpsys.portaro.setting.CustomSettingLoaderByAllProvider;
import cz.kpsys.portaro.setting.CustomSettingLoaderComposite;
import cz.kpsys.portaro.setting.SettingTypeLoader;
import cz.kpsys.portaro.setting.SpringDbCustomSettingLoader;
import cz.kpsys.portaro.setting.SpringDbSettingSectionLoader;
import cz.kpsys.portaro.setting.SpringDbSettingTypeLoader;
import cz.kpsys.portaro.setting.view.SpringDbAcceptableValuesGroupVIniLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class SettingConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SettingConfig.class);
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;

    @Bean
    public AllValuesProvider<String> settingSectionLoader() {
        return new SpringDbSettingSectionLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public SettingTypeLoader settingTypeLoader() {
        return new SpringDbSettingTypeLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public CustomSettingLoader customSettingLoader() {
        return new SpringDbCustomSettingLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public AllBySectionsLoader<CustomSetting<String>> envVariablesAwareCustomSettingLoader() {
        return new CustomSettingLoaderComposite(new AllBySectionsLoader[]{new CustomSettingLoaderByAllProvider((AllValuesProvider)AllCustomSettingLoaderEnvironmentVariables.ofSystemGetenv((String)"PORTARO_INI__")), new SpringDbCustomSettingLoader(this.jdbcTemplate, this.queryFactory)});
    }

    @Bean
    public ByIdLoadable<LabeledValuesGroup<LabeledIdentified<String>, String>, Object> iniAcceptableValuesGroupLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbAcceptableValuesGroupVIniLoader(this.jdbcTemplate, this.queryFactory)).staticCached(LabeledValuesGroup.class.getSimpleName()).fallbackWhenNotFoundById(id -> {
            log.warn("V tabulce {} chybi skupina s {} = {}", new Object[]{"ini_valhod", "id_valhod", id});
            return new LabeledValuesGroup(id);
        }).build();
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "codebookLoaderBuilderFactory"})
    @Generated
    public SettingConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
    }
}

