/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.app.CatalogConstants;
import cz.kpsys.portaro.appserver.GenericTableWriteSaver;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.dml.TableWriteGenerator;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.commons.cache.CacheBackedRepository;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.cache.DynamicCache;
import cz.kpsys.portaro.commons.cache.GuavaTimedDynamicCache;
import cz.kpsys.portaro.commons.contextual.CompositeAllValuesContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualFunction;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.FilteredAndSortedAllValuesContextualProvider;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.CompositeAllValuesProvider;
import cz.kpsys.portaro.commons.object.ConvertingAllValuesProvider;
import cz.kpsys.portaro.commons.object.FallbackingSettableProvider;
import cz.kpsys.portaro.commons.object.Identified;
import cz.kpsys.portaro.commons.object.LabeledIdentified;
import cz.kpsys.portaro.commons.object.ProvidedProxiedList;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.SameTypeSettableProvider;
import cz.kpsys.portaro.commons.object.StaticAllValuesProvider;
import cz.kpsys.portaro.commons.object.StaticCodebook;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.commons.object.filter.EqualsPredicate;
import cz.kpsys.portaro.commons.object.repo.AllProvidingRepository;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdOptLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.CompositeByIdLoader;
import cz.kpsys.portaro.commons.object.repo.DefaultProvider;
import cz.kpsys.portaro.commons.object.repo.Repository;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.core.editor.DispatchingSearchValueEditorLoader;
import cz.kpsys.portaro.datasource.Datasource;
import cz.kpsys.portaro.datasource.LocalDatasource;
import cz.kpsys.portaro.datatype.DatatypableStringConverter;
import cz.kpsys.portaro.datatype.Datatype;
import cz.kpsys.portaro.datatype.ScalarDatatype;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.exemplar.ExemplarConstants;
import cz.kpsys.portaro.file.FileConstants;
import cz.kpsys.portaro.file.FileSearchParams;
import cz.kpsys.portaro.inventory.InventoryConstants;
import cz.kpsys.portaro.loan.LoanConstants;
import cz.kpsys.portaro.loan.reminder.LoanReminderConstants;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.messages.MessageConstants;
import cz.kpsys.portaro.object.TypedDepartmentedObjectModifier;
import cz.kpsys.portaro.payment.PaymentConstants;
import cz.kpsys.portaro.record.KindedIdRecordDescriptor;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RecordConstants;
import cz.kpsys.portaro.record.document.SpringDbKat14YearExtremesLoader;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.record.isbn.IsbnChecker;
import cz.kpsys.portaro.record.isbn.IsbnDisjunctionAddingTermConverter;
import cz.kpsys.portaro.record.search.AppserverSearchEngine;
import cz.kpsys.portaro.record.search.KeywordsParserAppserver;
import cz.kpsys.portaro.record.search.KindFieldTermToFondListConverter;
import cz.kpsys.portaro.record.search.RawableSearchService;
import cz.kpsys.portaro.record.search.RawableSearchServiceAppserverLuceneWithMultiTries;
import cz.kpsys.portaro.record.search.restriction.AuthorityFieldsSearchParamsRestrictionModifier;
import cz.kpsys.portaro.record.search.restriction.CommonAuthorityParamsConjunctionModifier;
import cz.kpsys.portaro.record.search.restriction.CommonDocumentParamsConjunctionModifier;
import cz.kpsys.portaro.record.search.restriction.DocumentFieldsSearchParamsRestrictionModifier;
import cz.kpsys.portaro.record.search.restriction.FieldedQAddingConjunctionModifier;
import cz.kpsys.portaro.record.search.restriction.NamePrefixAddingConjunctionModifier;
import cz.kpsys.portaro.record.search.restriction.NonFieldedQAddingConjunctionModifier;
import cz.kpsys.portaro.search.CoreSearchParams;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.MapToMapSearchParamsConverter;
import cz.kpsys.portaro.search.Search;
import cz.kpsys.portaro.search.factory.SearchFactoryResolver;
import cz.kpsys.portaro.search.field.BasicSearchField;
import cz.kpsys.portaro.search.field.CustomSearchField;
import cz.kpsys.portaro.search.field.CustomSearchFieldEntity;
import cz.kpsys.portaro.search.field.DatatypeBySearchFieldLoader;
import cz.kpsys.portaro.search.field.EntityToCustomSearchFieldConverter;
import cz.kpsys.portaro.search.field.QueryFieldsBySearchFieldLoader;
import cz.kpsys.portaro.search.field.SearchField;
import cz.kpsys.portaro.search.field.StaticSearchFields;
import cz.kpsys.portaro.search.history.SearchHistoryImpl;
import cz.kpsys.portaro.search.keywords.SearchedKeywordsLoader;
import cz.kpsys.portaro.search.keywords.SearchedKeywordsSaver;
import cz.kpsys.portaro.search.keywords.SpringDbSearchedKeywordsLoader;
import cz.kpsys.portaro.search.keywords.SpringDbSearchedKeywordsSaver;
import cz.kpsys.portaro.search.lucene.FacetKeyIdentified;
import cz.kpsys.portaro.search.lucene.KeywordsParser;
import cz.kpsys.portaro.search.lucene.LuceneSearchResult;
import cz.kpsys.portaro.search.lucene.QToLuceneQueryConverterByPattern;
import cz.kpsys.portaro.search.lucene.StringQueryBuilder;
import cz.kpsys.portaro.search.lucene.facets.FacetDefinitionType;
import cz.kpsys.portaro.search.lucene.facets.FacetScope;
import cz.kpsys.portaro.search.lucene.facets.FacetType;
import cz.kpsys.portaro.search.lucene.facets.FacetTypeSaveTableWriteGenerator;
import cz.kpsys.portaro.search.lucene.facets.FacetTypeSorting;
import cz.kpsys.portaro.search.lucene.facets.SpringDbFacetTypeLoader;
import cz.kpsys.portaro.search.restriction.RawQueryAddingConjunctionModifier;
import cz.kpsys.portaro.search.restriction.RecordSearchParamsStringQueryBuilder;
import cz.kpsys.portaro.search.restriction.Restriction;
import cz.kpsys.portaro.search.restriction.convert.MatchingCompositeTermConverter;
import cz.kpsys.portaro.search.restriction.convert.RestrictionDeserializer;
import cz.kpsys.portaro.search.restriction.convert.RestrictionDeserializerWithSearchFields;
import cz.kpsys.portaro.search.restriction.convert.RestrictionSerializer;
import cz.kpsys.portaro.search.restriction.convert.SingleStringMatcherValueTermMatcher;
import cz.kpsys.portaro.search.restriction.deserialize.json.RestrictionDeserializerPostModifyingDecorator;
import cz.kpsys.portaro.search.restriction.serialize.lucene.DatatypeBySearchFieldLoaderByLuceneQueryFieldLoader;
import cz.kpsys.portaro.search.restriction.serialize.lucene.IdToLuceneValueConverter;
import cz.kpsys.portaro.search.restriction.serialize.lucene.IdentifiedToLuceneValueConverter;
import cz.kpsys.portaro.search.restriction.serialize.lucene.KindedIdRecordDescriptorToLuceneValueConverter;
import cz.kpsys.portaro.search.restriction.serialize.lucene.LuceneQueryField;
import cz.kpsys.portaro.search.restriction.serialize.lucene.LuceneQueryFieldLoaderDispatching;
import cz.kpsys.portaro.search.restriction.serialize.lucene.RestrictionToLuceneQueryConverterBuilder;
import cz.kpsys.portaro.search.restriction.serialize.lucene.SimpleLuceneQueryField;
import cz.kpsys.portaro.search.restriction.serialize.lucene.StringToLuceneValueConverter;
import cz.kpsys.portaro.search.sorting.SearchSortingLoaderBySortingStrings;
import cz.kpsys.portaro.search.sorting.Sorting;
import cz.kpsys.portaro.search.view.DepartmentedSearchFieldToViewableSearchFieldConverter;
import cz.kpsys.portaro.search.view.SearchSubtitleResolver;
import cz.kpsys.portaro.search.view.SearchTextResolver;
import cz.kpsys.portaro.search.view.SearchTitleResolver;
import cz.kpsys.portaro.search.view.SearchValueEditorLoader;
import cz.kpsys.portaro.search.view.ViewableSearchField;
import cz.kpsys.portaro.search.view.ViewableSearchFieldContextualProvider;
import cz.kpsys.portaro.search.z.ZServerDatasource;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.stats.StatsConstants;
import cz.kpsys.portaro.user.UserConstants;
import cz.kpsys.portaro.view.web.rest.FacetTypeRequest;
import cz.kpsys.portaro.view.web.rest.FacetTypeRequestDefaulter;
import cz.kpsys.portaro.view.web.rest.FacetTypeRequestToFacetTypeConverter;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class SearchConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchConfig.class);
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final NamedParameterJdbcOperations notCriticalJdbcTemplate;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final DmlAppserverService dmlAppserverService;
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final DatatypableStringConverter datatypableStringConverter;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final SimpleModule objectMapperModule;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final ByIdLoadable<AllValuesProvider<? extends LabeledIdentified<?>>, String> acceptableValuesProviderLoader;
    @NonNull
    private final ContextualProvider<Department, List<Fond>> allowedDocumentFondsDepartmentedProvider;
    @NonNull
    private final ContextualProvider<Department, List<Fond>> allowedAuthorityFondsDepartmentedProvider;
    @NonNull
    private final ContextualProvider<Department, List<Fond>> allowedFondsDepartmentedProvider;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final ContextualProvider<Department, List<Location>> allowedLocationsContextualProvider;
    @NonNull
    private final AllValuesProvider<Fond> authorityFondLoader;
    @NonNull
    private final AllValuesProvider<Fond> documentFondLoader;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final FormattingConversionService conversionService;
    @NonNull
    private final ObjectMapper objectMapper;
    @NonNull
    private final AllValuesProvider<ZServerDatasource> allZServerDatasetsProvider;
    @NonNull
    private final ContextualProvider<Department, List<ZServerDatasource>> allowedZServerDatasetsProvider;
    @NonNull
    private final LinkedHashMap<Predicate<String>, AllValuesProvider<? extends LabeledIdentified<?>>> allDatatypeToAllValuesProviderMap;

    @Bean
    public SearchFactoryResolver searchFactoryResolver() {
        return new SearchFactoryResolver();
    }

    @Bean
    public SearchedKeywordsLoader searchedKeywordsLoader() {
        return new SpringDbSearchedKeywordsLoader(this.notCriticalJdbcTemplate, this.queryFactory, (Provider)StaticProvider.of((Object)3));
    }

    @Bean
    public SearchedKeywordsSaver searchedKeywordsSaver() {
        return new SpringDbSearchedKeywordsSaver(this.notCriticalJdbcTemplate, this.queryFactory, this.executorService);
    }

    @Bean
    public KeywordsParser keywordsParser() {
        return new KeywordsParserAppserver(this.mappingAppserver, ExemplarConstants.Datatype.SIGNATURE.getName(), ExemplarConstants.Datatype.ACCESS_NUMBER.getName());
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public Codebook<SearchField, String> searchFieldLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new CompositeAllValuesProvider(new AllValuesProvider[]{this.customSearchFieldLoader(), ConvertingAllValuesProvider.byItemConverter((AllValuesProvider)this.facetTypeLoader(), FacetType::toSearchField), StaticAllValuesProvider.of((List)StaticSearchFields.LIST)})).build();
    }

    @Bean
    public Codebook<CustomSearchField, String> customSearchFieldLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(CustomSearchFieldEntity.class).convertedEachBy((Converter)new EntityToCustomSearchFieldConverter()).staticCached(CustomSearchField.class.getSimpleName()).build();
    }

    @Bean
    public ContextualProvider<Department, List<ViewableSearchField>> viewableSearchFieldsProvider() {
        return new ViewableSearchFieldContextualProvider(this.settingLoader.getDepartmentedProvider(SettingKeys.FORM_SEARCH_FIELDS), (ByIdLoadable)this.searchFieldLoader(), this.departmentedSearchFieldToViewableSearchFieldConverter());
    }

    @Bean
    public BiFunction<Department, SearchField, ViewableSearchField> departmentedSearchFieldToViewableSearchFieldConverter() {
        return new DepartmentedSearchFieldToViewableSearchFieldConverter(this.searchValueEditorLoader(), this.datatypeBySearchFieldLoader());
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public QueryFieldsBySearchFieldLoader<LuceneQueryField> luceneQueryFieldLoader() {
        HashMap<String, List<SimpleLuceneQueryField>> staticFields = new HashMap<String, List<SimpleLuceneQueryField>>();
        staticFields.put((String)((Object)StaticSearchFields.WHATEVER.getId()), List.of(SimpleLuceneQueryField.create((String)"PALL", (Datatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)((Object)StaticSearchFields.NAME.getId()), List.of(SimpleLuceneQueryField.create((String)"PNAZEV", (Datatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)((Object)StaticSearchFields.FOND.getId()), List.of(SimpleLuceneQueryField.create((String)"REZS_FOND", (Datatype)RecordConstants.Datatype.FOND)));
        staticFields.put((String)((Object)StaticSearchFields.RECORD_RELATED_RECORD.getId()), List.of(SimpleLuceneQueryField.create((String)"REL_AUT", (Datatype)RecordConstants.Datatype.AUTHORITY)));
        staticFields.put((String)((Object)StaticSearchFields.DEPARTMENT.getId()), List.of(SimpleLuceneQueryField.create((String)"REZS_PUJC", (Datatype)CoreConstants.Datatype.DEPARTMENT)));
        staticFields.put((String)((Object)StaticSearchFields.UNRESTRICTED_DEPARTMENT.getId()), List.of(SimpleLuceneQueryField.create((String)"REZS_PUJC", (Datatype)CoreConstants.Datatype.DEPARTMENT)));
        staticFields.put((String)((Object)StaticSearchFields.LOCATION.getId()), List.of(SimpleLuceneQueryField.create((String)"REZS_LOKACE", (Datatype)ExemplarConstants.Datatype.LOCATION)));
        staticFields.put((String)((Object)StaticSearchFields.DOCUMENT_FOND.getId()), List.of(SimpleLuceneQueryField.create((String)"REZS_FOND", (Datatype)RecordConstants.Datatype.DOCUMENT_FOND)));
        staticFields.put((String)((Object)StaticSearchFields.RECORD_STATUS.getId()), List.of(SimpleLuceneQueryField.create((String)"STATUS", (Datatype)RecordConstants.Datatype.RECORD_STATUS)));
        staticFields.put((String)((Object)StaticSearchFields.DOCUMENT_ISBN.getId()), List.of(SimpleLuceneQueryField.create((String)"P20", (Datatype)RecordConstants.Datatype.ISBN)));
        staticFields.put((String)((Object)StaticSearchFields.DOCUMENT_ISSN.getId()), List.of(SimpleLuceneQueryField.create((String)"P22", (Datatype)RecordConstants.Datatype.ISSN)));
        staticFields.put((String)((Object)StaticSearchFields.DOCUMENT_ISBN_OR_ISSN.getId()), List.of(SimpleLuceneQueryField.create((String)"P20", (Datatype)RecordConstants.Datatype.ISBN), SimpleLuceneQueryField.create((String)"P22", (Datatype)RecordConstants.Datatype.ISSN)));
        staticFields.put((String)((Object)StaticSearchFields.DOCUMENT_NAME.getId()), List.of(SimpleLuceneQueryField.create((String)"P245", (Datatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)((Object)StaticSearchFields.DOCUMENT_SIGNATURE.getId()), List.of(SimpleLuceneQueryField.create((String)"PSIGNATURA", (Datatype)ExemplarConstants.Datatype.SIGNATURE)));
        staticFields.put((String)((Object)StaticSearchFields.DOCUMENT_ACCESS_NUMBER.getId()), List.of(SimpleLuceneQueryField.create((String)"PPRIRCISLO", (Datatype)ExemplarConstants.Datatype.ACCESS_NUMBER)));
        staticFields.put((String)((Object)StaticSearchFields.RECORD_SOURCE_RECORD.getId()), List.of(SimpleLuceneQueryField.create((String)"P773", (Datatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)((Object)StaticSearchFields.AUTHOR.getId()), List.of(SimpleLuceneQueryField.create((String)"P100", (Datatype)CoreConstants.Datatype.TEXT), SimpleLuceneQueryField.create((String)"P110", (Datatype)CoreConstants.Datatype.TEXT), SimpleLuceneQueryField.create((String)"P111", (Datatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)((Object)StaticSearchFields.DOCUMENT_YEAR.getId()), List.of(SimpleLuceneQueryField.create((String)"REZS_ROK", (Datatype)CoreConstants.Datatype.NUMBER)));
        staticFields.put((String)((Object)StaticSearchFields.PUBLISHER.getId()), List.of(SimpleLuceneQueryField.create((String)"P260", (Datatype)CoreConstants.Datatype.TEXT), SimpleLuceneQueryField.create((String)"P264", (Datatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)((Object)StaticSearchFields.AUTHORITY_NAME.getId()), List.of(SimpleLuceneQueryField.create((String)"P100", (Datatype)CoreConstants.Datatype.TEXT), SimpleLuceneQueryField.create((String)"P110", (Datatype)CoreConstants.Datatype.TEXT), SimpleLuceneQueryField.create((String)"P111", (Datatype)CoreConstants.Datatype.TEXT), SimpleLuceneQueryField.create((String)"P150", (Datatype)CoreConstants.Datatype.TEXT), SimpleLuceneQueryField.create((String)"P151", (Datatype)CoreConstants.Datatype.TEXT), SimpleLuceneQueryField.create((String)"P240", (Datatype)CoreConstants.Datatype.TEXT), SimpleLuceneQueryField.create((String)"P148", (Datatype)CoreConstants.Datatype.TEXT), SimpleLuceneQueryField.create((String)"P773", (Datatype)CoreConstants.Datatype.TEXT), SimpleLuceneQueryField.create((String)"P190", (Datatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)((Object)StaticSearchFields.CNA.getId()), List.of(SimpleLuceneQueryField.create((String)"P1", (Datatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)((Object)StaticSearchFields.AUTHORITY_FOND.getId()), List.of(SimpleLuceneQueryField.create((String)"REZS_FOND", (Datatype)RecordConstants.Datatype.AUTHORITY_FOND)));
        staticFields.put((String)((Object)StaticSearchFields.RECORD_ID.getId()), List.of(SimpleLuceneQueryField.create((String)"RECORD_ID", (Datatype)RecordConstants.Datatype.RECORD)));
        staticFields.put((String)((Object)StaticSearchFields.RECORD_CREATION_DATE.getId()), List.of(SimpleLuceneQueryField.create((String)"REZS_DATVYT", (Datatype)CoreConstants.Datatype.DATETIME)));
        staticFields.put((String)((Object)StaticSearchFields.RECORD_FILE_CATEGORY.getId()), List.of(SimpleLuceneQueryField.create((String)"REZS_TYP_FULLTEXT", (Datatype)FileConstants.Datatype.FILE_CATEGORY)));
        staticFields.put((String)((Object)StaticSearchFields.RECORD_LOAN_SOURCE.getId()), List.of(SimpleLuceneQueryField.create((String)"REZS_EXTERNI", (Datatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)((Object)StaticSearchFields.TABLE_OF_CONTENT.getId()), List.of(SimpleLuceneQueryField.create((String)"PTOC", (Datatype)CoreConstants.Datatype.TEXT)));
        return new LuceneQueryFieldLoaderDispatching(staticFields, (ByIdOptLoadable)this.customSearchFieldLoader());
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
    public AllProvidingRepository<Search<MapBackedParams, ?>, UUID> searchHistory() {
        return new SearchHistoryImpl();
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
    public SameTypeSettableProvider<Integer> documentDefaultPageSizeProvider() {
        return new FallbackingSettableProvider(this.settingLoader.getOnRootProvider(SettingKeys.DOCUMENT_SEARCH_PAGE_SIZE));
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
    public SameTypeSettableProvider<Integer> authorityPageSizeProvider() {
        return new FallbackingSettableProvider(this.settingLoader.getOnRootProvider(SettingKeys.AUTHORITY_SEARCH_PAGE_SIZE));
    }

    @Bean
    public Codebook<FacetType, Integer> facetTypeLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbFacetTypeLoader(this.jdbcTemplate, this.queryFactory, (ByIdLoadable)this.facetTypeSortingLoader())).staticCached(FacetType.class.getSimpleName()).build();
    }

    @Bean
    public Saver<FacetType> facetTypeSaver() {
        return GenericTableWriteSaver.of((TableWriteGenerator)new FacetTypeSaveTableWriteGenerator(), (DmlAppserverService)this.dmlAppserverService, (CacheCleaner[])new CacheCleaner[]{this.cacheService.createCleanerFor(FacetType.class.getSimpleName())});
    }

    @Bean
    public TypedDepartmentedObjectModifier<FacetTypeRequest> facetTypeRequestDefaulter() {
        return new FacetTypeRequestDefaulter(this.facetTypeLoader());
    }

    @Bean
    public Converter<FacetTypeRequest, FacetType> facetTypeRequestToFacetTypeConverter() {
        return new FacetTypeRequestToFacetTypeConverter();
    }

    @Bean
    public SearchTextResolver searchTitleResolver() {
        return new SearchTitleResolver(this.translator);
    }

    @Bean
    public SearchTextResolver searchSubtitleResolver() {
        return new SearchSubtitleResolver();
    }

    @Bean
    public Repository<Search<? extends MapBackedParams, ?>, UUID> searchRepository() {
        return CacheBackedRepository.ofIdentified((DynamicCache)GuavaTimedDynamicCache.ofIdentified((Duration)Duration.ofMinutes(10L), (boolean)false));
    }

    @Bean
    public SearchValueEditorLoader searchValueEditorLoader() {
        return new DispatchingSearchValueEditorLoader(this.acceptableValuesProviderLoader, this.allowedLocationsContextualProvider, this.allowedDocumentFondsDepartmentedProvider, this.allowedAuthorityFondsDepartmentedProvider, this.allowedFondsDepartmentedProvider, this.departmentAccessor);
    }

    @Bean
    public DatatypeBySearchFieldLoader datatypeBySearchFieldLoader() {
        HashMap<BasicSearchField, ScalarDatatype> staticFieldsToDatatypes = new HashMap<BasicSearchField, ScalarDatatype>();
        staticFieldsToDatatypes.put(StaticSearchFields.FOND, RecordConstants.Datatype.FOND);
        staticFieldsToDatatypes.put(StaticSearchFields.RECORD_RELATED_RECORD, RecordConstants.Datatype.RECORD);
        staticFieldsToDatatypes.put(StaticSearchFields.DEPARTMENT, CoreConstants.Datatype.DEPARTMENT);
        staticFieldsToDatatypes.put(StaticSearchFields.UNRESTRICTED_DEPARTMENT, CoreConstants.Datatype.DEPARTMENT);
        staticFieldsToDatatypes.put(StaticSearchFields.LOCATION, ExemplarConstants.Datatype.LOCATION);
        staticFieldsToDatatypes.put(StaticSearchFields.DOCUMENT, RecordConstants.Datatype.DOCUMENT);
        staticFieldsToDatatypes.put(StaticSearchFields.DOCUMENT_FOND, RecordConstants.Datatype.DOCUMENT_FOND);
        staticFieldsToDatatypes.put(StaticSearchFields.RECORD_STATUS, RecordConstants.Datatype.RECORD_STATUS);
        staticFieldsToDatatypes.put(StaticSearchFields.DOCUMENT_ISBN, RecordConstants.Datatype.ISBN);
        staticFieldsToDatatypes.put(StaticSearchFields.DOCUMENT_ISSN, RecordConstants.Datatype.ISSN);
        staticFieldsToDatatypes.put(StaticSearchFields.DOCUMENT_ISBN_OR_ISSN, CoreConstants.Datatype.TEXT);
        staticFieldsToDatatypes.put(StaticSearchFields.DOCUMENT_NAME, CoreConstants.Datatype.TEXT);
        staticFieldsToDatatypes.put(StaticSearchFields.DOCUMENT_SIGNATURE, ExemplarConstants.Datatype.SIGNATURE);
        staticFieldsToDatatypes.put(StaticSearchFields.DOCUMENT_ACCESS_NUMBER, ExemplarConstants.Datatype.ACCESS_NUMBER);
        staticFieldsToDatatypes.put(StaticSearchFields.AUTHOR, CoreConstants.Datatype.TEXT);
        staticFieldsToDatatypes.put(StaticSearchFields.DOCUMENT_YEAR, CoreConstants.Datatype.YEAR);
        staticFieldsToDatatypes.put(StaticSearchFields.PUBLISHER, CoreConstants.Datatype.TEXT);
        staticFieldsToDatatypes.put(StaticSearchFields.AUTHORITY_NAME, CoreConstants.Datatype.TEXT);
        staticFieldsToDatatypes.put(StaticSearchFields.CNA, CoreConstants.Datatype.TEXT);
        staticFieldsToDatatypes.put(StaticSearchFields.AUTHORITY_FOND, RecordConstants.Datatype.AUTHORITY_FOND);
        staticFieldsToDatatypes.put(StaticSearchFields.RECORD_CREATION_DATE, CoreConstants.Datatype.DATETIME);
        staticFieldsToDatatypes.put(StaticSearchFields.RECORD_FILE_CATEGORY, FileConstants.Datatype.FILE_CATEGORY);
        staticFieldsToDatatypes.put(StaticSearchFields.RECORD_LOAN_SOURCE, CoreConstants.Datatype.TEXT);
        staticFieldsToDatatypes.put(StaticSearchFields.TABLE_OF_CONTENT, CoreConstants.Datatype.TEXT);
        return new DatatypeBySearchFieldLoaderByLuceneQueryFieldLoader(staticFieldsToDatatypes, (ByIdOptLoadable)this.customSearchFieldLoader(), (AllValuesProvider)this.facetTypeLoader());
    }

    @Bean
    public AppserverSearchEngine appserverSearchEngine() {
        return new AppserverSearchEngine(this.mappingAppserver, this.settingLoader.getDepartmentedProvider(SettingKeys.FACETS), this.settingLoader.getDepartmentedProvider(SettingKeys.FACET_KEYS_MAX_COUNT), this.departmentAccessor);
    }

    @Bean
    public RawableSearchService<LuceneSearchResult<Record, MapBackedParams>, MapBackedParams, Record> recordSearchService() {
        return new RawableSearchServiceAppserverLuceneWithMultiTries(this.appserverSearchEngine(), this.datatypableStringConverter, List.of(this.luceneSearchQueryBuilder()), this.documentYearExtremeRangeProvider());
    }

    @Bean
    public ContextualProvider<Department, Range<Integer>> documentYearExtremeRangeProvider() {
        return this.settingLoader.getDepartmentedProvider(SettingKeys.DOCUMENT_MIN_YEAR).andThenFastReturningNull(minYear -> Range.between((Comparable)minYear, (Comparable)Integer.valueOf(LocalDate.now().getYear()))).fallbacked((Provider)new SpringDbKat14YearExtremesLoader(this.jdbcTemplate, this.queryFactory).cached());
    }

    @Bean
    public Codebook<Sorting, String> facetTypeSortingLoader() {
        return new StaticCodebook((Identified[])new Sorting[]{FacetTypeSorting.SORTING_FREQ_DESC, FacetTypeSorting.SORTING_ALPH_ASC, FacetTypeSorting.SORTING_ALPH_DESC, FacetTypeSorting.SORTING_CHRONO_ASC, FacetTypeSorting.SORTING_CHRONO_DESC, FacetTypeSorting.SORTING_NUM_ASC, FacetTypeSorting.SORTING_NUM_DESC});
    }

    @Bean
    public Codebook<FacetScope, Integer> facetScopeLoader() {
        return FacetScope.CODEBOOK;
    }

    @Bean
    public Codebook<FacetDefinitionType, Integer> facetDefinitionTypeLoader() {
        return FacetDefinitionType.CODEBOOK;
    }

    @Bean
    public ByIdLoadable<Sorting, String> searchSortingLoader() {
        return new CompositeByIdLoader(new ByIdLoadable[]{this.documentSearchSortingLoader(), this.authoritySearchSortingLoader(), this.exemplarSearchSortingLoader(), this.facetTypeSortingLoader(), Sorting::ofDefaultMessage});
    }

    @Bean
    public Provider<Sorting> defaultDocumentSearchSortingProvider() {
        return DefaultProvider.byFirst((AllValuesProvider)this.documentSearchSortingLoader());
    }

    @Bean
    public Codebook<Sorting, String> documentSearchSortingLoader() {
        return new SearchSortingLoaderBySortingStrings(this.settingLoader.getOnRootProvidedList(SettingKeys.DOCUMENT_SEARCH_SORTINGS));
    }

    @Bean
    public Provider<Sorting> defaultAuthoritySearchSortingProvider() {
        return DefaultProvider.byFirst((AllValuesProvider)this.authoritySearchSortingLoader());
    }

    @Bean
    public Codebook<Sorting, String> authoritySearchSortingLoader() {
        return new SearchSortingLoaderBySortingStrings(this.settingLoader.getOnRootProvidedList(SettingKeys.AUTHORITY_SEARCH_SORTINGS));
    }

    @Bean
    public AllValuesProvider<LocalDatasource> allLocalDatasetsProvider() {
        return StaticAllValuesProvider.of((Object[])new LocalDatasource[]{CatalogConstants.Search.DATASOURCE_LOCAL, CatalogConstants.Search.DATASOURCE_LOCAL_ALL_DEPARTMENTS});
    }

    @Bean
    public ByIdLoadable<Datasource, String> datasourceLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new CompositeAllValuesProvider(new AllValuesProvider[]{this.allLocalDatasetsProvider(), this.allZServerDatasetsProvider})).build();
    }

    @Bean
    public ContextualProvider<Department, List<LocalDatasource>> allowedLocalDatasetsProvider() {
        return new FilteredAndSortedAllValuesContextualProvider(this.allLocalDatasetsProvider(), this.settingLoader.getDepartmentedProvider(SettingKeys.ENABLED_LOCAL_DATASETS));
    }

    @Bean
    public ContextualProvider<Department, @NonNull List<Datasource>> allowedDatasetsDepartmentedProvider() {
        return new CompositeAllValuesContextualProvider(List.of(this.allowedLocalDatasetsProvider(), this.allowedZServerDatasetsProvider));
    }

    @Bean
    public Provider<Sorting> defaultExemplarSearchSortingProvider() {
        return DefaultProvider.byId((AllValuesProvider)this.exemplarSearchSortingLoader(), (Object)"accessNumber");
    }

    @Bean
    public Codebook<Sorting, String> exemplarSearchSortingLoader() {
        return new StaticCodebook((Identified[])new Sorting[]{Sorting.ofDefaultMessage((String)"accessNumber", (boolean)true), Sorting.ofDefaultMessage((String)"accessNumber", (boolean)false), Sorting.ofDefaultMessage((String)"signature", (boolean)false), Sorting.ofDefaultMessage((String)"discardNumber", (boolean)true)});
    }

    @Bean
    public MapToMapSearchParamsConverter mapToMapSearchParamsConverter() {
        HashSet<Object> params = new HashSet<Object>();
        params.add(CoreSearchParams.KIND);
        params.add(CoreSearchParams.SORTING);
        params.add(CoreSearchParams.DEPARTMENT);
        params.add(CoreSearchParams.UNRESTRICTED_DEPARTMENT);
        params.add(CoreSearchParams.NAME);
        params.add(CoreSearchParams.Q);
        params.add(CoreSearchParams.INITIATOR);
        params.add(CoreSearchParams.DATASOURCE);
        params.add(CoreSearchParams.DATASOURCE_GROUP);
        params.add(CoreSearchParams.CENTRAL_INDEX_ENABLED);
        params.add(InventoryConstants.SearchParams.INVENTORY);
        params.add(CoreSearchParams.TYPE);
        params.add(CoreSearchParams.TITLE);
        params.add(CoreSearchParams.FROM_DATE);
        params.add(CoreSearchParams.INCLUDE_DRAFT);
        params.add(CoreSearchParams.INCLUDE_DELETED);
        params.add(CoreSearchParams.INCLUDE_ACTIVE);
        params.add(CoreSearchParams.TO_DATE);
        params.add(CoreSearchParams.QT);
        params.add(FileSearchParams.DIRECTORY);
        params.add(FileSearchParams.ROOT_DIRECTORY);
        params.add(FileSearchParams.FILE_CATEGORY);
        params.add(FileSearchParams.FILE_PROCESSING_STATE);
        params.add(FileSearchParams.FILENAME_EXTENSION);
        params.add(FileSearchParams.FILENAME);
        params.add(FileSearchParams.FORBIDDEN_FILE);
        params.add(FileSearchParams.FORBIDDEN_FILE_CATEGORY);
        params.add(FileSearchParams.MINIMAL_FILE_SIZE_KB);
        params.add(RecordConstants.SearchParams.OPERATED_KIND);
        params.add(RecordConstants.SearchParams.OPERATION_TYPE);
        params.add(PaymentConstants.SearchParams.INCLUSIVE_FROM_CREATION_DATE);
        params.add(PaymentConstants.SearchParams.EXCLUSIVE_TO_CREATION_DATE);
        params.add(PaymentConstants.SearchParams.CREATION_DATE);
        params.add(PaymentConstants.SearchParams.INCLUSIVE_FROM_PAY_DATE);
        params.add(PaymentConstants.SearchParams.EXCLUSIVE_TO_PAY_DATE);
        params.add(PaymentConstants.SearchParams.PAY_DATE);
        params.add(PaymentConstants.SearchParams.PAYMENT_STATE);
        params.add(PaymentConstants.SearchParams.PROVIDER);
        params.add(PaymentConstants.SearchParams.TRANSACTION_ID);
        params.add(PaymentConstants.SearchParams.OWNER);
        params.add(PaymentConstants.SearchParams.AMOUNT_TYPE);
        params.add(PaymentConstants.SearchParams.INCLUDE_CREDITS);
        params.add(PaymentConstants.SearchParams.INCLUDE_DEBTS);
        params.add(PaymentConstants.SearchParams.INCLUDE_ZEROS);
        params.add(UserConstants.SearchParams.CREATOR);
        params.add(CoreSearchParams.RAW_QUERY);
        params.add(CoreSearchParams.FINAL_RAW_QUERY);
        params.add(CoreSearchParams.FACET_RESTRICTION);
        params.add(CoreSearchParams.FACETS_ENABLED);
        params.add(CoreSearchParams.RIGHT_HAND_EXTENSION);
        params.add(CoreSearchParams.FIELD);
        params.add(RecordConstants.SearchParams.PREFIX);
        params.add(RecordConstants.SearchParams.FORBIDDEN_RECORD);
        params.add(RecordConstants.SearchParams.RECORD);
        params.add(RecordConstants.SearchParams.EXEMPLAR_STATUS);
        params.add(RecordConstants.SearchParams.FORBIDDEN_EXEMPLAR);
        params.add(RecordConstants.SearchParams.ACQUISITION_WAY);
        params.add(RecordConstants.SearchParams.FOND);
        params.add(RecordConstants.SearchParams.DOCUMENT_FOND);
        params.add(RecordConstants.SearchParams.AUTHORIY_FOND);
        params.add(RecordConstants.SearchParams.RECORD_RELATED_RECORD);
        params.add(RecordConstants.SearchParams.RECORD_RELATED_RECORD_FOND);
        params.add(RecordConstants.SearchParams.FORBIDDEN_RECORD_STATUS);
        params.add(RecordConstants.SearchParams.INCLUDE_EXCLUDED);
        params.add(ExemplarConstants.SearchParams.INCLUDE_FAKE);
        params.add(ExemplarConstants.SearchParams.LOCATION);
        params.add(ExemplarConstants.SearchParams.EXEMPLAR_TYPE);
        params.add(ExemplarConstants.SearchParams.INCREASE_YEAR);
        params.add(ExemplarConstants.SearchParams.BAR_CODE);
        params.add(ExemplarConstants.SearchParams.ACCESS_NUMBER);
        params.add(ExemplarConstants.SearchParams.ACCESS_NUMBER_START);
        params.add(ExemplarConstants.SearchParams.ACCESS_NUMBER_END);
        params.add(ExemplarConstants.SearchParams.SIGNATURE);
        params.add(ExemplarConstants.SearchParams.SIGNATURE_START);
        params.add(ExemplarConstants.SearchParams.SIGNATURE_END);
        params.add(ExemplarConstants.SearchParams.DISCARD_NUMBER_START);
        params.add(ExemplarConstants.SearchParams.DISCARD_NUMBER_END);
        params.add(ExemplarConstants.SearchParams.BUNDLED_VOLUME_YEAR);
        params.add(UserConstants.SearchParams.USER_AUTHORITY);
        params.add(UserConstants.SearchParams.USERNAME);
        params.add(UserConstants.SearchParams.USERNAME_IGNORE_CASE);
        params.add(UserConstants.SearchParams.EMAIL);
        params.add(UserConstants.SearchParams.LAST_NAME);
        params.add(UserConstants.SearchParams.CARD_NUMBER);
        params.add(UserConstants.SearchParams.BAR_CODE);
        params.add(UserConstants.SearchParams.CASE_INSENSITIVE_NET_ID);
        params.add(UserConstants.SearchParams.OPENID);
        params.add(UserConstants.SearchParams.RFID_USER_ID);
        params.add(UserConstants.SearchParams.READER_CATEGORY);
        params.add(UserConstants.SearchParams.ROLE);
        params.add(UserConstants.SearchParams.INCLUDE_ANONYMIZED);
        params.add(UserConstants.SearchParams.EDIT_LEVEL);
        params.add(LoanConstants.SearchParams.LENDER);
        params.add(LoanConstants.SearchParams.LOAN_STATE);
        params.add(LoanConstants.SearchParams.EXEMPLAR);
        params.add(LoanConstants.SearchParams.LOAN_REQUEST);
        params.add(LoanConstants.SearchParams.SHIPMENT_ITEM);
        params.add(LoanConstants.SearchParams.INCLUDE_NOT_SHIPPING);
        params.add(LoanConstants.SearchParams.EXEMPLAR_Q);
        params.add(LoanReminderConstants.SearchParams.LOAN_REMINDER_TYPE);
        params.add(LoanReminderConstants.SearchParams.SENT_INCLUDED);
        params.add(MessageConstants.SearchParams.CREATE_DATE);
        params.add(MessageConstants.SearchParams.SENDER_USER);
        params.add(MessageConstants.SearchParams.TARGET_USER);
        params.add(MessageConstants.SearchParams.SEVERITY);
        params.add(MessageConstants.SearchParams.TOPIC);
        params.add(MessageConstants.SearchParams.MESSAGE_MEDIUM);
        params.add(MessageConstants.SearchParams.MESSAGE);
        params.add(MessageConstants.SearchParams.MESSAGE_STATUS);
        params.add(RecordConstants.SearchParams.CNA);
        params.add(RecordConstants.SearchParams.ISBN);
        params.add(RecordConstants.SearchParams.ISSN);
        params.add(RecordConstants.SearchParams.ISBN_OR_ISSN);
        params.add(RecordConstants.SearchParams.AUTHOR);
        params.add(RecordConstants.SearchParams.PUBLICATION_YEAR);
        params.add(InventoryConstants.SearchParams.MATCH_STATE);
        params.add(StatsConstants.SearchParams.TIME_GRANULARITY);
        Set<String> notMappableButAllowedQueryParams = Set.of("pageNumber", "pageSize", "exports", "focusedFieldTypeId", "format", "locale");
        return new MapToMapSearchParamsConverter((ConversionService)this.conversionService, params, notMappableButAllowedQueryParams);
    }

    @Bean
    public StringQueryBuilder<MapBackedParams> luceneSearchQueryBuilder() {
        return new RecordSearchParamsStringQueryBuilder(this.restrictionToLuceneQueryConverter()).withDocumentConjunctionModifier(MapBackedParams.class, (RecordSearchParamsStringQueryBuilder.RestrictionModifier)new CommonDocumentParamsConjunctionModifier(this.departmentAccessor, this.documentFondLoader)).withDocumentConjunctionModifier(MapBackedParams.class, (RecordSearchParamsStringQueryBuilder.RestrictionModifier)new DocumentFieldsSearchParamsRestrictionModifier()).withAuthorityConjunctionModifier(MapBackedParams.class, (RecordSearchParamsStringQueryBuilder.RestrictionModifier)new CommonAuthorityParamsConjunctionModifier(this.authorityFondLoader)).withAuthorityConjunctionModifier(MapBackedParams.class, (RecordSearchParamsStringQueryBuilder.RestrictionModifier)new AuthorityFieldsSearchParamsRestrictionModifier()).withRestrictionModifierFor(MapBackedParams.class, (RecordSearchParamsStringQueryBuilder.RestrictionModifier)new RawQueryAddingConjunctionModifier()).withRestrictionModifierFor(MapBackedParams.class, (RecordSearchParamsStringQueryBuilder.RestrictionModifier)new FieldedQAddingConjunctionModifier()).withRestrictionModifierFor(MapBackedParams.class, (RecordSearchParamsStringQueryBuilder.RestrictionModifier)new NonFieldedQAddingConjunctionModifier((ContextualFunction)new QToLuceneQueryConverterByPattern(this.settingLoader.getDepartmentedProvider(SettingKeys.AUTHORITY_GLOBAL_SEARCH_QUERY_TEMPLATE), this.keywordsParser()), (ContextualFunction)new QToLuceneQueryConverterByPattern(this.settingLoader.getDepartmentedProvider(SettingKeys.GLOBAL_SEARCH_TEMPLATE_1), this.keywordsParser()))).withRestrictionModifierFor(MapBackedParams.class, (RecordSearchParamsStringQueryBuilder.RestrictionModifier)new NamePrefixAddingConjunctionModifier());
    }

    @Bean
    public Converter<Restriction<? extends SearchField>, String> restrictionToLuceneQueryConverter() {
        Converter luceneFieldRestrictionToQuery = new RestrictionToLuceneQueryConverterBuilder(this.keywordsParser(), this.luceneQueryFieldLoader()).registerEqValueConverter(Integer.class, (Converter)new IdToLuceneValueConverter()).registerEqValueConverter(String.class, (Converter)new StringToLuceneValueConverter()).registerEqValueConverter(KindedIdRecordDescriptor.class, (Converter)new KindedIdRecordDescriptorToLuceneValueConverter(new IdToLuceneValueConverter())).registerBetweenValueItemConverter(Identified.class, (Converter)new IdentifiedToLuceneValueConverter()).registerEqValueConverter(Identified.class, (Converter)new IdentifiedToLuceneValueConverter()).buildLuceneFieldRestrictionToQuery();
        Converter simpleSearchFieldRestrictionToLuceneFieldRestriction = new RestrictionToLuceneQueryConverterBuilder(this.keywordsParser(), this.luceneQueryFieldLoader()).buildSearchFieldRestrictionToLuceneFieldRestriction();
        Converter searchFieldRestrictionToLuceneFieldRestriction = new RestrictionToLuceneQueryConverterBuilder(this.keywordsParser(), this.luceneQueryFieldLoader()).configureRecursiveSearchFieldTermConverter((searchFieldTermConverter, finalConverter) -> searchFieldTermConverter.addByField((Object)StaticSearchFields.KIND, (Converter)new KindFieldTermToFondListConverter((List)new ProvidedProxiedList(this.documentFondLoader), (List)new ProvidedProxiedList(this.authorityFondLoader)))).configureNonRecursiveSearchFieldTermConverter((searchFieldTermConverter, finalConverter) -> {
            searchFieldTermConverter.addFirst((MatchingCompositeTermConverter.TermMatcher)new SingleStringMatcherValueTermMatcher(IsbnChecker::isValidIsbn), new IsbnDisjunctionAddingTermConverter((Object)StaticSearchFields.DOCUMENT_ISBN).andThen(simpleSearchFieldRestrictionToLuceneFieldRestriction));
            searchFieldTermConverter.addFirst((MatchingCompositeTermConverter.TermMatcher)new SingleStringMatcherValueTermMatcher(IsbnChecker::isValidIssn), new IsbnDisjunctionAddingTermConverter((Object)StaticSearchFields.DOCUMENT_ISSN).andThen(simpleSearchFieldRestrictionToLuceneFieldRestriction));
        }).buildSearchFieldRestrictionToLuceneFieldRestriction();
        return searchFieldRestrictionToLuceneFieldRestriction.andThen(luceneFieldRestrictionToQuery);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerAcceptableValuesProviders() {
        this.allDatatypeToAllValuesProviderMap.put(new EqualsPredicate((Object)CoreConstants.Datatype.LOCAL_DATASET.getName()), this.allLocalDatasetsProvider());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForStringId(Datasource.class, this.datasourceLoader()).registerForStringId(FacetKeyIdentified.class, id -> new FacetKeyIdentified.StringIdToFacetKeyIdentifiedConverter().convert(id)).registerForIntegerId(FacetDefinitionType.class, (ByIdLoadable)FacetDefinitionType.CODEBOOK).registerForIntegerId(FacetScope.class, (ByIdLoadable)FacetScope.CODEBOOK).registerForStringId(SearchField.class, (ByIdLoadable)this.searchFieldLoader()).registerForStringId(Sorting.class, this.searchSortingLoader()).registerForUuidId(Search.class, (ByIdLoadable)this.searchRepository());
        this.conversionService.addConverter(String.class, Restriction.class, source -> {
            try {
                return (Restriction)this.objectMapper.readValue(source, Restriction.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot deserialize json to %s".formatted(Restriction.class.getSimpleName()), e);
            }
        });
        this.objectMapperModule.addSerializer(Restriction.class, (JsonSerializer)new RestrictionSerializer()).addDeserializer(Restriction.class, (JsonDeserializer)new RestrictionDeserializerPostModifyingDecorator((RestrictionDeserializer)new RestrictionDeserializerWithSearchFields(), this.datatypableStringConverter, this.datatypeBySearchFieldLoader()));
    }

    @ConstructorProperties(value={"queryFactory", "jdbcTemplate", "notCriticalJdbcTemplate", "mappingAppserver", "dmlAppserverService", "executorService", "datatypableStringConverter", "cacheService", "codebookLoaderBuilderFactory", "objectMapperModule", "settingLoader", "acceptableValuesProviderLoader", "allowedDocumentFondsDepartmentedProvider", "allowedAuthorityFondsDepartmentedProvider", "allowedFondsDepartmentedProvider", "departmentAccessor", "allowedLocationsContextualProvider", "authorityFondLoader", "documentFondLoader", "translator", "converterRegisterer", "conversionService", "objectMapper", "allZServerDatasetsProvider", "allowedZServerDatasetsProvider", "allDatatypeToAllValuesProviderMap"})
    @Generated
    public SearchConfig(@NonNull QueryFactory queryFactory, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull NamedParameterJdbcOperations notCriticalJdbcTemplate, @NonNull MappingAppserverService mappingAppserver, @NonNull DmlAppserverService dmlAppserverService, @NonNull ExecutorService executorService, @NonNull DatatypableStringConverter datatypableStringConverter, @NonNull CacheService cacheService, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull SimpleModule objectMapperModule, @NonNull SettingLoader settingLoader, @NonNull ByIdLoadable<AllValuesProvider<? extends LabeledIdentified<?>>, String> acceptableValuesProviderLoader, @NonNull ContextualProvider<Department, List<Fond>> allowedDocumentFondsDepartmentedProvider, @NonNull ContextualProvider<Department, List<Fond>> allowedAuthorityFondsDepartmentedProvider, @NonNull ContextualProvider<Department, List<Fond>> allowedFondsDepartmentedProvider, @NonNull DepartmentAccessor departmentAccessor, @NonNull ContextualProvider<Department, List<Location>> allowedLocationsContextualProvider, @NonNull AllValuesProvider<Fond> authorityFondLoader, @NonNull AllValuesProvider<Fond> documentFondLoader, @NonNull Translator<Department> translator, @NonNull ConverterRegisterer converterRegisterer, @NonNull FormattingConversionService conversionService, @NonNull ObjectMapper objectMapper, @NonNull AllValuesProvider<ZServerDatasource> allZServerDatasetsProvider, @NonNull ContextualProvider<Department, List<ZServerDatasource>> allowedZServerDatasetsProvider, @NonNull LinkedHashMap<Predicate<String>, AllValuesProvider<? extends LabeledIdentified<?>>> allDatatypeToAllValuesProviderMap) {
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(notCriticalJdbcTemplate, "notCriticalJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(dmlAppserverService, "dmlAppserverService is marked non-null but is null");
        Objects.requireNonNull(executorService, "executorService is marked non-null but is null");
        Objects.requireNonNull(datatypableStringConverter, "datatypableStringConverter is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(objectMapperModule, "objectMapperModule is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(acceptableValuesProviderLoader, "acceptableValuesProviderLoader is marked non-null but is null");
        Objects.requireNonNull(allowedDocumentFondsDepartmentedProvider, "allowedDocumentFondsDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(allowedAuthorityFondsDepartmentedProvider, "allowedAuthorityFondsDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(allowedFondsDepartmentedProvider, "allowedFondsDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(allowedLocationsContextualProvider, "allowedLocationsContextualProvider is marked non-null but is null");
        Objects.requireNonNull(authorityFondLoader, "authorityFondLoader is marked non-null but is null");
        Objects.requireNonNull(documentFondLoader, "documentFondLoader is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(conversionService, "conversionService is marked non-null but is null");
        Objects.requireNonNull(objectMapper, "objectMapper is marked non-null but is null");
        Objects.requireNonNull(allZServerDatasetsProvider, "allZServerDatasetsProvider is marked non-null but is null");
        Objects.requireNonNull(allowedZServerDatasetsProvider, "allowedZServerDatasetsProvider is marked non-null but is null");
        Objects.requireNonNull(allDatatypeToAllValuesProviderMap, "allDatatypeToAllValuesProviderMap is marked non-null but is null");
        this.queryFactory = queryFactory;
        this.jdbcTemplate = jdbcTemplate;
        this.notCriticalJdbcTemplate = notCriticalJdbcTemplate;
        this.mappingAppserver = mappingAppserver;
        this.dmlAppserverService = dmlAppserverService;
        this.executorService = executorService;
        this.datatypableStringConverter = datatypableStringConverter;
        this.cacheService = cacheService;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.objectMapperModule = objectMapperModule;
        this.settingLoader = settingLoader;
        this.acceptableValuesProviderLoader = acceptableValuesProviderLoader;
        this.allowedDocumentFondsDepartmentedProvider = allowedDocumentFondsDepartmentedProvider;
        this.allowedAuthorityFondsDepartmentedProvider = allowedAuthorityFondsDepartmentedProvider;
        this.allowedFondsDepartmentedProvider = allowedFondsDepartmentedProvider;
        this.departmentAccessor = departmentAccessor;
        this.allowedLocationsContextualProvider = allowedLocationsContextualProvider;
        this.authorityFondLoader = authorityFondLoader;
        this.documentFondLoader = documentFondLoader;
        this.translator = translator;
        this.converterRegisterer = converterRegisterer;
        this.conversionService = conversionService;
        this.objectMapper = objectMapper;
        this.allZServerDatasetsProvider = allZServerDatasetsProvider;
        this.allowedZServerDatasetsProvider = allowedZServerDatasetsProvider;
        this.allDatatypeToAllValuesProviderMap = allDatatypeToAllValuesProviderMap;
    }
}

