/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.config.web.ProxiedJobRunrDashboardWebServer;
import cz.kpsys.portaro.logging.ExecutionTimeLoggingAspect;
import cz.kpsys.portaro.logging.LoggingAspect;
import cz.kpsys.portaro.logging.TraceIdAddingCronAspect;
import cz.kpsys.portaro.logging.TraceIdRepository;
import cz.kpsys.portaro.web.NoServletPathEmulatingServletWrappingController;
import cz.kpsys.portaro.web.proxy.UrlEncodedFormParametersCorrectingProxyServlet;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import lombok.NonNull;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.spring.annotation.EnableSchedulerLock;
import org.jobrunr.configuration.JobRunr;
import org.jobrunr.configuration.JobRunrConfiguration;
import org.jobrunr.scheduling.JobRequestScheduler;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.storage.InMemoryStorageProvider;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.mapper.JsonMapper;
import org.jobrunr.utils.mapper.jackson.JacksonJsonMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.web.servlet.mvc.ServletWrappingController;

@EnableScheduling
@EnableSchedulerLock(defaultLockAtMostFor="PT120S")
@Configuration
public class SchedulingConfig
implements SchedulingConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulingConfig.class);
    public static final int JOBRUNR_DASHBOARD_PORT = 6010;
    public static final String JOBRUNR_DASHBOARD_PROXY_SERVLET_PATH = "/jobs";
    @NonNull
    private final DataSource dataSource;
    @NonNull
    private final TraceIdRepository traceIdRepository;
    @NonNull
    private final BeanFactory applicationContext;

    @Bean
    public LoggingAspect loggingCronAspect() {
        return new LoggingAspect();
    }

    @Bean
    public ExecutionTimeLoggingAspect executionTimeLoggingAspect() {
        return new ExecutionTimeLoggingAspect();
    }

    @Bean
    public TraceIdAddingCronAspect traceIdAddingCronAspect() {
        return new TraceIdAddingCronAspect(this.traceIdRepository);
    }

    @Bean
    public TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(20);
        return taskScheduler;
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setTaskScheduler(this.taskScheduler());
    }

    @Bean
    public LockProvider lockProvider() {
        return new JdbcTemplateLockProvider(this.dataSource, "scheduling_shedlock");
    }

    @Bean
    public JobRunrConfiguration.JobRunrConfigurationResult jobRunrInit() {
        return JobRunr.configure().useJobActivator(arg_0 -> ((BeanFactory)this.applicationContext).getBean(arg_0)).useStorageProvider((StorageProvider)this.jobRunrStorageProvider()).useBackgroundJobServer().initialize();
    }

    @Bean
    public InMemoryStorageProvider jobRunrStorageProvider() {
        return new InMemoryStorageProvider();
    }

    @Bean
    public JobScheduler jobScheduler() {
        return this.jobRunrInit().getJobScheduler();
    }

    @Bean
    public JobRequestScheduler jobRequestScheduler() {
        return this.jobRunrInit().getJobRequestScheduler();
    }

    @Bean
    public ProxiedJobRunrDashboardWebServer jobRunrDashboardWebServer() {
        return new ProxiedJobRunrDashboardWebServer((StorageProvider)this.jobRunrStorageProvider(), (JsonMapper)new JacksonJsonMapper(), 6010);
    }

    @Bean
    public ServletWrappingController jobRunrDashboardProxyController() {
        log.debug("Enabling jobrunr dashboard reverse-proxy");
        NoServletPathEmulatingServletWrappingController bean = new NoServletPathEmulatingServletWrappingController(UrlEncodedFormParametersCorrectingProxyServlet.class, JOBRUNR_DASHBOARD_PROXY_SERVLET_PATH).withMatchAllPatternInServletMapping();
        Properties initParameters = new Properties();
        initParameters.setProperty("targetUri", "http://localhost:%d".formatted(6010));
        bean.setInitParameters(initParameters);
        return bean;
    }

    @Bean
    public CommandLineRunner jobRunrDashboardWebServerRunner() {
        return args -> {
            try {
                this.jobRunrDashboardWebServer().start();
            }
            catch (Exception e) {
                log.error("Cannot start JobRunr dashboard", (Throwable)e);
            }
        };
    }

    @ConstructorProperties(value={"dataSource", "traceIdRepository", "applicationContext"})
    @Generated
    public SchedulingConfig(@NonNull DataSource dataSource, @NonNull TraceIdRepository traceIdRepository, @NonNull BeanFactory applicationContext) {
        Objects.requireNonNull(dataSource, "dataSource is marked non-null but is null");
        Objects.requireNonNull(traceIdRepository, "traceIdRepository is marked non-null but is null");
        Objects.requireNonNull(applicationContext, "applicationContext is marked non-null but is null");
        this.dataSource = dataSource;
        this.traceIdRepository = traceIdRepository;
        this.applicationContext = applicationContext;
    }
}

