/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.commons.contextual.ContextualFunction;
import cz.kpsys.portaro.commons.convert.ListToModifiedListConverter;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.form.editor2.bool.BooleanValueEditorModifier;
import cz.kpsys.portaro.object.TypedDepartmentedObjectModifier;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.deletion.RecordHoldingDeletionRequest;
import cz.kpsys.portaro.record.deletion.RecordHoldingDeletionRequestDefaulter;
import cz.kpsys.portaro.record.edit.RecordEditationFactory;
import cz.kpsys.portaro.record.holding.AppserverRecordHoldingCreator;
import cz.kpsys.portaro.record.holding.AuthorityHoldingDepartmentReplacingRecordHoldingCreator;
import cz.kpsys.portaro.record.holding.DelegatingRecordHoldingLoader;
import cz.kpsys.portaro.record.holding.DelegatingRecordHoldingSourceLoader;
import cz.kpsys.portaro.record.holding.EntityToRecordHoldingConverter;
import cz.kpsys.portaro.record.holding.EntityToRecordHoldingSourceConverter;
import cz.kpsys.portaro.record.holding.ExternalRecordSavingRecordHoldingCreator;
import cz.kpsys.portaro.record.holding.RecordHolding;
import cz.kpsys.portaro.record.holding.RecordHoldingCreator;
import cz.kpsys.portaro.record.holding.RecordHoldingEntity;
import cz.kpsys.portaro.record.holding.RecordHoldingEntityLoader;
import cz.kpsys.portaro.record.holding.RecordHoldingLoader;
import cz.kpsys.portaro.record.holding.RecordHoldingSourceEntityLoader;
import cz.kpsys.portaro.record.holding.RecordHoldingSourceLoader;
import cz.kpsys.portaro.record.holding.RecordHoldingToEntityConverter;
import cz.kpsys.portaro.record.operation.RecordOperation;
import cz.kpsys.portaro.record.operation.RecordOperationType;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

@Configuration
public class RecordHoldingConfig {
    @NonNull
    private final RepositoryFactorySupport jpaRepositoryFactory;
    @NonNull
    private final SaverBuilderFactory saverBuilderFactory;
    @NonNull
    private final ObjectMapper appserverXmlMapper;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final IdAndIdsLoadable<? extends Record, UUID> recordLoader;
    @NonNull
    private final RecordEditationFactory recordEditationFactory;
    @NonNull
    private final ByIdLoadable<RecordOperationType, Integer> recordOperationTypeLoader;
    @NonNull
    private final Saver<RecordOperation> recordOperationSaver;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final ContextualFunction<Record, Department, Boolean> singleNodeDepartmentedRecordHasExemplarsPredicate;
    @NonNull
    private final Provider<Department> realRootDepartmentProvider;

    @Bean
    public RecordHoldingCreator recordHoldingCreator() {
        AppserverRecordHoldingCreator bean = new AppserverRecordHoldingCreator(this.appserverXmlMapper, this.mappingAppserver, this.recordHoldingLoader(), this.recordOperationTypeLoader, this.recordOperationSaver);
        AuthorityHoldingDepartmentReplacingRecordHoldingCreator authorityHoldingDepartmentReplacing = new AuthorityHoldingDepartmentReplacingRecordHoldingCreator((RecordHoldingCreator)bean, this.realRootDepartmentProvider);
        return new ExternalRecordSavingRecordHoldingCreator(this.recordEditationFactory, (RecordHoldingCreator)authorityHoldingDepartmentReplacing);
    }

    @Bean
    public RecordHoldingEntityLoader recordHoldingEntityLoader() {
        return (RecordHoldingEntityLoader)this.jpaRepositoryFactory.getRepository(RecordHoldingEntityLoader.class);
    }

    @Bean
    public RecordHoldingLoader recordHoldingLoader() {
        ListToModifiedListConverter entitiesToRecordHoldingConverter = new ListToModifiedListConverter((Converter)new EntityToRecordHoldingConverter(this.departmentLoader));
        return new DelegatingRecordHoldingLoader(this.recordHoldingEntityLoader(), (Converter)entitiesToRecordHoldingConverter, this.departmentAccessor);
    }

    @Bean
    public Saver<RecordHolding> recordHoldingSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new RecordHoldingToEntityConverter()).withClearedCacheName(RecordHoldingEntity.class.getSimpleName()).build();
    }

    @Bean
    public RecordHoldingSourceEntityLoader recordHoldingSourceEntityLoader() {
        return (RecordHoldingSourceEntityLoader)this.jpaRepositoryFactory.getRepository(RecordHoldingSourceEntityLoader.class);
    }

    @Bean
    public RecordHoldingSourceLoader recordHoldingSourceLoader() {
        ListToModifiedListConverter entitiesToRecordHoldingSourceConverter = new ListToModifiedListConverter((Converter)new EntityToRecordHoldingSourceConverter());
        return new DelegatingRecordHoldingSourceLoader(this.recordHoldingSourceEntityLoader(), (Converter)entitiesToRecordHoldingSourceConverter);
    }

    @Bean
    public TypedDepartmentedObjectModifier<RecordHoldingDeletionRequest> recordHoldingDeletionRequestDefaulter() {
        return new RecordHoldingDeletionRequestDefaulter();
    }

    @Bean
    public BooleanValueEditorModifier<RecordHoldingDeletionRequest> recordHoldingDeletionAcceptingExemplarsDeletionEditorModifier() {
        return new RecordHoldingDeletionRequest.RecordHoldingDeletionAcceptingExemplarsDeletionEditorModifier(this.recordLoader, this.singleNodeDepartmentedRecordHasExemplarsPredicate);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForUuidId(RecordHolding.class, (ByIdLoadable)this.recordHoldingLoader());
    }

    @ConstructorProperties(value={"jpaRepositoryFactory", "saverBuilderFactory", "appserverXmlMapper", "mappingAppserver", "converterRegisterer", "recordLoader", "recordEditationFactory", "recordOperationTypeLoader", "recordOperationSaver", "departmentAccessor", "departmentLoader", "singleNodeDepartmentedRecordHasExemplarsPredicate", "realRootDepartmentProvider"})
    @Generated
    public RecordHoldingConfig(@NonNull RepositoryFactorySupport jpaRepositoryFactory, @NonNull SaverBuilderFactory saverBuilderFactory, @NonNull ObjectMapper appserverXmlMapper, @NonNull MappingAppserverService mappingAppserver, @NonNull ConverterRegisterer converterRegisterer, @NonNull IdAndIdsLoadable<? extends Record, UUID> recordLoader, @NonNull RecordEditationFactory recordEditationFactory, @NonNull ByIdLoadable<RecordOperationType, Integer> recordOperationTypeLoader, @NonNull Saver<RecordOperation> recordOperationSaver, @NonNull DepartmentAccessor departmentAccessor, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull ContextualFunction<Record, Department, Boolean> singleNodeDepartmentedRecordHasExemplarsPredicate, @NonNull Provider<Department> realRootDepartmentProvider) {
        Objects.requireNonNull(jpaRepositoryFactory, "jpaRepositoryFactory is marked non-null but is null");
        Objects.requireNonNull(saverBuilderFactory, "saverBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(appserverXmlMapper, "appserverXmlMapper is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(recordLoader, "recordLoader is marked non-null but is null");
        Objects.requireNonNull(recordEditationFactory, "recordEditationFactory is marked non-null but is null");
        Objects.requireNonNull(recordOperationTypeLoader, "recordOperationTypeLoader is marked non-null but is null");
        Objects.requireNonNull(recordOperationSaver, "recordOperationSaver is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(singleNodeDepartmentedRecordHasExemplarsPredicate, "singleNodeDepartmentedRecordHasExemplarsPredicate is marked non-null but is null");
        Objects.requireNonNull(realRootDepartmentProvider, "realRootDepartmentProvider is marked non-null but is null");
        this.jpaRepositoryFactory = jpaRepositoryFactory;
        this.saverBuilderFactory = saverBuilderFactory;
        this.appserverXmlMapper = appserverXmlMapper;
        this.mappingAppserver = mappingAppserver;
        this.converterRegisterer = converterRegisterer;
        this.recordLoader = recordLoader;
        this.recordEditationFactory = recordEditationFactory;
        this.recordOperationTypeLoader = recordOperationTypeLoader;
        this.recordOperationSaver = recordOperationSaver;
        this.departmentAccessor = departmentAccessor;
        this.departmentLoader = departmentLoader;
        this.singleNodeDepartmentedRecordHasExemplarsPredicate = singleNodeDepartmentedRecordHasExemplarsPredicate;
        this.realRootDepartmentProvider = realRootDepartmentProvider;
    }
}

