/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.appserver.GenericTableWriteSaver;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.dml.TableWriteGenerator;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.department.CurrentAuthDepartmentsLoader;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.logging.Logged;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.ProviderByIdProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.HookableSaver;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.conversation.ActionRequestUrlGenerator;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.department.HierarchicalDepartment;
import cz.kpsys.portaro.department.HierarchicalDepartmentLoaderByDepartmentLoader;
import cz.kpsys.portaro.finance.AmountType;
import cz.kpsys.portaro.finance.AmountTypeEntity;
import cz.kpsys.portaro.finance.AmountTypeLoader;
import cz.kpsys.portaro.finance.CodebookBackedAmountTypeLoader;
import cz.kpsys.portaro.finance.EntityToAmountTypeConverter;
import cz.kpsys.portaro.form.conversation.SubmittingFormPackage;
import cz.kpsys.portaro.form.property.AcceptableValueResolver;
import cz.kpsys.portaro.form.property.AcceptableValuesResolver;
import cz.kpsys.portaro.logging.ActionSaver;
import cz.kpsys.portaro.object.TypedDepartmentedObjectModifier;
import cz.kpsys.portaro.payment.Payment;
import cz.kpsys.portaro.payment.PaymentProvider;
import cz.kpsys.portaro.payment.PaymentProviderOwnerPair;
import cz.kpsys.portaro.payment.PaymentSecurityActions;
import cz.kpsys.portaro.payment.PaymentService;
import cz.kpsys.portaro.payment.PaymentUtil;
import cz.kpsys.portaro.payment.SecuredPaymentService;
import cz.kpsys.portaro.payment.SpringDbPaymentSearchLoader;
import cz.kpsys.portaro.payment.SpringDbTransactionLoader;
import cz.kpsys.portaro.payment.SpringDbTypedUserBilanceSearchLoader;
import cz.kpsys.portaro.payment.Transaction;
import cz.kpsys.portaro.payment.TransactionLoader;
import cz.kpsys.portaro.payment.TransactionsTableWriteGenerator;
import cz.kpsys.portaro.payment.TypedUserAmount;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoaderImpl;
import cz.kpsys.portaro.search.ResultConvertingPageSearchLoader;
import cz.kpsys.portaro.security.FlattingAndingPermissionResolver;
import cz.kpsys.portaro.security.MappingPermissionResolver;
import cz.kpsys.portaro.security.NullSubjectForwardingPermissionResolver;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.SecurityAccessor;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.template.TemplateEngine;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.User;
import cz.kpsys.portaro.user.payment.provider.AppserverPaymentSaver;
import cz.kpsys.portaro.user.payment.provider.DispatchingPaymentLoader;
import cz.kpsys.portaro.user.payment.provider.DispatchingPaymentService;
import cz.kpsys.portaro.user.payment.provider.PaymentClassDispatchingPaymentStateUpdater;
import cz.kpsys.portaro.user.payment.provider.PaymentItemLoader;
import cz.kpsys.portaro.user.payment.provider.PaymentLoader;
import cz.kpsys.portaro.user.payment.provider.PaymentLoaderProvider;
import cz.kpsys.portaro.user.payment.provider.PaymentProviderSettingKeys;
import cz.kpsys.portaro.user.payment.provider.PaymentRowMapper;
import cz.kpsys.portaro.user.payment.provider.PaymentServiceRegistrar;
import cz.kpsys.portaro.user.payment.provider.PaymentStateUpdater;
import cz.kpsys.portaro.user.payment.provider.PaymentTableWriteGenerator;
import cz.kpsys.portaro.user.payment.provider.PendingPaymentsUpdater;
import cz.kpsys.portaro.user.payment.provider.SearchingPendingPaymentsUpdater;
import cz.kpsys.portaro.user.payment.provider.SpringDbPaymentItemLoader;
import cz.kpsys.portaro.user.payment.provider.SpringDbPaymentLoader;
import cz.kpsys.portaro.user.payment.provider.manual.BasicPaymentSavingPaymentService;
import cz.kpsys.portaro.user.payment.provider.manual.ManualPaymentProviderSettingKeys;
import cz.kpsys.portaro.user.relation.UserRelationsHelper;
import cz.kpsys.portaro.view.web.page.PaymentPrintPageController;
import cz.kpsys.portaro.view.web.page.PrintReceiptOfPaymentRequest;
import cz.kpsys.portaro.view.web.page.PrintReceiptOfPaymentRequestDefaulter;
import cz.kpsys.portaro.view.web.rest.finance.AmountTypeApiController;
import cz.kpsys.portaro.view.web.rest.finance.TransactionApiController;
import cz.kpsys.portaro.view.web.rest.finance.TransactionsPrintRequest;
import cz.kpsys.portaro.view.web.rest.finance.TransationPrintApiController;
import cz.kpsys.portaro.view.web.rest.payment.PayApiController;
import cz.kpsys.portaro.view.web.rest.payment.PayRequest;
import cz.kpsys.portaro.view.web.rest.payment.PayRequestAllowedDepartmentsResolver;
import cz.kpsys.portaro.view.web.rest.payment.PayRequestDefaulter;
import cz.kpsys.portaro.view.web.rest.payment.PayRequestFormSubmitPackageModifier;
import cz.kpsys.portaro.view.web.rest.payment.PaymentApiController;
import cz.kpsys.portaro.web.page.ModelAndPageViewFactory;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class PaymentConfig {
    @NonNull
    private final @NonNull Provider<@NonNull String> publicContextPath;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final TemplateEngine templateEngine;
    @NonNull
    private final DmlAppserverService dmlAppserverService;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final SecurityAccessor securityAccessor;
    @NonNull
    private final ByIdLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final ActionSaver actionSaver;
    @NonNull
    private final @NonNull Provider<@NonNull User> portaroUserProvider;
    @NonNull
    private final Provider<Department> currentDepartmentProvider;
    @NonNull
    private final HierarchicalDepartmentLoaderByDepartmentLoader hierarchicalDepartmentLoaderByDepartmentLoader;
    @NonNull
    private final ActionRequestUrlGenerator actionRequestUrlGenerator;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final UserRelationsHelper userRelationsHelper;
    @NonNull
    private final ModelAndPageViewFactory modelAndPageViewFactory;

    @Bean
    public PayApiController payApiController() {
        return new PayApiController(this.actionSaver, this.paymentService(), (Saver)this.transactionsSaver(), this.portaroUserProvider, this.actionRequestUrlGenerator);
    }

    @Bean
    public TypedDepartmentedObjectModifier<SubmittingFormPackage<PayRequest>> payRequestFormSubmitPackageModifier() {
        return new PayRequestFormSubmitPackageModifier(this.authenticationHolder);
    }

    @Bean
    public AcceptableValuesResolver<PayRequest, Department> payRequestAllowedDepartmentsResolver() {
        return new PayRequestAllowedDepartmentsResolver(this.authenticationHolder, this.securityAccessor);
    }

    @Bean
    public TypedDepartmentedObjectModifier<PayRequest> payRequestDefaulter() {
        return new PayRequestDefaulter(this.typedUserBilanceSearchLoader(), this.settingLoader.getDepartmentedProvider(PaymentProviderSettingKeys.FORBIDDEN_GATEWAY_PAYMENT_TYPES), (AllValuesProvider)this.amountTypeLoader(), this.userRelationsHelper, this.payRequestAllowedDepartmentsResolver());
    }

    @Bean
    public PaymentApiController paymentApiController() {
        return new PaymentApiController(this.concretePaymentLoader(), (PaymentStateUpdater)this.paymentStateUpdater(), (PendingPaymentsUpdater)this.pendingPaymentsUpdater());
    }

    @Bean
    public TransationPrintApiController transationPrintApiController() {
        return new TransationPrintApiController(this.publicContextPath);
    }

    @Bean
    public AcceptableValueResolver<TransactionsPrintRequest, HierarchicalDepartment> transactionsPrintAllowedParentDepartmentResolver() {
        return (request, ctx) -> this.hierarchicalDepartmentLoaderByDepartmentLoader.toHierarchical(ctx);
    }

    @Bean
    public TypedDepartmentedObjectModifier<TransactionsPrintRequest> transactionsPrintRequestDefaulter() {
        return new TransactionsPrintRequest.TransactionsPrintRequestDefaulter(this.departmentAccessor, this.currentDepartmentProvider);
    }

    @Bean
    public PaymentPrintPageController paymentPrintPageController() {
        return new PaymentPrintPageController(this.templateEngine, this.transactionLoader(), this.departmentAccessor, this.currentAuthEditableDepartmentsLoader, this.modelAndPageViewFactory);
    }

    @Bean
    public TypedDepartmentedObjectModifier<PrintReceiptOfPaymentRequest> printReceiptOfPaymentRequestDefaulter() {
        return new PrintReceiptOfPaymentRequestDefaulter(this.authenticationHolder);
    }

    @Bean
    public TransactionApiController transactionApiController() {
        return new TransactionApiController(this.transactionLoader(), (Saver)this.transactionsSaver());
    }

    @Bean
    public AmountTypeApiController amountTypeApiController() {
        return new AmountTypeApiController(this.amountTypeLoader());
    }

    @Bean
    public TransactionLoader transactionLoader() {
        return new SpringDbTransactionLoader(this.jdbcTemplate, this.queryFactory, this.departmentLoader, (ByIdLoadable)this.amountTypeLoader(), this.basicUserLoader);
    }

    @Bean
    public HookableSaver<List<Transaction>> transactionsSaver() {
        return GenericTableWriteSaver.of((TableWriteGenerator)new TransactionsTableWriteGenerator(), (DmlAppserverService)this.dmlAppserverService, (CacheCleaner[])new CacheCleaner[0]);
    }

    @Bean
    public AmountTypeLoader amountTypeLoader() {
        Codebook codebook = this.codebookLoaderBuilderFactory.create().providedByJpa(AmountTypeEntity.class, "order").convertedEachBy((Converter)new EntityToAmountTypeConverter()).staticCached(AmountType.class.getSimpleName()).build();
        return new CodebookBackedAmountTypeLoader(codebook);
    }

    @Bean
    public Provider<AmountType> registrationFeeAmountTypeProvider() {
        return ProviderByIdProvider.ofStaticId((ByIdLoadable)this.amountTypeLoader(), (Object)5);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, TypedUserAmount> typedUserBilanceSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new SpringDbTypedUserBilanceSearchLoader(this.jdbcTemplate, this.queryFactory, (ByIdLoadable)this.amountTypeLoader(), this.basicUserLoader));
    }

    @Bean
    public Map<String, Class<?>> providerNamesToPaymentTypes() {
        HashMap map = new HashMap();
        map.put("cash", Payment.class);
        map.put("terminal-virtual", Payment.class);
        return map;
    }

    @Bean
    public Map<Class<? extends Payment>, ByIdLoadable<? extends Payment, Integer>> paymentTypesToLoaders() {
        HashMap<Class<? extends Payment>, ByIdLoadable<? extends Payment, Integer>> map = new HashMap<Class<? extends Payment>, ByIdLoadable<? extends Payment, Integer>>();
        map.put((Class<? extends Payment>)Payment.class, (ByIdLoadable<? extends Payment, Integer>)this.purePaymentLoader());
        return map;
    }

    @Bean
    public PaymentLoaderProvider paymentLoaderProvider() {
        return new PaymentLoaderProvider(this.providerNamesToPaymentTypes(), this.paymentTypesToLoaders());
    }

    @Bean
    public PaymentLoader purePaymentLoader() {
        return new SpringDbPaymentLoader(this.jdbcTemplate, this.queryFactory, this.paymentRowMapper());
    }

    @Bean
    public ByIdLoadable<Payment, Integer> concretePaymentLoader() {
        return new DispatchingPaymentLoader((ByIdLoadable)this.purePaymentLoader(), this.paymentLoaderProvider());
    }

    @Bean
    public RowMapper<Payment> paymentRowMapper() {
        return new PaymentRowMapper(this.basicUserLoader, this.departmentLoader, this.paymentItemLoader());
    }

    @Bean
    public DispatchingPaymentService dispatchingPaymentService() {
        return new DispatchingPaymentService().withAlwaysEnabled("cash", Integer.valueOf(100), this.basicPaymentSavingPaymentService()).withConditionalyEnabled("terminal-virtual", Integer.valueOf(200), this.settingLoader.getDepartmentedProvider(ManualPaymentProviderSettingKeys.TERMINAL_VIRTUAL_ENABLED), this.basicPaymentSavingPaymentService());
    }

    @Bean
    public PaymentService paymentService() {
        return new SecuredPaymentService(this.securityManager, (PaymentService)this.dispatchingPaymentService(), this.authenticationHolder);
    }

    @Bean
    public ContextualProvider<Department, List<String>> enabledPaymentProviderNames() {
        return department -> this.dispatchingPaymentService().getAllEnabled(department);
    }

    @Bean
    public Saver<Payment> paymentSaver() {
        return new AppserverPaymentSaver((TableWriteGenerator)new PaymentTableWriteGenerator(), this.dmlAppserverService, this.transactionLoader(), (Saver)this.transactionsSaver());
    }

    @Bean
    public PaymentService basicPaymentSavingPaymentService() {
        return new BasicPaymentSavingPaymentService(this.paymentSaver());
    }

    @Bean
    public PaymentItemLoader paymentItemLoader() {
        return new SpringDbPaymentItemLoader(this.jdbcTemplate, this.queryFactory, this.basicUserLoader, (ByIdLoadable)this.amountTypeLoader());
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Integer> paymentIdSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new SpringDbPaymentSearchLoader(this.jdbcTemplate, this.queryFactory));
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Payment> paymentSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)ResultConvertingPageSearchLoader.createConvertingFromIds((PageSearchLoader)this.paymentIdSearchLoader(), (AllByIdsLoadable)this.purePaymentLoader()));
    }

    @Bean
    public PaymentProvider cashPaymentProvider() {
        return new PaymentProvider("cash");
    }

    @Bean
    public PaymentProvider gpePaymentProvider() {
        return new PaymentProvider("terminal-gpe");
    }

    @Bean
    public PaymentProvider virtualTerminalPaymentProvider() {
        return new PaymentProvider("terminal-virtual");
    }

    @Bean
    public List<PaymentProvider> paymentProviders() {
        return new ArrayList<PaymentProvider>(List.of(this.cashPaymentProvider(), this.virtualTerminalPaymentProvider(), this.gpePaymentProvider()));
    }

    @Bean
    public PaymentClassDispatchingPaymentStateUpdater paymentStateUpdater() {
        return new PaymentClassDispatchingPaymentStateUpdater();
    }

    @Bean
    public SearchingPendingPaymentsUpdater pendingPaymentsUpdater() {
        DispatchingPaymentLoader concretePaymentLoader = new DispatchingPaymentLoader((ByIdLoadable)this.purePaymentLoader(), this.paymentLoaderProvider());
        return new SearchingPendingPaymentsUpdater(this.paymentIdSearchLoader(), (ByIdLoadable)concretePaymentLoader, (PaymentStateUpdater)this.paymentStateUpdater());
    }

    @Bean
    public PaymentServiceRegistrar paymentServiceRegistrar() {
        return new PaymentServiceRegistrar(this.providerNamesToPaymentTypes(), this.paymentTypesToLoaders(), this.dispatchingPaymentService(), this.paymentStateUpdater(), this.paymentProviders(), this.pendingPaymentsUpdater());
    }

    @Logged
    @Scheduled(cron="0 0 22 * * *")
    @SchedulerLock(name="PaymentConfig_multiplePaymentStatusUpdate", lockAtLeastFor="PT10M", lockAtMostFor="PT20M")
    public void multiplePaymentStatusUpdate() {
        this.pendingPaymentsUpdater().checkAllPending();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForIntegerId(AmountType.class, (ByIdLoadable)this.amountTypeLoader()).registerForIntegerId(Transaction.class, (ByIdLoadable)this.transactionLoader());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        PermissionResolver canPayAnyOfUser = PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticEditWithLoanLicence(), this.permissionFactory.editOnReadableDepartmentsOfUser()});
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENTS_SHOW, this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6133)));
        this.permissionRegistry.add(PaymentSecurityActions.DEBT_CREATE, (PermissionResolver)PermissionResolver.adaptingSubject(Transaction::getOwner, (PermissionResolver)PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvided(), canPayAnyOfUser, this.permissionFactory.editAction(Integer.valueOf(6161))})));
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENT_CREATE_ANY_OF_USER_BY_PROVIDER, (auth, ctx, pair) -> {
            String paymentProviderName = pair.provider();
            if (PaymentUtil.isOfType((String)paymentProviderName, (String)"gateway")) {
                return NullSubjectForwardingPermissionResolver.of((PermissionResolver)this.permissionFactory.feature("payment-gateway")).can(auth, ctx, null);
            }
            if (PaymentUtil.isOfType((String)paymentProviderName, (String)"cash") || PaymentUtil.isOfType((String)paymentProviderName, (String)"terminal")) {
                return PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{MappingPermissionResolver.of(PaymentProviderOwnerPair::owner, (PermissionResolver)canPayAnyOfUser), NullSubjectForwardingPermissionResolver.of((PermissionResolver)this.permissionFactory.editAction(Integer.valueOf(6111)))}).can(auth, ctx, pair);
            }
            throw new UnsupportedOperationException("Unsupported payment provider type %s".formatted(paymentProviderName));
        });
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENT_CREATE, (PermissionResolver)FlattingAndingPermissionResolver.of(payCommand -> payCommand.getItems().getTransactions().stream().map(paymentItem -> new PaymentProviderOwnerPair(payCommand.getProvider(), paymentItem.getOwner())), (PermissionResolver)this.permissionRegistry.get(PaymentSecurityActions.PAYMENT_CREATE_ANY_OF_USER_BY_PROVIDER)));
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENT_CONFIRM_OF_OWNER, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvided(), canPayAnyOfUser, this.permissionFactory.editAction(Integer.valueOf(6111))}));
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENT_CONFIRM, (PermissionResolver)FlattingAndingPermissionResolver.of(payment -> payment.getItems().stream().map(TypedUserAmount::getOwner), (PermissionResolver)this.permissionRegistry.get(PaymentSecurityActions.PAYMENT_CONFIRM_OF_OWNER)));
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENT_DELETE, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvided(), canPayAnyOfUser, this.permissionFactory.editAction(Integer.valueOf(6163))}));
        this.permissionRegistry.add(PaymentSecurityActions.DEBT_DELETE, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvided(), canPayAnyOfUser, this.permissionFactory.editAction(Integer.valueOf(6164))}));
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENTS_RETURN_DEPOSIT, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvided(), canPayAnyOfUser, this.permissionFactory.editAction(Integer.valueOf(6165))}));
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENTS_PRINT, this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6134)));
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENTS_RECEIPT_PRINT, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvided(), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveIsSubjectUser(), PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6133)), this.permissionFactory.editOnReadableDepartmentsOfUser()})})}));
    }

    @ConstructorProperties(value={"publicContextPath", "jdbcTemplate", "queryFactory", "permissionRegistry", "codebookLoaderBuilderFactory", "templateEngine", "dmlAppserverService", "departmentAccessor", "securityAccessor", "basicUserLoader", "departmentLoader", "permissionFactory", "settingLoader", "securityManager", "currentAuthEditableDepartmentsLoader", "authenticationHolder", "actionSaver", "portaroUserProvider", "currentDepartmentProvider", "hierarchicalDepartmentLoaderByDepartmentLoader", "actionRequestUrlGenerator", "converterRegisterer", "userRelationsHelper", "modelAndPageViewFactory"})
    @Generated
    public PaymentConfig(@NonNull @NonNull Provider<@NonNull String> publicContextPath, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull PermissionRegistry permissionRegistry, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull TemplateEngine templateEngine, @NonNull DmlAppserverService dmlAppserverService, @NonNull DepartmentAccessor departmentAccessor, @NonNull SecurityAccessor securityAccessor, @NonNull ByIdLoadable<BasicUser, Integer> basicUserLoader, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull PermissionFactory permissionFactory, @NonNull SettingLoader settingLoader, @NonNull SecurityManager securityManager, @NonNull CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader, @NonNull AuthenticationHolder authenticationHolder, @NonNull ActionSaver actionSaver, @NonNull @NonNull Provider<@NonNull User> portaroUserProvider, @NonNull Provider<Department> currentDepartmentProvider, @NonNull HierarchicalDepartmentLoaderByDepartmentLoader hierarchicalDepartmentLoaderByDepartmentLoader, @NonNull ActionRequestUrlGenerator actionRequestUrlGenerator, @NonNull ConverterRegisterer converterRegisterer, @NonNull UserRelationsHelper userRelationsHelper, @NonNull ModelAndPageViewFactory modelAndPageViewFactory) {
        Objects.requireNonNull(publicContextPath, "publicContextPath is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(templateEngine, "templateEngine is marked non-null but is null");
        Objects.requireNonNull(dmlAppserverService, "dmlAppserverService is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(securityAccessor, "securityAccessor is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(currentAuthEditableDepartmentsLoader, "currentAuthEditableDepartmentsLoader is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(actionSaver, "actionSaver is marked non-null but is null");
        Objects.requireNonNull(portaroUserProvider, "portaroUserProvider is marked non-null but is null");
        Objects.requireNonNull(currentDepartmentProvider, "currentDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(hierarchicalDepartmentLoaderByDepartmentLoader, "hierarchicalDepartmentLoaderByDepartmentLoader is marked non-null but is null");
        Objects.requireNonNull(actionRequestUrlGenerator, "actionRequestUrlGenerator is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(userRelationsHelper, "userRelationsHelper is marked non-null but is null");
        Objects.requireNonNull(modelAndPageViewFactory, "modelAndPageViewFactory is marked non-null but is null");
        this.publicContextPath = publicContextPath;
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.permissionRegistry = permissionRegistry;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.templateEngine = templateEngine;
        this.dmlAppserverService = dmlAppserverService;
        this.departmentAccessor = departmentAccessor;
        this.securityAccessor = securityAccessor;
        this.basicUserLoader = basicUserLoader;
        this.departmentLoader = departmentLoader;
        this.permissionFactory = permissionFactory;
        this.settingLoader = settingLoader;
        this.securityManager = securityManager;
        this.currentAuthEditableDepartmentsLoader = currentAuthEditableDepartmentsLoader;
        this.authenticationHolder = authenticationHolder;
        this.actionSaver = actionSaver;
        this.portaroUserProvider = portaroUserProvider;
        this.currentDepartmentProvider = currentDepartmentProvider;
        this.hierarchicalDepartmentLoaderByDepartmentLoader = hierarchicalDepartmentLoaderByDepartmentLoader;
        this.actionRequestUrlGenerator = actionRequestUrlGenerator;
        this.converterRegisterer = converterRegisterer;
        this.userRelationsHelper = userRelationsHelper;
        this.modelAndPageViewFactory = modelAndPageViewFactory;
    }
}

