/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.convert.FallbackingConverter;
import cz.kpsys.portaro.commons.convert.IdToObjectConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerToAnyConverter;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.IdSettable;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ItemNotFoundException;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.exemplar.Exemplar;
import cz.kpsys.portaro.exemplar.ExemplarDescriptor;
import cz.kpsys.portaro.exemplar.exemplarstatus.ExemplarStatus;
import cz.kpsys.portaro.exemplar.loancategory.LoanCategory;
import cz.kpsys.portaro.exemplar.thematicgroup.ThematicGroup;
import cz.kpsys.portaro.inventory.Capture;
import cz.kpsys.portaro.inventory.CaptureEntity;
import cz.kpsys.portaro.inventory.CaptureFromDtoConverter;
import cz.kpsys.portaro.inventory.CaptureToEntityConverter;
import cz.kpsys.portaro.inventory.CaptureWay;
import cz.kpsys.portaro.inventory.EntitiesToInventoriesConverter;
import cz.kpsys.portaro.inventory.EntitiesToMatchesConverter;
import cz.kpsys.portaro.inventory.Inventory;
import cz.kpsys.portaro.inventory.InventoryEntity;
import cz.kpsys.portaro.inventory.Match;
import cz.kpsys.portaro.inventory.MatchEntity;
import cz.kpsys.portaro.inventory.MatchState;
import cz.kpsys.portaro.inventory.SpringDbCaptureSearchLoader;
import cz.kpsys.portaro.inventory.SpringDbInventoryIdSearchLoader;
import cz.kpsys.portaro.inventory.SpringDbMatchIdSearchLoader;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.location.LocationImpl;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.document.RichDocument;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.sec.SecurityActions;
import cz.kpsys.portaro.view.web.rest.inventory.CaptureApiController;
import cz.kpsys.portaro.view.web.rest.inventory.InventoryApiController;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class InventoryConfig {
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final SaverBuilderFactory saverBuilderFactory;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final AllByIdsLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final ByIdLoadable<Fond, Integer> fondLoader;
    @NonNull
    private final ByIdLoadable<Location, Integer> locationLoader;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final ByIdLoadable<LoanCategory, String> loanCategoryLoader;
    @NonNull
    private final ByIdLoadable<ThematicGroup, String> thematicGroupLoader;
    @NonNull
    private final ByIdLoadable<ExemplarStatus, Integer> exemplarStatusLoader;
    @NonNull
    private final ByIdLoadable<? extends ExemplarDescriptor, Integer> exemplarDescriptorLoader;
    @NonNull
    private final IdAndIdsLoadable<RichDocument, Integer> nonDetailedDocumentByKindedIdLoader;
    @NonNull
    private final ByIdLoadable<? extends Record, UUID> nonDetailedDocumentLoader;
    @NonNull
    private final IdAndIdsLoadable<Exemplar, Integer> exemplarLoader;
    @NonNull
    private final ConverterRegisterer converterRegisterer;

    @Bean
    public InventoryApiController inventoryApiController() {
        return new InventoryApiController(this.inventoryLoader());
    }

    @Bean
    public CaptureApiController captureApiController() {
        Saver captureSaver = this.saverBuilderFactory.saver().intermediateConverting((Converter)new CaptureToEntityConverter()).idSetting(CaptureEntity.class, (Converter)new StringToIntegerConverter(), IdSettable::setId).withClearedCacheName(CaptureEntity.class.getSimpleName()).build();
        return new CaptureApiController(captureSaver, (ByIdLoadable)this.exemplarLoader, this.nonDetailedDocumentLoader);
    }

    @Bean
    public Codebook<Inventory, Integer> inventoryLoader() {
        EntitiesToInventoriesConverter entitiesToInventoriesConverter = new EntitiesToInventoriesConverter(this.basicUserLoader, this.fondLoader, this.departmentLoader, (Converter)this.fallbackingStringIdToLocationConverter());
        return this.codebookLoaderBuilderFactory.create().providedByJpa(InventoryEntity.class).converted((Converter)entitiesToInventoriesConverter).staticCached(Inventory.class.getSimpleName()).build();
    }

    @NonNull
    private FallbackingConverter<String, Location> fallbackingStringIdToLocationConverter() {
        return FallbackingConverter.onException((Converter)StringToIntegerToAnyConverter.strict((Converter)new IdToObjectConverter(this.locationLoader)), ItemNotFoundException.class, (Converter)StringToIntegerToAnyConverter.strict(naId -> new LocationImpl(naId, "unknown-%s".formatted(naId), String.valueOf(naId), 0)));
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Integer> inventoryIdSearchLoader() {
        SpringDbInventoryIdSearchLoader modelIdSearchLoader = new SpringDbInventoryIdSearchLoader(this.jdbcTemplate, this.queryFactory);
        return this.modelBeanBuilder.idSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)modelIdSearchLoader).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Inventory> inventorySearchLoader() {
        return this.modelBeanBuilder.modelSearchLoaderByIdSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)this.inventoryIdSearchLoader(), (AllValuesProvider)this.inventoryLoader()).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Capture> captureSearchLoader() {
        SpringDbCaptureSearchLoader modelSearchLoader = new SpringDbCaptureSearchLoader(this.jdbcTemplate, this.queryFactory, (Converter)new CaptureFromDtoConverter((ByIdLoadable)this.inventoryLoader(), this.exemplarDescriptorLoader, (ByIdLoadable)CaptureWay.CODEBOOK));
        return this.modelBeanBuilder.searchLoader(MapBackedParams::createEmpty, (PageSearchLoader)modelSearchLoader).build();
    }

    @Bean
    public IdAndIdsLoadable<Match, UUID> matchLoader() {
        EntitiesToMatchesConverter entitiesToMatchesConverter = new EntitiesToMatchesConverter((ByIdLoadable)this.inventoryLoader(), (ByIdLoadable)MatchState.CODEBOOK, this.nonDetailedDocumentByKindedIdLoader, (AllByIdsLoadable)this.exemplarLoader, (Converter)this.fallbackingStringIdToLocationConverter(), (Converter)FallbackingConverter.onException((Converter)new IdToObjectConverter(this.loanCategoryLoader), ItemNotFoundException.class, naId -> new LoanCategory(naId, naId)), (Converter)FallbackingConverter.onException((Converter)new IdToObjectConverter(this.thematicGroupLoader), ItemNotFoundException.class, naId -> new ThematicGroup(naId, naId, 0)), (Converter)FallbackingConverter.onException((Converter)StringToIntegerToAnyConverter.strict((Converter)new IdToObjectConverter(this.exemplarStatusLoader)), ItemNotFoundException.class, (Converter)StringToIntegerToAnyConverter.strict(naId -> new ExemplarStatus(naId, "unknown-%s".formatted(naId)))));
        return this.modelBeanBuilder.allByIdsLoader(MatchEntity.class, (Converter)entitiesToMatchesConverter).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, UUID> matchIdSearchLoader() {
        SpringDbMatchIdSearchLoader modelIdSearchLoader = new SpringDbMatchIdSearchLoader(this.jdbcTemplate, this.queryFactory);
        return this.modelBeanBuilder.idSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)modelIdSearchLoader).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Match> matchSearchLoader() {
        return this.modelBeanBuilder.modelSearchLoaderByIdSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)this.matchIdSearchLoader(), (AllByIdsLoadable)this.matchLoader()).build();
    }

    @Bean
    public Codebook<MatchState, Integer> matchStateLoader() {
        return MatchState.CODEBOOK;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForIntegerId(Inventory.class, (ByIdLoadable)this.inventoryLoader()).registerForUuidId(Match.class, (ByIdLoadable)this.matchLoader()).registerForIntegerId(MatchState.class, (ByIdLoadable)this.matchStateLoader());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(SecurityActions.INVENTORIES_SHOW, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}));
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "modelBeanBuilder", "codebookLoaderBuilderFactory", "saverBuilderFactory", "permissionRegistry", "permissionFactory", "basicUserLoader", "fondLoader", "locationLoader", "departmentLoader", "loanCategoryLoader", "thematicGroupLoader", "exemplarStatusLoader", "exemplarDescriptorLoader", "nonDetailedDocumentByKindedIdLoader", "nonDetailedDocumentLoader", "exemplarLoader", "converterRegisterer"})
    @Generated
    public InventoryConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull SaverBuilderFactory saverBuilderFactory, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull AllByIdsLoadable<BasicUser, Integer> basicUserLoader, @NonNull ByIdLoadable<Fond, Integer> fondLoader, @NonNull ByIdLoadable<Location, Integer> locationLoader, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull ByIdLoadable<LoanCategory, String> loanCategoryLoader, @NonNull ByIdLoadable<ThematicGroup, String> thematicGroupLoader, @NonNull ByIdLoadable<ExemplarStatus, Integer> exemplarStatusLoader, @NonNull ByIdLoadable<? extends ExemplarDescriptor, Integer> exemplarDescriptorLoader, @NonNull IdAndIdsLoadable<RichDocument, Integer> nonDetailedDocumentByKindedIdLoader, @NonNull ByIdLoadable<? extends Record, UUID> nonDetailedDocumentLoader, @NonNull IdAndIdsLoadable<Exemplar, Integer> exemplarLoader, @NonNull ConverterRegisterer converterRegisterer) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(saverBuilderFactory, "saverBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        Objects.requireNonNull(locationLoader, "locationLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(loanCategoryLoader, "loanCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(thematicGroupLoader, "thematicGroupLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarStatusLoader, "exemplarStatusLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarDescriptorLoader, "exemplarDescriptorLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentByKindedIdLoader, "nonDetailedDocumentByKindedIdLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentLoader, "nonDetailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarLoader, "exemplarLoader is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.modelBeanBuilder = modelBeanBuilder;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.saverBuilderFactory = saverBuilderFactory;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.basicUserLoader = basicUserLoader;
        this.fondLoader = fondLoader;
        this.locationLoader = locationLoader;
        this.departmentLoader = departmentLoader;
        this.loanCategoryLoader = loanCategoryLoader;
        this.thematicGroupLoader = thematicGroupLoader;
        this.exemplarStatusLoader = exemplarStatusLoader;
        this.exemplarDescriptorLoader = exemplarDescriptorLoader;
        this.nonDetailedDocumentByKindedIdLoader = nonDetailedDocumentByKindedIdLoader;
        this.nonDetailedDocumentLoader = nonDetailedDocumentLoader;
        this.exemplarLoader = exemplarLoader;
        this.converterRegisterer = converterRegisterer;
    }
}

