/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.app.CatalogConstants;
import cz.kpsys.portaro.appserver.Appserver;
import cz.kpsys.portaro.appserver.AppserverService;
import cz.kpsys.portaro.appserver.BasicAppserverService;
import cz.kpsys.portaro.appserver.mapping.BasicMappingAppserverService;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.appserver.properties.AppserverAppserverPropertiesLoader;
import cz.kpsys.portaro.appserver.properties.AppserverProperties;
import cz.kpsys.portaro.appserver.properties.AppserverPropertiesLoader;
import cz.kpsys.portaro.appserver.properties.MultiTryingAppserverPropertiesLoader;
import cz.kpsys.portaro.commons.object.FallbackedProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.commons.object.ValidatingProvider;
import cz.kpsys.portaro.commons.util.ObjectUtil;
import cz.kpsys.portaro.commons.util.StringUtil;
import cz.kpsys.portaro.commons.webclient.HttpFactory;
import cz.kpsys.portaro.config.ObjectMapperFactory;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.core.application.PortaroVersion;
import cz.kpsys.portaro.core.application.VcsBackedPortaroVersion;
import cz.kpsys.portaro.database.IntegerValueDatabaseLoader;
import cz.kpsys.portaro.databaseproperties.DataSourceFactory;
import cz.kpsys.portaro.databaseproperties.DatabaseConnectionSettings;
import cz.kpsys.portaro.databaseproperties.DatabaseProperties;
import cz.kpsys.portaro.databaseproperties.ForceableConncetionDefinitionProvider;
import cz.kpsys.portaro.httpclient.RestOperationsFactory;
import cz.kpsys.portaro.licence.BusinessVersion;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.portaro.licence.LicenceKeyDecoder;
import cz.kpsys.portaro.licence.LicenceKeyDecodingLicenceKeyExpiredPredicate;
import cz.kpsys.portaro.licence.LicenceKeyDecodingLicenceProvider;
import cz.kpsys.portaro.licence.LicenceKeyExpiredException;
import cz.kpsys.portaro.licence.LicenceServerFetchingLicenceKeyProvider;
import cz.kpsys.portaro.licence.jwt.Auth0JwtLicenceKeyDecoder;
import cz.kpsys.portaro.logging.TraceIdRepository;
import cz.kpsys.portaro.logging.UuidMdcTraceIdRepository;
import cz.kpsys.portaro.setting.IniNotSetException;
import cz.kpsys.portaro.setting.JdbcSimplifiedCustomSettingValueLoader;
import cz.kpsys.portaro.setting.SettingTypeId;
import cz.kpsys.portaro.setting.SimplifiedCustomSettingValueLoader;
import cz.kpsys.portaro.sql.generator.DbSpecifics;
import cz.kpsys.portaro.sql.generator.DbSpecificsFirebird;
import cz.kpsys.portaro.sql.generator.DbSpecificsPostgresql;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import java.time.ZoneId;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.sql.DataSource;
import lombok.Generated;
import lombok.NonNull;
import org.apache.hc.client5.http.classic.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.web.client.RestOperations;

@Configuration
public class InitializationConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InitializationConfig.class);
    @Value(value="${git.build.version}")
    String versionId;
    @Value(value="${git.commit.time}")
    String versionDateString;
    @Value(value="${git.commit.id.abbrev}")
    String commitAbbrev;
    @Value(value="${git.branch}")
    String versionBranch;
    @Value(value="${git.commit.message.short}")
    String versionLastCommitMessage;
    @Value(value="${http.proxy.url}")
    String httpProxyUrl;
    @Value(value="${http.proxy.auth}")
    boolean httpProxyAuth;
    @Value(value="${http.proxy.username}")
    String httpProxyUsername;
    @Value(value="${http.proxy.password}")
    String httpProxyPassword;
    @Value(value="${appserver.url}")
    private String appserverUrl;
    @Value(value="${portaro.startupAttemptsPeriod}")
    private int startupAttemptsPeriod;
    @Value(value="${portaro.startupAttemptsCount}")
    private int startupAttemptsCount;
    @Value(value="${database.username}")
    private String databaseUsername;
    @Value(value="${database.password}")
    private String databasePassword;
    @Value(value="${database.type}")
    private String forcedDatabaseType;
    @Value(value="${database.host}")
    private String forcedDatabaseHost;
    @Value(value="${database.port}")
    private int forcedDatabasePort;
    @Value(value="${database.file}")
    private String forcedDatabaseFile;

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertyConfigInDev() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Bean
    public Provider<@NonNull BusinessVersion> currentVersionProvider() {
        return () -> ((PortaroVersion)this.portaroVersion()).getBusinessVersion();
    }

    @Bean
    public Provider<@NonNull BusinessVersion> licenceVersionProvider() {
        return this.initLicenceProvider().andThen(Licence::getLicenceVersion);
    }

    @Bean
    public Provider<@NonNull String> initRootSerialCodeProvider() {
        return this.initSimplifiedCustomSettingValueLoader().getProvider((SettingTypeId)SettingKeys.SERIAL_CODE, this.realRootDepartmentIdProvider()).throwingWhenNull();
    }

    @Bean
    public DbSpecifics dbSpecifics() {
        return switch (this.databaseProperties().getType()) {
            case "firebird" -> new DbSpecificsFirebird();
            case "postgresql" -> new DbSpecificsPostgresql();
            default -> throw new UnsupportedOperationException("Unsupported database type %s".formatted(this.databaseProperties().getType()));
        };
    }

    @Bean
    public DataSource initDataSource() {
        return DataSourceFactory.createDataSource((String)"portaro-init-pool", (DatabaseConnectionSettings)this.databaseProperties(), (ZoneId)((ZoneId)this.databaseColumnsTimeZoneProvider().get()), cfg -> cfg.setMaximumPoolSize(1));
    }

    @Bean
    public SimplifiedCustomSettingValueLoader initSimplifiedCustomSettingValueLoader() {
        return new JdbcSimplifiedCustomSettingValueLoader((JdbcOperations)new JdbcTemplate(this.initDataSource()), this.dbSpecifics());
    }

    @Bean
    public Provider<@NonNull Licence> initLicenceProvider() {
        LicenceKeyDecodingLicenceProvider provider = new LicenceKeyDecodingLicenceProvider((Supplier)this.initJwtLicenceKeyProvider(), this.licenceKeyDecoder());
        return provider.cached();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Bean
    public Provider<@NonNull String> initJwtLicenceKeyProvider() {
        @NonNull Provider fromIniProvider = this.initSimplifiedCustomSettingValueLoader().getProvider((SettingTypeId)SettingKeys.LICENCE_KEY, this.realRootDepartmentIdProvider()).throwingWhenNull();
        @NonNull LicenceKeyDecodingLicenceKeyExpiredPredicate keyExpired = new LicenceKeyDecodingLicenceKeyExpiredPredicate(this.licenceKeyDecoder());
        @NonNull ValidatingProvider validatingFromIniProvider = ValidatingProvider.invalidWhen((Provider)fromIniProvider, (Predicate)keyExpired, expiredJwt -> new LicenceKeyExpiredException());
        @NonNull LicenceServerFetchingLicenceKeyProvider fromLicenceServerProvider = new LicenceServerFetchingLicenceKeyProvider(this.rest(), this.initRootSerialCodeProvider(), this.initSimplifiedCustomSettingValueLoader().getProvider((SettingTypeId)SettingKeys.KPSYS_API_KEY, this.realRootDepartmentIdProvider()).throwingWhenNull());
        return new FallbackedProvider((Provider)validatingFromIniProvider, (Provider)fromLicenceServerProvider).fallbackOnException(IniNotSetException.class).fallbackOnException(LicenceKeyExpiredException.class);
    }

    @Bean
    public LicenceKeyDecoder licenceKeyDecoder() {
        return Auth0JwtLicenceKeyDecoder.ofInternalPublicKey();
    }

    @Bean
    public Provider<@NonNull Integer> realRootDepartmentIdProvider() {
        return IntegerValueDatabaseLoader.ofQuery((NamedParameterJdbcOperations)new NamedParameterJdbcTemplate(this.initDataSource()), (QueryFactory)this.queryFactory(), (String)"def_pujc", (String)"id_pujc", where -> where.isNull("fk_nadr")).cached();
    }

    @Bean
    public HttpFactory httpFactory() {
        HttpFactory bean = new HttpFactory((String)this.userAgentProvider().get());
        if (StringUtil.hasLength((String)this.httpProxyUrl)) {
            bean.withProxy(this.httpProxyUrl, this.httpProxyAuth, this.httpProxyUsername, this.httpProxyPassword, List.of(this.appserverUrl));
        }
        return bean;
    }

    @Bean
    public RestOperationsFactory restOperationsFactory() {
        return new RestOperationsFactory();
    }

    @Bean
    public TraceIdRepository traceIdRepository() {
        return new UuidMdcTraceIdRepository();
    }

    @Bean
    public String httpProxyUrl() {
        return this.httpProxyUrl;
    }

    @Bean
    public PortaroVersion portaroVersion() {
        return VcsBackedPortaroVersion.createFromGitVersionStrings((String)this.versionId, (String)this.commitAbbrev, (String)this.versionDateString, (String)this.versionBranch, (String)this.versionLastCommitMessage);
    }

    @Bean
    public Provider<@NonNull String> userAgentProvider() {
        return () -> CatalogConstants.PORTARO_USER_AGENT_TEMPLATE.withParameter("version", (Object)this.portaroVersion().getValue()).build();
    }

    @Bean
    public Appserver appserver() {
        return new Appserver(this.appserverUrl);
    }

    @Bean
    public AppserverPropertiesLoader appserverPropertiesLoader() {
        BasicMappingAppserverService mappingService = new BasicMappingAppserverService((AppserverService)new BasicAppserverService(this.appserver().getUrl(), this.rest(), this.xmlMapper()));
        return new AppserverAppserverPropertiesLoader(this.xmlMapper(), (MappingAppserverService)mappingService, this.appserverUrl);
    }

    @Bean
    public Provider<ZoneId> defaultTimeZoneProvider() {
        return StaticProvider.of((Object)CoreConstants.CZECH_TIME_ZONE_ID);
    }

    @Bean
    public Provider<ZoneId> databaseColumnsTimeZoneProvider() {
        return this.defaultTimeZoneProvider();
    }

    @Bean
    public Provider<AppserverProperties> appserverPropertiesProvider() {
        MultiTryingAppserverPropertiesLoader appserverPropertiesLoader = new MultiTryingAppserverPropertiesLoader(this.appserverPropertiesLoader(), this.startupAttemptsCount, this.startupAttemptsPeriod);
        Provider appserverPropertiesProvider = () -> this.lambda$appserverPropertiesProvider$4((AppserverPropertiesLoader)appserverPropertiesLoader);
        return appserverPropertiesProvider.cached();
    }

    @Bean
    public Provider<String> appserverPropertiesDatabaseDriverProvider() {
        return this.appserverPropertiesProvider().andThen(AppserverProperties::databaseDriver);
    }

    @Bean
    public Provider<String> appserverPropertiesDatabaseUrlProvider() {
        return this.appserverPropertiesProvider().andThen(AppserverProperties::databaseUrl);
    }

    @Bean
    public DatabaseProperties databaseProperties() {
        DatabaseProperties dbProperties = new ForceableConncetionDefinitionProvider((Supplier)this.appserverPropertiesDatabaseDriverProvider(), (Supplier)this.appserverPropertiesDatabaseUrlProvider()).withForcedType(StringUtil.notEmptyString((String)this.forcedDatabaseType)).withForcedHost(StringUtil.notEmptyString((String)this.forcedDatabaseHost)).withForcedPort(ObjectUtil.nullIfZero((Integer)this.forcedDatabasePort)).withForcedFile(StringUtil.notEmptyString((String)this.forcedDatabaseFile)).databaseProperties(this.databaseUsername, this.databasePassword);
        if (log.isInfoEnabled()) {
            log.info("Initializing Portaro {} - DB {}", (Object)this.portaroVersion().getHumanReadableString(), (Object)dbProperties.getUrl());
        }
        return dbProperties;
    }

    @Bean
    public QueryFactory queryFactory() {
        return QueryFactory.of((DatabaseConnectionSettings)this.databaseProperties());
    }

    @Bean
    public ObjectMapper objectMapper() {
        return ObjectMapperFactory.createGenericJsonMapper();
    }

    @Bean
    public ObjectMapper xmlMapper() {
        return ObjectMapperFactory.createGenericXmlMapper();
    }

    @Bean
    public RestOperations rest() {
        return this.restOperationsFactory().rest(this.httpClient(), (Supplier)this.traceIdRepository(), this.objectMapper(), this.xmlMapper());
    }

    @Bean
    public RestOperations fileDataRest() {
        return this.restOperationsFactory().rest(this.fileDataHttpClient(), (Supplier)this.traceIdRepository(), this.objectMapper(), this.xmlMapper());
    }

    @Bean
    public HttpClient httpClient() {
        return this.httpFactory().httpClientBuilder().build();
    }

    @Bean
    public HttpClient fileDataHttpClient() {
        return this.httpFactory().httpClientBuilder().build();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void logInitializationInfo() {
        if (log.isInfoEnabled()) {
            log.info("Portaro {} {}, started with version {} (available version is {})", new Object[]{this.portaroVersion().getHumanReadableString(), this.portaroVersion().getHumanReadableDetailString(), ((BusinessVersion)this.currentVersionProvider().get()).getValue(), ((BusinessVersion)this.licenceVersionProvider().get()).getValue()});
        }
    }

    private /* synthetic */ AppserverProperties lambda$appserverPropertiesProvider$4(AppserverPropertiesLoader appserverPropertiesLoader) {
        AppserverProperties appserverProperties = appserverPropertiesLoader.get();
        if (log.isInfoEnabled()) {
            log.info("Initializing Portaro {} - AS {} {}", new Object[]{this.portaroVersion().getHumanReadableString(), this.appserverUrl, appserverProperties.version()});
        }
        return appserverProperties;
    }
}

