/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.LabeledIdentified;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.filter.EqualsPredicate;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.DefaultProvider;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.database.InstantiingLabeledIdentifiableLoaderSpringDb;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.exemplar.ExemplarConstants;
import cz.kpsys.portaro.exemplar.ExemplarType;
import cz.kpsys.portaro.exemplar.account.Account;
import cz.kpsys.portaro.exemplar.account.AccountEntity;
import cz.kpsys.portaro.exemplar.account.EntityToAccountConverter;
import cz.kpsys.portaro.exemplar.acquisitionway.AcquisitionWay;
import cz.kpsys.portaro.exemplar.acquisitionway.AcquisitionWayEntity;
import cz.kpsys.portaro.exemplar.acquisitionway.AcquisitionWayLoader;
import cz.kpsys.portaro.exemplar.acquisitionway.CodebookDelegatingAcquisitionWayLoader;
import cz.kpsys.portaro.exemplar.acquisitionway.EntityToAcquisitionWayConverter;
import cz.kpsys.portaro.exemplar.customvalue.CustomValue;
import cz.kpsys.portaro.exemplar.exchangeset.EntityToExchangeExemplarSetConverter;
import cz.kpsys.portaro.exemplar.exchangeset.ExchangeExemplarSet;
import cz.kpsys.portaro.exemplar.exchangeset.ExchangeExemplarSetEntity;
import cz.kpsys.portaro.exemplar.exemplarstatus.CodebookDelegatingExemplarStatusLoader;
import cz.kpsys.portaro.exemplar.exemplarstatus.ExemplarStatus;
import cz.kpsys.portaro.exemplar.exemplarstatus.ExemplarStatusLoader;
import cz.kpsys.portaro.exemplar.exemplarstatus.SpringDbExemplarStatusLoader;
import cz.kpsys.portaro.exemplar.loancategory.CodebookDelegatingLoanCategoryLoader;
import cz.kpsys.portaro.exemplar.loancategory.LoanCategory;
import cz.kpsys.portaro.exemplar.loancategory.LoanCategoryLoader;
import cz.kpsys.portaro.exemplar.loancategory.SpringDbLoanCategoryLoader;
import cz.kpsys.portaro.exemplar.replacementway.ReplacementWay;
import cz.kpsys.portaro.exemplar.thematicgroup.CodebookDelegatingThematicGroupLoader;
import cz.kpsys.portaro.exemplar.thematicgroup.ThematicGroup;
import cz.kpsys.portaro.exemplar.thematicgroup.ThematicGroupEntity;
import cz.kpsys.portaro.exemplar.thematicgroup.ThematicGroupFromDtoConverter;
import cz.kpsys.portaro.exemplar.thematicgroup.ThematicGroupLoader;
import cz.kpsys.portaro.exemplar.volume.VolumePeriodicity;
import cz.kpsys.portaro.loan.LoanConstants;
import cz.kpsys.portaro.record.RecordConstants;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class ExemplarCodebookConfig {
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final LinkedHashMap<Predicate<String>, AllValuesProvider<? extends LabeledIdentified<?>>> allowedDatatypeToAllValuesProviderMap;
    @NonNull
    private final LinkedHashMap<Predicate<String>, AllValuesProvider<? extends LabeledIdentified<?>>> allDatatypeToAllValuesProviderMap;

    @Bean
    public ExemplarStatusLoader exemplarStatusLoader() {
        Codebook cachedCodebook = this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbExemplarStatusLoader(this.jdbcTemplate, this.queryFactory)).staticCached(ExemplarStatus.class.getSimpleName()).build();
        return new CodebookDelegatingExemplarStatusLoader(cachedCodebook, this.settingLoader.getDepartmentedProvider(SettingKeys.DEFAULT_STATUS), this.rootDepartmentProvider);
    }

    @Bean
    public Codebook<Account, String> accountLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(AccountEntity.class).convertedEachBy((Converter)new EntityToAccountConverter()).staticCached(Account.class.getSimpleName()).build();
    }

    @Bean
    public LoanCategoryLoader loanCategoryLoader() {
        Codebook cachedCodebook = this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbLoanCategoryLoader(this.jdbcTemplate, this.queryFactory)).staticCached(LoanCategory.class.getSimpleName()).build();
        return new CodebookDelegatingLoanCategoryLoader(cachedCodebook, this.settingLoader.getDepartmentedProvider(SettingKeys.DEFAULT_LOAN_CATEGORY), this.rootDepartmentProvider);
    }

    @Bean
    public AcquisitionWayLoader acquisitionWayLoader() {
        Codebook codebook = this.codebookLoaderBuilderFactory.create().providedByJpa(AcquisitionWayEntity.class, "order").convertedEachBy((Converter)new EntityToAcquisitionWayConverter()).staticCached(AcquisitionWay.class.getSimpleName()).build();
        Provider defaultAcquisitionWayIdDepartmentedProvider = DefaultProvider.byFirst((AllValuesProvider)codebook);
        return new CodebookDelegatingAcquisitionWayLoader(codebook, this.settingLoader.getDepartmentedProvider(SettingKeys.DEFAULT_ACQUISITION_WAY), defaultAcquisitionWayIdDepartmentedProvider);
    }

    @Bean
    public Codebook<CustomValue, String> customValueLoader() {
        InstantiingLabeledIdentifiableLoaderSpringDb loader = new InstantiingLabeledIdentifiableLoaderSpringDb(this.jdbcTemplate, this.queryFactory, CustomValue.class, "def_stavz", "id_stavz", "popis", "poradi");
        loader.setTrimName(true);
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)loader).staticCached(CustomValue.class.getSimpleName()).build();
    }

    @Bean
    public Codebook<ReplacementWay, String> replacementWayLoader() {
        InstantiingLabeledIdentifiableLoaderSpringDb loader = new InstantiingLabeledIdentifiableLoaderSpringDb(this.jdbcTemplate, this.queryFactory, ReplacementWay.class, "def_zpnahr", "kod", "popis", "kod");
        loader.setTrimName(true);
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)loader).staticCached(ReplacementWay.class.getSimpleName()).build();
    }

    @Bean
    public ThematicGroupLoader thematicGroupLoader() {
        Codebook codebook = this.codebookLoaderBuilderFactory.create().providedByJpa(ThematicGroupEntity.class, "order").convertedEachBy((Converter)new ThematicGroupFromDtoConverter()).staticCached(ThematicGroup.class.getSimpleName()).build();
        Provider defaultThematicGroupProvider = DefaultProvider.byFirst((AllValuesProvider)codebook);
        return new CodebookDelegatingThematicGroupLoader(codebook, defaultThematicGroupProvider, this.settingLoader.getDepartmentedProvider(SettingKeys.DEFAULT_THEMATIC_GROUP), this.rootDepartmentProvider);
    }

    @Bean
    public Codebook<ExchangeExemplarSet, Integer> exchangeExemplarSetLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(ExchangeExemplarSetEntity.class).convertedEachBy((Converter)new EntityToExchangeExemplarSetConverter()).staticCached(ExchangeExemplarSet.class.getSimpleName()).build();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerAcceptableValuesProviders() {
        this.allowedDatatypeToAllValuesProviderMap.put(new EqualsPredicate((Object)ExemplarConstants.Datatype.CUSTOM_VALUE.getName()), this.customValueLoader());
        this.allDatatypeToAllValuesProviderMap.put(new EqualsPredicate((Object)ExemplarConstants.Datatype.CUSTOM_VALUE.getName()), this.customValueLoader());
        this.allowedDatatypeToAllValuesProviderMap.put(new EqualsPredicate((Object)ExemplarConstants.Datatype.CUSTOM_VALUE_OLD.getName()), this.customValueLoader());
        this.allDatatypeToAllValuesProviderMap.put(new EqualsPredicate((Object)ExemplarConstants.Datatype.CUSTOM_VALUE_OLD.getName()), this.customValueLoader());
        this.allowedDatatypeToAllValuesProviderMap.put(new EqualsPredicate((Object)RecordConstants.Datatype.EXEMPLAR_STATUS.getName()), this.exemplarStatusLoader());
        this.allDatatypeToAllValuesProviderMap.put(new EqualsPredicate((Object)RecordConstants.Datatype.EXEMPLAR_STATUS.getName()), this.exemplarStatusLoader());
        this.allowedDatatypeToAllValuesProviderMap.put(new EqualsPredicate((Object)RecordConstants.Datatype.THEMATIC_GROUP.getName()), this.thematicGroupLoader());
        this.allDatatypeToAllValuesProviderMap.put(new EqualsPredicate((Object)RecordConstants.Datatype.THEMATIC_GROUP.getName()), this.thematicGroupLoader());
        this.allowedDatatypeToAllValuesProviderMap.put(new EqualsPredicate((Object)LoanConstants.Datatype.LOAN_CATEGORY.getName()), this.loanCategoryLoader());
        this.allDatatypeToAllValuesProviderMap.put(new EqualsPredicate((Object)LoanConstants.Datatype.LOAN_CATEGORY.getName()), this.loanCategoryLoader());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForStringId(Account.class, (ByIdLoadable)this.accountLoader()).registerForStringId(AcquisitionWay.class, (ByIdLoadable)this.acquisitionWayLoader()).registerForStringId(CustomValue.class, (ByIdLoadable)this.customValueLoader()).registerForIntegerId(ExchangeExemplarSet.class, (ByIdLoadable)this.exchangeExemplarSetLoader()).registerForIntegerId(ExemplarStatus.class, (ByIdLoadable)this.exemplarStatusLoader()).registerForIntegerId(ExemplarType.class, (ByIdLoadable)ExemplarType.CODEBOOK).registerForStringId(LoanCategory.class, (ByIdLoadable)this.loanCategoryLoader()).registerForStringId(ReplacementWay.class, (ByIdLoadable)this.replacementWayLoader()).registerForStringId(ThematicGroup.class, (ByIdLoadable)this.thematicGroupLoader()).registerForIntegerId(VolumePeriodicity.class, (ByIdLoadable)VolumePeriodicity.CODEBOOK);
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "converterRegisterer", "settingLoader", "rootDepartmentProvider", "codebookLoaderBuilderFactory", "allowedDatatypeToAllValuesProviderMap", "allDatatypeToAllValuesProviderMap"})
    @Generated
    public ExemplarCodebookConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull ConverterRegisterer converterRegisterer, @NonNull SettingLoader settingLoader, @NonNull Provider<Department> rootDepartmentProvider, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull LinkedHashMap<Predicate<String>, AllValuesProvider<? extends LabeledIdentified<?>>> allowedDatatypeToAllValuesProviderMap, @NonNull LinkedHashMap<Predicate<String>, AllValuesProvider<? extends LabeledIdentified<?>>> allDatatypeToAllValuesProviderMap) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(allowedDatatypeToAllValuesProviderMap, "allowedDatatypeToAllValuesProviderMap is marked non-null but is null");
        Objects.requireNonNull(allDatatypeToAllValuesProviderMap, "allDatatypeToAllValuesProviderMap is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.converterRegisterer = converterRegisterer;
        this.settingLoader = settingLoader;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.allowedDatatypeToAllValuesProviderMap = allowedDatatypeToAllValuesProviderMap;
        this.allDatatypeToAllValuesProviderMap = allDatatypeToAllValuesProviderMap;
    }
}

