/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.zaxxer.hikari.HikariDataSource;
import cz.kpsys.portaro.commons.logging.Logged;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.database.QueryFactoryDatabaseScriptCaller;
import cz.kpsys.portaro.databaseproperties.DataSourceFactory;
import cz.kpsys.portaro.databaseproperties.DatabaseConnectionSettings;
import cz.kpsys.portaro.databaseproperties.DatabaseProperties;
import cz.kpsys.portaro.sql.generator.DeleteQuery;
import cz.kpsys.portaro.sql.generator.Query;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import lombok.Generated;
import lombok.NonNull;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class DatafixBatchConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatafixBatchConfig.class);
    @NonNull
    private final DatabaseProperties dbUpdateDatabaseProperties;
    @NonNull
    private final Provider<ZoneId> databaseColumnsTimeZoneProvider;

    @Logged
    @Scheduled(initialDelay=5L, fixedDelay=99999999L, timeUnit=TimeUnit.MINUTES)
    @SchedulerLock(name="DatafixBatchConfig_deleteBots", lockAtLeastFor="PT10M", lockAtMostFor="PT20M")
    public void deleteBots() {
        try (HikariDataSource dataSource = DataSourceFactory.createDbUpdateDataSource((DatabaseConnectionSettings)this.dbUpdateDatabaseProperties, (ZoneId)((ZoneId)this.databaseColumnsTimeZoneProvider.get()), cfg -> {});){
            Instant olderThanOneHour = Instant.now().minus(Duration.ofHours(1L));
            new QueryFactoryDatabaseScriptCaller(new NamedParameterJdbcTemplate((DataSource)dataSource), this.getActionDeleteQuery(olderThanOneHour)).call();
            new QueryFactoryDatabaseScriptCaller(new NamedParameterJdbcTemplate((DataSource)dataSource), this.getSessionDeleteQuery(olderThanOneHour)).call();
        }
    }

    private Query getActionDeleteQuery(Instant olderThan) {
        DeleteQuery q = QueryFactory.of((DatabaseConnectionSettings)this.dbUpdateDatabaseProperties).newDeleteQuery();
        q.delete("opac_log_akce");
        q.where().in("fk_opac_log_sessions", sq -> {
            sq.select(new String[]{"id_session"});
            sq.from(new String[]{"opac_log_sessions"});
            sq.where().lt("cas_vytvoreni", (Object)olderThan).and().eq("je_bot", (Object)true);
        });
        return q;
    }

    private Query getSessionDeleteQuery(Instant olderThan) {
        DeleteQuery q = QueryFactory.of((DatabaseConnectionSettings)this.dbUpdateDatabaseProperties).newDeleteQuery();
        q.delete("opac_log_sessions");
        q.where().lt("cas_vytvoreni", (Object)olderThan).and().eq("je_bot", (Object)true);
        return q;
    }

    @ConstructorProperties(value={"dbUpdateDatabaseProperties", "databaseColumnsTimeZoneProvider"})
    @Generated
    public DatafixBatchConfig(@NonNull DatabaseProperties dbUpdateDatabaseProperties, @NonNull Provider<ZoneId> databaseColumnsTimeZoneProvider) {
        Objects.requireNonNull(dbUpdateDatabaseProperties, "dbUpdateDatabaseProperties is marked non-null but is null");
        Objects.requireNonNull(databaseColumnsTimeZoneProvider, "databaseColumnsTimeZoneProvider is marked non-null but is null");
        this.dbUpdateDatabaseProperties = dbUpdateDatabaseProperties;
        this.databaseColumnsTimeZoneProvider = databaseColumnsTimeZoneProvider;
    }
}

