/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.BasicUserAuthentication;
import cz.kpsys.portaro.auth.process.AuthoritiedSuccessAuthentication;
import cz.kpsys.portaro.auth.process.StaticSuccessAuthentication;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.cache.DynamicCache;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.logging.Logged;
import cz.kpsys.portaro.commons.object.FilteredList;
import cz.kpsys.portaro.commons.object.ProvidedProxiedList;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.SimpleTransferer;
import cz.kpsys.portaro.commons.object.Transferer;
import cz.kpsys.portaro.commons.object.filter.WhitelistObjectFilter;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.MultipleItemsSaver;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.ImageDownloader;
import cz.kpsys.portaro.file.cover.BatchCoverImporter;
import cz.kpsys.portaro.file.cover.CoverDownloader;
import cz.kpsys.portaro.file.cover.CoverLoader;
import cz.kpsys.portaro.file.cover.CoverLoaderCustomFileTemplateByFond;
import cz.kpsys.portaro.file.cover.CoverSearchManager;
import cz.kpsys.portaro.file.cover.CoverService;
import cz.kpsys.portaro.file.cover.CoversToSearchLoader;
import cz.kpsys.portaro.file.cover.CoversTransferService;
import cz.kpsys.portaro.file.cover.GoogleBooksCoverLoader;
import cz.kpsys.portaro.file.cover.MultiLoaderCoverLoader;
import cz.kpsys.portaro.file.cover.NamedCoverLoader;
import cz.kpsys.portaro.file.cover.NamesByFondMapCoverLoaderClasspathFile;
import cz.kpsys.portaro.file.cover.ObalkyKnihCoverLoader;
import cz.kpsys.portaro.file.cover.OpenLibraryCoverLoader;
import cz.kpsys.portaro.file.cover.SpringDbCoversToSearchLoader;
import cz.kpsys.portaro.file.cover.SpringDbUnfoundCoverDeleter;
import cz.kpsys.portaro.file.cover.SpringDbUnfoundCoverSaver;
import cz.kpsys.portaro.file.cover.UnfoundCoverDeleter;
import cz.kpsys.portaro.file.cover.UnfoundCoverSaver;
import cz.kpsys.portaro.file.custom.CustomFile;
import cz.kpsys.portaro.record.RichRecord;
import cz.kpsys.portaro.record.file.RecordWithAttachmentSaveCommand;
import cz.kpsys.portaro.record.file.RecordWithAttachmentSaverAppserver;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.User;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.client.RestOperations;

@Configuration
@Lazy
public class AttachmentConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttachmentConfig.class);
    @NonNull
    private final DmlAppserverService dmlAppserverService;
    @NonNull
    private final ByIdLoadable<CustomFile, String> hierarchyTraversingCustomFileLoader;
    @NonNull
    private final RestOperations rest;
    @NonNull
    private final RestOperations fileDataRest;
    @NonNull
    private final FileDataStreamer cachedFileThumbnailDataStreamer;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final Provider<Integer> portaroUserIdProvider;
    @NonNull
    private final Saver<IdentifiedFile> loadedIdentifiedFileSaver;
    @NonNull
    private final Deleter<IdentifiedFile> identifiedFileDeleter;
    @NonNull
    private final @NonNull Provider<@NonNull Department> rootDepartmentProvider;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final IdAndIdsLoadable<RichRecord, UUID> richRecordLoader;
    @NonNull
    private final IdAndIdsLoadable<RichRecord, UUID> nonDetailedRichRecordLoader;
    @NonNull
    private final DynamicCache<RichRecord> recordCache;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final Provider<User> portaroUserProvider;

    @Bean
    public CoverService coverService() {
        return new CoverService(this.cachedFileThumbnailDataStreamer, this.coverLoader(), this.allWebCoverLoader(), this.recordWithAttachmentSaver(), this.identifiedFileDeleter, () -> ((DynamicCache)this.recordCache).clear());
    }

    @Bean
    public CoverLoader coverLoader() {
        CoverLoaderCustomFileTemplateByFond customCoversLoader = new CoverLoaderCustomFileTemplateByFond(this.hierarchyTraversingCustomFileLoader, this.cachedFileThumbnailDataStreamer, "design", "default_cover_{fond}.png");
        NamesByFondMapCoverLoaderClasspathFile builtInCoversLoader = new NamesByFondMapCoverLoaderClasspathFile("resources/img/covers/{name}.png", this.settingLoader.getOnRootProvider(SettingKeys.BUILT_IN_COVERS_BY_FONDS), "book");
        this.cacheService.registerCleaner((CacheCleaner)builtInCoversLoader);
        MultiLoaderCoverLoader multiLoader = new MultiLoaderCoverLoader("LocalDatabase", new CoverLoader[]{customCoversLoader, builtInCoversLoader});
        multiLoader.setThrowExceptions(true);
        return multiLoader;
    }

    @Bean
    public CoverDownloader coverDownloader() {
        return new CoverDownloader(new ImageDownloader(this.fileDataRest), this.portaroUserIdProvider);
    }

    @Bean
    public List<? extends NamedCoverLoader> webCoverLoaders() {
        return new FilteredList(List.of(new ObalkyKnihCoverLoader(this.coverDownloader()), new OpenLibraryCoverLoader(this.coverDownloader()), new GoogleBooksCoverLoader(this.rest, this.coverDownloader())), (Predicate)new WhitelistObjectFilter((Collection)this.settingLoader.getOnRootProvidedList(SettingKeys.SERVICES), NamedCoverLoader::getServiceName));
    }

    @Bean
    public List<BatchCoverImporter> coverImporters() {
        List coverImporters = ListUtil.convert((Iterable)this.webCoverLoaders(), coverLoader -> new BatchCoverImporter(coverLoader, this.recordWithAttachmentSaver(), this.unfoundCoverSaver()));
        return new ProvidedProxiedList(() -> coverImporters);
    }

    @Bean
    public CoverLoader allWebCoverLoader() {
        MultiLoaderCoverLoader multiLoader = new MultiLoaderCoverLoader("AllWebCoverLoaders", this.webCoverLoaders());
        multiLoader.setThrowExceptions(false);
        return multiLoader;
    }

    @Bean
    public CoversToSearchLoader vyhledavaneObalkyDokumentuLoader() {
        return new SpringDbCoversToSearchLoader(this.jdbcTemplate, this.queryFactory, (AllByIdsLoadable)this.richRecordLoader, this.settingLoader.getOnRootProvidedList(SettingKeys.FORBIDDEN_RECORD_STATUSES));
    }

    @Bean
    public UnfoundCoverDeleter unfoundCoverDeleter() {
        return new SpringDbUnfoundCoverDeleter(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public CoverSearchManager coverSearchManager() {
        return new CoverSearchManager(this.coverImporters(), this.vyhledavaneObalkyDokumentuLoader(), this.unfoundCoverDeleter(), this.executorService);
    }

    @Logged
    @Scheduled(cron="0 0 20 * * *")
    public void startCoverSearchingCron() {
        this.authenticationHolder.authenticated((AuthoritiedSuccessAuthentication)StaticSuccessAuthentication.authenticatedForBackgroundJobs((User)((User)this.portaroUserProvider.get()), (Department)((Department)this.rootDepartmentProvider.get())), () -> this.coverSearchManager().startCoverSearching((Department)this.rootDepartmentProvider.get(), (BasicUserAuthentication)this.authenticationHolder.getCurrentAuth()));
    }

    @Bean
    public UnfoundCoverSaver unfoundCoverSaver() {
        return new SpringDbUnfoundCoverSaver(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public CoversTransferService coversTransferService() {
        return new CoversTransferService((Transferer)new SimpleTransferer(), new MultipleItemsSaver(this.recordWithAttachmentSaver(), true), this.portaroUserIdProvider);
    }

    @Bean
    public Saver<RecordWithAttachmentSaveCommand> recordWithAttachmentSaver() {
        return new RecordWithAttachmentSaverAppserver((ByIdLoadable)this.nonDetailedRichRecordLoader, this.loadedIdentifiedFileSaver, this.dmlAppserverService);
    }

    @ConstructorProperties(value={"dmlAppserverService", "hierarchyTraversingCustomFileLoader", "rest", "fileDataRest", "cachedFileThumbnailDataStreamer", "cacheService", "settingLoader", "portaroUserIdProvider", "loadedIdentifiedFileSaver", "identifiedFileDeleter", "rootDepartmentProvider", "jdbcTemplate", "queryFactory", "executorService", "richRecordLoader", "nonDetailedRichRecordLoader", "recordCache", "authenticationHolder", "portaroUserProvider"})
    @Generated
    public AttachmentConfig(@NonNull DmlAppserverService dmlAppserverService, @NonNull ByIdLoadable<CustomFile, String> hierarchyTraversingCustomFileLoader, @NonNull RestOperations rest, @NonNull RestOperations fileDataRest, @NonNull FileDataStreamer cachedFileThumbnailDataStreamer, @NonNull CacheService cacheService, @NonNull SettingLoader settingLoader, @NonNull Provider<Integer> portaroUserIdProvider, @NonNull Saver<IdentifiedFile> loadedIdentifiedFileSaver, @NonNull Deleter<IdentifiedFile> identifiedFileDeleter, @NonNull @NonNull Provider<@NonNull Department> rootDepartmentProvider, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull ExecutorService executorService, @NonNull IdAndIdsLoadable<RichRecord, UUID> richRecordLoader, @NonNull IdAndIdsLoadable<RichRecord, UUID> nonDetailedRichRecordLoader, @NonNull DynamicCache<RichRecord> recordCache, @NonNull AuthenticationHolder authenticationHolder, @NonNull Provider<User> portaroUserProvider) {
        Objects.requireNonNull(dmlAppserverService, "dmlAppserverService is marked non-null but is null");
        Objects.requireNonNull(hierarchyTraversingCustomFileLoader, "hierarchyTraversingCustomFileLoader is marked non-null but is null");
        Objects.requireNonNull(rest, "rest is marked non-null but is null");
        Objects.requireNonNull(fileDataRest, "fileDataRest is marked non-null but is null");
        Objects.requireNonNull(cachedFileThumbnailDataStreamer, "cachedFileThumbnailDataStreamer is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(portaroUserIdProvider, "portaroUserIdProvider is marked non-null but is null");
        Objects.requireNonNull(loadedIdentifiedFileSaver, "loadedIdentifiedFileSaver is marked non-null but is null");
        Objects.requireNonNull(identifiedFileDeleter, "identifiedFileDeleter is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(executorService, "executorService is marked non-null but is null");
        Objects.requireNonNull(richRecordLoader, "richRecordLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedRichRecordLoader, "nonDetailedRichRecordLoader is marked non-null but is null");
        Objects.requireNonNull(recordCache, "recordCache is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(portaroUserProvider, "portaroUserProvider is marked non-null but is null");
        this.dmlAppserverService = dmlAppserverService;
        this.hierarchyTraversingCustomFileLoader = hierarchyTraversingCustomFileLoader;
        this.rest = rest;
        this.fileDataRest = fileDataRest;
        this.cachedFileThumbnailDataStreamer = cachedFileThumbnailDataStreamer;
        this.cacheService = cacheService;
        this.settingLoader = settingLoader;
        this.portaroUserIdProvider = portaroUserIdProvider;
        this.loadedIdentifiedFileSaver = loadedIdentifiedFileSaver;
        this.identifiedFileDeleter = identifiedFileDeleter;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.executorService = executorService;
        this.richRecordLoader = richRecordLoader;
        this.nonDetailedRichRecordLoader = nonDetailedRichRecordLoader;
        this.recordCache = recordCache;
        this.authenticationHolder = authenticationHolder;
        this.portaroUserProvider = portaroUserProvider;
    }
}

