/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.alert.Alert;
import cz.kpsys.portaro.alert.AlertProvider;
import cz.kpsys.portaro.alert.CompositeAlertProvider;
import cz.kpsys.portaro.alert.NotEmptyValueCheckingAlertProvider;
import cz.kpsys.portaro.alert.ProvidedConditionCheckingAlertProvider;
import cz.kpsys.portaro.alert.SimpleAlert;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.StaticContextualDelegatingProvider;
import cz.kpsys.portaro.commons.localization.MultiText;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.licence.BusinessVersion;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.portaro.monitoring.health.AppserverHealthMonitor;
import cz.kpsys.portaro.setting.SettingLoader;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
public class AlertConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertConfig.class);
    @NonNull
    private final CompositeAlertProvider alertProvider;
    @NonNull
    private final AppserverHealthMonitor appserverHealthMonitor;
    @NonNull
    private final SettingLoader settingLoader;
    private final @NonNull Provider<@NullableNotBlank String> rootServerUrlProvider;
    private final @NonNull ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider;
    @NonNull
    private final @NonNull Provider<@NonNull Licence> licenceProvider;
    @NonNull
    private final @NonNull Provider<@NonNull BusinessVersion> currentVersionProvider;
    @NonNull
    private final @NonNull Provider<@NonNull BusinessVersion> licenceVersionProvider;
    @NonNull
    private final @NonNull Provider<@NonNull Department> realRootDepartmentProvider;

    @Bean
    public AlertProvider testingVersionCheckingAlerter() {
        return new ProvidedConditionCheckingAlertProvider(() -> ((Licence)this.licenceProvider.get()).isTesting(), (Alert)new SimpleAlert(Texts.ofNative((String)"Toto je pouze uk\u00e1zkov\u00e1/demo verze syst\u00e9mu Verbis, data nemusej\u00ed b\u00fdt skute\u010dn\u00e1 a aktu\u00e1ln\u00ed."), "DANGER"));
    }

    @Bean
    public AlertProvider licenceVersionCheckingAlerter() {
        return new ProvidedConditionCheckingAlertProvider(() -> !((BusinessVersion)this.licenceVersionProvider.get()).isAtLeast((BusinessVersion)this.currentVersionProvider.get()), (Alert)new SimpleAlert(Texts.ofNative((String)"Licence je vydan\u00e1 pro ni\u017e\u0161\u00ed verzi softwaru (%s) ne\u017e je tato (%s).".formatted(((BusinessVersion)this.licenceVersionProvider.get()).getValue(), ((BusinessVersion)this.currentVersionProvider.get()).getValue())), "DANGER"));
    }

    @Bean
    public AlertProvider serverUrlCheckingAlerter() {
        return new NotEmptyValueCheckingAlertProvider(this.rootServerUrlProvider, (Alert)new SimpleAlert(Texts.ofNative((String)"Nenastavena adresa serveru v nastaven\u00ed OPAC.URL, n\u011bkter\u00e9 funkce nemusej\u00ed pracovat spr\u00e1vn\u011b."), "DANGER"));
    }

    @Bean
    public AlertProvider appserverHealthCheckingAlerter() {
        return new ProvidedConditionCheckingAlertProvider(() -> !this.appserverHealthMonitor.isUp() && (Boolean)this.settingLoader.getOnRootProvider(SettingKeys.APPSERVER_ENABLED).get() != false, (Alert)new SimpleAlert(Texts.ofNative((String)"Aplika\u010dn\u00ed server je moment\u00e1ln\u011b nedostupn\u00fd, n\u011bkter\u00e9 funkce nemus\u00ed fungovat spr\u00e1vn\u011b"), "DANGER"));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Bean
    public AlertProvider licenceServerUrlCheckingAlerter() {
        @NullableNotBlank StaticContextualDelegatingProvider realRootDepartmentServerUrlProvider = new StaticContextualDelegatingProvider(this.serverUrlProvider, this.realRootDepartmentProvider);
        return new ProvidedConditionCheckingAlertProvider(() -> this.lambda$licenceServerUrlCheckingAlerter$3((Provider)realRootDepartmentServerUrlProvider), (Alert)new SimpleAlert((Text)MultiText.ofTexts((String)"Licence softwaru je vyd\u00e1na pro pou\u017eit\u00ed na adrese '{}', kter\u00e1 nesouhlas\u00ed s aktu\u00e1ln\u00ed '{}'.", (Text[])new Text[]{Texts.ofNativeOrEmpty((String)((Licence)this.licenceProvider.get()).getRootUrl()), Texts.ofNativeOrEmpty((String)((String)realRootDepartmentServerUrlProvider.get()))}), "DANGER"));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerAlerts() {
        this.alertProvider.withProvider(this.testingVersionCheckingAlerter());
        this.alertProvider.withProvider(this.licenceVersionCheckingAlerter());
        this.alertProvider.withProvider(this.serverUrlCheckingAlerter());
        this.alertProvider.withProvider(this.appserverHealthCheckingAlerter());
        this.alertProvider.withProvider(this.licenceServerUrlCheckingAlerter());
    }

    @ConstructorProperties(value={"alertProvider", "appserverHealthMonitor", "settingLoader", "rootServerUrlProvider", "serverUrlProvider", "licenceProvider", "currentVersionProvider", "licenceVersionProvider", "realRootDepartmentProvider"})
    @Generated
    public AlertConfig(@NonNull CompositeAlertProvider alertProvider, @NonNull AppserverHealthMonitor appserverHealthMonitor, @NonNull SettingLoader settingLoader, @NonNull Provider<@NullableNotBlank String> rootServerUrlProvider, @NonNull ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider, @NonNull @NonNull Provider<@NonNull Licence> licenceProvider, @NonNull @NonNull Provider<@NonNull BusinessVersion> currentVersionProvider, @NonNull @NonNull Provider<@NonNull BusinessVersion> licenceVersionProvider, @NonNull @NonNull Provider<@NonNull Department> realRootDepartmentProvider) {
        Objects.requireNonNull(alertProvider, "alertProvider is marked non-null but is null");
        Objects.requireNonNull(appserverHealthMonitor, "appserverHealthMonitor is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(rootServerUrlProvider, "rootServerUrlProvider is marked non-null but is null");
        Objects.requireNonNull(serverUrlProvider, "serverUrlProvider is marked non-null but is null");
        Objects.requireNonNull(licenceProvider, "licenceProvider is marked non-null but is null");
        Objects.requireNonNull(currentVersionProvider, "currentVersionProvider is marked non-null but is null");
        Objects.requireNonNull(licenceVersionProvider, "licenceVersionProvider is marked non-null but is null");
        Objects.requireNonNull(realRootDepartmentProvider, "realRootDepartmentProvider is marked non-null but is null");
        this.alertProvider = alertProvider;
        this.appserverHealthMonitor = appserverHealthMonitor;
        this.settingLoader = settingLoader;
        this.rootServerUrlProvider = rootServerUrlProvider;
        this.serverUrlProvider = serverUrlProvider;
        this.licenceProvider = licenceProvider;
        this.currentVersionProvider = currentVersionProvider;
        this.licenceVersionProvider = licenceVersionProvider;
        this.realRootDepartmentProvider = realRootDepartmentProvider;
    }

    private /* synthetic */ Boolean lambda$licenceServerUrlCheckingAlerter$3(Provider realRootDepartmentServerUrlProvider) {
        String iniServerUrl = (String)realRootDepartmentServerUrlProvider.get();
        String licenceServerUrl = ((Licence)this.licenceProvider.get()).getRootUrl();
        return iniServerUrl != null && licenceServerUrl != null && !iniServerUrl.equals(licenceServerUrl);
    }
}

