/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ro extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arab\u0103";
        final String metaValue_hy = "armean\u0103";
        final String metaValue_ban = "balinez\u0103";
        final String metaValue_bn = "bengalez\u0103";
        final String metaValue_bug = "buginez\u0103";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "copt\u0103";
        final String metaValue_ka = "georgian\u0103";
        final String metaValue_got = "gotic\u0103";
        final String metaValue_el = "greac\u0103";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "ebraic\u0103";
        final String metaValue_jv = "javanez\u0103";
        final String metaValue_ja = "japonez\u0103";
        final String metaValue_kaw = "kawi";
        final String metaValue_km = "khmer\u0103";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "coreean\u0103";
        final String metaValue_lo = "lao\u021bian\u0103";
        final String metaValue_la = "latin\u0103";
        final String metaValue_mak = "makasar";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongol\u0103";
        final String metaValue_my = "birman\u0103";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_osa = "osage";
        final String metaValue_phn = "fenician\u0103";
        final String metaValue_su = "sundanez\u0103";
        final String metaValue_syr = "siriac\u0103";
        final String metaValue_ta = "tamil\u0103";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalog";
        final String metaValue_th = "thailandez\u0103";
        final String metaValue_bo = "tibetan\u0103";
        final String metaValue_uga = "ugaritic\u0103";
        final String metaValue_vai = "vai";
        final String metaValue_peo = "persan\u0103 veche";
        final Object[][] data = new Object[][] {
            { "001", "Lume" },
            { "002", "Africa" },
            { "003", "America de Nord" },
            { "005", "America de Sud" },
            { "009", "Oceania" },
            { "011", "Africa Occidental\u0103" },
            { "013", "America Central\u0103" },
            { "014", "Africa Oriental\u0103" },
            { "015", "Africa Septentrional\u0103" },
            { "017", "Africa Central\u0103" },
            { "018", "Africa Meridional\u0103" },
            { "019", "Americi" },
            { "021", "America Septentrional\u0103" },
            { "029", "Caraibe" },
            { "030", "Asia Oriental\u0103" },
            { "034", "Asia Meridional\u0103" },
            { "035", "Asia de Sud-Est" },
            { "039", "Europa Meridional\u0103" },
            { "053", "Australasia" },
            { "054", "Melanezia" },
            { "057", "Regiunea Micronezia" },
            { "061", "Polinezia" },
            { "142", "Asia" },
            { "143", "Asia Central\u0103" },
            { "145", "Asia Occidental\u0103" },
            { "150", "Europa" },
            { "151", "Europa Oriental\u0103" },
            { "154", "Europa Septentrional\u0103" },
            { "155", "Europa Occidental\u0103" },
            { "202", "Africa Subsaharian\u0103" },
            { "419", "America Latin\u0103" },
            { "AC", "Insula Ascension" },
            { "AD", "Andorra" },
            { "AE", "Emiratele Arabe Unite" },
            { "AF", "Afganistan" },
            { "AG", "Antigua \u0219i Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "AS", "Samoa American\u0103" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Insulele \u00c5land" },
            { "AZ", "Azerbaidjan" },
            { "BA", "Bosnia \u0219i Her\u021begovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Insulele Caraibe Olandeze" },
            { "BR", "Brazilia" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Insula Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Insulele Cocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Republica Centrafrican\u0103" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Elve\u021bia" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Insulele Cook" },
            { "CL", "Chile" },
            { "CM", "Camerun" },
            { "CN", "China" },
            { "CO", "Columbia" },
            { "CP", "Insula Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Capul Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Insula Christmas" },
            { "CY", "Cipru" },
            { "CZ", "Cehia" },
            { "DE", "Germania" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Danemarca" },
            { "DM", "Dominica" },
            { "DO", "Republica Dominican\u0103" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta \u0219i Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egipt" },
            { "EH", "Sahara Occidental\u0103" },
            { "ER", "Eritreea" },
            { "ES", "Spania" },
            { "ET", "Etiopia" },
            { "EU", "Uniunea European\u0103" },
            { "EZ", "Zona euro" },
            { "FI", "Finlanda" },
            { "FJ", "Fiji" },
            { "FK", "Insulele Falkland" },
            { "FM", "Micronezia" },
            { "FO", "Insulele Feroe" },
            { "FR", "Fran\u021ba" },
            { "GA", "Gabon" },
            { "GB", "Regatul Unit" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guyana Francez\u0103" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlanda" },
            { "GM", "Gambia" },
            { "GN", "Guineea" },
            { "GP", "Guadelupa" },
            { "GQ", "Guineea Ecuatorial\u0103" },
            { "GR", "Grecia" },
            { "GS", "Georgia de Sud \u0219i Insulele Sandwich de Sud" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guineea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "R.A.S. Hong Kong, China" },
            { "HM", "Insula Heard \u0219i Insulele McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croa\u021bia" },
            { "HT", "Haiti" },
            { "HU", "Ungaria" },
            { "IC", "Insulele Canare" },
            { "ID", "Indonezia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Insula Man" },
            { "IN", "India" },
            { "IO", "Teritoriul Britanic din Oceanul Indian" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islanda" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Iordania" },
            { "JP", "Japonia" },
            { "KE", "Kenya" },
            { "KG", "K\u00e2rg\u00e2zstan" },
            { "KH", "Cambodgia" },
            { "KI", "Kiribati" },
            { "KM", "Comore" },
            { "KN", "Saint Kitts \u0219i Nevis" },
            { "KP", "Coreea de Nord" },
            { "KR", "Coreea de Sud" },
            { "KW", "Kuweit" },
            { "KY", "Insulele Cayman" },
            { "KZ", "Kazahstan" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Sf\u00e2nta Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Luxemburg" },
            { "LV", "Letonia" },
            { "LY", "Libia" },
            { "MA", "Maroc" },
            { "MC", "Monaco" },
            { "MD", "Republica Moldova" },
            { "ME", "Muntenegru" },
            { "MF", "Sf\u00e2ntul Martin" },
            { "MG", "Madagascar" },
            { "MH", "Insulele Marshall" },
            { "MK", "Macedonia de Nord" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "MO", "R.A.S. Macao, China" },
            { "MP", "Insulele Mariane de Nord" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldive" },
            { "MW", "Malawi" },
            { "MX", "Mexic" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambic" },
            { "NA", "Namibia" },
            { "NC", "Noua Caledonie" },
            { "NE", "Niger" },
            { "NF", "Insula Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "\u021a\u0103rile de Jos" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Noua Zeeland\u0103" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polinezia Francez\u0103" },
            { "PG", "Papua-Noua Guinee" },
            { "PH", "Filipine" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "PM", "Saint-Pierre \u0219i Miquelon" },
            { "PN", "Insulele Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Teritoriile Palestiniene" },
            { "PT", "Portugalia" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oceania Periferic\u0103" },
            { "RE", "R\u00e9union" },
            { "RO", "Rom\u00e2nia" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Rwanda" },
            { "SA", "Arabia Saudit\u0103" },
            { "SB", "Insulele Solomon" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Suedia" },
            { "SG", "Singapore" },
            { "SH", "Sf\u00e2nta Elena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard \u0219i Jan Mayen" },
            { "SK", "Slovacia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "Sudanul de Sud" },
            { "ST", "S\u00e3o Tom\u00e9 \u0219i Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint-Maarten" },
            { "SY", "Siria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Insulele Turks \u0219i Caicos" },
            { "TD", "Ciad" },
            { "TF", "Teritoriile Australe \u0219i Antarctice Franceze" },
            { "TG", "Togo" },
            { "TH", "Thailanda" },
            { "TJ", "Tadjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turcia" },
            { "TT", "Trinidad \u0219i Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ucraina" },
            { "UG", "Uganda" },
            { "UM", "Insulele \u00cendep\u0103rtate ale S.U.A." },
            { "UN", "Na\u021biunile Unite" },
            { "US", "Statele Unite ale Americii" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Statul Cet\u0103\u021bii Vaticanului" },
            { "VC", "Saint Vincent \u0219i Grenadinele" },
            { "VE", "Venezuela" },
            { "VG", "Insulele Virgine Britanice" },
            { "VI", "Insulele Virgine Americane" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis \u0219i Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudo-accente" },
            { "XB", "Pseudo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Africa de Sud" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Regiune necunoscut\u0103" },
            { "aa", "afar" },
            { "ab", "abhaz\u0103" },
            { "ae", "avestan\u0103" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amharic\u0103" },
            { "an", "aragonez\u0103" },
            { "ar", metaValue_ar },
            { "as", "asamez\u0103" },
            { "av", "avar\u0103" },
            { "ay", "aymara" },
            { "az", "azer\u0103" },
            { "ba", "ba\u0219kir\u0103" },
            { "be", "belarus\u0103" },
            { "bg", "bulgar\u0103" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "breton\u0103" },
            { "bs", "bosniac\u0103" },
            { "ca", "catalan\u0103" },
            { "ce", "cecen\u0103" },
            { "ch", "chamorro" },
            { "co", "corsican\u0103" },
            { "cr", "cree" },
            { "cs", "ceh\u0103" },
            { "cu", "slavon\u0103" },
            { "cv", "ciuva\u0219\u0103" },
            { "cy", "galez\u0103" },
            { "da", "danez\u0103" },
            { "de", "german\u0103" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "englez\u0103" },
            { "eo", "esperanto" },
            { "es", "spaniol\u0103" },
            { "et", "eston\u0103" },
            { "eu", "basc\u0103" },
            { "fa", "persan\u0103" },
            { "ff", "fulah" },
            { "fi", "finlandez\u0103" },
            { "fj", "fijian\u0103" },
            { "fo", "feroez\u0103" },
            { "fr", "francez\u0103" },
            { "fy", "frizon\u0103 occidental\u0103" },
            { "ga", "irlandez\u0103" },
            { "gd", "gaelic\u0103 sco\u021bian\u0103" },
            { "gl", "galician\u0103" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "croat\u0103" },
            { "ht", "haitian\u0103" },
            { "hu", "maghiar\u0103" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonezian\u0103" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yi din Sichuan" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "islandez\u0103" },
            { "it", "italian\u0103" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "congolez\u0103" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazah\u0103" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "ca\u0219mir\u0103" },
            { "ku", "kurd\u0103" },
            { "kv", "komi" },
            { "kw", "cornic\u0103" },
            { "ky", "k\u00e2rg\u00e2z\u0103" },
            { "la", metaValue_la },
            { "lb", "luxemburghez\u0103" },
            { "lg", "ganda" },
            { "li", "limburghez\u0103" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituanian\u0103" },
            { "lu", "luba-katanga" },
            { "lv", "leton\u0103" },
            { "mg", "malga\u0219\u0103" },
            { "mh", "marshallez\u0103" },
            { "mi", "maori" },
            { "mk", "macedonean\u0103" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malaez\u0103" },
            { "mt", "maltez\u0103" },
            { "my", metaValue_my },
            { "na", "nauru" },
            { "nb", "norvegian\u0103 bokm\u00e5l" },
            { "nd", "ndebele de nord" },
            { "ne", "nepalez\u0103" },
            { "ng", "ndonga" },
            { "nl", "neerlandez\u0103" },
            { "nn", "norvegian\u0103 nynorsk" },
            { "no", "norvegian\u0103" },
            { "nr", "ndebele de sud" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "occitan\u0103" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", "odia" },
            { "os", "oset\u0103" },
            { "pa", "punjabi" },
            { "pi", "pali" },
            { "pl", "polonez\u0103" },
            { "ps", "pa\u0219tun\u0103" },
            { "pt", "portughez\u0103" },
            { "qu", "quechua" },
            { "rm", "roman\u0219\u0103" },
            { "rn", "kirundi" },
            { "ro", "rom\u00e2n\u0103" },
            { "ru", "rus\u0103" },
            { "rw", "kinyarwanda" },
            { "sa", "sanscrit\u0103" },
            { "sc", "sardinian\u0103" },
            { "sd", "sindhi" },
            { "se", "sami de nord" },
            { "sg", "sango" },
            { "sh", "s\u00e2rbo-croat\u0103" },
            { "si", "singhalez\u0103" },
            { "sk", "slovac\u0103" },
            { "sl", "sloven\u0103" },
            { "sm", "samoan\u0103" },
            { "sn", "shona" },
            { "so", "somalez\u0103" },
            { "sq", "albanez\u0103" },
            { "sr", "s\u00e2rb\u0103" },
            { "ss", "swati" },
            { "st", "sesotho" },
            { "su", metaValue_su },
            { "sv", "suedez\u0103" },
            { "sw", "swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tadjic\u0103" },
            { "th", metaValue_th },
            { "ti", "tigrin\u0103" },
            { "tk", "turkmen\u0103" },
            { "tl", metaValue_tl },
            { "tn", "setswana" },
            { "to", "tongan\u0103" },
            { "tr", "turc\u0103" },
            { "ts", "tsonga" },
            { "tt", "t\u0103tar\u0103" },
            { "tw", "twi" },
            { "ty", "tahitian\u0103" },
            { "ug", "uigur\u0103" },
            { "uk", "ucrainean\u0103" },
            { "ur", "urdu" },
            { "uz", "uzbec\u0103" },
            { "ve", "venda" },
            { "vi", "vietnamez\u0103" },
            { "vo", "volapuk" },
            { "wa", "valon\u0103" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "idi\u0219" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "chinez\u0103" },
            { "zu", "zulu" },
            { "ace", "aceh" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adyghe" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "akkadian\u0103" },
            { "ale", "aleut\u0103" },
            { "alt", "altaic\u0103 meridional\u0103" },
            { "ang", "englez\u0103 veche" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aramaic\u0103" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "ars", "arab\u0103 najdi" },
            { "arw", "arawak" },
            { "asa", "asu" },
            { "ast", "asturian\u0103" },
            { "atj", "atikamekw" },
            { "awa", "awadhi" },
            { "bal", "baluchi" },
            { "ban", metaValue_ban },
            { "bas", "basaa" },
            { "bax", "bamun" },
            { "bbj", "ghomala" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bgc", "haryanvi" },
            { "bgn", "baluchi occidental\u0103" },
            { "bho", "bhojpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "buriat" },
            { "bug", metaValue_bug },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "carib" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuan\u0103" },
            { "cgg", "chiga" },
            { "chb", "chibcha" },
            { "chg", "chagatai" },
            { "chk", "chuukese" },
            { "chm", "mari" },
            { "chn", "jargon chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "cheyenne" },
            { "ckb", "kurd\u0103 central\u0103" },
            { "clc", "chilcotin" },
            { "cop", metaValue_cop },
            { "crg", "michif" },
            { "crh", "turc\u0103 crimeean\u0103" },
            { "crj", "cree de sud-est" },
            { "crk", "cree (Prerii)" },
            { "crl", "cree de nord-est" },
            { "crm", "cree (Moose)" },
            { "crr", "algonquian\u0103 Carolina" },
            { "crs", "creol\u0103 francez\u0103 seselwa" },
            { "csb", "ca\u0219ubian\u0103" },
            { "csw", "cree (Mla\u0219tini)" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "sorab\u0103 de jos" },
            { "dua", "duala" },
            { "dum", "neerlandez\u0103 medie" },
            { "dyo", "jola-fonyi" },
            { "dyu", "dyula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "egiptean\u0103 veche" },
            { "eka", "ekajuk" },
            { "elx", "elamit\u0103" },
            { "enm", "englez\u0103 medie" },
            { "ewo", "ewondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipinez\u0103" },
            { "fon", "fon" },
            { "frc", "francez\u0103 cajun" },
            { "frm", "francez\u0103 medie" },
            { "fro", "francez\u0103 veche" },
            { "frr", "frizon\u0103 nordic\u0103" },
            { "frs", "frizon\u0103 oriental\u0103" },
            { "fur", "friulan\u0103" },
            { "gaa", "ga" },
            { "gag", "g\u0103g\u0103uz\u0103" },
            { "gan", "chinez\u0103 gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gez", "geez" },
            { "gil", "gilbertin\u0103" },
            { "gmh", "german\u0103 \u00eenalt\u0103 medie" },
            { "goh", "german\u0103 \u00eenalt\u0103 veche" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "greac\u0103 veche" },
            { "gsw", "german\u0103 (Elve\u021bia)" },
            { "guz", "gusii" },
            { "gwi", "gwich\u02bcin" },
            { "hai", "haida" },
            { "hak", "chinez\u0103 hakka" },
            { "haw", "hawaiian\u0103" },
            { "hax", "haida de sud" },
            { "hil", "hiligaynon" },
            { "hit", "hitit\u0103" },
            { "hmn", "hmong" },
            { "hsb", "sorab\u0103 de sus" },
            { "hsn", "chinez\u0103 xiang" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut canadian\u0103 occidental\u0103" },
            { "ilo", "iloko" },
            { "inh", "ingu\u0219\u0103" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "iudeo-persan\u0103" },
            { "jrb", "iudeo-arab\u0103" },
            { "kaa", "karakalpak" },
            { "kab", "kabyle" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", metaValue_kaw },
            { "kbd", "kabardian" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kabuverdianu" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "kho", "khotanez\u0103" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permiak" },
            { "kok", "konkani" },
            { "kos", "kosrae" },
            { "kpe", "kpelle" },
            { "krc", "karaceai-balkar" },
            { "krl", "karelian\u0103" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "k\u00f6lsch" },
            { "kum", "kumyk" },
            { "kut", "kutenai" },
            { "kwk", "kwak\u02bcwala" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezghian" },
            { "lij", "ligurian\u0103" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lol", "mongo" },
            { "lou", "creol\u0103 (Louisiana)" },
            { "loz", "lozi" },
            { "lrc", "luri de nord" },
            { "lsm", "saamia" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "mad", "madurez\u0103" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", metaValue_mak },
            { "man", "mandingo" },
            { "mas", "masai" },
            { "mde", "maba" },
            { "mdf", "moksha" },
            { "mdr", "mandar" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "morisyen" },
            { "mga", "irlandez\u0103 medie" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta\u2019" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "manciurian\u0103" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "mai multe limbi" },
            { "mus", "creek" },
            { "mwl", "mirandez\u0103" },
            { "mwr", "marwari" },
            { "mye", "myene" },
            { "myv", "erzya" },
            { "mzn", "mazanderani" },
            { "nan", "chinez\u0103 min nan" },
            { "nap", "napolitan\u0103" },
            { "naq", "nama" },
            { "nds", "germana de jos" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niuean\u0103" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "non", "nordic\u0103 veche" },
            { "nqo", metaValue_nqo },
            { "nso", "sotho de nord" },
            { "nus", "nuer" },
            { "nwc", "newari clasic\u0103" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "ojb", "ojibwa de nord-vest" },
            { "ojc", "ojibwa central\u0103" },
            { "ojs", "oji-cree" },
            { "ojw", "ojibwa de vest" },
            { "oka", "okanagan" },
            { "osa", metaValue_osa },
            { "ota", "turc\u0103 otoman\u0103" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauan\u0103" },
            { "pcm", "pidgin nigerian" },
            { "peo", metaValue_peo },
            { "phn", metaValue_phn },
            { "pis", "pijin" },
            { "pon", "pohnpeian\u0103" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "prusac\u0103" },
            { "pro", "provensal\u0103 veche" },
            { "quc", "quich\u00e9" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotongan" },
            { "rhg", "rohingya" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rup", "arom\u00e2n\u0103" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "sakha" },
            { "sam", "aramaic\u0103 samaritean\u0103" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sicilian\u0103" },
            { "sco", "scots" },
            { "sdh", "kurd\u0103 de sud" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sel", "selkup" },
            { "ses", "koyraboro Senni" },
            { "sga", "irlandez\u0103 veche" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "shu", "arab\u0103 ciadian\u0103" },
            { "sid", "sidamo" },
            { "slh", "lushootseed de usd" },
            { "sma", "sami de sud" },
            { "smj", "sami lule" },
            { "smn", "sami inari" },
            { "sms", "sami skolt" },
            { "snk", "soninke" },
            { "sog", "sogdien" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", "saho" },
            { "str", "salish (Str\u00e2mtori)" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumerian\u0103" },
            { "swb", "comorez\u0103" },
            { "syc", "siriac\u0103 clasic\u0103" },
            { "syr", metaValue_syr },
            { "tce", "tutchone de sud" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigre" },
            { "tiv", "tiv" },
            { "tkl", "tokelau" },
            { "tlh", "klingonian\u0103" },
            { "tli", "tlingit" },
            { "tmh", "tamashek" },
            { "tog", "nyasa tonga" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "tsi", "tsimshian" },
            { "ttm", "tutchone de nord" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawaq" },
            { "tyv", "tuvan\u0103" },
            { "tzm", "tamazight din Atlasul Central" },
            { "udm", "udmurt" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "limb\u0103 necunoscut\u0103" },
            { "vai", metaValue_vai },
            { "vec", "venet\u0103" },
            { "vot", "votic\u0103" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaita" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "chinez\u0103 wu" },
            { "xal", "calmuc\u0103" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "yapez\u0103" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "cantonez\u0103" },
            { "zap", "zapotec\u0103" },
            { "zbl", "simboluri Bilss" },
            { "zen", "zenaga" },
            { "zgh", "tamazight standard marocan\u0103" },
            { "zun", "zuni" },
            { "zxx", "far\u0103 con\u021binut lingvistic" },
            { "zza", "zaza" },
            { "Adlm", "adlam" },
            { "Aghb", "albanez\u0103 caucazian\u0103" },
            { "Ahom", "ahom" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaaliq" },
            { "Armi", "aramaic\u0103 imperial\u0103" },
            { "Armn", metaValue_hy },
            { "Avst", "avestic\u0103" },
            { "Bali", metaValue_ban },
            { "Bamu", "bamum" },
            { "Bass", "bassa vah" },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Bhks", "bhaiksuki" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmanic\u0103" },
            { "Brai", "braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid\u0103" },
            { "Cakm", metaValue_ccp },
            { "Cans", "silabic\u0103 aborigen\u0103 canadian\u0103 unificat\u0103" },
            { "Cari", "carian\u0103" },
            { "Cham", "cham" },
            { "Cher", metaValue_chr },
            { "Chrs", "khorezmian\u0103" },
            { "Copt", metaValue_cop },
            { "Cpmn", "cipro-minoan\u0103" },
            { "Cprt", "cipriot\u0103" },
            { "Cyrl", "chirilic\u0103" },
            { "Cyrs", "chirilic\u0103 slavon\u0103 bisericeasc\u0103 veche" },
            { "Deva", "devanagari" },
            { "Diak", "dives akuru" },
            { "Dogr", "dogra" },
            { "Dsrt", "mormon\u0103" },
            { "Dupl", "stenografie duployan\u0103" },
            { "Egyd", "demotic\u0103 egiptean\u0103" },
            { "Egyh", "hieratic\u0103 egiptean\u0103" },
            { "Egyp", "hieroglife egiptene" },
            { "Elba", "elbasan" },
            { "Elym", "elimaic\u0103" },
            { "Ethi", "etiopian\u0103" },
            { "Geok", "georgian\u0103 bisericeasc\u0103" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolitic\u0103" },
            { "Gong", "gunjala gondi" },
            { "Gonm", "masaram gondi" },
            { "Goth", metaValue_got },
            { "Gran", "grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "hanb" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "simplificat\u0103" },
            { "Hant", "tradi\u021bional\u0103" },
            { "Hatr", "hatran\u0103" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "hieroglife anatoliene" },
            { "Hmng", "pahawh hmong" },
            { "Hmnp", "nyiakeng puachue hmong" },
            { "Hrkt", "silabic\u0103 japonez\u0103" },
            { "Hung", "maghiar\u0103 veche" },
            { "Inds", "indus" },
            { "Ital", "italic\u0103 veche" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Kawi", metaValue_kaw },
            { "Khar", "kharosthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "khojki" },
            { "Kits", "litere mici khitane" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "latin\u0103 Fraktur" },
            { "Latg", "latin\u0103 gaelic\u0103" },
            { "Latn", metaValue_la },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "linear\u0103 A" },
            { "Linb", "linear\u0103 B" },
            { "Lisu", "fraser" },
            { "Lyci", "lician\u0103" },
            { "Lydi", "lidian\u0103" },
            { "Mahj", "mahajani" },
            { "Maka", metaValue_mak },
            { "Mand", "mandean\u0103" },
            { "Mani", "maniheean\u0103" },
            { "Marc", "marchen" },
            { "Maya", "hieroglife maya" },
            { "Medf", "medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "meroitic\u0103 cursiv\u0103" },
            { "Mero", "meroitic\u0103" },
            { "Mlym", metaValue_ml },
            { "Modi", "modi" },
            { "Mong", metaValue_mn },
            { "Mroo", "mro" },
            { "Mtei", "meitei mayek" },
            { "Mult", "multani" },
            { "Mymr", metaValue_my },
            { "Nagm", "nag mundari" },
            { "Nand", "nandinagari" },
            { "Narb", "arab\u0103 veche din nord" },
            { "Nbat", "nabateean\u0103" },
            { "Newa", "newa" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "n\u00fcshu" },
            { "Ogam", "ogham" },
            { "Olck", "ol chiki" },
            { "Orkh", "orhon" },
            { "Orya", "oriya" },
            { "Osge", metaValue_osa },
            { "Osma", "osmanya" },
            { "Ougr", "uigur\u0103 veche" },
            { "Palm", "palmiren\u0103" },
            { "Pauc", "pau cin hau" },
            { "Perm", "permic\u0103 veche" },
            { "Phag", "phags-pa" },
            { "Phli", "pahlavi pentru inscrip\u021bii" },
            { "Phlp", "pahlavi pentru psaltire" },
            { "Phnx", metaValue_phn },
            { "Plrd", "pollard\u0103 fonetic\u0103" },
            { "Prti", "part\u0103 pentru inscrip\u021bii" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Runr", "runic\u0103" },
            { "Samr", "samaritean\u0103" },
            { "Sarb", "arab\u0103 veche din sud" },
            { "Saur", "saurashtra" },
            { "Sgnw", "scrierea simbolic\u0103" },
            { "Shaw", "sav\u0103" },
            { "Shrd", "sharad\u0103" },
            { "Sidd", "siddham" },
            { "Sind", "khudawadi" },
            { "Sinh", "singalez\u0103" },
            { "Sogd", "sogdian\u0103" },
            { "Sogo", "sogdian\u0103 veche" },
            { "Sora", "sora sompeng" },
            { "Soyo", "soyombo" },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syrj", "siriac\u0103 occidental\u0103" },
            { "Syrn", "siriac\u0103 oriental\u0103" },
            { "Tagb", "tagbanwa" },
            { "Takr", "takri" },
            { "Tale", "tai le" },
            { "Talu", "tai le nou\u0103" },
            { "Taml", metaValue_ta },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Tfng", "tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Tnsa", "tangsa" },
            { "Toto", "toto" },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Vith", "vithkuqi" },
            { "Wara", "varang kshiti" },
            { "Wcho", "wancho" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "cuneiform\u0103 sumero-akkadian\u0103" },
            { "Yezi", "yazidit\u0103" },
            { "Yiii", "yi" },
            { "Zanb", "Pia\u021ba Zanabazar" },
            { "Zinh", "mo\u0219tenit\u0103" },
            { "Zmth", "nota\u021bie matematic\u0103" },
            { "Zsye", "emoji" },
            { "Zsym", "simboluri" },
            { "Zxxx", "nescris\u0103" },
            { "Zyyy", "comun\u0103" },
            { "Zzzz", "scriere necunoscut\u0103" },
            { "de_CH", "german\u0103 standard (Elve\u021bia)" },
            { "es_ES", "spaniol\u0103 (Europa)" },
            { "fa_AF", "dari" },
            { "nl_BE", "flamand\u0103" },
            { "pt_PT", "portughez\u0103 (Europa)" },
            { "sw_CD", "swahili (R.D. Congo)" },
            { "%%1901", "ortografie german\u0103 tradi\u021bional\u0103" },
            { "%%1994", "ortografie resian\u0103 standardizat\u0103" },
            { "%%1996", "ortografie german\u0103 de la 1996" },
            { "ar_001", "arab\u0103 standard modern\u0103" },
            { "key.ca", "tip calendar" },
            { "key.cf", "Format moned\u0103" },
            { "key.co", "ordine de sortare" },
            { "key.cu", "moned\u0103" },
            { "key.hc", "ciclu orar (12 sau 24)" },
            { "key.lb", "stil de \u00eentrerupere a liniei" },
            { "key.ms", "sistem de unit\u0103\u021bi de m\u0103sur\u0103" },
            { "key.nu", "numere" },
            { "key.tz", "fus orar" },
            { "key.va", "variant\u0103 local\u0103" },
            { "nds_NL", "saxona de jos" },
            { "%%ALUKU", "dialect aluku" },
            { "%%BARLA", "grupul de dialecte barlavento al limbii kabuverdianu" },
            { "%%BISKE", "dialect San Giorgio/Bila" },
            { "%%BOONT", "boontling" },
            { "%%CORNU", "Cornu" },
            { "%%GALLO", "Gallo" },
            { "%%JAUER", "Jauer" },
            { "%%KKCOR", "ortografie comuna cornish" },
            { "%%KSCOR", "ortografie standard" },
            { "%%LIPAW", "dialect lipovaz din resian\u0103" },
            { "%%NEDIS", "dialect Natisone" },
            { "%%NJIVA", "dialect Gniva/Njiva" },
            { "%%NULIK", "volap\u00fck modern\u0103" },
            { "%%OSOJS", "dialect Oseacco/Osojane" },
            { "%%PEANO", "Peano" },
            { "%%POSIX", "informatic\u0103" },
            { "%%PUTER", "Puter" },
            { "%%RIGIK", "volap\u00fck clasic\u0103" },
            { "%%ROZAJ", "dialect resian" },
            { "%%RUMGR", "Rumgr" },
            { "%%SAAHO", "dialect saho" },
            { "%%SOLBA", "dialect Stolvizza/Solbica" },
            { "%%SOTAV", "grupul de dialecte sotavento al limbii kabuverdianu" },
            { "%%UCCOR", "ortografie unificat\u0103 cornish" },
            { "zh_Hans", "chinez\u0103 simplificat\u0103" },
            { "zh_Hant", "chinez\u0103 tradi\u021bional\u0103" },
            { "%%AO1990", "Acordul de ortografie a limbii portugheze de la 1990" },
            { "%%ARANES", "Aranes" },
            { "%%ASANTE", "Asante" },
            { "%%AUVERN", "Auvern" },
            { "%%CISAUP", "Cisaup" },
            { "%%CREISS", "Creiss" },
            { "%%DAJNKO", "alfabet dajnko" },
            { "%%EKAVSK", "s\u00e2rb\u0103 cu pronun\u021bie ekavian\u0103" },
            { "%%FONIPA", "alfabet fonetic interna\u021bional" },
            { "%%FONUPA", "alfabet fonetic uralic" },
            { "%%GASCON", "Gascon" },
            { "%%GRITAL", "Grital" },
            { "%%NDYUKA", "dialect ndyuka" },
            { "%%NICARD", "Nicard" },
            { "%%PAMAKA", "dialect pamaka" },
            { "%%PINYIN", "pinyin" },
            { "%%SCOUSE", "dialect scouse" },
            { "%%SIMPLE", "Simple" },
            { "%%TARASK", "ortografie taraskievica" },
            { "%%UCRCOR", "ortografie revizuit\u0103 unificat\u0103 cornish" },
            { "%%ULSTER", "Ulster" },
            { "%%UNIFON", "alfabet fonetic unifon" },
            { "%%ABL1943", "formularea ortografic\u0103 de la 1943" },
            { "%%AKUAPEM", "Akuapem" },
            { "%%ALALC97", "ALA-LC, edi\u021bia din 1997" },
            { "%%AREVELA", "armean\u0103 oriental\u0103" },
            { "%%AREVMDA", "armean\u0103 occidental\u0103" },
            { "%%ARKAIKA", "Arkaika" },
            { "%%BALANKA", "dialectul balanka al limbii anii" },
            { "%%BAUDDHA", "Bauddha" },
            { "%%BOHORIC", "alfabet Bohori\u010d" },
            { "%%EMODENG", "limba englez\u0103 modern\u0103 timpurie" },
            { "%%FONNAPA", "Fonnapa" },
            { "%%GRCLASS", "Grclass" },
            { "%%GRMISTR", "Grmistr" },
            { "%%HEPBURN", "hepburn" },
            { "%%ITIHASA", "Itihasa" },
            { "%%LAUKIKA", "Laukika" },
            { "%%LEMOSIN", "Lemosin" },
            { "%%METELKO", "alfabet metelko" },
            { "%%MONOTON", "monotonic\u0103" },
            { "%%PAHAWH2", "Pahawh2" },
            { "%%PAHAWH3", "Pahawh3" },
            { "%%PAHAWH4", "Pahawh4" },
            { "%%POLYTON", "politonic\u0103" },
            { "%%PROVENC", "Provenc" },
            { "%%REVISED", "ortografie revizuit\u0103" },
            { "%%SURSILV", "Sursilv" },
            { "%%SUTSILV", "Sutsilv" },
            { "%%VAIDIKA", "Vaidika" },
            { "%%1606NICT", "francez\u0103 medieval\u0103 t\u00e2rzie p\u00e2n\u0103 la 1606" },
            { "%%1694ACAD", "francez\u0103 modern\u0103 veche" },
            { "%%1959ACAD", "belarus\u0103 academic\u0103" },
            { "%%BAKU1926", "alfabet latin altaic unificat" },
            { "%%BASICENG", "Basiceng" },
            { "%%BISCAYAN", "Biscayan" },
            { "%%BORNHOLM", "Bornholm" },
            { "%%COLB1945", "Conven\u021bia ortografic\u0103 a limbii portugheze braziliene de la 1945" },
            { "%%FONKIRSH", "Fonkirsh" },
            { "%%FONXSAMP", "Fonxsamp" },
            { "%%HOGNORSK", "Hognorsk" },
            { "%%HSISTEMO", "Hsistemo" },
            { "%%IJEKAVSK", "s\u00e2rb\u0103 cu pronun\u021bie ijekavian\u0103" },
            { "%%IVANCHOV", "Ivanchov" },
            { "%%JYUTPING", "Jyutping" },
            { "%%KOCIEWIE", "Kociewie" },
            { "%%LENGADOC", "Lengadoc" },
            { "%%LUNA1918", "Luna1918" },
            { "%%NEWFOUND", "Newfound" },
            { "%%OXENDICT", "ortografia dic\u021bionarului Oxford de limb\u0103 englez\u0103" },
            { "%%PETR1708", "Petr1708" },
            { "%%SCOTLAND", "englez\u0103 standard sco\u021bian\u0103" },
            { "%%SPANGLIS", "Spanglis" },
            { "%%SURMIRAN", "Surmiran" },
            { "%%SYNNEJYL", "Synnejyl" },
            { "%%TONGYONG", "Tongyong" },
            { "%%TUNUMIIT", "Tunumiit" },
            { "%%VALENCIA", "valencian\u0103" },
            { "%%VALLADER", "Vallader" },
            { "%%VECDRUKA", "Vecdruka" },
            { "%%VIVARAUP", "Vivaraup" },
            { "%%WADEGILE", "Wade-Giles" },
            { "%%XSISTEMO", "Xsistemo" },
            { "type.ca.roc", "calendarul Republicii Chineze" },
            { "type.co.eor", "regulile europene de sortare" },
            { "type.hc.h11", "sistem cu 12 ore (0\u201311)" },
            { "type.hc.h12", "sistem cu 12 ore (1\u201312)" },
            { "type.hc.h23", "sistem cu 24 de ore (0\u201323)" },
            { "type.hc.h24", "sistem cu 24 de ore (1\u201324)" },
            { "type.m0.bgn", "transliterare BGN SUA" },
            { "type.nu.ahom", "cifre ahom" },
            { "type.nu.arab", "cifre indo-arabe" },
            { "type.nu.armn", "numerale armene\u0219ti" },
            { "type.nu.bali", "cifre balineze" },
            { "type.nu.beng", "cifre bengaleze" },
            { "type.nu.brah", "cifre brahmi" },
            { "type.nu.cakm", "cifre chakma" },
            { "type.nu.cham", "cifre cham" },
            { "type.nu.cyrl", "cifre chirilice" },
            { "type.nu.deva", "cifre devanagari" },
            { "type.nu.diak", "cifre dives akuru" },
            { "type.nu.ethi", "numerale etiopiene" },
            { "type.nu.geor", "numerale georgiene" },
            { "type.nu.gong", "cifre gunjala gondi" },
            { "type.nu.gonm", "cifre masaram gondi" },
            { "type.nu.grek", "numerale grece\u0219ti" },
            { "type.nu.gujr", "cifre gujarati" },
            { "type.nu.guru", "cifre gurmukhi" },
            { "type.nu.hans", "numerale chineze\u0219ti simplificate" },
            { "type.nu.hant", "numerale chineze\u0219ti tradi\u021bionale" },
            { "type.nu.hebr", "numerale ebraice" },
            { "type.nu.hmng", "cifre pahawh hmong" },
            { "type.nu.hmnp", "cifre nyiakeng puachue hmong" },
            { "type.nu.java", "cifre javaneze" },
            { "type.nu.jpan", "numerale japoneze" },
            { "type.nu.kali", "cifre kayah li" },
            { "type.nu.kawi", "cifre kawi" },
            { "type.nu.khmr", "cifre khmere" },
            { "type.nu.knda", "cifre kannada" },
            { "type.nu.lana", "cifre tai tham hora" },
            { "type.nu.laoo", "cifre lao\u021biene" },
            { "type.nu.latn", "cifre occidentale" },
            { "type.nu.lepc", "cifre lepcha" },
            { "type.nu.limb", "cifre limbu" },
            { "type.nu.mlym", "cifre malayalam" },
            { "type.nu.modi", "cifre modi" },
            { "type.nu.mong", "Cifre mongole" },
            { "type.nu.mroo", "cifre mro" },
            { "type.nu.mtei", "cifre meetei mayek" },
            { "type.nu.mymr", "cifre birmaneze" },
            { "type.nu.nagm", "cifre nag mundari" },
            { "type.nu.nkoo", "cifre n\u2019ko" },
            { "type.nu.olck", "cifre ol chiki" },
            { "type.nu.orya", "cifre oriya" },
            { "type.nu.osma", "cifre osmanya" },
            { "type.nu.rohg", "cifre hanifi rohingya" },
            { "type.nu.saur", "cifre saurashtra" },
            { "type.nu.shrd", "cifre sharada" },
            { "type.nu.sind", "cifre khudawadi" },
            { "type.nu.sinh", "cifre sinhala lith" },
            { "type.nu.sora", "cifre sora sompeng" },
            { "type.nu.sund", "cifre sundaneze" },
            { "type.nu.takr", "cifre takri" },
            { "type.nu.talu", "cifre tai lue noi" },
            { "type.nu.taml", "numerale tradi\u021bionale tamile" },
            { "type.nu.telu", "cifre telugu" },
            { "type.nu.thai", "cifre thailandeze" },
            { "type.nu.tibt", "cifre tibetane" },
            { "type.nu.tirh", "cifre tirhuta" },
            { "type.nu.tnsa", "cifre tangsa" },
            { "type.nu.vaii", "cifre vai" },
            { "type.nu.wara", "cifre warang citi" },
            { "type.nu.wcho", "cifre wancho" },
            { "type.ca.dangi", "calendar dangi" },
            { "type.co.ducet", "ordine de sortare Unicode implicit\u0103" },
            { "type.co.emoji", "ordine de sortare a emojiurilor" },
            { "type.lb.loose", "stil liber de \u00eentrerupere a liniei" },
            { "type.nu.roman", "numerale romane" },
            { "type.ca.coptic", "calendar copt" },
            { "type.ca.hebrew", "calendar ebraic" },
            { "type.ca.indian", "calendar na\u021bional indian" },
            { "type.co.compat", "ordine de sortare anterioar\u0103, pentru compatibilitate" },
            { "type.co.pinyin", "ordine de sortare pinyin" },
            { "type.co.search", "c\u0103utare cu scop general" },
            { "type.co.stroke", "ordine de sortare dup\u0103 trasare" },
            { "type.co.unihan", "ordine de sortare dup\u0103 radical \u0219i trasare" },
            { "type.co.zhuyin", "ordine de sortare zhuyin" },
            { "type.d0.fwidth", "Cu l\u0103\u021bime \u00eentreag\u0103" },
            { "type.d0.hwidth", "Cu jum\u0103tate de l\u0103\u021bime" },
            { "type.lb.normal", "stil normal de \u00eentrerupere a liniei" },
            { "type.lb.strict", "stil strict de \u00eentrerupere a liniei" },
            { "type.m0.ungegn", "transliterare GEGN ONU" },
            { "type.ms.metric", "sistemul metric" },
            { "type.nu.native", "cifre native" },
            { "type.ca.chinese", "calendar chinezesc" },
            { "type.ca.islamic", "calendarul hegirei" },
            { "type.ca.iso8601", "calendar ISO-8601" },
            { "type.ca.persian", "calendar persan" },
            { "type.cf.account", "Format moned\u0103 contabilitate" },
            { "type.co.big5han", "ordine de sortare a chinezei tradi\u021bionale - Big5" },
            { "type.d0.npinyin", "Numeric" },
            { "type.nu.arabext", "cifre indo-arabe extinse" },
            { "type.nu.armnlow", "numerale armene\u0219ti cu minuscule" },
            { "type.nu.finance", "Sistemul numeric financiar" },
            { "type.nu.greklow", "numerale grece\u0219ti cu minuscule" },
            { "type.nu.hanidec", "numerale zecimale chineze\u0219ti" },
            { "type.nu.hansfin", "numerale financiare chineze\u0219ti simplificate" },
            { "type.nu.hantfin", "numerale financiare chineze\u0219ti tradi\u021bionale" },
            { "type.nu.jpanfin", "numerale financiare japoneze" },
            { "type.nu.mathdbl", "cifre matematice cu dou\u0103 linii" },
            { "type.nu.tamldec", "cifre tamile" },
            { "type.ca.buddhist", "calendar budist" },
            { "type.ca.ethiopic", "calendar etiopian" },
            { "type.ca.japanese", "calendar japonez" },
            { "type.cf.standard", "Format moned\u0103 standard" },
            { "type.co.phonetic", "ordine de sortare fonetic\u0103" },
            { "type.co.reformed", "ordine de sortare reformat\u0103" },
            { "type.co.searchjl", "C\u0103uta\u021bi \u00een func\u021bie de consoana ini\u021bial\u0103 hangul" },
            { "type.co.standard", "ordine de sortare standard" },
            { "type.ms.uksystem", "sistemul imperial de unit\u0103\u021bi de m\u0103sur\u0103" },
            { "type.ms.ussystem", "sistemul american de unit\u0103\u021bi de m\u0103sur\u0103" },
            { "type.nu.fullwide", "cifre cu l\u0103\u021bimea \u00eentreag\u0103" },
            { "type.nu.lanatham", "cifre tai tham tham" },
            { "type.nu.mathbold", "cifre matematice aldine" },
            { "type.nu.mathmono", "cifre matematice cu un singur spa\u021biu" },
            { "type.nu.mathsanb", "cifre matematice aldine sans serif" },
            { "type.nu.mathsans", "cifre matematice sans serif" },
            { "type.nu.mymrshan", "cifre birmaneze shan" },
            { "type.nu.mymrtlng", "cifre birmaneze tai laing" },
            { "type.nu.romanlow", "numerale romane cu minuscule" },
            { "type.ca.gregorian", "calendar gregorian" },
            { "type.co.gb2312han", "ordine de sortare a chinezei simplificate - GB2312" },
            { "type.co.phonebook", "ordine de sortare dup\u0103 cartea de telefon" },
            { "type.co.dictionary", "ordine de sortare a dic\u021bionarului" },
            { "type.co.traditional", "ordine de sortare tradi\u021bional\u0103" },
            { "type.nu.traditional", "Numere tradi\u021bionale" },
            { "type.ca.islamic-civil", "calendarul hegirei (tabular, civil)" },
            { "type.ca.islamic-umalqura", "calendarul hegirei (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "calendar etiopian amete alem" },
        };
        return data;
    }
}
