/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.modules;

import cz.kpsys.portaro.commons.convert.PrefixRemovingStringToEConverter;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.export.CompositeExportDescriptorLoader;
import cz.kpsys.portaro.export.ExportDescriptorLoader;
import cz.kpsys.portaro.export.Exporter;
import cz.kpsys.portaro.export.ExporterResolver;
import cz.kpsys.portaro.export.StaticExportDescriptorLoader;
import cz.kpsys.portaro.file.export.TemplateFilesExporter;
import cz.kpsys.portaro.template.BasicTemplateDescriptor;
import cz.kpsys.portaro.template.TemplateDescriptor;
import cz.kpsys.portaro.template.TemplateDescriptorLoader;
import cz.kpsys.portaro.template.TemplateEngine;
import cz.kpsys.portaro.template.TemplateLoadingExportDescriptorLoader;
import cz.kpsys.portaro.template.Templates;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ExporterConfig {
    @NonNull
    private final TemplateEngine templateEngine;
    @NonNull
    private final TemplateDescriptorLoader templateDescriptorLoader;
    @NonNull
    private final FileDataStreamer fileDataStreamer;

    @Bean
    public ExporterResolver exporterResolver() {
        ExporterResolver bean = new ExporterResolver();
        Function<String, Exporter> printFilesExporterByPathLoader = templatePath -> new TemplateFilesExporter("files.html", (TemplateDescriptor)BasicTemplateDescriptor.parse((String)templatePath), this.templateEngine, this.fileDataStreamer);
        bean.addFactory("files-print:", (Function)new PrefixRemovingStringToEConverter("files-print:", printFilesExporterByPathLoader));
        return bean;
    }

    @Bean
    public TemplateLoadingExportDescriptorLoader templateLoadingExportDescriptorLoader() {
        return new TemplateLoadingExportDescriptorLoader(this.templateDescriptorLoader).registerTemplated(List.of("files", "html", "print"), "files-print:", Templates.TEMPLATE_FILES_PRINT.getType());
    }

    @Bean
    public StaticExportDescriptorLoader staticExportDescriptorLoader() {
        return new StaticExportDescriptorLoader();
    }

    @Bean
    public CompositeExportDescriptorLoader exportDescriptorLoader() {
        return new CompositeExportDescriptorLoader().with((ExportDescriptorLoader)this.templateLoadingExportDescriptorLoader()).with((ExportDescriptorLoader)this.staticExportDescriptorLoader());
    }

    @ConstructorProperties(value={"templateEngine", "templateDescriptorLoader", "fileDataStreamer"})
    @Generated
    public ExporterConfig(@NonNull TemplateEngine templateEngine, @NonNull TemplateDescriptorLoader templateDescriptorLoader, @NonNull FileDataStreamer fileDataStreamer) {
        Objects.requireNonNull(templateEngine, "templateEngine is marked non-null but is null");
        Objects.requireNonNull(templateDescriptorLoader, "templateDescriptorLoader is marked non-null but is null");
        Objects.requireNonNull(fileDataStreamer, "fileDataStreamer is marked non-null but is null");
        this.templateEngine = templateEngine;
        this.templateDescriptorLoader = templateDescriptorLoader;
        this.fileDataStreamer = fileDataStreamer;
    }
}

