/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.commons.cache.FallbackableCompositeCacheManager;
import cz.kpsys.portaro.commons.contextual.CompositeAllValuesContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.FilteredAndSortedAllValuesContextualProvider;
import cz.kpsys.portaro.commons.convert.ListToModifiedListConverter;
import cz.kpsys.portaro.commons.date.StringToDateRangeConverter;
import cz.kpsys.portaro.commons.date.TimezonedStringToDatetimeRangeConverter;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.CompositeAddableAllValuesProvider;
import cz.kpsys.portaro.commons.object.ConvertingAllValuesProvider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.config.ZServerConfig;
import cz.kpsys.portaro.datatype.DatatypedAcceptableValuesRegistry;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.hierarchy.HierarchyLoader;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RecordConstants;
import cz.kpsys.portaro.record.RecordFactory;
import cz.kpsys.portaro.record.datasource.Datasource;
import cz.kpsys.portaro.record.detail.appservermarc.MarcXmlToDetailConverterImpl;
import cz.kpsys.portaro.record.detail.convert.MarcXmlToDetailConverter;
import cz.kpsys.portaro.record.edit.FieldTypesByFondLoader;
import cz.kpsys.portaro.record.fond.BestSuitableFondResolver;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.record.sec.CurrentAuthFondsLoader;
import cz.kpsys.portaro.search.CoreSearchParams;
import cz.kpsys.portaro.search.RangePaging;
import cz.kpsys.portaro.search.Search;
import cz.kpsys.portaro.search.factory.SearchFactory;
import cz.kpsys.portaro.search.factory.SearchFactoryCaching;
import cz.kpsys.portaro.search.factory.SearchFactoryResolver;
import cz.kpsys.portaro.search.field.QueryFieldsBySearchFieldLoader;
import cz.kpsys.portaro.search.field.SearchField;
import cz.kpsys.portaro.search.restriction.Restriction;
import cz.kpsys.portaro.search.z.ParametersConvertingZServerService;
import cz.kpsys.portaro.search.z.RestrictionToZServerQueryConverter;
import cz.kpsys.portaro.search.z.SpringDbZServerLoader;
import cz.kpsys.portaro.search.z.ZServer;
import cz.kpsys.portaro.search.z.ZServerConstants;
import cz.kpsys.portaro.search.z.ZServerDatasource;
import cz.kpsys.portaro.search.z.ZServerQueryBuilder;
import cz.kpsys.portaro.search.z.ZServerQueryFieldLoaderInMemory;
import cz.kpsys.portaro.search.z.ZServerService;
import cz.kpsys.portaro.search.z.ZServerServiceAppserver;
import cz.kpsys.portaro.search.z.ZServerToZServerDatasetConverter;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class ZServerConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZServerConfig.class);
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final ByIdLoadable<Fond, Integer> fondLoader;
    @NonNull
    private final AllValuesProvider<Fond> enabledFondsProvider;
    @NonNull
    private final DatatypedAcceptableValuesRegistry allDatatypeToAllValuesProviderMap;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final FieldTypesByFondLoader fieldTypesByFondLoader;
    @NonNull
    private final RecordFactory recordFactory;
    @NonNull
    private final HierarchyLoader<Department> departmentAccessor;
    @NonNull
    private final Function<Fond, List<Fond>> enabledIncludableFondsExpander;
    @NonNull
    private final Function<String, List<Fond>> subkindToEnabledFondsExpander;
    @NonNull
    private final CurrentAuthFondsLoader currentAuthShowableFondsLoader;
    @NonNull
    private final FallbackableCompositeCacheManager cacheManager;
    @NonNull
    private final Saver<Record, Record> externalRecordRepository;
    @NonNull
    private final CompositeAddableAllValuesProvider<Datasource> allDatasetsProvider;
    @NonNull
    private final CompositeAllValuesContextualProvider<Department, Datasource> allowedDatasetsProvider;
    @NonNull
    private final CurrentAuthFondsLoader currentAuthEditableFondsLoader;
    @NonNull
    private final SearchFactoryResolver searchFactoryResolver;
    @NonNull
    private final BestSuitableFondResolver bestSuitableFondResolver;
    @NonNull
    private final @NonNull Converter<@NonNull String, @NonNull Instant> recordFieldStringToInstantConverter;
    @NonNull
    private final StringToDateRangeConverter recordFieldStringToDateRangeConverter;
    @NonNull
    private final TimezonedStringToDatetimeRangeConverter recordFieldStringToDatetimeRangeConverter;

    @Bean
    public Codebook<ZServer, Integer> zServerLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbZServerLoader(this.jdbcTemplate, this.queryFactory, this.fondLoader, this.enabledFondsProvider)).staticCached(ZServer.class.getSimpleName()).build();
    }

    @Bean
    public ContextualProvider<Department, List<ZServer>> allowedZServersDepartmentedProvider() {
        return new FilteredAndSortedAllValuesContextualProvider((AllValuesProvider)this.zServerLoader(), this.settingLoader.getDepartmentedProvider(SettingKeys.ENABLED_ZSERVERS)).withConditionallyShowAll(this.settingLoader.getDepartmentedProvider(SettingKeys.SHOW_ALL_ZSERVERS));
    }

    @Bean
    public AllValuesProvider<ZServerDatasource> allZServerDatasetsProvider() {
        return ConvertingAllValuesProvider.byItemConverter((AllValuesProvider)this.zServerLoader(), (Converter)new ZServerToZServerDatasetConverter());
    }

    @Bean
    public ContextualProvider<Department, List<ZServerDatasource>> allowedZServerDatasetsProvider() {
        return this.allowedZServersDepartmentedProvider().andThen(arg_0 -> ((ListToModifiedListConverter)new ListToModifiedListConverter((Converter)new ZServerToZServerDatasetConverter())).convert(arg_0));
    }

    @Bean
    public ZServerService zServerService() {
        ZServerServiceAppserver pureService = new ZServerServiceAppserver(this.mappingAppserver, (ByIdLoadable)this.zServerLoader(), new ZServerQueryBuilder(this.restrictionToZServerQueryConverter()), (MarcXmlToDetailConverter)new MarcXmlToDetailConverterImpl(true, this.fieldTypesByFondLoader, this.recordFieldStringToInstantConverter, this.recordFieldStringToDateRangeConverter, this.recordFieldStringToDatetimeRangeConverter, this.fondLoader), this.bestSuitableFondResolver);
        return new ParametersConvertingZServerService((ZServerService)pureService).withExpandingParam(CoreSearchParams.SUBKIND, RecordConstants.SearchParams.FOND, this.subkindToEnabledFondsExpander).withExpandingParam(RecordConstants.SearchParams.ROOT_FOND, RecordConstants.SearchParams.FOND, this.enabledIncludableFondsExpander);
    }

    @Bean
    public SearchFactory<RangePaging> zServerSearchFactory() {
        1 zServerSearchFactory = new /* Unavailable Anonymous Inner Class!! */;
        CaffeineCacheManager zServerSearchCaching = new CaffeineCacheManager(new String[]{"search"});
        zServerSearchCaching.setCaffeine(Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).removalListener((key, value, cause) -> {
            if (cause != RemovalCause.REPLACED) {
                ((Search)Objects.requireNonNull(value)).close();
            }
        }));
        this.cacheManager.addCacheManager((CacheManager)zServerSearchCaching);
        Cache searchCache = Objects.requireNonNull(this.cacheManager.getCache("search"));
        return new SearchFactoryCaching(searchCache, (SearchFactory)zServerSearchFactory);
    }

    @Bean
    public Converter<Restriction<? extends SearchField>, String> restrictionToZServerQueryConverter() {
        return new RestrictionToZServerQueryConverter((QueryFieldsBySearchFieldLoader)new ZServerQueryFieldLoaderInMemory());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerModule() {
        this.allDatatypeToAllValuesProviderMap.registerEquals(ZServerConstants.Datatype.Z_SERVER, (AllValuesProvider)this.zServerLoader());
        this.converterRegisterer.registerForIntegerId(ZServer.class, (ByIdLoadable)this.zServerLoader());
        this.searchFactoryResolver.with(this.zServerSearchFactory(), Integer.valueOf(2000));
        this.allDatasetsProvider.withProvider(this.allZServerDatasetsProvider());
        this.allowedDatasetsProvider.add(this.allowedZServerDatasetsProvider());
    }

    @ConstructorProperties(value={"codebookLoaderBuilderFactory", "jdbcTemplate", "queryFactory", "converterRegisterer", "settingLoader", "fondLoader", "enabledFondsProvider", "allDatatypeToAllValuesProviderMap", "mappingAppserver", "fieldTypesByFondLoader", "recordFactory", "departmentAccessor", "enabledIncludableFondsExpander", "subkindToEnabledFondsExpander", "currentAuthShowableFondsLoader", "cacheManager", "externalRecordRepository", "allDatasetsProvider", "allowedDatasetsProvider", "currentAuthEditableFondsLoader", "searchFactoryResolver", "bestSuitableFondResolver", "recordFieldStringToInstantConverter", "recordFieldStringToDateRangeConverter", "recordFieldStringToDatetimeRangeConverter"})
    @Generated
    public ZServerConfig(@NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull ConverterRegisterer converterRegisterer, @NonNull SettingLoader settingLoader, @NonNull ByIdLoadable<Fond, Integer> fondLoader, @NonNull AllValuesProvider<Fond> enabledFondsProvider, @NonNull DatatypedAcceptableValuesRegistry allDatatypeToAllValuesProviderMap, @NonNull MappingAppserverService mappingAppserver, @NonNull FieldTypesByFondLoader fieldTypesByFondLoader, @NonNull RecordFactory recordFactory, @NonNull HierarchyLoader<Department> departmentAccessor, @NonNull Function<Fond, List<Fond>> enabledIncludableFondsExpander, @NonNull Function<String, List<Fond>> subkindToEnabledFondsExpander, @NonNull CurrentAuthFondsLoader currentAuthShowableFondsLoader, @NonNull FallbackableCompositeCacheManager cacheManager, @NonNull Saver<Record, Record> externalRecordRepository, @NonNull CompositeAddableAllValuesProvider<Datasource> allDatasetsProvider, @NonNull CompositeAllValuesContextualProvider<Department, Datasource> allowedDatasetsProvider, @NonNull CurrentAuthFondsLoader currentAuthEditableFondsLoader, @NonNull SearchFactoryResolver searchFactoryResolver, @NonNull BestSuitableFondResolver bestSuitableFondResolver, @NonNull @NonNull Converter<@NonNull String, @NonNull Instant> recordFieldStringToInstantConverter, @NonNull StringToDateRangeConverter recordFieldStringToDateRangeConverter, @NonNull TimezonedStringToDatetimeRangeConverter recordFieldStringToDatetimeRangeConverter) {
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        Objects.requireNonNull(enabledFondsProvider, "enabledFondsProvider is marked non-null but is null");
        Objects.requireNonNull(allDatatypeToAllValuesProviderMap, "allDatatypeToAllValuesProviderMap is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(fieldTypesByFondLoader, "fieldTypesByFondLoader is marked non-null but is null");
        Objects.requireNonNull(recordFactory, "recordFactory is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(enabledIncludableFondsExpander, "enabledIncludableFondsExpander is marked non-null but is null");
        Objects.requireNonNull(subkindToEnabledFondsExpander, "subkindToEnabledFondsExpander is marked non-null but is null");
        Objects.requireNonNull(currentAuthShowableFondsLoader, "currentAuthShowableFondsLoader is marked non-null but is null");
        Objects.requireNonNull(cacheManager, "cacheManager is marked non-null but is null");
        Objects.requireNonNull(externalRecordRepository, "externalRecordRepository is marked non-null but is null");
        Objects.requireNonNull(allDatasetsProvider, "allDatasetsProvider is marked non-null but is null");
        Objects.requireNonNull(allowedDatasetsProvider, "allowedDatasetsProvider is marked non-null but is null");
        Objects.requireNonNull(currentAuthEditableFondsLoader, "currentAuthEditableFondsLoader is marked non-null but is null");
        Objects.requireNonNull(searchFactoryResolver, "searchFactoryResolver is marked non-null but is null");
        Objects.requireNonNull(bestSuitableFondResolver, "bestSuitableFondResolver is marked non-null but is null");
        Objects.requireNonNull(recordFieldStringToInstantConverter, "recordFieldStringToInstantConverter is marked non-null but is null");
        Objects.requireNonNull(recordFieldStringToDateRangeConverter, "recordFieldStringToDateRangeConverter is marked non-null but is null");
        Objects.requireNonNull(recordFieldStringToDatetimeRangeConverter, "recordFieldStringToDatetimeRangeConverter is marked non-null but is null");
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.converterRegisterer = converterRegisterer;
        this.settingLoader = settingLoader;
        this.fondLoader = fondLoader;
        this.enabledFondsProvider = enabledFondsProvider;
        this.allDatatypeToAllValuesProviderMap = allDatatypeToAllValuesProviderMap;
        this.mappingAppserver = mappingAppserver;
        this.fieldTypesByFondLoader = fieldTypesByFondLoader;
        this.recordFactory = recordFactory;
        this.departmentAccessor = departmentAccessor;
        this.enabledIncludableFondsExpander = enabledIncludableFondsExpander;
        this.subkindToEnabledFondsExpander = subkindToEnabledFondsExpander;
        this.currentAuthShowableFondsLoader = currentAuthShowableFondsLoader;
        this.cacheManager = cacheManager;
        this.externalRecordRepository = externalRecordRepository;
        this.allDatasetsProvider = allDatasetsProvider;
        this.allowedDatasetsProvider = allowedDatasetsProvider;
        this.currentAuthEditableFondsLoader = currentAuthEditableFondsLoader;
        this.searchFactoryResolver = searchFactoryResolver;
        this.bestSuitableFondResolver = bestSuitableFondResolver;
        this.recordFieldStringToInstantConverter = recordFieldStringToInstantConverter;
        this.recordFieldStringToDateRangeConverter = recordFieldStringToDateRangeConverter;
        this.recordFieldStringToDatetimeRangeConverter = recordFieldStringToDatetimeRangeConverter;
    }
}

