/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.thymeleaf.spring6.ISpringTemplateEngine;
import org.thymeleaf.spring6.SpringTemplateEngine;
import org.thymeleaf.spring6.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.spring6.view.ThymeleafViewResolver;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
public class WebDbSchedulerConfig {
    @NonNull
    private final ApplicationContext applicationContext;

    @Bean
    public ThymeleafViewResolver thymeleafViewResolver() {
        ThymeleafViewResolver resolver = new ThymeleafViewResolver();
        resolver.setCache(true);
        resolver.setTemplateEngine((ISpringTemplateEngine)this.thymeleafTemplateEngine());
        resolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resolver.setContentType("text/html;charset=UTF-8");
        resolver.setAlwaysProcessRedirectAndForward(false);
        resolver.setViewNames(new String[]{"db-scheduler-ui/*"});
        resolver.setOrder(11);
        return resolver;
    }

    @Bean
    public SpringTemplateEngine thymeleafTemplateEngine() {
        SpringTemplateEngine engine = new SpringTemplateEngine();
        engine.addTemplateResolver((ITemplateResolver)this.thymeleafTemplateResolver());
        return engine;
    }

    @Bean
    public SpringResourceTemplateResolver thymeleafTemplateResolver() {
        SpringResourceTemplateResolver resolver = new SpringResourceTemplateResolver();
        resolver.setApplicationContext(this.applicationContext);
        resolver.setPrefix("classpath:/templates/");
        resolver.setSuffix(".html");
        resolver.setTemplateMode(TemplateMode.HTML);
        resolver.setCacheable(true);
        resolver.setCheckExistence(true);
        return resolver;
    }

    @ConstructorProperties(value={"applicationContext"})
    @Generated
    public WebDbSchedulerConfig(@NonNull ApplicationContext applicationContext) {
        Objects.requireNonNull(applicationContext, "applicationContext is marked non-null but is null");
        this.applicationContext = applicationContext;
    }
}

