/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.core.type.TypeReference;
import cz.kpsys.portaro.action.ActionSaver;
import cz.kpsys.portaro.auth.context.AuthenticatedContextualFunction;
import cz.kpsys.portaro.auth.context.AuthenticatedContextualProvider;
import cz.kpsys.portaro.auth.context.TypedAuthenticatedContextualObjectModifier;
import cz.kpsys.portaro.autocomplete.AutocompleteByGroupLoader;
import cz.kpsys.portaro.autocomplete.AutocompleteByGroupLoaderDispatcher;
import cz.kpsys.portaro.autocomplete.AutocompleteLoader;
import cz.kpsys.portaro.commons.contextual.CompositeListContextualFunction;
import cz.kpsys.portaro.commons.contextual.ContextualFunction;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.SameTypeSettableProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.AllProvidingRepository;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.InJsonTokenSingleValueRepository;
import cz.kpsys.portaro.commons.object.repo.Repository;
import cz.kpsys.portaro.commons.object.repo.SingleValueRepository;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.datatype.ScalarDatatype;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.SystemInstitution;
import cz.kpsys.portaro.exemplar.exemplarstatus.ExemplarStatus;
import cz.kpsys.portaro.export.ExportDescriptorLoader;
import cz.kpsys.portaro.licence.FeatureEnabledProvider;
import cz.kpsys.portaro.licence.FeatureManager;
import cz.kpsys.portaro.object.PhraseAutocompleteByGroupLoader;
import cz.kpsys.portaro.object.PhraseEntityLoader;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RecordSettingKeys;
import cz.kpsys.portaro.record.RecordStatus;
import cz.kpsys.portaro.record.datasource.Datasource;
import cz.kpsys.portaro.record.fond.ContextualFondedProvider;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.search.DefaultGettableAndSettableSearchParams;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.MapToMapSearchParamsConverter;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.Paging;
import cz.kpsys.portaro.search.RangePaging;
import cz.kpsys.portaro.search.Search;
import cz.kpsys.portaro.search.facet.FacetType;
import cz.kpsys.portaro.search.facet.FacetTypeCreator;
import cz.kpsys.portaro.search.facet.FacetTypeUpdater;
import cz.kpsys.portaro.search.factory.SearchFactoryResolver;
import cz.kpsys.portaro.search.factory.VelocitySearcherFactory;
import cz.kpsys.portaro.search.factory.VelocitySearcherImpl;
import cz.kpsys.portaro.search.field.SearchField;
import cz.kpsys.portaro.search.keywords.SearchedKeywordsAutocompleteLoader;
import cz.kpsys.portaro.search.keywords.SearchedKeywordsLoader;
import cz.kpsys.portaro.search.keywords.SearchedKeywordsSaver;
import cz.kpsys.portaro.search.params.ParamsModifier;
import cz.kpsys.portaro.search.restriction.Restriction;
import cz.kpsys.portaro.search.view.CompositeSearchFormFactory;
import cz.kpsys.portaro.search.view.SearchFormFactory;
import cz.kpsys.portaro.search.view.SearchTextResolver;
import cz.kpsys.portaro.search.view.SearchViewFactory;
import cz.kpsys.portaro.search.view.ViewableSearchField;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.FondedValues;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sorting.SortingItem;
import cz.kpsys.portaro.view.ViewableItemsConverter;
import cz.kpsys.portaro.view.web.rest.AutocompleteApiController;
import cz.kpsys.portaro.view.web.rest.FacetTypeApiController;
import cz.kpsys.portaro.view.web.rest.FacetTypeCreationRequest;
import cz.kpsys.portaro.view.web.rest.QueryConversionApiController;
import cz.kpsys.portaro.view.web.rest.search.SearchApiController;
import cz.kpsys.portaro.view.web.rest.search.SearchFormApiController;
import cz.kpsys.portaro.view.web.rest.search.SearchHistoryApiController;
import cz.kpsys.portaro.view.web.rss.RssController;
import cz.kpsys.portaro.web.page.ModelAndPageViewFactory;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.Range;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class SearchViewConfig {
    @NonNull
    private final @NonNull Provider<@NonNull String> publicContextPath;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final FeatureManager featureManager;
    @NonNull
    private final Translator<Department> translator;
    private final @NonNull ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider;
    @NonNull
    private final @NonNull ContextualProvider<Department, @NonNull List<Datasource>> allowedDatasetsProvider;
    @NonNull
    private final AllValuesProvider<Fond> readerShowableDocumentFondsProvider;
    @NonNull
    private final AllByIdsLoadable<Record, UUID> nonDetailedDocumentLoader;
    @NonNull
    private final Repository<Search<? extends MapBackedParams, ?, ? extends Paging>, UUID> searchRepository;
    @NonNull
    private final @NonNull ContextualProvider<Department, @NonNull FondedValues<@NonNull List<SortingItem>>> departmentedFondedRecordSearchSortingsLoader;
    @NonNull
    private final AllValuesProvider<SortingItem> authoritySearchSortingLoader;
    @NonNull
    private final AllValuesProvider<SortingItem> exemplarSearchSortingLoader;
    @NonNull
    private final AllValuesProvider<SortingItem> matchSearchSortingLoader;
    @NonNull
    private final @NonNull SameTypeSettableProvider<@NonNull Integer> documentDefaultPageSizeProvider;
    @NonNull
    private final AllProvidingRepository<Search<MapBackedParams, ?, ? extends Paging>, UUID> searchHistory;
    @NonNull
    private final PageSearchLoader<MapBackedParams, UUID, RangePaging> newestDocumentsLoader;
    @NonNull
    private final @NonNull ContextualProvider<Department, @NonNull SystemInstitution> systemInstitutionProvider;
    @NonNull
    private final SearchedKeywordsLoader searchedKeywordsLoader;
    @NonNull
    private final Converter<Restriction<? extends SearchField>, String> restrictionToLuceneQueryConverter;
    @NonNull
    private final Converter<Restriction<? extends SearchField>, String> restrictionToZServerQueryConverter;
    @NonNull
    private final PhraseEntityLoader phraseEntityLoader;
    @NonNull
    private final SearchFactoryResolver searchFactoryResolver;
    @NonNull
    private final ActionSaver actionSaver;
    @NonNull
    private final ViewableItemsConverter viewableItemsConverter;
    @NonNull
    private final CompositeSearchFormFactory searchFormFactory;
    @NonNull
    private final SearchTextResolver searchTitleResolver;
    @NonNull
    private final SearchTextResolver searchSubtitleResolver;
    @NonNull
    private final Codebook<FacetType, Integer> facetTypeLoader;
    @NonNull
    private final ByIdLoadable<RecordStatus, Integer> recordStatusLoader;
    @NonNull
    private final ByIdLoadable<ExemplarStatus, Integer> exemplarStatusLoader;
    @NonNull
    private final ExportDescriptorLoader exportDescriptorLoader;
    @NonNull
    private final SearchedKeywordsSaver searchedKeywordsSaver;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final AuthenticatedContextualFunction<SearchField, Department, ViewableSearchField> departmentedSearchFieldToViewableSearchFieldConverter;
    @NonNull
    private final MapToMapSearchParamsConverter mapToMapSearchParamsConverter;
    @NonNull
    private final ModelAndPageViewFactory modelAndPageViewFactory;
    @NonNull
    private final ContextualProvider<Department, Range<Integer>> documentYearExtremeRangeProvider;
    @NonNull
    private final AuthenticatedContextualProvider<Department, List<ViewableSearchField>> viewableSearchFieldsProvider;
    @NonNull
    private final ParamsModifier<DefaultGettableAndSettableSearchParams> fondRelatedParamsExpander;
    @NonNull
    private final FacetTypeCreator facetTypeCreator;
    @NonNull
    private final FacetTypeUpdater facetTypeUpdater;
    @NonNull
    private final ByIdLoadable<ScalarDatatype, String> fallbackingScalarDatatypeLoader;

    @Bean
    public AutocompleteApiController autocompleteApiController() {
        AutocompleteByGroupLoaderDispatcher autocompleteByGroupLoader = new AutocompleteByGroupLoaderDispatcher().withByGroupLoader("FRZ", (AutocompleteByGroupLoader)new PhraseAutocompleteByGroupLoader(this.phraseEntityLoader).caseInsensitive()).withLoader("searched-terms", (AutocompleteLoader)new SearchedKeywordsAutocompleteLoader(this.searchedKeywordsLoader)).withStaticStringValues("prefix-university-degrees", new String[]{"Bc.", "BcA.", "DiS.", "dr.", "Ing.", "Ing. arch.", "JUDr.", "MDDr.", "MgA.", "Mgr.", "MUDr.", "MVDr.", "Ph.", "PharmDr.", "PhDr.", "RNDr.", "Th.", "ThDr.", "ThLic."}).withStaticStringValues("suffix-university-degrees", new String[]{"DiS.", "doc.", "dr.", "DSc.", "Ph.", "prof.", "Th.", "Ph.D.", "Th.D.", "CSc.", "DrSc.", "PaedDr.", "PhMr."});
        return new AutocompleteApiController((AutocompleteByGroupLoader)autocompleteByGroupLoader);
    }

    @Bean
    public FacetTypeApiController facetTypeController() {
        return new FacetTypeApiController(this.facetTypeLoader, this.facetTypeCreator, this.facetTypeUpdater, this.fallbackingScalarDatatypeLoader);
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<FacetTypeCreationRequest> facetTypeRequestDefaulter() {
        return new FacetTypeCreationRequest.FacetTypeRequestDefaulter(this.facetTypeLoader);
    }

    @Bean
    public SearchApiController searchApiController() {
        return new SearchApiController(this.actionSaver, this.searchFactoryResolver, this.publicContextPath, this.searchRepository, (Provider)this.documentDefaultPageSizeProvider, this.searchViewFactory(), this.searchHistory, this.searchedKeywordsSaver, this.pagingParamsRepository());
    }

    @Bean
    public QueryConversionApiController queryConversionApiController() {
        return new QueryConversionApiController(this.restrictionToLuceneQueryConverter, this.restrictionToZServerQueryConverter);
    }

    @Bean
    public SearchHistoryApiController searchHistoryApiController() {
        return new SearchHistoryApiController(this.translator, (AllValuesProvider)this.searchHistory, this.searchTitleResolver, this.publicContextPath, this.departmentedSearchFieldToViewableSearchFieldConverter);
    }

    @Bean
    public SearchFormApiController searchFormApiController() {
        return new SearchFormApiController(this.viewableSearchFieldsProvider, this.settingLoader.getOnRootProvider(SettingKeys.BASIC_MODE_SEARCH_FIELDS_COUNT), (Provider)new FeatureEnabledProvider(this.featureManager, "search-parameters-history"));
    }

    @Bean
    public RssController rssController() {
        return new RssController(this.newestDocumentsLoader, this.settingLoader.getOnRootProvidedList(RecordSettingKeys.FORBIDDEN_RECORDS), this.settingLoader.getOnRootProvidedList(RecordSettingKeys.FORBIDDEN_RECORD_STATUSES), this.settingLoader.getOnRootProvidedList(RecordSettingKeys.NEWS_EXEMPLAR_STATUSES), this.recordStatusLoader, this.exemplarStatusLoader, this.readerShowableDocumentFondsProvider, this.nonDetailedDocumentLoader, this.systemInstitutionProvider, this.serverUrlProvider.throwingWhenNull(), this.modelAndPageViewFactory);
    }

    @Bean
    public SearchViewFactory searchViewFactory() {
        return new SearchViewFactory(this.viewableItemsConverter, (ContextualFunction)CompositeListContextualFunction.ofDistinctResultItems((ContextualFunction)new ContextualFondedProvider(this.departmentedFondedRecordSearchSortingsLoader, department -> this.authoritySearchSortingLoader.getAll())), this.exemplarSearchSortingLoader, this.matchSearchSortingLoader, this.settingLoader.getDepartmentedProvider(SettingKeys.DEFAULT_EXPANDED_FACETS), this.serverUrlProvider.throwingWhenNull(), this.allowedDatasetsProvider, this.settingLoader.getDepartmentedProvider(RecordSettingKeys.CYRILLIC_ENABLED), this.searchTitleResolver, this.searchSubtitleResolver, this.exportDescriptorLoader, (SearchFormFactory)this.searchFormFactory, this.securityManager, this.documentYearExtremeRangeProvider, this.fondRelatedParamsExpander, this.pagingParamsRepository());
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public VelocitySearcherFactory untypedSearcherFactory() {
        return (currentAuth, ctx, locale) -> new VelocitySearcherImpl(this.searchFactoryResolver, this.mapToMapSearchParamsConverter, currentAuth, ctx);
    }

    private SingleValueRepository<Paging, String> pagingParamsRepository() {
        return InJsonTokenSingleValueRepository.ofDefaultObjectMapper((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    @ConstructorProperties(value={"publicContextPath", "settingLoader", "featureManager", "translator", "serverUrlProvider", "allowedDatasetsProvider", "readerShowableDocumentFondsProvider", "nonDetailedDocumentLoader", "searchRepository", "departmentedFondedRecordSearchSortingsLoader", "authoritySearchSortingLoader", "exemplarSearchSortingLoader", "matchSearchSortingLoader", "documentDefaultPageSizeProvider", "searchHistory", "newestDocumentsLoader", "systemInstitutionProvider", "searchedKeywordsLoader", "restrictionToLuceneQueryConverter", "restrictionToZServerQueryConverter", "phraseEntityLoader", "searchFactoryResolver", "actionSaver", "viewableItemsConverter", "searchFormFactory", "searchTitleResolver", "searchSubtitleResolver", "facetTypeLoader", "recordStatusLoader", "exemplarStatusLoader", "exportDescriptorLoader", "searchedKeywordsSaver", "securityManager", "departmentedSearchFieldToViewableSearchFieldConverter", "mapToMapSearchParamsConverter", "modelAndPageViewFactory", "documentYearExtremeRangeProvider", "viewableSearchFieldsProvider", "fondRelatedParamsExpander", "facetTypeCreator", "facetTypeUpdater", "fallbackingScalarDatatypeLoader"})
    @Generated
    public SearchViewConfig(@NonNull @NonNull Provider<@NonNull String> publicContextPath, @NonNull SettingLoader settingLoader, @NonNull FeatureManager featureManager, @NonNull Translator<Department> translator, @NonNull ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider, @NonNull @NonNull ContextualProvider<Department, @NonNull List<Datasource>> allowedDatasetsProvider, @NonNull AllValuesProvider<Fond> readerShowableDocumentFondsProvider, @NonNull AllByIdsLoadable<Record, UUID> nonDetailedDocumentLoader, @NonNull Repository<Search<? extends MapBackedParams, ?, ? extends Paging>, UUID> searchRepository, @NonNull @NonNull ContextualProvider<Department, @NonNull FondedValues<@NonNull List<SortingItem>>> departmentedFondedRecordSearchSortingsLoader, @NonNull AllValuesProvider<SortingItem> authoritySearchSortingLoader, @NonNull AllValuesProvider<SortingItem> exemplarSearchSortingLoader, @NonNull AllValuesProvider<SortingItem> matchSearchSortingLoader, @NonNull @NonNull SameTypeSettableProvider<@NonNull Integer> documentDefaultPageSizeProvider, @NonNull AllProvidingRepository<Search<MapBackedParams, ?, ? extends Paging>, UUID> searchHistory, @NonNull PageSearchLoader<MapBackedParams, UUID, RangePaging> newestDocumentsLoader, @NonNull @NonNull ContextualProvider<Department, @NonNull SystemInstitution> systemInstitutionProvider, @NonNull SearchedKeywordsLoader searchedKeywordsLoader, @NonNull Converter<Restriction<? extends SearchField>, String> restrictionToLuceneQueryConverter, @NonNull Converter<Restriction<? extends SearchField>, String> restrictionToZServerQueryConverter, @NonNull PhraseEntityLoader phraseEntityLoader, @NonNull SearchFactoryResolver searchFactoryResolver, @NonNull ActionSaver actionSaver, @NonNull ViewableItemsConverter viewableItemsConverter, @NonNull CompositeSearchFormFactory searchFormFactory, @NonNull SearchTextResolver searchTitleResolver, @NonNull SearchTextResolver searchSubtitleResolver, @NonNull Codebook<FacetType, Integer> facetTypeLoader, @NonNull ByIdLoadable<RecordStatus, Integer> recordStatusLoader, @NonNull ByIdLoadable<ExemplarStatus, Integer> exemplarStatusLoader, @NonNull ExportDescriptorLoader exportDescriptorLoader, @NonNull SearchedKeywordsSaver searchedKeywordsSaver, @NonNull SecurityManager securityManager, @NonNull AuthenticatedContextualFunction<SearchField, Department, ViewableSearchField> departmentedSearchFieldToViewableSearchFieldConverter, @NonNull MapToMapSearchParamsConverter mapToMapSearchParamsConverter, @NonNull ModelAndPageViewFactory modelAndPageViewFactory, @NonNull ContextualProvider<Department, Range<Integer>> documentYearExtremeRangeProvider, @NonNull AuthenticatedContextualProvider<Department, List<ViewableSearchField>> viewableSearchFieldsProvider, @NonNull ParamsModifier<DefaultGettableAndSettableSearchParams> fondRelatedParamsExpander, @NonNull FacetTypeCreator facetTypeCreator, @NonNull FacetTypeUpdater facetTypeUpdater, @NonNull ByIdLoadable<ScalarDatatype, String> fallbackingScalarDatatypeLoader) {
        Objects.requireNonNull(publicContextPath, "publicContextPath is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(featureManager, "featureManager is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(serverUrlProvider, "serverUrlProvider is marked non-null but is null");
        Objects.requireNonNull(allowedDatasetsProvider, "allowedDatasetsProvider is marked non-null but is null");
        Objects.requireNonNull(readerShowableDocumentFondsProvider, "readerShowableDocumentFondsProvider is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentLoader, "nonDetailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(searchRepository, "searchRepository is marked non-null but is null");
        Objects.requireNonNull(departmentedFondedRecordSearchSortingsLoader, "departmentedFondedRecordSearchSortingsLoader is marked non-null but is null");
        Objects.requireNonNull(authoritySearchSortingLoader, "authoritySearchSortingLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarSearchSortingLoader, "exemplarSearchSortingLoader is marked non-null but is null");
        Objects.requireNonNull(matchSearchSortingLoader, "matchSearchSortingLoader is marked non-null but is null");
        Objects.requireNonNull(documentDefaultPageSizeProvider, "documentDefaultPageSizeProvider is marked non-null but is null");
        Objects.requireNonNull(searchHistory, "searchHistory is marked non-null but is null");
        Objects.requireNonNull(newestDocumentsLoader, "newestDocumentsLoader is marked non-null but is null");
        Objects.requireNonNull(systemInstitutionProvider, "systemInstitutionProvider is marked non-null but is null");
        Objects.requireNonNull(searchedKeywordsLoader, "searchedKeywordsLoader is marked non-null but is null");
        Objects.requireNonNull(restrictionToLuceneQueryConverter, "restrictionToLuceneQueryConverter is marked non-null but is null");
        Objects.requireNonNull(restrictionToZServerQueryConverter, "restrictionToZServerQueryConverter is marked non-null but is null");
        Objects.requireNonNull(phraseEntityLoader, "phraseEntityLoader is marked non-null but is null");
        Objects.requireNonNull(searchFactoryResolver, "searchFactoryResolver is marked non-null but is null");
        Objects.requireNonNull(actionSaver, "actionSaver is marked non-null but is null");
        Objects.requireNonNull(viewableItemsConverter, "viewableItemsConverter is marked non-null but is null");
        Objects.requireNonNull(searchFormFactory, "searchFormFactory is marked non-null but is null");
        Objects.requireNonNull(searchTitleResolver, "searchTitleResolver is marked non-null but is null");
        Objects.requireNonNull(searchSubtitleResolver, "searchSubtitleResolver is marked non-null but is null");
        Objects.requireNonNull(facetTypeLoader, "facetTypeLoader is marked non-null but is null");
        Objects.requireNonNull(recordStatusLoader, "recordStatusLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarStatusLoader, "exemplarStatusLoader is marked non-null but is null");
        Objects.requireNonNull(exportDescriptorLoader, "exportDescriptorLoader is marked non-null but is null");
        Objects.requireNonNull(searchedKeywordsSaver, "searchedKeywordsSaver is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(departmentedSearchFieldToViewableSearchFieldConverter, "departmentedSearchFieldToViewableSearchFieldConverter is marked non-null but is null");
        Objects.requireNonNull(mapToMapSearchParamsConverter, "mapToMapSearchParamsConverter is marked non-null but is null");
        Objects.requireNonNull(modelAndPageViewFactory, "modelAndPageViewFactory is marked non-null but is null");
        Objects.requireNonNull(documentYearExtremeRangeProvider, "documentYearExtremeRangeProvider is marked non-null but is null");
        Objects.requireNonNull(viewableSearchFieldsProvider, "viewableSearchFieldsProvider is marked non-null but is null");
        Objects.requireNonNull(fondRelatedParamsExpander, "fondRelatedParamsExpander is marked non-null but is null");
        Objects.requireNonNull(facetTypeCreator, "facetTypeCreator is marked non-null but is null");
        Objects.requireNonNull(facetTypeUpdater, "facetTypeUpdater is marked non-null but is null");
        Objects.requireNonNull(fallbackingScalarDatatypeLoader, "fallbackingScalarDatatypeLoader is marked non-null but is null");
        this.publicContextPath = publicContextPath;
        this.settingLoader = settingLoader;
        this.featureManager = featureManager;
        this.translator = translator;
        this.serverUrlProvider = serverUrlProvider;
        this.allowedDatasetsProvider = allowedDatasetsProvider;
        this.readerShowableDocumentFondsProvider = readerShowableDocumentFondsProvider;
        this.nonDetailedDocumentLoader = nonDetailedDocumentLoader;
        this.searchRepository = searchRepository;
        this.departmentedFondedRecordSearchSortingsLoader = departmentedFondedRecordSearchSortingsLoader;
        this.authoritySearchSortingLoader = authoritySearchSortingLoader;
        this.exemplarSearchSortingLoader = exemplarSearchSortingLoader;
        this.matchSearchSortingLoader = matchSearchSortingLoader;
        this.documentDefaultPageSizeProvider = documentDefaultPageSizeProvider;
        this.searchHistory = searchHistory;
        this.newestDocumentsLoader = newestDocumentsLoader;
        this.systemInstitutionProvider = systemInstitutionProvider;
        this.searchedKeywordsLoader = searchedKeywordsLoader;
        this.restrictionToLuceneQueryConverter = restrictionToLuceneQueryConverter;
        this.restrictionToZServerQueryConverter = restrictionToZServerQueryConverter;
        this.phraseEntityLoader = phraseEntityLoader;
        this.searchFactoryResolver = searchFactoryResolver;
        this.actionSaver = actionSaver;
        this.viewableItemsConverter = viewableItemsConverter;
        this.searchFormFactory = searchFormFactory;
        this.searchTitleResolver = searchTitleResolver;
        this.searchSubtitleResolver = searchSubtitleResolver;
        this.facetTypeLoader = facetTypeLoader;
        this.recordStatusLoader = recordStatusLoader;
        this.exemplarStatusLoader = exemplarStatusLoader;
        this.exportDescriptorLoader = exportDescriptorLoader;
        this.searchedKeywordsSaver = searchedKeywordsSaver;
        this.securityManager = securityManager;
        this.departmentedSearchFieldToViewableSearchFieldConverter = departmentedSearchFieldToViewableSearchFieldConverter;
        this.mapToMapSearchParamsConverter = mapToMapSearchParamsConverter;
        this.modelAndPageViewFactory = modelAndPageViewFactory;
        this.documentYearExtremeRangeProvider = documentYearExtremeRangeProvider;
        this.viewableSearchFieldsProvider = viewableSearchFieldsProvider;
        this.fondRelatedParamsExpander = fondRelatedParamsExpander;
        this.facetTypeCreator = facetTypeCreator;
        this.facetTypeUpdater = facetTypeUpdater;
        this.fallbackingScalarDatatypeLoader = fallbackingScalarDatatypeLoader;
    }
}

