/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.auth.UserAuthentication;
import cz.kpsys.portaro.auth.context.AuthenticatedContextualProvider;
import cz.kpsys.portaro.auth.context.TypedAuthenticatedContextualObjectModifier;
import cz.kpsys.portaro.batch.CacheCleaningChunkLoader;
import cz.kpsys.portaro.batch.ChunkLoader;
import cz.kpsys.portaro.commons.async.AsyncProcessStatus;
import cz.kpsys.portaro.commons.async.AsyncProcessesManager;
import cz.kpsys.portaro.commons.barcode.BarCodeValidator;
import cz.kpsys.portaro.commons.cache.CacheDeleter;
import cz.kpsys.portaro.commons.contextual.ContextIgnoringContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.StaticContextualDelegatingProvider;
import cz.kpsys.portaro.commons.convert.FallbackingConverter;
import cz.kpsys.portaro.commons.convert.IdToObjectConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerToAnyConverter;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.IdSettable;
import cz.kpsys.portaro.commons.object.LabeledIdentified;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.Sequence;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdOptLoadableRepository;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.InMemoryRepository;
import cz.kpsys.portaro.commons.object.repo.ItemNotFoundException;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.Repository;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.property.Property;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.database.FlushingJpaSaver;
import cz.kpsys.portaro.database.IntegerValueDatabaseLoader;
import cz.kpsys.portaro.databaseproperties.DatabaseProperties;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.exemplar.Exemplar;
import cz.kpsys.portaro.exemplar.ExemplarDescriptor;
import cz.kpsys.portaro.exemplar.ExemplarSettingKeys;
import cz.kpsys.portaro.exemplar.discard.ExemplarDiscarder;
import cz.kpsys.portaro.exemplar.exchangesetitem.SpringDbExchangeSetItemEntityLoader;
import cz.kpsys.portaro.exemplar.exemplarstatus.ExemplarStatus;
import cz.kpsys.portaro.exemplar.loancategory.LoanCategory;
import cz.kpsys.portaro.exemplar.thematicgroup.ThematicGroup;
import cz.kpsys.portaro.export.CacheDeletingExporter;
import cz.kpsys.portaro.export.ChunkLoadingDelegatingExporter;
import cz.kpsys.portaro.export.ChunkLoadingDelegatingToStringExporter;
import cz.kpsys.portaro.export.CompositeExportDescriptorLoader;
import cz.kpsys.portaro.export.CsvFileExporter;
import cz.kpsys.portaro.export.ExportDescriptorLoader;
import cz.kpsys.portaro.export.Exporter;
import cz.kpsys.portaro.export.ExporterResolver;
import cz.kpsys.portaro.export.FilteringChunkLoader;
import cz.kpsys.portaro.export.SearchedItemsExporter;
import cz.kpsys.portaro.export.StaticExportDescriptorLoader;
import cz.kpsys.portaro.export.TemplatedExporter;
import cz.kpsys.portaro.export.ToStringExporter;
import cz.kpsys.portaro.export.XlsFileExporterByCsvExporter;
import cz.kpsys.portaro.inventory.InventoryConstants;
import cz.kpsys.portaro.inventory.InventorySecurityActions;
import cz.kpsys.portaro.inventory.api.CaptureApiController;
import cz.kpsys.portaro.inventory.api.InventoryApiController;
import cz.kpsys.portaro.inventory.api.InventoryPageApiController;
import cz.kpsys.portaro.inventory.api.MatchApiController;
import cz.kpsys.portaro.inventory.capture.Capture;
import cz.kpsys.portaro.inventory.capture.CaptureByInventoryDeleter;
import cz.kpsys.portaro.inventory.capture.CaptureEntity;
import cz.kpsys.portaro.inventory.capture.CaptureFromDtoConverter;
import cz.kpsys.portaro.inventory.capture.CaptureToEntityConverter;
import cz.kpsys.portaro.inventory.capture.CaptureWay;
import cz.kpsys.portaro.inventory.capture.SpringDbCaptureSearchLoader;
import cz.kpsys.portaro.inventory.discardion.InventoryExemplarDiscarder;
import cz.kpsys.portaro.inventory.discardion.InventoryExemplarDiscardionRequest;
import cz.kpsys.portaro.inventory.execution.InventoryProcessExecutor;
import cz.kpsys.portaro.inventory.execution.MatchFinder;
import cz.kpsys.portaro.inventory.execution.QuantumLoansChangesSumByExemplarLoader;
import cz.kpsys.portaro.inventory.inventory.EntitiesToInventoriesConverter;
import cz.kpsys.portaro.inventory.inventory.Inventory;
import cz.kpsys.portaro.inventory.inventory.InventoryCloser;
import cz.kpsys.portaro.inventory.inventory.InventoryCreator;
import cz.kpsys.portaro.inventory.inventory.InventoryEntity;
import cz.kpsys.portaro.inventory.inventory.InventoryRemover;
import cz.kpsys.portaro.inventory.inventory.InventoryState;
import cz.kpsys.portaro.inventory.inventory.InventoryToEntityConverter;
import cz.kpsys.portaro.inventory.inventory.InventoryUpdater;
import cz.kpsys.portaro.inventory.inventory.SpringDbInventoryIdSearchLoader;
import cz.kpsys.portaro.inventory.match.EntitiesToMatchesConverter;
import cz.kpsys.portaro.inventory.match.Match;
import cz.kpsys.portaro.inventory.match.MatchByInventoryDeleter;
import cz.kpsys.portaro.inventory.match.MatchEditor;
import cz.kpsys.portaro.inventory.match.MatchEntity;
import cz.kpsys.portaro.inventory.match.MatchState;
import cz.kpsys.portaro.inventory.match.MatchToEntityConverter;
import cz.kpsys.portaro.inventory.match.SpringDbMatchIdSearchLoader;
import cz.kpsys.portaro.licence.FeatureEnabledProvider;
import cz.kpsys.portaro.licence.FeatureManager;
import cz.kpsys.portaro.loan.Loan;
import cz.kpsys.portaro.loan.LoanQuantityLoader;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.location.LocationImpl;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RecordConstants;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.ParametersConvertingPageSearchLoader;
import cz.kpsys.portaro.search.RangePaging;
import cz.kpsys.portaro.search.batch.BySearchLoaderRangePagingChunkLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.template.TemplateEngine;
import cz.kpsys.portaro.user.BasicUser;
import jakarta.persistence.EntityManager;
import java.beans.ConstructorProperties;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class InventoryConfig {
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final DatabaseProperties databaseProperties;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final SaverBuilderFactory saverBuilderFactory;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final AllByIdsLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final ByIdLoadable<Fond, Integer> fondLoader;
    @NonNull
    private final ByIdLoadable<Location, Integer> locationLoader;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final ByIdLoadable<LoanCategory, String> loanCategoryLoader;
    @NonNull
    private final ByIdLoadable<ThematicGroup, String> thematicGroupLoader;
    @NonNull
    private final Codebook<ExemplarStatus, Integer> exemplarStatusLoader;
    @NonNull
    private final ByIdLoadable<? extends ExemplarDescriptor, Integer> exemplarDescriptorLoader;
    @NonNull
    private final IdAndIdsLoadable<Record, Integer> nonDetailedDocumentByKindedIdLoader;
    @NonNull
    private final IdAndIdsLoadable<Record, UUID> nonDetailedDocumentLoader;
    @NonNull
    private final IdAndIdsLoadable<Exemplar, Integer> exemplarLoader;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final @NonNull Provider<@NonNull ZoneId> defaultTimeZoneProvider;
    @NonNull
    private final ContextualProvider<Department, BarCodeValidator> exemplarBarCodeValidatorProvider;
    @NonNull
    private final Provider<Department> realRootDepartmentProvider;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, Exemplar> exemplarSearchLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, Loan> nonDetailedLoanSearchLoader;
    @NonNull
    private final LoanQuantityLoader loanQuantityLoader;
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final ExemplarDiscarder exemplarDiscarder;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final AuthenticatedContextualProvider<Department, List<LabeledIdentified<String>>> discardNumberSequenceAuthenticatedContextualProvider;
    @NonNull
    private final FeatureManager featureManager;
    @NonNull
    private final ExporterResolver exporterResolver;
    @NonNull
    private final StaticExportDescriptorLoader staticExportDescriptorLoader;
    @NonNull
    private final TemplateEngine templateEngine;
    @NonNull
    private final CompositeExportDescriptorLoader exportDescriptorLoader;
    @NonNull
    private final CacheDeleter<Record> recordCache;
    @NonNull
    private final Function<Fond, List<Fond>> enabledIncludableFondsExpander;

    @Bean
    public InventoryApiController inventoryApiController() {
        return new InventoryApiController(this.inventoryLoader(), this.inventoryCreator(), this.inventoryUpdater(), this.inventoryProcessExecutor(), this.inventoryRemover(), this.inventoryCloser(), this.inventoryExemplarDiscarder(), this.executionProcessesManager(), this.discardionProcessesManager());
    }

    @Bean
    InventoryPageApiController inventoryPageApiController() {
        return new InventoryPageApiController((Provider)new FeatureEnabledProvider(this.featureManager, "exports"), (ExportDescriptorLoader)this.exportDescriptorLoader);
    }

    @Bean
    public CaptureApiController captureApiController() {
        return new CaptureApiController(this.captureSaver(), (ByIdLoadable)this.exemplarLoader, (ByIdLoadable)this.nonDetailedDocumentLoader);
    }

    @Bean
    public MatchApiController matchApiController() {
        return new MatchApiController(this.matchEditor());
    }

    @Bean
    Saver<Capture, Capture> captureSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new CaptureToEntityConverter()).idSetting(CaptureEntity.class, (Converter)new StringToIntegerConverter(), IdSettable::setId).withClearedCacheName(CaptureEntity.class.getSimpleName()).build();
    }

    @Bean
    public IdAndIdsLoadable<Inventory, Integer> inventoryLoader() {
        EntitiesToInventoriesConverter entitiesToInventoriesConverter = new EntitiesToInventoriesConverter(this.basicUserLoader, this.fondLoader, this.departmentLoader, (Converter)this.deprecatedIdFormatFallbackingStringIdToLocationConverter(), (ByIdLoadable)this.inventoryStateLoader());
        return this.modelBeanBuilder.allByIdsLoader(InventoryEntity.class, (Converter)entitiesToInventoriesConverter).build();
    }

    @Bean
    public Deleter<Inventory> inventoryDeleter() {
        return this.modelBeanBuilder.hibernateHardDeleter(InventoryEntity.class, (Converter)new InventoryToEntityConverter()).build();
    }

    @NonNull
    private FallbackingConverter<String, Location> deprecatedIdFormatFallbackingStringIdToLocationConverter() {
        return FallbackingConverter.onConversionException((Converter)this.itemNotFoundFallbackingStringIdToLocationConverter(), deprecatedLocationCode -> new LocationImpl(Integer.valueOf(-Sequence.getNextNumber()), deprecatedLocationCode, deprecatedLocationCode, 0));
    }

    @NonNull
    private FallbackingConverter<String, Location> itemNotFoundFallbackingStringIdToLocationConverter() {
        return FallbackingConverter.onException((Converter)StringToIntegerToAnyConverter.strict((Converter)new IdToObjectConverter(this.locationLoader)), ItemNotFoundException.class, (Converter)StringToIntegerToAnyConverter.strict(naId -> new LocationImpl(naId, "unknown-%s".formatted(naId), String.valueOf(naId), 0)));
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Integer> inventoryIdSearchLoader() {
        SpringDbInventoryIdSearchLoader pureSearchLoader = new SpringDbInventoryIdSearchLoader(this.jdbcTemplate, this.queryFactory);
        ParametersConvertingPageSearchLoader paramsConvertingSearchLoader = new ParametersConvertingPageSearchLoader((PageSearchLoader)pureSearchLoader).withExpandingParam(RecordConstants.SearchParams.ROOT_FOND, RecordConstants.SearchParams.FOND, this.enabledIncludableFondsExpander);
        return this.modelBeanBuilder.idSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)paramsConvertingSearchLoader).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Inventory> inventorySearchLoader() {
        return this.modelBeanBuilder.modelSearchLoaderByIdSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)this.inventoryIdSearchLoader(), (AllByIdsLoadable)this.inventoryLoader()).build();
    }

    @Bean
    public CaptureByInventoryDeleter captureByInventoryDeleter() {
        return new CaptureByInventoryDeleter(this.queryFactory, this.jdbcTemplate);
    }

    @Bean
    public Deleter<Capture> captureDeleter() {
        return this.modelBeanBuilder.hibernateHardDeleter(CaptureEntity.class, (Converter)new CaptureToEntityConverter()).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Capture> captureSearchLoader() {
        SpringDbCaptureSearchLoader modelSearchLoader = new SpringDbCaptureSearchLoader(this.jdbcTemplate, this.queryFactory, (Converter)new CaptureFromDtoConverter((ByIdLoadable)this.inventoryLoader(), this.exemplarDescriptorLoader, (ByIdLoadable)CaptureWay.CODEBOOK), (Provider)new StaticContextualDelegatingProvider(this.exemplarBarCodeValidatorProvider, this.realRootDepartmentProvider));
        return this.modelBeanBuilder.searchLoader(MapBackedParams::createEmpty, (PageSearchLoader)modelSearchLoader).build();
    }

    @Bean
    public IdAndIdsLoadable<Match, UUID> matchLoader() {
        EntitiesToMatchesConverter entitiesToMatchesConverter = new EntitiesToMatchesConverter((ByIdLoadable)this.inventoryLoader(), (ByIdLoadable)this.matchStateLoader(), this.nonDetailedDocumentByKindedIdLoader, (Converter)this.deprecatedIdFormatFallbackingStringIdToLocationConverter(), (Converter)FallbackingConverter.onException((Converter)new IdToObjectConverter(this.loanCategoryLoader), ItemNotFoundException.class, naId -> new LoanCategory(naId, naId)), (Converter)FallbackingConverter.onException((Converter)new IdToObjectConverter(this.thematicGroupLoader), ItemNotFoundException.class, naId -> new ThematicGroup(naId, naId, 0)), (Converter)FallbackingConverter.onException((Converter)StringToIntegerToAnyConverter.strict((Converter)new IdToObjectConverter((ByIdLoadable)this.exemplarStatusLoader)), ItemNotFoundException.class, (Converter)StringToIntegerToAnyConverter.strict(naId -> new ExemplarStatus(naId, "unknown-%s".formatted(naId)))));
        return this.modelBeanBuilder.allByIdsLoader(MatchEntity.class, (Converter)entitiesToMatchesConverter).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, UUID> matchIdSearchLoader() {
        SpringDbMatchIdSearchLoader modelIdSearchLoader = new SpringDbMatchIdSearchLoader(this.jdbcTemplate, this.queryFactory);
        return this.modelBeanBuilder.idSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)modelIdSearchLoader).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Match> matchSearchLoader() {
        return this.modelBeanBuilder.modelSearchLoaderByIdSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)this.matchIdSearchLoader(), (AllByIdsLoadable)this.matchLoader()).build();
    }

    @Bean
    public Codebook<MatchState, Integer> matchStateLoader() {
        return MatchState.CODEBOOK;
    }

    @Bean
    public Saver<Match, Match> matchSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new MatchToEntityConverter()).withClearedCacheName(MatchEntity.class.getSimpleName()).build();
    }

    @Bean
    public MatchByInventoryDeleter matchByInventoryDeleter() {
        return new MatchByInventoryDeleter(this.queryFactory, this.jdbcTemplate);
    }

    @Bean
    public MatchFinder matchFinder() {
        return new MatchFinder(this.jdbcTemplate, this.queryFactory, (ByIdLoadable)this.matchLoader());
    }

    @Bean
    public MatchEditor matchEditor() {
        return new MatchEditor(this.captureSaver(), this.matchSaver(), (ByIdLoadable)this.exemplarLoader, this.captureSearchLoader(), this.captureDeleter(), this.matchFinder());
    }

    @Bean
    public Codebook<InventoryState, Integer> inventoryStateLoader() {
        return InventoryState.CODEBOOK;
    }

    @Bean
    public Saver<Inventory, InventoryEntity> inventorySaver() {
        return new PreConvertingSaver((Converter)new InventoryToEntityConverter(), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(InventoryEntity.class, this.entityManager)));
    }

    @Bean
    public InventoryCreator inventoryCreator() {
        return new InventoryCreator((ContextualProvider)ContextIgnoringContextualProvider.of((Provider)IntegerValueDatabaseLoader.ofSequenceValueDbDependent((String)"seq_id_hl_revi", (String)"hl_revi_id_revi_seq", (NamedParameterJdbcOperations)this.jdbcTemplate, (QueryFactory)this.queryFactory, (DatabaseProperties)this.databaseProperties)), this.inventorySaver(), this.defaultTimeZoneProvider);
    }

    @Bean
    public InventoryUpdater inventoryUpdater() {
        return new InventoryUpdater(this.inventorySaver(), this.executionProcessesManager(), this.discardionProcessesManager());
    }

    @Bean
    public InventoryProcessExecutor inventoryProcessExecutor() {
        return new InventoryProcessExecutor(this.exemplarSearchLoader, (ChunkLoader)new BySearchLoaderRangePagingChunkLoader(this.exemplarSearchLoader, Integer.valueOf(100)), this.exemplarStatusLoader, this.matchByInventoryDeleter(), (AllByIdsLoadable)this.nonDetailedDocumentLoader, this.captureSearchLoader(), new QuantumLoansChangesSumByExemplarLoader(this.nonDetailedLoanSearchLoader, this.loanQuantityLoader), new SpringDbExchangeSetItemEntityLoader(this.jdbcTemplate, this.queryFactory), this.matchSaver(), this.matchFinder(), this.inventorySaver(), (Repository)this.executionProcessStatusRepository(), this.executorService, this.defaultTimeZoneProvider, this.executionProcessesManager(), this.discardionProcessesManager(), this.recordCache);
    }

    @Bean
    public InventoryRemover inventoryRemover() {
        return new InventoryRemover(this.inventoryDeleter(), this.matchByInventoryDeleter(), this.captureByInventoryDeleter(), this.executionProcessesManager(), this.discardionProcessesManager());
    }

    @Bean
    public ByIdOptLoadableRepository<AsyncProcessStatus<Integer>, Integer> executionProcessStatusRepository() {
        return InMemoryRepository.ofIdentified();
    }

    @Bean
    public AsyncProcessesManager<Integer> executionProcessesManager() {
        return new AsyncProcessesManager(this.executionProcessStatusRepository());
    }

    @Bean
    public ByIdOptLoadableRepository<AsyncProcessStatus<Integer>, Integer> discardionProcessStatusRepository() {
        return InMemoryRepository.ofIdentified();
    }

    @Bean
    public AsyncProcessesManager<Integer> discardionProcessesManager() {
        return new AsyncProcessesManager(this.discardionProcessStatusRepository());
    }

    @Bean
    public InventoryCloser inventoryCloser() {
        return new InventoryCloser(this.inventorySaver(), this.defaultTimeZoneProvider, this.executionProcessesManager(), this.discardionProcessesManager());
    }

    @Bean
    public InventoryExemplarDiscarder inventoryExemplarDiscarder() {
        return new InventoryExemplarDiscarder(this.exemplarDiscarder, this.matchSaver(), this.exemplarLoader, this.matchSearchLoader(), (ChunkLoader)new BySearchLoaderRangePagingChunkLoader(this.matchSearchLoader(), Integer.valueOf(100)), this.settingLoader.getDepartmentedProvider(ExemplarSettingKeys.INVENTORY_DISCARD_ONLY_TWICE_NOT_FOUND), this.executorService, (Repository)this.discardionProcessStatusRepository(), this.executionProcessesManager(), this.discardionProcessesManager());
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<InventoryExemplarDiscardionRequest> inventoryExemplarDiscardionRequestDefaulter() {
        return (request, ctx, currentAuth) -> request.withDiscardNumber((String)((LabeledIdentified)((List)this.discardNumberSequenceAuthenticatedContextualProvider.getOn((Object)currentAuth, (Object)ctx)).getFirst()).getId());
    }

    @Bean
    public ChunkLoader<Match, MapBackedParams, RangePaging> matchCacheCleaningChunkLoader() {
        return new CacheCleaningChunkLoader((ChunkLoader)new BySearchLoaderRangePagingChunkLoader(this.matchSearchLoader(), Integer.valueOf(100)), this.matchCacheDeletable());
    }

    @Bean
    public FilteringChunkLoader<Inventory, Match> matchByInventoryFilteringChunkLoader() {
        return new FilteringChunkLoader(this.matchCacheCleaningChunkLoader(), (inventory, params) -> params.set((Property)InventoryConstants.SearchParams.INVENTORY, List.of(inventory.id())));
    }

    @Bean
    public CacheDeleter<Match> matchCacheDeletable() {
        return match -> this.recordCache.deleteFromCache((Object)match.record());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerExports() {
        if (this.featureManager.isEnabled("exports")) {
            CsvFileExporter matchesCsvExporter = new CsvFileExporter("matches.csv", InventoryConstants.Template.TEMPLATE_INVENTORY_MATCHES_CSV, Match.class, "matches", this.templateEngine);
            this.exporterResolver.addStatic("matches-csv:", (Exporter)matchesCsvExporter);
            XlsFileExporterByCsvExporter matchesXlsExporter = new XlsFileExporterByCsvExporter("matches.xls", (Exporter)matchesCsvExporter);
            this.exporterResolver.addStatic("matches-xls:", (Exporter)matchesXlsExporter);
            CacheDeletingExporter searchedLoansCsvExporter = SearchedItemsExporter.ofUnlimited((Exporter)matchesCsvExporter).withCacheDeleter(this.matchCacheDeletable());
            this.exporterResolver.addStatic("searched-matches-csv:", (Exporter)searchedLoansCsvExporter);
            CacheDeletingExporter searchedLoansXlsExporter = SearchedItemsExporter.ofUnlimited((Exporter)matchesXlsExporter).withCacheDeleter(this.matchCacheDeletable());
            this.exporterResolver.addStatic("searched-matches-xls:", (Exporter)searchedLoansXlsExporter);
            ChunkLoadingDelegatingExporter inventoryCsvExporter = new ChunkLoadingDelegatingExporter((Exporter)matchesCsvExporter, Inventory.class, this.matchByInventoryFilteringChunkLoader());
            this.exporterResolver.addStatic("inventory-matches-csv:", (Exporter)inventoryCsvExporter);
            ChunkLoadingDelegatingExporter inventoryXlsExporter = new ChunkLoadingDelegatingExporter((Exporter)matchesXlsExporter, Inventory.class, this.matchByInventoryFilteringChunkLoader());
            this.exporterResolver.addStatic("inventory-matches-xls:", (Exporter)inventoryXlsExporter);
            TemplatedExporter matchesPrintExporter = new TemplatedExporter("matches.html", Match.class, "matches", InventoryConstants.Template.TEMPLATE_INVENTORY_MATCHES_PRINT, this.templateEngine);
            ChunkLoadingDelegatingToStringExporter inventoryPrintExporter = new ChunkLoadingDelegatingToStringExporter((ToStringExporter)matchesPrintExporter, Inventory.class, this.matchByInventoryFilteringChunkLoader());
            this.exporterResolver.addStatic("inventory-matches-print:", (Exporter)inventoryPrintExporter);
        }
        this.staticExportDescriptorLoader.with(List.of("inventory", "csv", "download"), "inventory-matches-csv:", Texts.ofMessageCoded((String)"export.CsvButton")).with(List.of("inventory", "xls", "download"), "inventory-matches-xls:", Texts.ofMessageCoded((String)"export.XlsButton")).with(List.of("inventory", "html", "print"), "inventory-matches-print:", Texts.ofMessageCoded((String)"commons.tisk")).with(List.of("searched-matches", "csv", "download"), "searched-matches-csv:", Texts.ofMessageCoded((String)"export.CsvButton")).with(List.of("searched-matches", "xls", "download"), "searched-matches-xls:", Texts.ofMessageCoded((String)"export.XlsButton"));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForIntegerId(Inventory.class, (ByIdLoadable)this.inventoryLoader()).registerForUuidId(Match.class, (ByIdLoadable)this.matchLoader()).registerForIntegerId(MatchState.class, (ByIdLoadable)this.matchStateLoader()).registerForIntegerId(InventoryState.class, (ByIdLoadable)this.inventoryStateLoader());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        PermissionResolver userIsOwner = (auth, ctx, inventory) -> PermissionResult.ifCan((boolean)inventory.creator().equals((Object)auth.getActiveUser()), (UserAuthentication)auth, () -> Texts.ofNative((String)"User is not the owner"));
        this.permissionRegistry.add(InventorySecurityActions.INVENTORIES_SHOW, this.permissionFactory.edit());
        this.permissionRegistry.add(InventorySecurityActions.INVENTORY_SHOW, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.editAction(Integer.valueOf(2412)), this.permissionFactory.edit()}));
        this.permissionRegistry.add(InventorySecurityActions.INVENTORY_CREATE, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.editAction(Integer.valueOf(2401)), this.permissionFactory.edit()}));
        this.permissionRegistry.add(InventorySecurityActions.INVENTORY_EDIT, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.editAction(Integer.valueOf(2408)), this.permissionFactory.edit(), userIsOwner}));
        this.permissionRegistry.add(InventorySecurityActions.INVENTORY_DELETE, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.editAction(Integer.valueOf(2409)), this.permissionFactory.edit(), userIsOwner}));
        this.permissionRegistry.add(InventorySecurityActions.INVENTORY_CLOSE, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.editAction(Integer.valueOf(2407)), this.permissionFactory.edit(), userIsOwner}));
        this.permissionRegistry.add(InventorySecurityActions.START_INVENTORY_EXECUTION, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.editAction(Integer.valueOf(2403)), this.permissionFactory.edit(), userIsOwner}));
        this.permissionRegistry.add(InventorySecurityActions.STOP_INVENTORY_EXECUTION, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.editAction(Integer.valueOf(2403)), this.permissionFactory.edit(), userIsOwner}));
        this.permissionRegistry.add(InventorySecurityActions.START_INVENTORY_DISCARDION, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.editAction(Integer.valueOf(2404)), this.permissionFactory.edit(), userIsOwner}));
        this.permissionRegistry.add(InventorySecurityActions.STOP_INVENTORY_DISCARDION, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.editAction(Integer.valueOf(2404)), this.permissionFactory.edit(), userIsOwner}));
        this.permissionRegistry.add(InventorySecurityActions.MATCH_MANUAL_FIX, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.editAction(Integer.valueOf(2411)), PermissionResolver.adaptingSubject(Match::inventory, (PermissionResolver)this.permissionRegistry.getLazy(InventorySecurityActions.INVENTORY_EDIT)), this.permissionFactory.edit()}));
        this.permissionRegistry.add(InventorySecurityActions.INVENTORY_CAPTURES_SHOW, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.editAction(Integer.valueOf(2405)), this.permissionFactory.edit()}));
        this.permissionRegistry.add(InventorySecurityActions.INVENTORY_CAPTURE_CREATE, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.editAction(Integer.valueOf(2402)), this.permissionFactory.edit()}));
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "databaseProperties", "entityManager", "modelBeanBuilder", "saverBuilderFactory", "permissionRegistry", "permissionFactory", "basicUserLoader", "fondLoader", "locationLoader", "departmentLoader", "loanCategoryLoader", "thematicGroupLoader", "exemplarStatusLoader", "exemplarDescriptorLoader", "nonDetailedDocumentByKindedIdLoader", "nonDetailedDocumentLoader", "exemplarLoader", "converterRegisterer", "defaultTimeZoneProvider", "exemplarBarCodeValidatorProvider", "realRootDepartmentProvider", "exemplarSearchLoader", "nonDetailedLoanSearchLoader", "loanQuantityLoader", "executorService", "exemplarDiscarder", "settingLoader", "discardNumberSequenceAuthenticatedContextualProvider", "featureManager", "exporterResolver", "staticExportDescriptorLoader", "templateEngine", "exportDescriptorLoader", "recordCache", "enabledIncludableFondsExpander"})
    @Generated
    public InventoryConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull DatabaseProperties databaseProperties, @NonNull EntityManager entityManager, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull SaverBuilderFactory saverBuilderFactory, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull AllByIdsLoadable<BasicUser, Integer> basicUserLoader, @NonNull ByIdLoadable<Fond, Integer> fondLoader, @NonNull ByIdLoadable<Location, Integer> locationLoader, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull ByIdLoadable<LoanCategory, String> loanCategoryLoader, @NonNull ByIdLoadable<ThematicGroup, String> thematicGroupLoader, @NonNull Codebook<ExemplarStatus, Integer> exemplarStatusLoader, @NonNull ByIdLoadable<? extends ExemplarDescriptor, Integer> exemplarDescriptorLoader, @NonNull IdAndIdsLoadable<Record, Integer> nonDetailedDocumentByKindedIdLoader, @NonNull IdAndIdsLoadable<Record, UUID> nonDetailedDocumentLoader, @NonNull IdAndIdsLoadable<Exemplar, Integer> exemplarLoader, @NonNull ConverterRegisterer converterRegisterer, @NonNull @NonNull Provider<@NonNull ZoneId> defaultTimeZoneProvider, @NonNull ContextualProvider<Department, BarCodeValidator> exemplarBarCodeValidatorProvider, @NonNull Provider<Department> realRootDepartmentProvider, @NonNull ParameterizedSearchLoader<MapBackedParams, Exemplar> exemplarSearchLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, Loan> nonDetailedLoanSearchLoader, @NonNull LoanQuantityLoader loanQuantityLoader, @NonNull ExecutorService executorService, @NonNull ExemplarDiscarder exemplarDiscarder, @NonNull SettingLoader settingLoader, @NonNull AuthenticatedContextualProvider<Department, List<LabeledIdentified<String>>> discardNumberSequenceAuthenticatedContextualProvider, @NonNull FeatureManager featureManager, @NonNull ExporterResolver exporterResolver, @NonNull StaticExportDescriptorLoader staticExportDescriptorLoader, @NonNull TemplateEngine templateEngine, @NonNull CompositeExportDescriptorLoader exportDescriptorLoader, @NonNull CacheDeleter<Record> recordCache, @NonNull Function<Fond, List<Fond>> enabledIncludableFondsExpander) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(databaseProperties, "databaseProperties is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(saverBuilderFactory, "saverBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        Objects.requireNonNull(locationLoader, "locationLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(loanCategoryLoader, "loanCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(thematicGroupLoader, "thematicGroupLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarStatusLoader, "exemplarStatusLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarDescriptorLoader, "exemplarDescriptorLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentByKindedIdLoader, "nonDetailedDocumentByKindedIdLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentLoader, "nonDetailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarLoader, "exemplarLoader is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(defaultTimeZoneProvider, "defaultTimeZoneProvider is marked non-null but is null");
        Objects.requireNonNull(exemplarBarCodeValidatorProvider, "exemplarBarCodeValidatorProvider is marked non-null but is null");
        Objects.requireNonNull(realRootDepartmentProvider, "realRootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(exemplarSearchLoader, "exemplarSearchLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedLoanSearchLoader, "nonDetailedLoanSearchLoader is marked non-null but is null");
        Objects.requireNonNull(loanQuantityLoader, "loanQuantityLoader is marked non-null but is null");
        Objects.requireNonNull(executorService, "executorService is marked non-null but is null");
        Objects.requireNonNull(exemplarDiscarder, "exemplarDiscarder is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(discardNumberSequenceAuthenticatedContextualProvider, "discardNumberSequenceAuthenticatedContextualProvider is marked non-null but is null");
        Objects.requireNonNull(featureManager, "featureManager is marked non-null but is null");
        Objects.requireNonNull(exporterResolver, "exporterResolver is marked non-null but is null");
        Objects.requireNonNull(staticExportDescriptorLoader, "staticExportDescriptorLoader is marked non-null but is null");
        Objects.requireNonNull(templateEngine, "templateEngine is marked non-null but is null");
        Objects.requireNonNull(exportDescriptorLoader, "exportDescriptorLoader is marked non-null but is null");
        Objects.requireNonNull(recordCache, "recordCache is marked non-null but is null");
        Objects.requireNonNull(enabledIncludableFondsExpander, "enabledIncludableFondsExpander is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.databaseProperties = databaseProperties;
        this.entityManager = entityManager;
        this.modelBeanBuilder = modelBeanBuilder;
        this.saverBuilderFactory = saverBuilderFactory;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.basicUserLoader = basicUserLoader;
        this.fondLoader = fondLoader;
        this.locationLoader = locationLoader;
        this.departmentLoader = departmentLoader;
        this.loanCategoryLoader = loanCategoryLoader;
        this.thematicGroupLoader = thematicGroupLoader;
        this.exemplarStatusLoader = exemplarStatusLoader;
        this.exemplarDescriptorLoader = exemplarDescriptorLoader;
        this.nonDetailedDocumentByKindedIdLoader = nonDetailedDocumentByKindedIdLoader;
        this.nonDetailedDocumentLoader = nonDetailedDocumentLoader;
        this.exemplarLoader = exemplarLoader;
        this.converterRegisterer = converterRegisterer;
        this.defaultTimeZoneProvider = defaultTimeZoneProvider;
        this.exemplarBarCodeValidatorProvider = exemplarBarCodeValidatorProvider;
        this.realRootDepartmentProvider = realRootDepartmentProvider;
        this.exemplarSearchLoader = exemplarSearchLoader;
        this.nonDetailedLoanSearchLoader = nonDetailedLoanSearchLoader;
        this.loanQuantityLoader = loanQuantityLoader;
        this.executorService = executorService;
        this.exemplarDiscarder = exemplarDiscarder;
        this.settingLoader = settingLoader;
        this.discardNumberSequenceAuthenticatedContextualProvider = discardNumberSequenceAuthenticatedContextualProvider;
        this.featureManager = featureManager;
        this.exporterResolver = exporterResolver;
        this.staticExportDescriptorLoader = staticExportDescriptorLoader;
        this.templateEngine = templateEngine;
        this.exportDescriptorLoader = exportDescriptorLoader;
        this.recordCache = recordCache;
        this.enabledIncludableFondsExpander = enabledIncludableFondsExpander;
    }
}

