/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.auth.context.TypedAuthenticatedContextualObjectModifier;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.io.JavaTempFileService;
import cz.kpsys.portaro.commons.io.LocalFilesystemService;
import cz.kpsys.portaro.commons.object.AndBooleanProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.database.IntegerValueDatabaseLoader;
import cz.kpsys.portaro.databaseproperties.DatabaseProperties;
import cz.kpsys.portaro.file.ByteArrayLoadedIdentifiedFileCreator;
import cz.kpsys.portaro.file.FileAccessType;
import cz.kpsys.portaro.file.FileSettingKeys;
import cz.kpsys.portaro.file.FilepathLoadedIdentifiedFileFromValidFsFileCreator;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.IdentifiedFileModifier;
import cz.kpsys.portaro.file.IdentifiedFileUpdater;
import cz.kpsys.portaro.file.LoadedIdentifiedFileCreator;
import cz.kpsys.portaro.file.directory.DirectoryInsightLoader;
import cz.kpsys.portaro.file.directory.DirectoryLoader;
import cz.kpsys.portaro.file.directory.ParentableDirectory;
import cz.kpsys.portaro.file.directory.ParentableDirectoryCreator;
import cz.kpsys.portaro.file.directory.ParentableDirectoryUpdater;
import cz.kpsys.portaro.file.security.FileSecurityActions;
import cz.kpsys.portaro.file.security.IdentifiedFileDeletionCommand;
import cz.kpsys.portaro.file.security.IdentifiedFileSaveCommand;
import cz.kpsys.portaro.file.web.ByteArrayChunkedFileUploadService;
import cz.kpsys.portaro.file.web.ChunkedFileUploadService;
import cz.kpsys.portaro.file.web.FallbackingChunkedFileUploadService;
import cz.kpsys.portaro.file.web.FilePathChunkedFileUploadService;
import cz.kpsys.portaro.filter.FilterLoader;
import cz.kpsys.portaro.record.file.cover.CoverFactory;
import cz.kpsys.portaro.record.file.cover.CoverService;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.RangePaging;
import cz.kpsys.portaro.search.factory.SearchFactory;
import cz.kpsys.portaro.search.factory.SearchFactoryResolver;
import cz.kpsys.portaro.search.view.CompositeSearchFormFactory;
import cz.kpsys.portaro.search.view.SearchFormFactory;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.view.ViewFormat;
import cz.kpsys.portaro.view.ViewableItemsConverter;
import cz.kpsys.portaro.view.ViewableItemsTypedConverter;
import cz.kpsys.portaro.view.web.FileDownloadController;
import cz.kpsys.portaro.view.web.rest.FilterApiController;
import cz.kpsys.portaro.view.web.rest.file.DirectoryApiController;
import cz.kpsys.portaro.view.web.rest.file.FileApiController;
import cz.kpsys.portaro.view.web.rest.file.FileEditationRequest;
import cz.kpsys.portaro.view.web.rest.file.FilesToViewableFilesConverter;
import cz.kpsys.portaro.view.web.rest.record.RecordCoverApiController;
import java.beans.ConstructorProperties;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.transaction.support.TransactionOperations;

@Configuration
@Lazy
public class FileViewConfig {
    @NonNull
    private final FilterLoader filterLoader;
    @NonNull
    private final ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, IdentifiedFile> fileSearchLoader;
    @NonNull
    private final Saver<IdentifiedFileSaveCommand, IdentifiedFile> primaryCoverSavingLoadedIdentifiedFileSaver;
    @NonNull
    private final Deleter<IdentifiedFileDeletionCommand> securedIdentifiedFileDeleter;
    @NonNull
    private final DirectoryLoader directoryLoader;
    @NonNull
    private final Deleter<ParentableDirectory> parentableDirectoryDeleter;
    @NonNull
    private final DirectoryInsightLoader directoryInsightLoader;
    @NonNull
    private final FileDataStreamer securedFileThumbnailDataStreamer;
    @NonNull
    private final FileDataStreamer securedFileDataStreamer;
    @NonNull
    private final FileDataStreamer securedFileTextDataStreamer;
    @NonNull
    private final CoverService coverService;
    @NonNull
    private final @NonNull Provider<@NonNull FileAccessType> defaultFileAccessTypeProvider;
    @NonNull
    private final SearchFactoryResolver searchFactoryResolver;
    @NonNull
    private final ViewableItemsConverter viewableItemsConverter;
    @NonNull
    private final CompositeSearchFormFactory searchFormFactory;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final CoverFactory coverFactory;
    @NonNull
    private final ParentableDirectoryUpdater parentableDirectoryUpdater;
    @NonNull
    private final ParentableDirectoryCreator parentableDirectoryCreator;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final LocalFilesystemService localFilesystemService;
    @NonNull
    private final NamedParameterJdbcOperations notAutoCommittingJdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final DatabaseProperties databaseProperties;
    @NonNull
    private final Saver<IdentifiedFileSaveCommand, IdentifiedFile> loadedIdentifiedFileSaver;

    @Bean
    public FilterApiController filterApiController() {
        return new FilterApiController(this.filterLoader);
    }

    @Bean
    public FileApiController fileApiController() {
        return new FileApiController(this.identifiedFileLoader, this.fileSearchLoader, this.securedIdentifiedFileDeleter, this.chunkedFileUploadService(), this.primaryCoverSavingLoadedIdentifiedFileCreator(), this.identifiedFileUpdater(), this.identifiedFileModifier(), this.filesToViewableFilesConverter());
    }

    @Bean
    public LoadedIdentifiedFileCreator primaryCoverSavingLoadedIdentifiedFileCreator() {
        return new LoadedIdentifiedFileCreator(Provider.of((Supplier)IntegerValueDatabaseLoader.ofSequenceValueDbDependent((String)"seq_fulltext", (String)"fulltext_soubory_id_fulltext_seq", (NamedParameterJdbcOperations)this.notAutoCommittingJdbcTemplate, (QueryFactory)this.queryFactory, (DatabaseProperties)this.databaseProperties)), this.defaultTransactionTemplateFactory.get(), this.securedPrimaryCoverSavingLoadedIdentifiedFileSaver());
    }

    @Bean
    public LoadedIdentifiedFileCreator loadedIdentifiedFileCreator() {
        return new LoadedIdentifiedFileCreator(Provider.of((Supplier)IntegerValueDatabaseLoader.ofSequenceValueDbDependent((String)"seq_fulltext", (String)"fulltext_soubory_id_fulltext_seq", (NamedParameterJdbcOperations)this.notAutoCommittingJdbcTemplate, (QueryFactory)this.queryFactory, (DatabaseProperties)this.databaseProperties)), this.defaultTransactionTemplateFactory.get(), this.loadedIdentifiedFileSaver);
    }

    @Bean
    public FilepathLoadedIdentifiedFileFromValidFsFileCreator filepathLoadedIdentifiedFileCreator() {
        return new FilepathLoadedIdentifiedFileFromValidFsFileCreator(Provider.of((Supplier)IntegerValueDatabaseLoader.ofSequenceValueDbDependent((String)"seq_fulltext", (String)"fulltext_soubory_id_fulltext_seq", (NamedParameterJdbcOperations)this.notAutoCommittingJdbcTemplate, (QueryFactory)this.queryFactory, (DatabaseProperties)this.databaseProperties)), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public ByteArrayLoadedIdentifiedFileCreator byteArrayLoadedIdentifiedFileCreator() {
        return new ByteArrayLoadedIdentifiedFileCreator(this.defaultTransactionTemplateFactory.get());
    }

    public IdentifiedFileModifier identifiedFileModifier() {
        return new IdentifiedFileModifier(this.securedPrimaryCoverSavingLoadedIdentifiedFileSaver(), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public IdentifiedFileUpdater identifiedFileUpdater() {
        return new IdentifiedFileUpdater(this.defaultTransactionTemplateFactory.get(), this.securedPrimaryCoverSavingLoadedIdentifiedFileSaver());
    }

    @Bean
    public DirectoryApiController directoryApiController() {
        return new DirectoryApiController(this.directoryLoader, this.parentableDirectoryDeleter, this.directoryInsightLoader, this.defaultFileAccessTypeProvider, this.parentableDirectoryUpdater, this.parentableDirectoryCreator);
    }

    @Bean
    public JavaTempFileService javaTempFileService() {
        return new JavaTempFileService(Files.createTempDirectory("chunkedFiles", new FileAttribute[0]));
    }

    @Bean
    public ChunkedFileUploadService chunkedFileUploadService() {
        return new FallbackingChunkedFileUploadService((Provider)AndBooleanProvider.of((Provider[])new Provider[]{this.settingLoader.getOnRootProvider(FileSettingKeys.BLOB_DIR_ENABLED), this.settingLoader.getOnRootProvider(FileSettingKeys.PORTARO_BLOB_DIR_FILES_DIRECT_LOAD)}), (ChunkedFileUploadService)new FilePathChunkedFileUploadService(this.localFilesystemService, (TransactionOperations)this.defaultTransactionTemplateFactory.get(), (ByIdLoadable)this.directoryLoader, this.filepathLoadedIdentifiedFileCreator(), this.securedPrimaryCoverSavingLoadedIdentifiedFileSaver()), (ChunkedFileUploadService)new ByteArrayChunkedFileUploadService(this.javaTempFileService(), (TransactionOperations)this.defaultTransactionTemplateFactory.get(), (ByIdLoadable)this.directoryLoader, this.byteArrayLoadedIdentifiedFileCreator(), this.securedPrimaryCoverSavingLoadedIdentifiedFileSaver()));
    }

    @Bean
    public FilesToViewableFilesConverter filesToViewableFilesConverter() {
        return new FilesToViewableFilesConverter(this.securityManager);
    }

    @Bean
    public FileDownloadController fileDownloadController() {
        return new FileDownloadController(this.securedFileDataStreamer, this.securedFileThumbnailDataStreamer, this.securedFileTextDataStreamer, this.fileSearchLoader);
    }

    @Bean
    public RecordCoverApiController recordCoverApiController() {
        return new RecordCoverApiController(this.coverService, this.coverFactory);
    }

    @Bean
    public SearchFactory<RangePaging> fileSearchFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFormFactory fileSearchTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public CommandLineRunner fileSearchRegistrar() {
        return args -> {
            this.searchFactoryResolver.withStandardOrder(this.fileSearchFactory());
            this.viewableItemsConverter.register(IdentifiedFile.class, ViewFormat.STANDARD, (ViewableItemsTypedConverter)this.filesToViewableFilesConverter());
            this.searchFormFactory.add("file-search", this.fileSearchTypeSearchFormFactory());
        };
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<FileEditationRequest> fileEditationRequestDefaulter() {
        return new FileEditationRequest.FileEditationRequestDefaulter();
    }

    @Bean
    public Saver<IdentifiedFileSaveCommand, IdentifiedFile> securedPrimaryCoverSavingLoadedIdentifiedFileSaver() {
        return cmd -> {
            this.securityManager.throwIfCannot(FileSecurityActions.FILES_MANAGE, cmd.currentAuth(), cmd.ctx());
            return (IdentifiedFile)this.primaryCoverSavingLoadedIdentifiedFileSaver.save(cmd);
        };
    }

    @ConstructorProperties(value={"filterLoader", "identifiedFileLoader", "fileSearchLoader", "primaryCoverSavingLoadedIdentifiedFileSaver", "securedIdentifiedFileDeleter", "directoryLoader", "parentableDirectoryDeleter", "directoryInsightLoader", "securedFileThumbnailDataStreamer", "securedFileDataStreamer", "securedFileTextDataStreamer", "coverService", "defaultFileAccessTypeProvider", "searchFactoryResolver", "viewableItemsConverter", "searchFormFactory", "securityManager", "defaultTransactionTemplateFactory", "coverFactory", "parentableDirectoryUpdater", "parentableDirectoryCreator", "settingLoader", "localFilesystemService", "notAutoCommittingJdbcTemplate", "queryFactory", "databaseProperties", "loadedIdentifiedFileSaver"})
    @Generated
    public FileViewConfig(@NonNull FilterLoader filterLoader, @NonNull ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, IdentifiedFile> fileSearchLoader, @NonNull Saver<IdentifiedFileSaveCommand, IdentifiedFile> primaryCoverSavingLoadedIdentifiedFileSaver, @NonNull Deleter<IdentifiedFileDeletionCommand> securedIdentifiedFileDeleter, @NonNull DirectoryLoader directoryLoader, @NonNull Deleter<ParentableDirectory> parentableDirectoryDeleter, @NonNull DirectoryInsightLoader directoryInsightLoader, @NonNull FileDataStreamer securedFileThumbnailDataStreamer, @NonNull FileDataStreamer securedFileDataStreamer, @NonNull FileDataStreamer securedFileTextDataStreamer, @NonNull CoverService coverService, @NonNull @NonNull Provider<@NonNull FileAccessType> defaultFileAccessTypeProvider, @NonNull SearchFactoryResolver searchFactoryResolver, @NonNull ViewableItemsConverter viewableItemsConverter, @NonNull CompositeSearchFormFactory searchFormFactory, @NonNull SecurityManager securityManager, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull CoverFactory coverFactory, @NonNull ParentableDirectoryUpdater parentableDirectoryUpdater, @NonNull ParentableDirectoryCreator parentableDirectoryCreator, @NonNull SettingLoader settingLoader, @NonNull LocalFilesystemService localFilesystemService, @NonNull NamedParameterJdbcOperations notAutoCommittingJdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull DatabaseProperties databaseProperties, @NonNull Saver<IdentifiedFileSaveCommand, IdentifiedFile> loadedIdentifiedFileSaver) {
        Objects.requireNonNull(filterLoader, "filterLoader is marked non-null but is null");
        Objects.requireNonNull(identifiedFileLoader, "identifiedFileLoader is marked non-null but is null");
        Objects.requireNonNull(fileSearchLoader, "fileSearchLoader is marked non-null but is null");
        Objects.requireNonNull(primaryCoverSavingLoadedIdentifiedFileSaver, "primaryCoverSavingLoadedIdentifiedFileSaver is marked non-null but is null");
        Objects.requireNonNull(securedIdentifiedFileDeleter, "securedIdentifiedFileDeleter is marked non-null but is null");
        Objects.requireNonNull(directoryLoader, "directoryLoader is marked non-null but is null");
        Objects.requireNonNull(parentableDirectoryDeleter, "parentableDirectoryDeleter is marked non-null but is null");
        Objects.requireNonNull(directoryInsightLoader, "directoryInsightLoader is marked non-null but is null");
        Objects.requireNonNull(securedFileThumbnailDataStreamer, "securedFileThumbnailDataStreamer is marked non-null but is null");
        Objects.requireNonNull(securedFileDataStreamer, "securedFileDataStreamer is marked non-null but is null");
        Objects.requireNonNull(securedFileTextDataStreamer, "securedFileTextDataStreamer is marked non-null but is null");
        Objects.requireNonNull(coverService, "coverService is marked non-null but is null");
        Objects.requireNonNull(defaultFileAccessTypeProvider, "defaultFileAccessTypeProvider is marked non-null but is null");
        Objects.requireNonNull(searchFactoryResolver, "searchFactoryResolver is marked non-null but is null");
        Objects.requireNonNull(viewableItemsConverter, "viewableItemsConverter is marked non-null but is null");
        Objects.requireNonNull(searchFormFactory, "searchFormFactory is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(coverFactory, "coverFactory is marked non-null but is null");
        Objects.requireNonNull(parentableDirectoryUpdater, "parentableDirectoryUpdater is marked non-null but is null");
        Objects.requireNonNull(parentableDirectoryCreator, "parentableDirectoryCreator is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(localFilesystemService, "localFilesystemService is marked non-null but is null");
        Objects.requireNonNull(notAutoCommittingJdbcTemplate, "notAutoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(databaseProperties, "databaseProperties is marked non-null but is null");
        Objects.requireNonNull(loadedIdentifiedFileSaver, "loadedIdentifiedFileSaver is marked non-null but is null");
        this.filterLoader = filterLoader;
        this.identifiedFileLoader = identifiedFileLoader;
        this.fileSearchLoader = fileSearchLoader;
        this.primaryCoverSavingLoadedIdentifiedFileSaver = primaryCoverSavingLoadedIdentifiedFileSaver;
        this.securedIdentifiedFileDeleter = securedIdentifiedFileDeleter;
        this.directoryLoader = directoryLoader;
        this.parentableDirectoryDeleter = parentableDirectoryDeleter;
        this.directoryInsightLoader = directoryInsightLoader;
        this.securedFileThumbnailDataStreamer = securedFileThumbnailDataStreamer;
        this.securedFileDataStreamer = securedFileDataStreamer;
        this.securedFileTextDataStreamer = securedFileTextDataStreamer;
        this.coverService = coverService;
        this.defaultFileAccessTypeProvider = defaultFileAccessTypeProvider;
        this.searchFactoryResolver = searchFactoryResolver;
        this.viewableItemsConverter = viewableItemsConverter;
        this.searchFormFactory = searchFormFactory;
        this.securityManager = securityManager;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.coverFactory = coverFactory;
        this.parentableDirectoryUpdater = parentableDirectoryUpdater;
        this.parentableDirectoryCreator = parentableDirectoryCreator;
        this.settingLoader = settingLoader;
        this.localFilesystemService = localFilesystemService;
        this.notAutoCommittingJdbcTemplate = notAutoCommittingJdbcTemplate;
        this.queryFactory = queryFactory;
        this.databaseProperties = databaseProperties;
        this.loadedIdentifiedFileSaver = loadedIdentifiedFileSaver;
    }
}

