/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.auth.context.AuthenticatedContextualProvider;
import cz.kpsys.portaro.auth.context.TypedAuthenticatedContextualObjectModifier;
import cz.kpsys.portaro.commons.barcode.BarCodeValidator;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.localization.MultiText;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.Identified;
import cz.kpsys.portaro.commons.object.LabeledId;
import cz.kpsys.portaro.commons.object.LabeledIdentified;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.DataUtils;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.exemplar.Exemplar;
import cz.kpsys.portaro.exemplar.ExemplarSecurityActions;
import cz.kpsys.portaro.exemplar.ExemplarSequenceItemLoader;
import cz.kpsys.portaro.exemplar.ExemplarType;
import cz.kpsys.portaro.exemplar.accessnumber.AccessNumberSequenceItem;
import cz.kpsys.portaro.exemplar.accessnumber.AccessNumberSequenceLoader;
import cz.kpsys.portaro.exemplar.account.Account;
import cz.kpsys.portaro.exemplar.acquisitionway.AcquisitionWayLoader;
import cz.kpsys.portaro.exemplar.discard.DiscardNumberSequenceItem;
import cz.kpsys.portaro.exemplar.discard.DiscardNumberSequenceItemLoader;
import cz.kpsys.portaro.exemplar.discard.ExemplarDiscardionRequest;
import cz.kpsys.portaro.exemplar.exemplarstatus.ExemplarStatusLoader;
import cz.kpsys.portaro.exemplar.loancategory.LoanCategoryLoader;
import cz.kpsys.portaro.exemplar.location.MostSuitableEditableLocationAuthenticatedContextualProvider;
import cz.kpsys.portaro.exemplar.signature.SignatureSequenceItem;
import cz.kpsys.portaro.exemplar.signature.SignatureSequenceLoader;
import cz.kpsys.portaro.exemplar.thematicgroup.ThematicGroup;
import cz.kpsys.portaro.exemplar.volume.VolumeLoader;
import cz.kpsys.portaro.exemplar.volume.VolumePeriodicity;
import cz.kpsys.portaro.finance.Currency;
import cz.kpsys.portaro.form.valueeditor.ValueEditor;
import cz.kpsys.portaro.form.valueeditor.list.ListValueEditorModifier;
import cz.kpsys.portaro.form.valueeditor.list.ListValueEditorOptions;
import cz.kpsys.portaro.form.valueeditor.object.ObjectValueEditor;
import cz.kpsys.portaro.form.valueeditor.scannabletext.ScannableTextValueEditorModifier;
import cz.kpsys.portaro.formconfig.formfield.FormFieldsNamesContextualFunction;
import cz.kpsys.portaro.formconfig.valueeditor.CanDoActionResolver;
import cz.kpsys.portaro.location.DepartmentLocationRelationLoader;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.location.SmartDefaultLocationDepartmentedProvider;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.security.SecurityAccessor;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.sequence.DefaultSequenceItem;
import cz.kpsys.portaro.sequence.SequenceItem;
import cz.kpsys.portaro.setting.SettingKey;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarIdentifierRequest;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarRequest;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarRequestDefaulter;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarRequestPreValidationDefaultModifier;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarRequestToExemplarsConverter;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarRequestUtils;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarToExemplarRequestConverter;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class ExemplarEditConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExemplarEditConfig.class);
    @NonNull
    private final SecurityAccessor securityAccessor;
    @NonNull
    private final ByIdLoadable<Location, Integer> locationLoader;
    @NonNull
    private final DepartmentLocationRelationLoader departmentLocationRelationLoader;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final DiscardNumberSequenceItemLoader<SequenceItem> fromDiscardionsDiscardNumberSequenceItemLoader;
    @NonNull
    private final @NonNull ContextualProvider<Department, @NonNull ThematicGroup> defaultThematicGroupProvider;
    @NonNull
    private final AcquisitionWayLoader acquisitionWayLoader;
    @NonNull
    private final LoanCategoryLoader loanCategoryLoader;
    @NonNull
    private final ExemplarStatusLoader exemplarStatusLoader;
    @NonNull
    private final VolumeLoader volumeLoader;
    @NonNull
    private final ByIdLoadable<Record, UUID> nonDetailedDocumentLoader;
    @NonNull
    private final ExemplarSequenceItemLoader<AccessNumberSequenceItem> accessNumberSequenceItemLoader;
    @NonNull
    private final ExemplarSequenceItemLoader<SignatureSequenceItem> signatureSequenceItemLoader;
    @NonNull
    private final AccessNumberSequenceLoader accessNumberSequenceLoader;
    @NonNull
    private final SignatureSequenceLoader signatureSequenceLoader;
    @NonNull
    private final ContextualProvider<Department, BarCodeValidator> exemplarBarCodeValidatorProvider;
    @NonNull
    private final @NonNull Provider<@NonNull Account> defaultAccountProvider;
    @NonNull
    private final @NonNull Provider<@NonNull Currency> defaultCurrencyProvider;
    @NonNull
    private final AuthenticatedContextualProvider<Department, List<Department>> editableDepartmentsAuthenticatedContextualProvider;
    @NonNull
    private final AuthenticatedContextualProvider<Department, List<Location>> editableLocationsAuthenticatedContextualProvider;
    @NonNull
    private final DiscardNumberSequenceItemLoader<DiscardNumberSequenceItem> fromSequenceDiscardNumberSequenceItemLoader;

    @Bean
    public ContextualProvider<Department, @NonNull Location> defaultLocationDepartmentedProvider() {
        return new SmartDefaultLocationDepartmentedProvider(this.settingLoader.getDepartmentedProvider(SettingKeys.DEFAULT_LOCATION), this.locationLoader, this.departmentLocationRelationLoader);
    }

    @Bean
    public AuthenticatedContextualProvider<Department, List<Department>> exemplarableEditableDepartmentsAuthenticatedContextualProvider() {
        return this.editableDepartmentsAuthenticatedContextualProvider.andThen(departments -> departments.stream().filter(Department::getExemplarable).distinct().toList());
    }

    @Bean
    public CanDoActionResolver<ExemplarIdentifierRequest> exemplarEditCanGenerateField() {
        return (form, ctx, currentAuth) -> this.securityManager.can(ExemplarSecurityActions.EXEMPLAR_FIELD_GENERATE, currentAuth, ctx);
    }

    @Bean
    public AllValuesProvider<ExemplarType> exemplarTypeLoader() {
        return ExemplarType.CODEBOOK;
    }

    @Bean
    public FormFieldsNamesContextualFunction<ExemplarRequest, Department> editableExemplarRequestPropsProvider() {
        return (exemplarRequest, ctx) -> {
            ContextualProvider propsProvider = exemplarRequest.volume() != null ? this.editableIssuePropsDepartmentedProvider() : this.editableExemplarPropsDepartmentedProvider();
            ArrayList<String> all = new ArrayList<String>((Collection)propsProvider.getOn(ctx));
            boolean addIdentifiers = all.stream().anyMatch(item -> "accessNumber".equals(item) || "signature".equals(item) || "barCode".equals(item));
            if (addIdentifiers) {
                all.add("identifiers");
            }
            return all;
        };
    }

    @Bean
    public FormFieldsNamesContextualFunction<ExemplarIdentifierRequest, Department> editableExemplarRequestIdentifiersPropsProvider() {
        return (exemplarIdentifierRequest, ctx) -> {
            SettingKey settingKey = exemplarIdentifierRequest.getParentForm().volume() != null ? SettingKeys.EDITABLE_ISSUE_PROPS : SettingKeys.EDITABLE_EXEMPLAR_PROPS;
            return (List)this.settingLoader.getDepartmentedProvider(settingKey).getOn(ctx);
        };
    }

    @Bean
    public ScannableTextValueEditorModifier<ExemplarIdentifierRequest> exemplarEditationBarCodeScannableTextEditorAnnotationModifier() {
        return (editor, formObject, ctx) -> editor.withPatternValidation(((BarCodeValidator)this.exemplarBarCodeValidatorProvider.getOn((Object)ctx)).getEditorValidationPattern());
    }

    @Bean
    public ListValueEditorModifier<ObjectValueEditor, ExemplarIdentifierRequest, ExemplarRequest> exemplarRequestListEditorModifier() {
        return (editor, exemplarRequest, ctx) -> {
            if (DataUtils.isPersisted((Identified)exemplarRequest)) {
                ObjectValueEditor objectValueEditor = editor.getOptions().flatMap(ListValueEditorOptions::getSubEditor).map(ove -> ove.withDisabled(Boolean.valueOf(false))).orElseThrow(() -> new IllegalArgumentException("Object value editor is null, but it should not happen"));
                return editor.withDisabled(Boolean.valueOf(true)).withSubEditor((ValueEditor)objectValueEditor);
            }
            return editor;
        };
    }

    @Bean
    public ContextualProvider<Department, List<String>> editableIssuePropsDepartmentedProvider() {
        return this.settingLoader.getDepartmentedProvider(SettingKeys.EDITABLE_ISSUE_PROPS);
    }

    @Bean
    public ContextualProvider<Department, List<String>> editableExemplarPropsDepartmentedProvider() {
        return this.settingLoader.getDepartmentedProvider(SettingKeys.EDITABLE_EXEMPLAR_PROPS);
    }

    @Bean
    public AuthenticatedContextualProvider<Department, Location> mostSuitableEditableLocationAuthenticatedContextualProvider() {
        return new MostSuitableEditableLocationAuthenticatedContextualProvider(this.editableDepartmentsAuthenticatedContextualProvider, this.defaultLocationDepartmentedProvider(), this.departmentLocationRelationLoader);
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<ExemplarRequest> exemplarRequestDefaulter() {
        return new ExemplarRequestDefaulter(this.defaultThematicGroupProvider, this.acquisitionWayLoader, this.loanCategoryLoader, this.exemplarStatusLoader, this.exemplarRequestPreValidationDefaultModifier(), this.securityAccessor, this.mostSuitableEditableLocationAuthenticatedContextualProvider(), this.defaultAccountProvider, this.defaultCurrencyProvider, false);
    }

    @Bean
    public ExemplarRequestDefaulter importingExemplarRequestDefaulter() {
        return new ExemplarRequestDefaulter(this.defaultThematicGroupProvider, this.acquisitionWayLoader, this.loanCategoryLoader, this.exemplarStatusLoader, this.exemplarRequestPreValidationDefaultModifier(), this.securityAccessor, this.mostSuitableEditableLocationAuthenticatedContextualProvider(), this.defaultAccountProvider, this.defaultCurrencyProvider, true);
    }

    @Bean
    public ExemplarRequestUtils exemplarRequestUtils() {
        return new ExemplarRequestUtils(this.signatureSequenceItemLoader, this.signatureSequenceLoader, this.accessNumberSequenceItemLoader, this.accessNumberSequenceLoader);
    }

    @Bean
    public ExemplarRequestPreValidationDefaultModifier exemplarRequestPreValidationDefaultModifier() {
        return new ExemplarRequestPreValidationDefaultModifier(this.securityManager, this.securityAccessor, this.editableLocationsAuthenticatedContextualProvider, this.defaultLocationDepartmentedProvider(), this.editableIssuePropsDepartmentedProvider(), this.editableExemplarPropsDepartmentedProvider(), this.exemplarRequestUtils(), this.defaultThematicGroupProvider, this.acquisitionWayLoader, this.exemplarStatusLoader, this.loanCategoryLoader, this.defaultAccountProvider);
    }

    @Bean
    public AuthenticatedContextualProvider<Department, List<LabeledIdentified<String>>> discardNumberSequenceAuthenticatedContextualProvider() {
        return (currentAuth, ctx) -> {
            List<DefaultSequenceItem> discardNumbersByDiscardions = this.fromDiscardionsDiscardNumberSequenceItemLoader.get((List)this.editableDepartmentsAuthenticatedContextualProvider.getOn(currentAuth, ctx));
            if (discardNumbersByDiscardions.isEmpty()) {
                discardNumbersByDiscardions = List.of(new DefaultSequenceItem().next());
            }
            List discardNumberBySequences = this.fromSequenceDiscardNumberSequenceItemLoader.get(List.of());
            List all = ListUtil.union((Collection[])new Collection[]{discardNumbersByDiscardions, discardNumberBySequences});
            List selectableDiscardNumbers = ListUtil.convert((Iterable)all, source -> new LabeledId((Serializable)((Object)((String)source.getValue())), (Text)MultiText.ofTexts((String)"{} ({})", (Text[])new Text[]{Texts.ofNative((String)((String)source.getValue())), Texts.ofMessageCoded((String)"exemplar.edit.generated")})));
            return ListUtil.removeDuplicates((List)selectableDiscardNumbers);
        };
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<ExemplarDiscardionRequest> discardionRequestDefaulter() {
        return new ExemplarDiscardionRequest.DiscardionRequestDefaulter(this.discardNumberSequenceAuthenticatedContextualProvider());
    }

    @Bean
    public AllValuesProvider<VolumePeriodicity> volumePeriodicity() {
        return VolumePeriodicity.CODEBOOK;
    }

    @Bean
    public ExemplarIdentifierRequest exemplarRequestIdentifiersPrototype() {
        return new ExemplarIdentifierRequest(null, null, null, null);
    }

    @Bean
    public Converter<ExemplarRequest, List<Exemplar>> exemplarRequestToExemplarsConverter() {
        return new ExemplarRequestToExemplarsConverter();
    }

    @Bean
    public Converter<Exemplar, ExemplarRequest> exemplarToExemplarRequestConverter() {
        return new ExemplarToExemplarRequestConverter(this.nonDetailedDocumentLoader, this.volumeLoader);
    }

    @ConstructorProperties(value={"securityAccessor", "locationLoader", "departmentLocationRelationLoader", "securityManager", "settingLoader", "fromDiscardionsDiscardNumberSequenceItemLoader", "defaultThematicGroupProvider", "acquisitionWayLoader", "loanCategoryLoader", "exemplarStatusLoader", "volumeLoader", "nonDetailedDocumentLoader", "accessNumberSequenceItemLoader", "signatureSequenceItemLoader", "accessNumberSequenceLoader", "signatureSequenceLoader", "exemplarBarCodeValidatorProvider", "defaultAccountProvider", "defaultCurrencyProvider", "editableDepartmentsAuthenticatedContextualProvider", "editableLocationsAuthenticatedContextualProvider", "fromSequenceDiscardNumberSequenceItemLoader"})
    @Generated
    public ExemplarEditConfig(@NonNull SecurityAccessor securityAccessor, @NonNull ByIdLoadable<Location, Integer> locationLoader, @NonNull DepartmentLocationRelationLoader departmentLocationRelationLoader, @NonNull SecurityManager securityManager, @NonNull SettingLoader settingLoader, @NonNull DiscardNumberSequenceItemLoader<SequenceItem> fromDiscardionsDiscardNumberSequenceItemLoader, @NonNull @NonNull ContextualProvider<Department, @NonNull ThematicGroup> defaultThematicGroupProvider, @NonNull AcquisitionWayLoader acquisitionWayLoader, @NonNull LoanCategoryLoader loanCategoryLoader, @NonNull ExemplarStatusLoader exemplarStatusLoader, @NonNull VolumeLoader volumeLoader, @NonNull ByIdLoadable<Record, UUID> nonDetailedDocumentLoader, @NonNull ExemplarSequenceItemLoader<AccessNumberSequenceItem> accessNumberSequenceItemLoader, @NonNull ExemplarSequenceItemLoader<SignatureSequenceItem> signatureSequenceItemLoader, @NonNull AccessNumberSequenceLoader accessNumberSequenceLoader, @NonNull SignatureSequenceLoader signatureSequenceLoader, @NonNull ContextualProvider<Department, BarCodeValidator> exemplarBarCodeValidatorProvider, @NonNull @NonNull Provider<@NonNull Account> defaultAccountProvider, @NonNull @NonNull Provider<@NonNull Currency> defaultCurrencyProvider, @NonNull AuthenticatedContextualProvider<Department, List<Department>> editableDepartmentsAuthenticatedContextualProvider, @NonNull AuthenticatedContextualProvider<Department, List<Location>> editableLocationsAuthenticatedContextualProvider, @NonNull DiscardNumberSequenceItemLoader<DiscardNumberSequenceItem> fromSequenceDiscardNumberSequenceItemLoader) {
        Objects.requireNonNull(securityAccessor, "securityAccessor is marked non-null but is null");
        Objects.requireNonNull(locationLoader, "locationLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLocationRelationLoader, "departmentLocationRelationLoader is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(fromDiscardionsDiscardNumberSequenceItemLoader, "fromDiscardionsDiscardNumberSequenceItemLoader is marked non-null but is null");
        Objects.requireNonNull(defaultThematicGroupProvider, "defaultThematicGroupProvider is marked non-null but is null");
        Objects.requireNonNull(acquisitionWayLoader, "acquisitionWayLoader is marked non-null but is null");
        Objects.requireNonNull(loanCategoryLoader, "loanCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarStatusLoader, "exemplarStatusLoader is marked non-null but is null");
        Objects.requireNonNull(volumeLoader, "volumeLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentLoader, "nonDetailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(accessNumberSequenceItemLoader, "accessNumberSequenceItemLoader is marked non-null but is null");
        Objects.requireNonNull(signatureSequenceItemLoader, "signatureSequenceItemLoader is marked non-null but is null");
        Objects.requireNonNull(accessNumberSequenceLoader, "accessNumberSequenceLoader is marked non-null but is null");
        Objects.requireNonNull(signatureSequenceLoader, "signatureSequenceLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarBarCodeValidatorProvider, "exemplarBarCodeValidatorProvider is marked non-null but is null");
        Objects.requireNonNull(defaultAccountProvider, "defaultAccountProvider is marked non-null but is null");
        Objects.requireNonNull(defaultCurrencyProvider, "defaultCurrencyProvider is marked non-null but is null");
        Objects.requireNonNull(editableDepartmentsAuthenticatedContextualProvider, "editableDepartmentsAuthenticatedContextualProvider is marked non-null but is null");
        Objects.requireNonNull(editableLocationsAuthenticatedContextualProvider, "editableLocationsAuthenticatedContextualProvider is marked non-null but is null");
        Objects.requireNonNull(fromSequenceDiscardNumberSequenceItemLoader, "fromSequenceDiscardNumberSequenceItemLoader is marked non-null but is null");
        this.securityAccessor = securityAccessor;
        this.locationLoader = locationLoader;
        this.departmentLocationRelationLoader = departmentLocationRelationLoader;
        this.securityManager = securityManager;
        this.settingLoader = settingLoader;
        this.fromDiscardionsDiscardNumberSequenceItemLoader = fromDiscardionsDiscardNumberSequenceItemLoader;
        this.defaultThematicGroupProvider = defaultThematicGroupProvider;
        this.acquisitionWayLoader = acquisitionWayLoader;
        this.loanCategoryLoader = loanCategoryLoader;
        this.exemplarStatusLoader = exemplarStatusLoader;
        this.volumeLoader = volumeLoader;
        this.nonDetailedDocumentLoader = nonDetailedDocumentLoader;
        this.accessNumberSequenceItemLoader = accessNumberSequenceItemLoader;
        this.signatureSequenceItemLoader = signatureSequenceItemLoader;
        this.accessNumberSequenceLoader = accessNumberSequenceLoader;
        this.signatureSequenceLoader = signatureSequenceLoader;
        this.exemplarBarCodeValidatorProvider = exemplarBarCodeValidatorProvider;
        this.defaultAccountProvider = defaultAccountProvider;
        this.defaultCurrencyProvider = defaultCurrencyProvider;
        this.editableDepartmentsAuthenticatedContextualProvider = editableDepartmentsAuthenticatedContextualProvider;
        this.editableLocationsAuthenticatedContextualProvider = editableLocationsAuthenticatedContextualProvider;
        this.fromSequenceDiscardNumberSequenceItemLoader = fromSequenceDiscardNumberSequenceItemLoader;
    }
}

