/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.alert.Alert;
import cz.kpsys.portaro.alert.ConditionalAlertsProvider;
import cz.kpsys.portaro.alert.NotEmptyValueCheckingAlertsProvider;
import cz.kpsys.portaro.alert.SimpleAlert;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.StaticContextualDelegatingProvider;
import cz.kpsys.portaro.commons.localization.MultiText;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.CompositeAddableAllValuesProvider;
import cz.kpsys.portaro.commons.object.ProvidedProxiedList;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.TtlCachedProvider;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.commons.util.UrlUtils;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.portaro.commons.web.CompositeListWebResolver;
import cz.kpsys.portaro.commons.web.RequestIgnoringWebResolver;
import cz.kpsys.portaro.commons.web.UserAgentConstants;
import cz.kpsys.portaro.commons.web.WebResolver;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.licence.BusinessVersion;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.portaro.monitoring.health.AppserverHealthMonitor;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.SettingLoader;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
public class AlertConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertConfig.class);
    @NonNull
    private final CompositeListWebResolver<Alert> alertsWebResolver;
    @NonNull
    private final CompositeAddableAllValuesProvider<Alert> globalAlertsProvider;
    @NonNull
    private final AppserverHealthMonitor appserverHealthMonitor;
    @NonNull
    private final SettingLoader settingLoader;
    private final @NonNull Provider<@NullableNotBlank String> rootServerUrlProvider;
    private final @NonNull ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider;
    @NonNull
    private final @NonNull Provider<@NonNull Licence> licenceProvider;
    @NonNull
    private final @NonNull Provider<@NonNull BusinessVersion> currentVersionProvider;
    @NonNull
    private final @NonNull Provider<@NonNull BusinessVersion> licenceVersionProvider;
    @NonNull
    private final @NonNull Provider<@NonNull Department> realRootDepartmentProvider;

    @Bean
    public AllValuesProvider<Alert> testingVersionCheckingAlerter() {
        return ConditionalAlertsProvider.of(() -> ((Licence)this.licenceProvider.get()).testing(), (Alert)SimpleAlert.ofDanger((Text)Texts.ofStaticallyLocalized((String)"This is only preview/demo version of Verbis system, data may not be up to date.").addCzech("Toto je pouze uk\u00e1zkov\u00e1/demo verze syst\u00e9mu Verbis, data nemusej\u00ed b\u00fdt skute\u010dn\u00e1 a aktu\u00e1ln\u00ed.")));
    }

    @Bean
    public AllValuesProvider<Alert> licenceVersionCheckingAlerter() {
        return ConditionalAlertsProvider.of(() -> !((BusinessVersion)this.licenceVersionProvider.get()).isAtLeast((BusinessVersion)this.currentVersionProvider.get()), (Alert)SimpleAlert.ofDanger((Text)Texts.ofStaticallyLocalized((String)"Licence is issued for lower software version (%s) than this one (%s).".formatted(((BusinessVersion)this.licenceVersionProvider.get()).getValue(), ((BusinessVersion)this.currentVersionProvider.get()).getValue())).addCzech("Licence je vydan\u00e1 pro ni\u017e\u0161\u00ed verzi softwaru (%s) ne\u017e je tato (%s).".formatted(((BusinessVersion)this.licenceVersionProvider.get()).getValue(), ((BusinessVersion)this.currentVersionProvider.get()).getValue()))));
    }

    @Bean
    public AllValuesProvider<Alert> serverUrlSetCheckingAlerter() {
        return new NotEmptyValueCheckingAlertsProvider(this.rootServerUrlProvider, (Alert)SimpleAlert.ofDanger((Text)Texts.ofStaticallyLocalized((String)"Server address in OPAC.URL settings is not set, some features may not work correctly.").addCzech("Nenastavena adresa serveru v nastaven\u00ed OPAC.URL, n\u011bkter\u00e9 funkce nemusej\u00ed pracovat spr\u00e1vn\u011b.")));
    }

    @Bean
    public AllValuesProvider<Alert> appserverHealthCheckingAlerter() {
        return ConditionalAlertsProvider.of(() -> !this.appserverHealthMonitor.isUp() && (Boolean)this.settingLoader.getOnRootProvider(SettingKeys.APPSERVER_ENABLED).get() != false, (Alert)SimpleAlert.ofDanger((Text)Texts.ofStaticallyLocalized((String)"Application server is currently unavailable, some features may not work correctly.").addCzech("Aplika\u010dn\u00ed server je moment\u00e1ln\u011b nedostupn\u00fd, n\u011bkter\u00e9 funkce nemus\u00ed fungovat spr\u00e1vn\u011b")));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Bean
    public AllValuesProvider<Alert> licenceServerUrlCheckingAlerter() {
        @NullableNotBlank StaticContextualDelegatingProvider realRootDepartmentServerUrlProvider = new StaticContextualDelegatingProvider(this.serverUrlProvider, this.realRootDepartmentProvider);
        return () -> this.lambda$licenceServerUrlCheckingAlerter$0((Provider)realRootDepartmentServerUrlProvider);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Bean
    public WebResolver<List<Alert>> registeredUrlAccessCheckingAlertWebResolver() {
        @NonNull @NonNull ProvidedProxiedList serverUrls = new ProvidedProxiedList((Provider)TtlCachedProvider.ofSeconds((long)10L, () -> new ArrayList(this.settingLoader.getContextToValueMap(CoreSettingKeys.SERVER_URL).values())));
        return arg_0 -> AlertConfig.lambda$registeredUrlAccessCheckingAlertWebResolver$1((List)serverUrls, arg_0);
    }

    @Bean
    public WebResolver<List<Alert>> supportedBrowsersCheckingAlertWebResolver() {
        return request -> {
            String userAgent = request.getHeader("User-Agent");
            if (UserAgentConstants.SUPPORTED_BROWSERS_REGEX.matcher(userAgent).find()) {
                return Optional.empty();
            }
            SimpleAlert alert = SimpleAlert.ofDanger((Text)Texts.ofMessageCoded((String)"commons.YouAreUsingUnsupportedBrowserMessage"));
            return Optional.of(List.of(alert));
        };
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerAlerts() {
        this.alertsWebResolver.add((WebResolver)RequestIgnoringWebResolver.ofNonNullProvider(() -> ((CompositeAddableAllValuesProvider)this.globalAlertsProvider).getAll()));
        this.alertsWebResolver.add(this.registeredUrlAccessCheckingAlertWebResolver());
        this.alertsWebResolver.add(this.supportedBrowsersCheckingAlertWebResolver());
        this.globalAlertsProvider.withProvider(this.testingVersionCheckingAlerter());
        this.globalAlertsProvider.withProvider(this.licenceVersionCheckingAlerter());
        this.globalAlertsProvider.withProvider(this.serverUrlSetCheckingAlerter());
        this.globalAlertsProvider.withProvider(this.appserverHealthCheckingAlerter());
        this.globalAlertsProvider.withProvider(this.licenceServerUrlCheckingAlerter());
    }

    @ConstructorProperties(value={"alertsWebResolver", "globalAlertsProvider", "appserverHealthMonitor", "settingLoader", "rootServerUrlProvider", "serverUrlProvider", "licenceProvider", "currentVersionProvider", "licenceVersionProvider", "realRootDepartmentProvider"})
    @Generated
    public AlertConfig(@NonNull CompositeListWebResolver<Alert> alertsWebResolver, @NonNull CompositeAddableAllValuesProvider<Alert> globalAlertsProvider, @NonNull AppserverHealthMonitor appserverHealthMonitor, @NonNull SettingLoader settingLoader, @NonNull Provider<@NullableNotBlank String> rootServerUrlProvider, @NonNull ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider, @NonNull @NonNull Provider<@NonNull Licence> licenceProvider, @NonNull @NonNull Provider<@NonNull BusinessVersion> currentVersionProvider, @NonNull @NonNull Provider<@NonNull BusinessVersion> licenceVersionProvider, @NonNull @NonNull Provider<@NonNull Department> realRootDepartmentProvider) {
        Objects.requireNonNull(alertsWebResolver, "alertsWebResolver is marked non-null but is null");
        Objects.requireNonNull(globalAlertsProvider, "globalAlertsProvider is marked non-null but is null");
        Objects.requireNonNull(appserverHealthMonitor, "appserverHealthMonitor is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(rootServerUrlProvider, "rootServerUrlProvider is marked non-null but is null");
        Objects.requireNonNull(serverUrlProvider, "serverUrlProvider is marked non-null but is null");
        Objects.requireNonNull(licenceProvider, "licenceProvider is marked non-null but is null");
        Objects.requireNonNull(currentVersionProvider, "currentVersionProvider is marked non-null but is null");
        Objects.requireNonNull(licenceVersionProvider, "licenceVersionProvider is marked non-null but is null");
        Objects.requireNonNull(realRootDepartmentProvider, "realRootDepartmentProvider is marked non-null but is null");
        this.alertsWebResolver = alertsWebResolver;
        this.globalAlertsProvider = globalAlertsProvider;
        this.appserverHealthMonitor = appserverHealthMonitor;
        this.settingLoader = settingLoader;
        this.rootServerUrlProvider = rootServerUrlProvider;
        this.serverUrlProvider = serverUrlProvider;
        this.licenceProvider = licenceProvider;
        this.currentVersionProvider = currentVersionProvider;
        this.licenceVersionProvider = licenceVersionProvider;
        this.realRootDepartmentProvider = realRootDepartmentProvider;
    }

    private static /* synthetic */ Optional lambda$registeredUrlAccessCheckingAlertWebResolver$1(List serverUrls, HttpServletRequest request) {
        String requestHostAndPort = UrlUtils.getPublicRequestHostAndPort((HttpServletRequest)request);
        List registeredHostAndPorts = ListUtil.convert((Iterable)serverUrls, UrlUtils::removeScheme);
        boolean matches = registeredHostAndPorts.contains(requestHostAndPort);
        if (matches) {
            return Optional.empty();
        }
        SimpleAlert alert = SimpleAlert.ofDanger((Text)MultiText.ofTexts((String)"K syst\u00e9mu p\u0159istupujete p\u0159es neregistrovanou adresu '{}'. Kontaktujte pros\u00edm knihovnu pro spr\u00e1vn\u00e9 nastaven\u00ed.", (Text[])new Text[]{Texts.ofNative((String)requestHostAndPort)}));
        return Optional.of(List.of(alert));
    }

    private /* synthetic */ List lambda$licenceServerUrlCheckingAlerter$0(Provider realRootDepartmentServerUrlProvider) {
        String iniServerUrl = (String)realRootDepartmentServerUrlProvider.get();
        if (iniServerUrl == null) {
            return List.of();
        }
        Licence licence = (Licence)this.licenceProvider.get();
        String licenceServerUrl = licence.rootUrl();
        if (licenceServerUrl == null) {
            return List.of();
        }
        if (iniServerUrl.equals(licenceServerUrl)) {
            return List.of();
        }
        if ((licence.testing() || licence.localhostAllowed()) && iniServerUrl.equals("http://localhost")) {
            return List.of();
        }
        MultiText text = MultiText.ofTexts((String)"Licence softwaru je vyd\u00e1na pro pou\u017eit\u00ed na adrese '{}', kter\u00e1 nesouhlas\u00ed s aktu\u00e1ln\u011b nastavenou (v ini) '{}'.", (Text[])new Text[]{Texts.ofNativeOrEmpty((String)licenceServerUrl), Texts.ofNativeOrEmpty((String)iniServerUrl)});
        return List.of(SimpleAlert.ofDanger((Text)text));
    }
}

