/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro;

import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.dml.UnsupportingDmlAppserverService;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.io.UnsupportingFileDataStreamer;
import cz.kpsys.portaro.commons.object.Settable;
import cz.kpsys.portaro.commons.object.SettableProvider;
import cz.kpsys.portaro.commons.util.StringUtil;
import cz.kpsys.portaro.database.DatabaseProductNameProvider;
import cz.kpsys.portaro.databaseproperties.DataSourceFactory;
import cz.kpsys.portaro.databaseproperties.DatabaseConnectionSettings;
import cz.kpsys.portaro.databaseproperties.DatabaseProperties;
import cz.kpsys.portaro.databaseproperties.ParsedConnectionDefinition;
import cz.kpsys.portaro.licence.BusinessVersion;
import cz.kpsys.portaro.licence.EnumeratedBusinessVersion;
import cz.kpsys.portaro.licence.LicenceKeyDecoder;
import cz.kpsys.portaro.licence.valcode.CipheredValidationCodeLicenceKeyDecoder;
import cz.kpsys.portaro.licence.valcode.DecipheredValidationCodeLicenceKeyDecoder;
import cz.kpsys.portaro.resourcesupdate.DbFileUpdateFactory;
import cz.kpsys.portaro.resourcesupdate.Portaro13UpdatesProvider;
import cz.kpsys.portaro.resourcesupdate.ResourcesUpdater;
import cz.kpsys.portaro.resourcesupdate.ResourcesUpdaterImpl;
import cz.kpsys.portaro.resourcesupdate.SpringDbCurrentVersionSettableProvider;
import cz.kpsys.portaro.resourcesupdate.TextualInteractiveUpdater;
import cz.kpsys.portaro.resourcesupdate.UpdateFactory;
import cz.kpsys.portaro.resourcesupdate.UpdatesProvider;
import cz.kpsys.portaro.resourcesupdate.migrationto20.Migration13To20UpdatesProvider;
import cz.kpsys.portaro.resourcesupdate.migrationto20.SerialCodeNotExistsOrNotValidException;
import cz.kpsys.portaro.resourcesupdate.migrationto20.V13IniCustomValueUpserter;
import cz.kpsys.portaro.resourcesupdate.migrationto20.ValidationCodeNotExistsNotSufficientException;
import java.time.ZoneId;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.beryx.textio.TextIoFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.jdbc.core.JdbcTemplate;

@PropertySource(value={"classpath:git.properties"}, ignoreResourceNotFound=true)
@Configuration
@Profile(value={"update"})
public class PortaroUpdaterApplication {
    private static final String DEFAULT_DATABASE_HOST = "localhost";
    private static final int DEFAULT_DATABASE_PORT = 3050;
    @Value(value="${database.host}")
    private String forcedDatabaseHost;
    @Value(value="${database.port}")
    private int forcedDatabasePort;
    @Value(value="${database.file}")
    private String databaseFile;
    @Value(value="${database.firebirdDbUpdateUsername}")
    private String firebirdDbUpdateUsername;
    @Value(value="${database.firebirdDbUpdatePassword}")
    private String firebirdDbUpdatePassword;

    @Bean
    public DatabaseProperties dbUpdateDatabaseProperties() {
        String databaseHost = StringUtil.firstNotEmpty((String[])new String[]{this.forcedDatabaseHost, DEFAULT_DATABASE_HOST});
        int databasePort = this.forcedDatabasePort > 0 ? this.forcedDatabasePort : 3050;
        return DatabaseProperties.ofAutodetectedType((ParsedConnectionDefinition)new ParsedConnectionDefinition("firebird", databaseHost, Integer.valueOf(databasePort), this.databaseFile, this.firebirdDbUpdateUsername, this.firebirdDbUpdatePassword));
    }

    @Bean
    public DataSource dbUpdateDataSource() {
        return DataSourceFactory.createDbUpdateDataSource((DatabaseConnectionSettings)this.dbUpdateDatabaseProperties(), (ZoneId)CoreConstants.CZECH_TIME_ZONE_ID, cfg -> {});
    }

    @Bean
    public TextualInteractiveUpdater textualInteractiveUpdaterTo2_0() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dbUpdateDataSource());
        DatabaseProperties dbUpdateDatabaseProperties = this.dbUpdateDatabaseProperties();
        UpdateFactory updateFactory = new UpdateFactory(jdbcTemplate, dbUpdateDatabaseProperties.getType(), (Supplier)new DatabaseProductNameProvider(jdbcTemplate));
        Migration13To20UpdatesProvider migration13To20Updates = new Migration13To20UpdatesProvider(updateFactory, jdbcTemplate, validationCodeCipher -> new CipheredValidationCodeLicenceKeyDecoder((LicenceKeyDecoder)new DecipheredValidationCodeLicenceKeyDecoder()).decode(validationCodeCipher).licenceVersion().isAtLeast((BusinessVersion)EnumeratedBusinessVersion.V2_0)).withDeleteAllOtherConnectionsBeforeUpdate();
        String versionColumn = "VERSION_MIG_2_0";
        SpringDbCurrentVersionSettableProvider currentVersionProvider = new SpringDbCurrentVersionSettableProvider(jdbcTemplate, versionColumn);
        ResourcesUpdaterImpl updater13To20 = new ResourcesUpdaterImpl((SettableProvider)currentVersionProvider, (UpdatesProvider)migration13To20Updates, true);
        return new TextualInteractiveUpdater(TextIoFactory.getTextTerminal(), (ResourcesUpdater)updater13To20, (Settable)currentVersionProvider, arg_0 -> ((JdbcTemplate)jdbcTemplate).update(arg_0)).withExceptionQuestion(SerialCodeNotExistsOrNotValidException.class, "Please, enter serial number", (Consumer)new V13IniCustomValueUpserter("KPWIN", "SERIAL", updateFactory, jdbcTemplate)).withExceptionQuestion(ValidationCodeNotExistsNotSufficientException.class, "Please, enter 2.0 validation code", (Consumer)new V13IniCustomValueUpserter("KPWIN", "VALKOD", updateFactory, jdbcTemplate));
    }

    @Bean
    public TextualInteractiveUpdater textualInteractiveUpdaterGlobal() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dbUpdateDataSource());
        DatabaseProperties dbUpdateDatabaseProperties = this.dbUpdateDatabaseProperties();
        UpdateFactory updateFactory = new UpdateFactory(jdbcTemplate, dbUpdateDatabaseProperties.getType(), (Supplier)new DatabaseProductNameProvider(jdbcTemplate));
        Portaro13UpdatesProvider updatesFillerGlobal = new Portaro13UpdatesProvider(updateFactory, jdbcTemplate, null, new DbFileUpdateFactory(updateFactory, jdbcTemplate, (DmlAppserverService)new UnsupportingDmlAppserverService(), (FileDataStreamer)new UnsupportingFileDataStreamer()));
        String versionColumn = "VERSION_OPAC";
        SpringDbCurrentVersionSettableProvider currentVersionProvider = new SpringDbCurrentVersionSettableProvider(jdbcTemplate, versionColumn);
        ResourcesUpdaterImpl updater = new ResourcesUpdaterImpl((SettableProvider)currentVersionProvider, (UpdatesProvider)updatesFillerGlobal, true);
        return new TextualInteractiveUpdater(TextIoFactory.getTextTerminal(), (ResourcesUpdater)updater, (Settable)currentVersionProvider, arg_0 -> ((JdbcTemplate)jdbcTemplate).update(arg_0));
    }
}

