/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.tools;

import java.io.PrintStream;
import java.util.Arrays;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class JasyptEncryptor {
    private static StringEncryptor stringEncryptor(String password) {
        PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword(password);
        config.setAlgorithm("PBEWITHMD5ANDTRIPLEDES");
        config.setKeyObtentionIterations("1000");
        config.setPoolSize("1");
        config.setSaltGeneratorClassName("org.jasypt.salt.RandomSaltGenerator");
        config.setIvGeneratorClassName("org.jasypt.iv.RandomIvGenerator");
        encryptor.setConfig((PBEConfig)config);
        return encryptor;
    }

    private static String encrypt(String password, String text) {
        StringEncryptor textEncryptor = JasyptEncryptor.stringEncryptor((String)password);
        return textEncryptor.encrypt(text);
    }

    private static String decrypt(String password, String text) {
        StringEncryptor textEncryptor = JasyptEncryptor.stringEncryptor((String)password);
        return textEncryptor.decrypt(text);
    }

    public static void main(String[] args) {
        if (Arrays.asList(args).contains("-h")) {
            JasyptEncryptor.printHelp((PrintStream)System.out);
            System.exit(0);
        }
        int requiredArgCount = 2;
        String password = System.getenv("ENCRYPTION_PASSWORD");
        if (password != null) {
            System.err.println("Password read from ENCRYPTION_PASSWORD env");
            System.err.flush();
            --requiredArgCount;
        }
        if (args.length != requiredArgCount) {
            System.err.printf("Not enough parameters! Expected: %d, got: %d%n", requiredArgCount, args.length);
            JasyptEncryptor.printHelp((PrintStream)System.err);
            System.exit(1);
        }
        int currentArgPos = 0;
        if (password == null) {
            password = args[currentArgPos++];
        }
        String input = args[currentArgPos];
        String encrypted = JasyptEncryptor.encrypt((String)password, (String)input);
        System.out.println(encrypted);
        String decrypted = JasyptEncryptor.decrypt((String)password, (String)encrypted);
        Assert.state((boolean)input.equals(decrypted), (String)"Input %s and encrypted->decrypted value mismatch".formatted(input));
    }

    private static void printHelp(PrintStream out) {
        out.println("NAME\n    JasyptEncryptor - encryption tool for embedded values\nSYNOPSIS\n    JasyptEncryptor <password> <input_to_encrypt>\n    env ENCRYPTION_PASSWORD=<password> JasyptEncryptor <input_to_encrypt>\nDESCRIPTION\n    Easiest is to run this file from IDEA. But don't forget to set arguments!\n");
    }
}

