/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.modules;

import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.ext.report.server.DynamicDepartmentedReportServerClient;
import cz.kpsys.portaro.ext.report.server.EnabledAssertingReportServerLoader;
import cz.kpsys.portaro.ext.report.server.ReportServerApiController;
import cz.kpsys.portaro.ext.report.server.ReportServerLoader;
import cz.kpsys.portaro.ext.report.server.ReportServerSecurityActions;
import cz.kpsys.portaro.ext.report.server.ReportServerSettingsKeys;
import cz.kpsys.portaro.ext.report.server.SimpleReportServerLoader;
import cz.kpsys.portaro.ext.report.server.TemplateParametersFormCreator;
import cz.kpsys.portaro.form.form.FormByFormObjectFactory;
import cz.kpsys.portaro.form.formsubmit.FormSubmitTargetByFormObjectResolver;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.user.role.reader.ReaderCategory;
import cz.kpsys.portaro.web.page.ModelAndPageViewFactory;
import feign.RequestInterceptor;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
public class ReportServerConfig {
    public static final String FEATURE_NAME = "Report Server";
    @NonNull
    private final RequestInterceptor userAgentAddingInterceptor;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final ObjectFactory<HttpMessageConverters> messageConverters;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final FormByFormObjectFactory formByFormObjectFactory;
    @NonNull
    private final FormSubmitTargetByFormObjectResolver formSubmitTargetByFormObjectResolver;
    @NonNull
    private final ModelAndPageViewFactory modelAndPageViewFactory;
    @NonNull
    private final Codebook<Location, Integer> locationLoader;
    @NonNull
    private final Codebook<Department, Integer> departmentLoader;
    @NonNull
    private final Codebook<ReaderCategory, String> readerCategoryLoader;
    @NonNull
    private final Translator<Department> translator;

    @Bean
    public ReportServerApiController reportServerApiController() {
        return new ReportServerApiController(this.reportServerLoader(), this.templateParametersFormCreator(), this.modelAndPageViewFactory, this.settingLoader.getDepartmentedFondedValuesProvider(ReportServerSettingsKeys.REPORT_SERVER_RECORD_ROOT_FOLDER), this.translator);
    }

    @Bean
    public ReportServerLoader reportServerLoader() {
        return new EnabledAssertingReportServerLoader(this.settingLoader.getDepartmentedProvider(ReportServerSettingsKeys.REPORT_SERVER_ENABLED).toEnabledAsserter(value -> value, FEATURE_NAME, Texts.ofMessageCoded((String)"reportServer.message.ReportServerNotEnabled")), (ReportServerLoader)new SimpleReportServerLoader(this.settingLoader.getDepartmentedProvider(ReportServerSettingsKeys.REPORT_SERVER_ROOT_FOLDER).throwingWhenNull(), this.dynamicDepartmentedReportServerClient()));
    }

    @Bean
    public DynamicDepartmentedReportServerClient dynamicDepartmentedReportServerClient() {
        return new DynamicDepartmentedReportServerClient(this.settingLoader.getDepartmentedProvider(ReportServerSettingsKeys.REPORT_SERVER_API_URL).throwingWhenNull(), this.settingLoader.getDepartmentedProvider(ReportServerSettingsKeys.REPORT_SERVER_READER_CLIENT_ID).throwingWhenNull(), this.settingLoader.getDepartmentedProvider(ReportServerSettingsKeys.REPORT_SERVER_READER_CLIENT_TOKEN).throwingWhenNull(), this.settingLoader.getDepartmentedProvider(ReportServerSettingsKeys.REPORT_SERVER_EDITOR_CLIENT_ID).throwingWhenNull(), this.settingLoader.getDepartmentedProvider(ReportServerSettingsKeys.REPORT_SERVER_EDITOR_CLIENT_TOKEN).throwingWhenNull(), this.userAgentAddingInterceptor, this.messageConverters, this.securityManager);
    }

    @Bean
    public TemplateParametersFormCreator templateParametersFormCreator() {
        return new TemplateParametersFormCreator(this.formByFormObjectFactory, this.formSubmitTargetByFormObjectResolver, this.locationLoader, this.departmentLoader, this.readerCategoryLoader);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        ContextualProvider reportServerEnableProvider = this.settingLoader.getDepartmentedProvider(ReportServerSettingsKeys.REPORT_SERVER_ENABLED);
        this.permissionRegistry.add(ReportServerSecurityActions.REPORT_SERVER_ADMIN_EXPORT, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.enabled(reportServerEnableProvider, Texts.ofNative((String)"Report server is not enabled")), this.permissionFactory.edit()}));
        this.permissionRegistry.add(ReportServerSecurityActions.REPORT_SERVER_EXPORT, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.enabled(reportServerEnableProvider, Texts.ofNative((String)"Report server is not enabled")), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_READER"}), this.permissionFactory.edit()})}));
    }

    @ConstructorProperties(value={"userAgentAddingInterceptor", "settingLoader", "messageConverters", "permissionRegistry", "permissionFactory", "securityManager", "formByFormObjectFactory", "formSubmitTargetByFormObjectResolver", "modelAndPageViewFactory", "locationLoader", "departmentLoader", "readerCategoryLoader", "translator"})
    @Generated
    public ReportServerConfig(@NonNull RequestInterceptor userAgentAddingInterceptor, @NonNull SettingLoader settingLoader, @NonNull ObjectFactory<HttpMessageConverters> messageConverters, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull SecurityManager securityManager, @NonNull FormByFormObjectFactory formByFormObjectFactory, @NonNull FormSubmitTargetByFormObjectResolver formSubmitTargetByFormObjectResolver, @NonNull ModelAndPageViewFactory modelAndPageViewFactory, @NonNull Codebook<Location, Integer> locationLoader, @NonNull Codebook<Department, Integer> departmentLoader, @NonNull Codebook<ReaderCategory, String> readerCategoryLoader, @NonNull Translator<Department> translator) {
        Objects.requireNonNull(userAgentAddingInterceptor, "userAgentAddingInterceptor is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(messageConverters, "messageConverters is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(formByFormObjectFactory, "formByFormObjectFactory is marked non-null but is null");
        Objects.requireNonNull(formSubmitTargetByFormObjectResolver, "formSubmitTargetByFormObjectResolver is marked non-null but is null");
        Objects.requireNonNull(modelAndPageViewFactory, "modelAndPageViewFactory is marked non-null but is null");
        Objects.requireNonNull(locationLoader, "locationLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(readerCategoryLoader, "readerCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        this.userAgentAddingInterceptor = userAgentAddingInterceptor;
        this.settingLoader = settingLoader;
        this.messageConverters = messageConverters;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.securityManager = securityManager;
        this.formByFormObjectFactory = formByFormObjectFactory;
        this.formSubmitTargetByFormObjectResolver = formSubmitTargetByFormObjectResolver;
        this.modelAndPageViewFactory = modelAndPageViewFactory;
        this.locationLoader = locationLoader;
        this.departmentLoader = departmentLoader;
        this.readerCategoryLoader = readerCategoryLoader;
        this.translator = translator;
    }
}

