/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.portaro.FieldsNotResolvableException;
import cz.kpsys.portaro.alert.Alert;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.BadLoginCredentialsException;
import cz.kpsys.portaro.auth.InsufficientlyAuthenticatedException;
import cz.kpsys.portaro.auth.UserIsNotPersonAuthenticationException;
import cz.kpsys.portaro.auth.current.CurrentAuthProvider;
import cz.kpsys.portaro.auth.current.CurrentAuthWebResolver;
import cz.kpsys.portaro.auth.external.ExternalAuthenticationCancelException;
import cz.kpsys.portaro.auth.external.ExternallyAuthenticatedUserIsNotInLocalException;
import cz.kpsys.portaro.auth.useragent.EvidedUserUserAgentRegistration;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.ip.IpAddressInRangeResolver;
import cz.kpsys.portaro.commons.licence.FeatureNotEnabledException;
import cz.kpsys.portaro.commons.localization.UserFriendlyExceptionTextResolver;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.SeveritedException;
import cz.kpsys.portaro.commons.object.repo.ItemNotFoundException;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.TransactionalSaver;
import cz.kpsys.portaro.commons.util.AnnotationUtil;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.portaro.commons.web.CompositeListWebResolver;
import cz.kpsys.portaro.commons.web.WebResolver;
import cz.kpsys.portaro.conversation.SimpleActionResponse;
import cz.kpsys.portaro.database.FlushingJpaSaver;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.form.form.ConfirmationRequestFormObjectModifier;
import cz.kpsys.portaro.form.form.FormByFormObjectFactory;
import cz.kpsys.portaro.form.formsubmit.AnnotationFormSubmitTargetByFormObjectResolver;
import cz.kpsys.portaro.form.formsubmit.FormSubmitTargetByFormObjectResolver;
import cz.kpsys.portaro.form.spring.BindExceptionObjectResolverByForm;
import cz.kpsys.portaro.form.spring.BindingResultRecoverableErrorResolver;
import cz.kpsys.portaro.form.spring.ConstraintViolationExceptionObjectResolverByForm;
import cz.kpsys.portaro.form.spring.ConstraintViolationExceptionRecoverableErrorResolver;
import cz.kpsys.portaro.form.spring.MessageTemplateResolvingConstraintViolationExceptionRecoverableErrorResolver;
import cz.kpsys.portaro.form.spring.MethodArgumentNotValidExceptionObjectResolverByForm;
import cz.kpsys.portaro.form.spring.RecoverableErrorResolver;
import cz.kpsys.portaro.form.spring.ValidationErrorFormResolver;
import cz.kpsys.portaro.form.validation.AdhocValidator;
import cz.kpsys.portaro.form.validation.IntegrityValidationGroupAdhocValidator;
import cz.kpsys.portaro.form.validation.JavaxValidationAdhocValidator;
import cz.kpsys.portaro.formannotation.annotations.form.ConfirmableRequest;
import cz.kpsys.portaro.formconfig.conversation.AnnotationByBeanNameFormSubmitPackageModifier;
import cz.kpsys.portaro.formconfig.validation.AfterRequiredValidationViolationFormObjectModifier;
import cz.kpsys.portaro.formconfig.validation.BeforeIntegritySupportingAdhocValidator;
import cz.kpsys.portaro.logging.LogOnlyAsDebug;
import cz.kpsys.portaro.matcher.Matcher;
import cz.kpsys.portaro.matcher.string.AnyEqualsStringMatcher;
import cz.kpsys.portaro.matcher.string.InfixStringMatcher;
import cz.kpsys.portaro.matcher.string.PrefixStringMatcher;
import cz.kpsys.portaro.object.CompositeDepartmentedObjectModifier;
import cz.kpsys.portaro.object.TypedContextualObjectModifier;
import cz.kpsys.portaro.pops.agreement.AgreementConfirmationException;
import cz.kpsys.portaro.search.lucene.IncorrectLuceneQueryException;
import cz.kpsys.portaro.security.NotActivatedException;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.user.UserByUsernameLoader;
import cz.kpsys.portaro.util.logging.ClientSession;
import cz.kpsys.portaro.util.logging.ClientSessionByClientRequestUpdater;
import cz.kpsys.portaro.util.logging.ClientSessionEntity;
import cz.kpsys.portaro.util.logging.ClientSessionRepository;
import cz.kpsys.portaro.util.logging.ClientSessionSavingClientRequestSaver;
import cz.kpsys.portaro.util.logging.ClientSessionToEntityConverter;
import cz.kpsys.portaro.util.logging.CombinedClientSessionRepository;
import cz.kpsys.portaro.util.logging.InMemoryClientSessionRepository;
import cz.kpsys.portaro.util.logging.UserCheckingBotFinder;
import cz.kpsys.portaro.util.logging.WebClientRequestWebResolver;
import cz.kpsys.portaro.util.logging.session.SessionDestroyedEventListener;
import cz.kpsys.portaro.view.web.ClientSessionVerifierApiController;
import cz.kpsys.portaro.view.web.log.UserInfoLogAddingSimpleRequestDebugStringBuilder;
import cz.kpsys.portaro.view.web.ratelimit.RateLimitExceededException;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarRequest;
import cz.kpsys.portaro.view.web.rest.exemplar.unique.ExemplarsUniqueIdentifiers;
import cz.kpsys.portaro.web.CurrentDepartmentServerUrlProvidingUrlWebResolver;
import cz.kpsys.portaro.web.ExceptionObjectResolverByUserFriendlyTextResolver;
import cz.kpsys.portaro.web.JsonResponseEntityHttpResponseWriter;
import cz.kpsys.portaro.web.ResponseEntityHttpResponseWriter;
import cz.kpsys.portaro.web.UrlWebResolver;
import cz.kpsys.portaro.web.bot.BotFinder;
import cz.kpsys.portaro.web.bot.BotProbabilityProvider;
import cz.kpsys.portaro.web.bot.CompositeBotFinder;
import cz.kpsys.portaro.web.bot.IpBasedBotFinder;
import cz.kpsys.portaro.web.bot.UserAgentBasedBotFinder;
import cz.kpsys.portaro.web.client.WebClientRequest;
import cz.kpsys.portaro.web.exception.AddableExceptionResponseLogger;
import cz.kpsys.portaro.web.exception.CompositeExceptionObjectResolver;
import cz.kpsys.portaro.web.exception.CompositeWebClientRequestExceptionResponseLogger;
import cz.kpsys.portaro.web.exception.ExceptionObjectResolver;
import cz.kpsys.portaro.web.exception.ExceptionResponseLogger;
import cz.kpsys.portaro.web.log.RequestDebugStringBuilder;
import cz.kpsys.portaro.web.page.CompositeCurrentPageDialogsResolver;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import jakarta.persistence.EntityManager;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.web.session.HttpSessionDestroyedEvent;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.ServletWrappingController;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;
import org.springframework.web.servlet.view.freemarker.FreeMarkerViewResolver;

@org.springframework.context.annotation.Configuration
public class WebConfig {
    @NonNull
    private final CurrentAuthWebResolver currentAuthWebResolver;
    @NonNull
    private final WebResolver<Department> currentDepartmentWebResolver;
    private final @NonNull ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider;
    @NonNull
    private final Provider<UUID> traceIdRepository;
    @NonNull
    private final IpAddressInRangeResolver internalIpResolver;
    @NonNull
    private final ServletWrappingController appserverProxyController;
    @NonNull
    private final ServletWrappingController dbConsoleProxyController;
    @NonNull
    private final ObjectMapper objectMapper;
    @NonNull
    private final UserFriendlyExceptionTextResolver userFriendlyExceptionTextResolver;
    @NonNull
    private final FormByFormObjectFactory formByFormObjectFactory;
    @NonNull
    private final Provider<Department> currentDepartmentProvider;
    @NonNull
    private final BeanFactory applicationContext;
    @NonNull
    private final UserByUsernameLoader userByUsernameLoader;
    @NonNull
    private final Validator validator;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final AuthenticationHolder authenticationHolder;

    @Bean
    public SimpleUrlHandlerMapping urlHandlerMapping() {
        SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
        mapping.setLazyInitHandlers(true);
        mapping.setOrder(0x7FFFFFFD);
        Properties mappings = new Properties();
        mappings.put("/appserver/**", this.appserverProxyController);
        mappings.put("/db/**", this.dbConsoleProxyController);
        mapping.setMappings(mappings);
        return mapping;
    }

    @Bean
    public WebResolver<WebClientRequest> webClientRequestWebResolver() {
        return new WebClientRequestWebResolver(this.currentAuthWebResolver, this.currentDepartmentWebResolver, this.traceIdRepository);
    }

    @Bean
    public FreeMarkerViewResolver freeMarkerAngularTemplatesViewResolver() {
        FreeMarkerViewResolver resolver = new FreeMarkerViewResolver();
        resolver.setCache(true);
        resolver.setPrefix("");
        resolver.setSuffix(".ftl");
        resolver.setContentType("text/html;charset=UTF-8");
        resolver.setOrder(10);
        return resolver;
    }

    @Bean
    public FreeMarkerConfigurer freeMarkerConfig() throws IOException, TemplateException {
        FreeMarkerConfigurationFactory factory = new FreeMarkerConfigurationFactory();
        TemplateLoader[] loaders = new TemplateLoader[]{new ClassTemplateLoader(this.getClass(), "/"), new ClassTemplateLoader(this.getClass(), "/freemarker"), new ClassTemplateLoader(FreeMarkerConfigurer.class, "")};
        factory.setPreTemplateLoaders(loaders);
        factory.setDefaultEncoding(StandardCharsets.UTF_8.name());
        Properties props = new Properties();
        props.put("date_format", "d.M.yyyy");
        props.put("datetime_format", "d.M.yyyy HH:mm:ss");
        props.put("incompatible_improvements", Configuration.VERSION_2_3_33.toString());
        factory.setFreemarkerSettings(props);
        FreeMarkerConfigurer result = new FreeMarkerConfigurer();
        result.setConfiguration(factory.createConfiguration());
        return result;
    }

    @Bean
    public ResponseEntityHttpResponseWriter responseEntityHttpResponseWriter() {
        return new JsonResponseEntityHttpResponseWriter(this.objectMapper);
    }

    @Bean
    public ValidationErrorFormResolver<ObjectError> bindingResultFormResolver() {
        return new ValidationErrorFormResolver(this.formSubmitTargetByFormObjectResolver(), (TypedContextualObjectModifier)new CompositeDepartmentedObjectModifier(List.of(new AfterRequiredValidationViolationFormObjectModifier(this.applicationContext, (CurrentAuthProvider)this.authenticationHolder), new ConfirmationRequestFormObjectModifier())), this.formByFormObjectFactory, this.currentDepartmentProvider, this.bindingResultRecoverableErrorResolver(), (TypedContextualObjectModifier)new AnnotationByBeanNameFormSubmitPackageModifier(this.applicationContext, (CurrentAuthProvider)this.authenticationHolder));
    }

    @Bean
    public FormSubmitTargetByFormObjectResolver formSubmitTargetByFormObjectResolver() {
        return new AnnotationFormSubmitTargetByFormObjectResolver();
    }

    @Bean
    public RecoverableErrorResolver<ObjectError> bindingResultRecoverableErrorResolver() {
        return new BindingResultRecoverableErrorResolver((Collection)this.customByFormRecoverableFieldResolver(), (Collection)this.customByFormRecoverableObjectResolver());
    }

    @Bean
    public ValidationErrorFormResolver<ConstraintViolation<?>> constraintViolationFormResolver() {
        return new ValidationErrorFormResolver(this.formSubmitTargetByFormObjectResolver(), (TypedContextualObjectModifier)new CompositeDepartmentedObjectModifier(List.of(new AfterRequiredValidationViolationFormObjectModifier(this.applicationContext, (CurrentAuthProvider)this.authenticationHolder), new ConfirmationRequestFormObjectModifier())), this.formByFormObjectFactory, this.currentDepartmentProvider, this.constraintViolationRecoverableErrorResolver(), (TypedContextualObjectModifier)new AnnotationByBeanNameFormSubmitPackageModifier(this.applicationContext, (CurrentAuthProvider)this.authenticationHolder));
    }

    @Bean
    public RecoverableErrorResolver<ConstraintViolation<?>> constraintViolationRecoverableErrorResolver() {
        return new ConstraintViolationExceptionRecoverableErrorResolver((Collection)this.customByFormRecoverableFieldResolver(), (Collection)this.customByFormRecoverableObjectResolver());
    }

    @Bean
    public RecoverableErrorResolver<ConstraintViolation<?>> messageTemplateResolvingConstraintViolationRecoverableErrorResolver() {
        return new MessageTemplateResolvingConstraintViolationExceptionRecoverableErrorResolver((Collection)this.customByFormRecoverableFieldResolver(), (Collection)this.customByFormRecoverableObjectResolver());
    }

    private List<Predicate<RecoverableErrorResolver.ByFormRecoverableFieldResolverParams>> customByFormRecoverableFieldResolver() {
        return List.of(params -> params.violatedFormObject() instanceof ConfirmableRequest && params.field().equals("confirmed"), params -> params.violatedFormObject() instanceof ExemplarRequest && params.constraintAnnotationType() != null && params.constraintAnnotationType().equals(ExemplarsUniqueIdentifiers.class));
    }

    private List<Predicate<RecoverableErrorResolver.ByFormRecoverableObjectResolverParams>> customByFormRecoverableObjectResolver() {
        return List.of();
    }

    @Bean
    public AdhocValidator adhocValidator() {
        return new BeforeIntegritySupportingAdhocValidator((AdhocValidator)new JavaxValidationAdhocValidator(this.validator), (AdhocValidator)new IntegrityValidationGroupAdhocValidator(this.validator), this.applicationContext, (CurrentAuthProvider)this.authenticationHolder);
    }

    @Bean
    public CompositeExceptionObjectResolver<Throwable> exceptionResponseObjectResolver() {
        return new CompositeExceptionObjectResolver().with(MethodArgumentNotValidException.class, (ExceptionObjectResolver)new MethodArgumentNotValidExceptionObjectResolverByForm(this.bindingResultFormResolver())).with(BindException.class, (ExceptionObjectResolver)new BindExceptionObjectResolverByForm(this.bindingResultFormResolver())).with(ConstraintViolationException.class, (ExceptionObjectResolver)new ConstraintViolationExceptionObjectResolverByForm(this.constraintViolationFormResolver())).withStatic(NotActivatedException.class, (Object)new SimpleActionResponse("userActivationRequired", false)).withFallback((ExceptionObjectResolver)new ExceptionObjectResolverByUserFriendlyTextResolver("exception", this.userFriendlyExceptionTextResolver));
    }

    @Bean
    public RequestDebugStringBuilder requestDebugStringBuilder() {
        return new UserInfoLogAddingSimpleRequestDebugStringBuilder(this.currentAuthWebResolver);
    }

    @Bean
    public AddableExceptionResponseLogger exceptionResponseLogger() {
        return new CompositeWebClientRequestExceptionResponseLogger(this.webClientRequestWebResolver(), this.requestDebugStringBuilder()).with(SeveritedException.class, (request, e) -> e.isError() ? ExceptionResponseLogger.LogLevel.ERROR : ExceptionResponseLogger.LogLevel.DEBUG).withDebug(InsufficientlyAuthenticatedException.class).withDebug(InsufficientAuthenticationException.class).withDebug(BadLoginCredentialsException.class).withDebug(UserIsNotPersonAuthenticationException.class).withDebug(ExternalAuthenticationCancelException.class).withError(ExternallyAuthenticatedUserIsNotInLocalException.class).withDebug(AccessDeniedException.class).withDebug(RateLimitExceededException.class).withDebug(FeatureNotEnabledException.class).withDebug(AgreementConfirmationException.class).withError(IncorrectLuceneQueryException.class).withDebug(HttpRequestMethodNotSupportedException.class).withDebug(FieldsNotResolvableException.class).withDebug(MethodArgumentNotValidException.class).withDebug(ConstraintViolationException.class).with(ItemNotFoundException.class, (request, e) -> this.botFinder().isProbablyHuman(request) ? ExceptionResponseLogger.LogLevel.ERROR : ExceptionResponseLogger.LogLevel.DEBUG).with(EmptyResultDataAccessException.class, (request, e) -> this.botFinder().isProbablyHuman(request) ? ExceptionResponseLogger.LogLevel.ERROR : ExceptionResponseLogger.LogLevel.DEBUG).withError(HttpSessionRequiredException.class).with(IOException.class, (request, e) -> "ClientAbortException".equals(e.getClass().getSimpleName()) ? ExceptionResponseLogger.LogLevel.DEBUG : ExceptionResponseLogger.LogLevel.ERROR).withUnwrapping(TypeMismatchException.class, ExceptionResponseLogger.LogLevel.ERROR).withUnwrapping(ConversionFailedException.class, ExceptionResponseLogger.LogLevel.ERROR).with(Exception.class, (request, e) -> {
            if (AnnotationUtil.findClassLevelAnnotation((Object)e, LogOnlyAsDebug.class).isPresent()) {
                return ExceptionResponseLogger.LogLevel.DEBUG;
            }
            return e.getMessage() != null && e.getMessage().contains("message.warning") ? ExceptionResponseLogger.LogLevel.DEBUG : ExceptionResponseLogger.LogLevel.ERROR;
        });
    }

    @Bean
    public Saver<WebClientRequest, ClientSession> clientRequestSaver() {
        return new ClientSessionSavingClientRequestSaver(this.clientSessionRepository(), this.internalIpResolver);
    }

    @Bean
    public ApplicationListener<HttpSessionDestroyedEvent> sessionDestroyedEventListener() {
        return new SessionDestroyedEventListener(this.clientSessionRepository());
    }

    @Bean
    public ClientSessionRepository clientSessionRepository() {
        return new CombinedClientSessionRepository((ClientSessionRepository)new InMemoryClientSessionRepository(), this.sessionClientSaver());
    }

    @Bean
    public Saver<ClientSession, ClientSessionEntity> sessionClientSaver() {
        return new TransactionalSaver((Saver)new PreConvertingSaver((Converter)new ClientSessionToEntityConverter(), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(ClientSessionEntity.class, this.entityManager))), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public BotFinder botFinder() {
        return new CompositeBotFinder((BotProbabilityProvider)new UserAgentBasedBotFinder(ListUtil.union((Collection[])new Collection[]{this.evidedUserBotUserAgentRegistrations(), this.anonymousBotUserAgentMatchers()})), (BotProbabilityProvider)new IpBasedBotFinder(), (BotProbabilityProvider)new UserCheckingBotFinder(this.clientSessionRepository()));
    }

    @Bean
    public List<EvidedUserUserAgentRegistration> evidedUserBotUserAgentRegistrations() {
        return List.of(new EvidedUserUserAgentRegistration((Matcher)InfixStringMatcher.ofSingle((String)"UptimeRobot"), department -> this.userByUsernameLoader.get("uptimerobot")), new EvidedUserUserAgentRegistration((Matcher)InfixStringMatcher.ofSingle((String)"Verbis/"), department -> this.userByUsernameLoader.get("verbisapplication")), new EvidedUserUserAgentRegistration((Matcher)InfixStringMatcher.ofSingle((String)"AhrefsBot"), department -> this.userByUsernameLoader.get("ahrefsbot")), new EvidedUserUserAgentRegistration((Matcher)InfixStringMatcher.ofSingle((String)"Applebot"), department -> this.userByUsernameLoader.get("applelebot")), new EvidedUserUserAgentRegistration((Matcher)InfixStringMatcher.ofSingleCaseInsensitive((String)"bingbot"), department -> this.userByUsernameLoader.get("bingbot")), new EvidedUserUserAgentRegistration((Matcher)InfixStringMatcher.ofSingle((String)"Googlebot"), department -> this.userByUsernameLoader.get("googlebot")), new EvidedUserUserAgentRegistration((Matcher)InfixStringMatcher.ofSingle((String)"MJ12bot"), department -> this.userByUsernameLoader.get("mj12bot")), new EvidedUserUserAgentRegistration((Matcher)InfixStringMatcher.ofSingle((String)"PetalBot"), department -> this.userByUsernameLoader.get("petalbot")), new EvidedUserUserAgentRegistration((Matcher)InfixStringMatcher.ofSingle((String)"SemrushBot"), department -> this.userByUsernameLoader.get("semrushbot")), new EvidedUserUserAgentRegistration((Matcher)InfixStringMatcher.ofSingle((String)"SeznamBot"), department -> this.userByUsernameLoader.get("seznambot")), new EvidedUserUserAgentRegistration((Matcher)InfixStringMatcher.ofSingle((String)"YandexBot"), department -> this.userByUsernameLoader.get("yandexbot")));
    }

    @Bean
    public List<Matcher<String>> anonymousBotUserAgentMatchers() {
        return List.of(InfixStringMatcher.ofSingleCaseInsensitive((String)"UptimeRobot"), InfixStringMatcher.ofSingleCaseInsensitive((String)"Verbis"), InfixStringMatcher.ofSingleCaseInsensitive((String)"googlebot"), AnyEqualsStringMatcher.ofSingle((String)"revolt"), AnyEqualsStringMatcher.ofSingle((String)"NeohapsisLab"), AnyEqualsStringMatcher.ofSingle((String)"Mediapartners-Google"), AnyEqualsStringMatcher.ofSingle((String)"Phantom.js bot"), AnyEqualsStringMatcher.ofSingle((String)"Morfeus Fucking Scanner"), AnyEqualsStringMatcher.ofSingle((String)"betaBot"), AnyEqualsStringMatcher.ofSingle((String)"the beast"), AnyEqualsStringMatcher.ofSingle((String)"shellshock-scan"), AnyEqualsStringMatcher.ofSingle((String)"mifetcher/1.0"), AnyEqualsStringMatcher.ofSingle((String)"ContextAd Bot 1.0"), AnyEqualsStringMatcher.ofSingle((String)"Jyxobot/1"), AnyEqualsStringMatcher.ofSingle((String)"Seznam.cz open proxy check bot"), AnyEqualsStringMatcher.ofSingle((String)"listicka"), AnyEqualsStringMatcher.ofSingle((String)"Ruby"), AnyEqualsStringMatcher.ofSingle((String)"YisouSpider"), AnyEqualsStringMatcher.ofSingle((String)"LinkSaver/2.0"), AnyEqualsStringMatcher.ofSingle((String)"LinkParser/2.0"), AnyEqualsStringMatcher.ofSingle((String)"Dragonfly File Reader"), AnyEqualsStringMatcher.ofSingle((String)"netscan.gtisc.gatech.edu"), AnyEqualsStringMatcher.ofSingle((String)"BOT/0.1 (BOT for JCE)"), AnyEqualsStringMatcher.ofSingle((String)"ltx71 - (http://ltx71.com/)"), AnyEqualsStringMatcher.ofSingle((String)"Zend_Http_Client"), AnyEqualsStringMatcher.ofSingle((String)"eBot/1.0 (+http://alfa.elchron.cz)"), AnyEqualsStringMatcher.ofSingle((String)"bitlybot/2.0"), AnyEqualsStringMatcher.ofSingle((String)"iZSearch.com"), AnyEqualsStringMatcher.ofSingle((String)"Mozilla/5.0 (X11; U; en-US; Fortinet"), AnyEqualsStringMatcher.ofSingle((String)"Mozilla/5.0 (compatible; worldwebheritage.org/1.0; +crawl@worldwebheritage.org)"), AnyEqualsStringMatcher.ofSingle((String)"ADmantX Platform Semantic Analyzer - ADmantX Inc. - www.admantx.com - support@admantx.com"), AnyEqualsStringMatcher.ofSingle((String)"Mozilla/3.0 (compatible; Indy Library)"), AnyEqualsStringMatcher.ofSingle((String)"Mediatoolkitbot (complaints@mediatoolkit.com)"), AnyEqualsStringMatcher.ofSingle((String)"Mozilla/5.0 (compatible; DataForSeoBot/1.0; +https://dataforseo.com/dataforseo-bot)"), AnyEqualsStringMatcher.ofSingle((String)"Hello, world"), AnyEqualsStringMatcher.ofSingle((String)"https://gdnplus.com:Gather Analyze Provide."), AnyEqualsStringMatcher.ofSingle((String)"Linux Gnu (cow)"), AnyEqualsStringMatcher.ofSingle((String)"Auto Spider 1.0"), AnyEqualsStringMatcher.ofSingle((String)"Hello World"), AnyEqualsStringMatcher.ofSingle((String)"DavClnt"), AnyEqualsStringMatcher.ofSingle((String)"Chrome Privacy Preserving Prefetch Proxy"), AnyEqualsStringMatcher.ofSingle((String)"Keybot Translation-Search-Machine"), AnyEqualsStringMatcher.ofSingle((String)"wp_is_mobile"), PrefixStringMatcher.ofSingle((String)"python-requests/"), PrefixStringMatcher.ofSingle((String)"Mozilla/5.0 zgrab/"), PrefixStringMatcher.ofSingle((String)"webprosbot/"), PrefixStringMatcher.ofSingle((String)"NetSystemsResearch"), PrefixStringMatcher.ofSingle((String)"curl/"), PrefixStringMatcher.ofSingle((String)"okhttp/"), PrefixStringMatcher.ofSingle((String)"Go-http-client/"), PrefixStringMatcher.ofSingle((String)"gbrmss/"), PrefixStringMatcher.ofSingle((String)"Mozilla/5.0 (compatible; DotBot/"), PrefixStringMatcher.ofSingle((String)"Mozilla/5.0 (compatible; Adsbot/"), PrefixStringMatcher.ofSingle((String)"Sogou web spider"), PrefixStringMatcher.ofSingle((String)"KOCMOHABT"), InfixStringMatcher.ofSingleCaseInsensitive((String)"bot.htm"), InfixStringMatcher.ofSingleCaseInsensitive((String)"surveybot"), InfixStringMatcher.ofSingleCaseInsensitive((String)"yahoo.com"), InfixStringMatcher.ofSingleCaseInsensitive((String)"seznambot"), InfixStringMatcher.ofSingleCaseInsensitive((String)"fulltext.sblog.cz"), InfixStringMatcher.ofSingleCaseInsensitive((String)"baiduspider"), InfixStringMatcher.ofSingleCaseInsensitive((String)"apache-httpclient"), InfixStringMatcher.ofSingleCaseInsensitive((String)"check_http"), InfixStringMatcher.ofSingleCaseInsensitive((String)"yandexbot"), InfixStringMatcher.ofSingleCaseInsensitive((String)"java/"), InfixStringMatcher.ofSingleCaseInsensitive((String)"ezooms"), InfixStringMatcher.ofSingleCaseInsensitive((String)"exabot"), InfixStringMatcher.ofSingleCaseInsensitive((String)"ahrefsbot"), InfixStringMatcher.ofSingleCaseInsensitive((String)"yandex"), InfixStringMatcher.ofSingleCaseInsensitive((String)"crawler"), InfixStringMatcher.ofSingleCaseInsensitive((String)"python-openid"), InfixStringMatcher.ofSingleCaseInsensitive((String)"python-urllib"), InfixStringMatcher.ofSingleCaseInsensitive((String)"cliqz.com"), InfixStringMatcher.ofSingleCaseInsensitive((String)"microsoft url control"), InfixStringMatcher.ofSingleCaseInsensitive((String)"ia_archiver"), InfixStringMatcher.ofSingleCaseInsensitive((String)"libwww-perl"), InfixStringMatcher.ofSingleCaseInsensitive((String)"feedreader"), InfixStringMatcher.ofSingleCaseInsensitive((String)"pycurl"), InfixStringMatcher.ofSingleCaseInsensitive((String)"openstat"), InfixStringMatcher.ofSingleCaseInsensitive((String)"xpymep.exe"), InfixStringMatcher.ofSingleCaseInsensitive((String)"bot.php"), InfixStringMatcher.ofSingleCaseInsensitive((String)"mj12bot"), InfixStringMatcher.ofSingleCaseInsensitive((String)"wotbox"), InfixStringMatcher.ofSingleCaseInsensitive((String)"pagesinventory"), InfixStringMatcher.ofSingleCaseInsensitive((String)"ahrefsbot"), InfixStringMatcher.ofSingleCaseInsensitive((String)"compspy.com"), InfixStringMatcher.ofSingleCaseInsensitive((String)"windows-rss-platform"), InfixStringMatcher.ofSingleCaseInsensitive((String)"bubing"), InfixStringMatcher.ofSingleCaseInsensitive((String)"zmeu"), InfixStringMatcher.ofSingleCaseInsensitive((String)"seznam screenshot-generator"), InfixStringMatcher.ofSingleCaseInsensitive((String)"facebook.com"), InfixStringMatcher.ofSingleCaseInsensitive((String)"masscan"), InfixStringMatcher.ofSingleCaseInsensitive((String)"niki-bot"), InfixStringMatcher.ofSingleCaseInsensitive((String)"www.checkprivacy"), InfixStringMatcher.ofSingleCaseInsensitive((String)"thefuckie"), InfixStringMatcher.ofSingleCaseInsensitive((String)"nutch"), InfixStringMatcher.ofSingleCaseInsensitive((String)"www.feedly.com"), InfixStringMatcher.ofSingleCaseInsensitive((String)"addthis.com"), InfixStringMatcher.ofSingleCaseInsensitive((String)"proxy gear pro"), InfixStringMatcher.ofSingleCaseInsensitive((String)"nikto"), InfixStringMatcher.ofSingleCaseInsensitive((String)"mj12bot"), InfixStringMatcher.ofSingleCaseInsensitive((String)"prtg network monitor"), InfixStringMatcher.ofSingleCaseInsensitive((String)"spbot"), InfixStringMatcher.ofSingleCaseInsensitive((String)"gigablastopensource"), InfixStringMatcher.ofSingleCaseInsensitive((String)"metaspider"), InfixStringMatcher.ofSingleCaseInsensitive((String)"publiclibraryarchive"), InfixStringMatcher.ofSingleCaseInsensitive((String)"visionutils"), InfixStringMatcher.ofSingleCaseInsensitive((String)"feedfetcher-google"), InfixStringMatcher.ofSingleCaseInsensitive((String)"/usr/bin/"), InfixStringMatcher.ofSingleCaseInsensitive((String)"wget/"), InfixStringMatcher.ofSingleCaseInsensitive((String)"qwantify"), InfixStringMatcher.ofSingleCaseInsensitive((String)"reactornetty"), InfixStringMatcher.ofSingleCaseInsensitive((String)"semrushbot"), InfixStringMatcher.ofSingleCaseInsensitive((String)"verbis/"), InfixStringMatcher.ofSingleCaseInsensitive((String)"bingpreview"), InfixStringMatcher.ofSingleCaseInsensitive((String)"petalbot"), InfixStringMatcher.ofSingleCaseInsensitive((String)"postmanruntime"), InfixStringMatcher.ofSingleCaseInsensitive((String)"facebookexternalhit"), InfixStringMatcher.ofSingle((String)"AlexaMediaPlayer"), InfixStringMatcher.ofSingle((String)"aiohttp"), InfixStringMatcher.ofSingle((String)"CensysInspect"), InfixStringMatcher.ofSingle((String)"CFNetwork/"), InfixStringMatcher.ofSingle((String)"coccocbot-web/"), InfixStringMatcher.ofSingle((String)"DuckDuckGo-Favicons-Bot/"), InfixStringMatcher.ofSingle((String)"Facebot"), InfixStringMatcher.ofSingle((String)"J2ME/MIDP; Opera Mini"), InfixStringMatcher.ofSingle((String)"IABot/"), InfixStringMatcher.ofSingle((String)"InternetMeasurement"), InfixStringMatcher.ofSingle((String)"Mail.RU_Bot"), InfixStringMatcher.ofSingle((String)"MiniRedir"), InfixStringMatcher.ofSingle((String)"Neevabot/"), InfixStringMatcher.ofSingle((String)"research@pdrlabs.net"), InfixStringMatcher.ofSingle((String)"FirmoGraph"), InfixStringMatcher.ofSingle((String)"OpenVAS"), InfixStringMatcher.ofSingle((String)"panscient.com"), InfixStringMatcher.ofSingle((String)"serpstatbot"), InfixStringMatcher.ofSingle((String)"SearchHelper"), InfixStringMatcher.ofSingle((String)"SeekportBot"), InfixStringMatcher.ofSingle((String)"Amazonbot"), InfixStringMatcher.ofSingle((String)"Twitterbot/"), InfixStringMatcher.ofSingle((String)"TurnitinBot"), InfixStringMatcher.ofSingle((String)"Turnitin"));
    }

    @Bean
    public CompositeCurrentPageDialogsResolver currentPageDialogsResolver() {
        return new CompositeCurrentPageDialogsResolver();
    }

    @Bean
    public UrlWebResolver serverUrlWebResolver() {
        return new CurrentDepartmentServerUrlProvidingUrlWebResolver(this.currentDepartmentWebResolver, this.serverUrlProvider);
    }

    @Bean
    public CompositeListWebResolver<Alert> alertsWebResolver() {
        return CompositeListWebResolver.ofEmpty();
    }

    @Bean
    public ClientSessionVerifierApiController clientSessionVerifierApiController() {
        return new ClientSessionVerifierApiController(this.webClientRequestWebResolver(), this.clientSessionByClientRequestUpdater());
    }

    @Bean
    public ClientSessionByClientRequestUpdater clientSessionByClientRequestUpdater() {
        return new ClientSessionByClientRequestUpdater(this.clientSessionRepository(), this.botFinder());
    }

    @ConstructorProperties(value={"currentAuthWebResolver", "currentDepartmentWebResolver", "serverUrlProvider", "traceIdRepository", "internalIpResolver", "appserverProxyController", "dbConsoleProxyController", "objectMapper", "userFriendlyExceptionTextResolver", "formByFormObjectFactory", "currentDepartmentProvider", "applicationContext", "userByUsernameLoader", "validator", "entityManager", "defaultTransactionTemplateFactory", "authenticationHolder"})
    @Generated
    public WebConfig(@NonNull CurrentAuthWebResolver currentAuthWebResolver, @NonNull WebResolver<Department> currentDepartmentWebResolver, @NonNull ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider, @NonNull Provider<UUID> traceIdRepository, @NonNull IpAddressInRangeResolver internalIpResolver, @NonNull ServletWrappingController appserverProxyController, @NonNull ServletWrappingController dbConsoleProxyController, @NonNull ObjectMapper objectMapper, @NonNull UserFriendlyExceptionTextResolver userFriendlyExceptionTextResolver, @NonNull FormByFormObjectFactory formByFormObjectFactory, @NonNull Provider<Department> currentDepartmentProvider, @NonNull BeanFactory applicationContext, @NonNull UserByUsernameLoader userByUsernameLoader, @NonNull Validator validator, @NonNull EntityManager entityManager, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull AuthenticationHolder authenticationHolder) {
        Objects.requireNonNull(currentAuthWebResolver, "currentAuthWebResolver is marked non-null but is null");
        Objects.requireNonNull(currentDepartmentWebResolver, "currentDepartmentWebResolver is marked non-null but is null");
        Objects.requireNonNull(serverUrlProvider, "serverUrlProvider is marked non-null but is null");
        Objects.requireNonNull(traceIdRepository, "traceIdRepository is marked non-null but is null");
        Objects.requireNonNull(internalIpResolver, "internalIpResolver is marked non-null but is null");
        Objects.requireNonNull(appserverProxyController, "appserverProxyController is marked non-null but is null");
        Objects.requireNonNull(dbConsoleProxyController, "dbConsoleProxyController is marked non-null but is null");
        Objects.requireNonNull(objectMapper, "objectMapper is marked non-null but is null");
        Objects.requireNonNull(userFriendlyExceptionTextResolver, "userFriendlyExceptionTextResolver is marked non-null but is null");
        Objects.requireNonNull(formByFormObjectFactory, "formByFormObjectFactory is marked non-null but is null");
        Objects.requireNonNull(currentDepartmentProvider, "currentDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(applicationContext, "applicationContext is marked non-null but is null");
        Objects.requireNonNull(userByUsernameLoader, "userByUsernameLoader is marked non-null but is null");
        Objects.requireNonNull(validator, "validator is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        this.currentAuthWebResolver = currentAuthWebResolver;
        this.currentDepartmentWebResolver = currentDepartmentWebResolver;
        this.serverUrlProvider = serverUrlProvider;
        this.traceIdRepository = traceIdRepository;
        this.internalIpResolver = internalIpResolver;
        this.appserverProxyController = appserverProxyController;
        this.dbConsoleProxyController = dbConsoleProxyController;
        this.objectMapper = objectMapper;
        this.userFriendlyExceptionTextResolver = userFriendlyExceptionTextResolver;
        this.formByFormObjectFactory = formByFormObjectFactory;
        this.currentDepartmentProvider = currentDepartmentProvider;
        this.applicationContext = applicationContext;
        this.userByUsernameLoader = userByUsernameLoader;
        this.validator = validator;
        this.entityManager = entityManager;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.authenticationHolder = authenticationHolder;
    }
}

