/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kagkarlsson.scheduler.SchedulerClient;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.cache.DynamicCache;
import cz.kpsys.portaro.commons.date.DateRangeToStringConverter;
import cz.kpsys.portaro.commons.date.DatetimeRangeToTimezonedStringConverter;
import cz.kpsys.portaro.commons.date.InstantToStringConverter;
import cz.kpsys.portaro.commons.date.StringToDateRangeConverter;
import cz.kpsys.portaro.commons.date.TimezonedStringToDatetimeRangeConverter;
import cz.kpsys.portaro.commons.object.BasicIdentified;
import cz.kpsys.portaro.commons.object.Identified;
import cz.kpsys.portaro.commons.object.OrBooleanProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadableByAllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ChunkingAllByIdsLoader;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.SwitchingAllByIdsLoader;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.marcxml.MarcConstants;
import cz.kpsys.portaro.record.AfterSaveNotifierRecordSaver;
import cz.kpsys.portaro.record.AppserverRecordSaver;
import cz.kpsys.portaro.record.DelegatingRichRecordsByIdsLoader;
import cz.kpsys.portaro.record.DependentRecordFieldDbProcInvalidator;
import cz.kpsys.portaro.record.InternalRecordLoader;
import cz.kpsys.portaro.record.KindedDelegatingRecordsByIdsLoader;
import cz.kpsys.portaro.record.KindedInternalRecordLoader;
import cz.kpsys.portaro.record.KindedRecordLoader;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RecordConstants;
import cz.kpsys.portaro.record.RecordEntity;
import cz.kpsys.portaro.record.RecordIdFondPair;
import cz.kpsys.portaro.record.RecordLoadCommonConfig;
import cz.kpsys.portaro.record.RecordSaver;
import cz.kpsys.portaro.record.RecordSettingKeys;
import cz.kpsys.portaro.record.RichRecordLoader;
import cz.kpsys.portaro.record.SecuredRecordSaver;
import cz.kpsys.portaro.record.authority.RecordLoaderDelegatingAuthorityLoader;
import cz.kpsys.portaro.record.detail.AppserverRecordDetailLoader;
import cz.kpsys.portaro.record.detail.IdentifiedFieldContainer;
import cz.kpsys.portaro.record.detail.appservermarc.MarcXmlToDetailConverterImpl;
import cz.kpsys.portaro.record.detail.appservermarc.StringBuilderDetailToMarcXmlConverter;
import cz.kpsys.portaro.record.detail.convert.DetailToMarcXmlConverter;
import cz.kpsys.portaro.record.detail.convert.MarcXmlToDetailConverter;
import cz.kpsys.portaro.record.document.DocumentLoader;
import cz.kpsys.portaro.record.document.RecordDelegatingDocumentLoader;
import cz.kpsys.portaro.record.edit.FieldTypesByFondLoader;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.record.holding.AppserverRecordHoldingUpserter;
import cz.kpsys.portaro.record.holding.AuthorityHoldingDepartmentReplacingRecordHoldingUpserter;
import cz.kpsys.portaro.record.holding.ExternalRecordSavingRecordHoldingUpserter;
import cz.kpsys.portaro.record.holding.RecordHoldingLoader;
import cz.kpsys.portaro.record.holding.RecordHoldingUpserter;
import cz.kpsys.portaro.record.load.RecordFieldEntity;
import cz.kpsys.portaro.record.load.RecordFieldsLoader;
import cz.kpsys.portaro.record.load.RecordFieldsLoadingRecordDetailLoader;
import cz.kpsys.portaro.record.load.SwitchableRecordFieldsLoader;
import cz.kpsys.portaro.record.operation.CachingRecordEditLevelProvider;
import cz.kpsys.portaro.record.operation.EntitiesToRecordOperationsConverter;
import cz.kpsys.portaro.record.operation.EntityToRecordOperationTypeConverter;
import cz.kpsys.portaro.record.operation.RecordEditLevelProvider;
import cz.kpsys.portaro.record.operation.RecordOperation;
import cz.kpsys.portaro.record.operation.RecordOperationEntity;
import cz.kpsys.portaro.record.operation.RecordOperationSearchDelegatingRecordEditLevelProvider;
import cz.kpsys.portaro.record.operation.RecordOperationToEntityConverter;
import cz.kpsys.portaro.record.operation.RecordOperationType;
import cz.kpsys.portaro.record.operation.RecordOperationTypeEntity;
import cz.kpsys.portaro.record.operation.SpringDbRecordOperationEntitySearchLoader;
import cz.kpsys.portaro.scheduler.DatabaseQueue;
import cz.kpsys.portaro.scheduler.DbSchedulerQueue;
import cz.kpsys.portaro.scheduler.DynamicTaskRegistrar;
import cz.kpsys.portaro.scheduler.LazyScheduler;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoaderImpl;
import cz.kpsys.portaro.search.ParametersConvertingPageSearchLoader;
import cz.kpsys.portaro.search.ResultConvertingPageSearchLoader;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.UserByBasicUserLoader;
import cz.kpsys.portaro.user.UserLoader;
import jakarta.persistence.EntityManager;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
@Import(value={RecordLoadCommonConfig.class})
public class RecordLoadConfig {
    @NonNull
    private final ObjectMapper appserverXmlMapper;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final Codebook<Fond, Integer> fondLoader;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final @NonNull Provider<@NonNull ZoneId> databaseColumnsTimeZoneProvider;
    @NonNull
    private final AllByIdsLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final UserLoader userLoader;
    @NonNull
    private final Function<String, List<Fond>> subkindToEnabledFondsExpander;
    @NonNull
    private final Function<Fond, List<Fond>> enabledIncludableFondsExpander;
    @NonNull
    private final Provider<Department> realRootDepartmentProvider;
    @NonNull
    private final RecordHoldingLoader recordHoldingLoader;
    @NonNull
    private final SaverBuilderFactory saverBuilderFactory;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final FieldTypesByFondLoader fieldTypesByFondLoader;
    @NonNull
    private final @NonNull Converter<@NonNull String, @NonNull Instant> recordFieldStringToInstantConverter;
    @NonNull
    private final StringToDateRangeConverter recordFieldStringToDateRangeConverter;
    @NonNull
    private final TimezonedStringToDatetimeRangeConverter recordFieldStringToDatetimeRangeConverter;
    @NonNull
    private final RecordFieldsLoader legacyRecordFieldsLoader;
    @NonNull
    private final RecordFieldsLoader newRecordFieldsLoader;
    @NonNull
    private final InternalRecordLoader internalRecordAllByIdsLoader;
    @NonNull
    private final KindedInternalRecordLoader kindedInternalRecordAllByIdsLoader;
    @NonNull
    private final DynamicCache<Record> recordCache;
    @NonNull
    private final LazyScheduler lazyScheduler;
    @NonNull
    private final DynamicTaskRegistrar taskRegistrar;
    @NonNull
    private final NamedParameterJdbcOperations notAutoCommittingJdbcTemplate;
    @NonNull
    private final EntityManager entityManager;

    @Bean
    public Provider<@NonNull Boolean> recordDetailPortaroLoadEnabled() {
        return this.settingLoader.getOnRootProvider(RecordSettingKeys.PORTARO_DETAIL_LOAD_ENABLED);
    }

    @Bean
    public Provider<@NonNull Boolean> recordDetailPortaroRecordFieldLoadEnabled() {
        return this.settingLoader.getOnRootProvider(RecordSettingKeys.PORTARO_DETAIL_RECORD_FIELD_LOAD_ENABLED);
    }

    @Bean
    public IdAndIdsLoadable<RecordEntity, UUID> recordEntityLoader() {
        return this.modelBeanBuilder.allByIdsLoader(RecordEntity.class);
    }

    @Bean
    public RecordFieldsLoader recordFieldsLoader() {
        return new SwitchableRecordFieldsLoader(this.recordDetailPortaroRecordFieldLoadEnabled(), this.newRecordFieldsLoader, this.legacyRecordFieldsLoader);
    }

    @Bean
    public AllByIdsLoadable<IdentifiedFieldContainer, Record> recordDetailLoader() {
        MarcXmlToDetailConverterImpl detailFromMarcXmlConstructor = new MarcXmlToDetailConverterImpl(false, this.fieldTypesByFondLoader, this.recordFieldStringToInstantConverter, this.recordFieldStringToDateRangeConverter, this.recordFieldStringToDatetimeRangeConverter, (ByIdLoadable)this.fondLoader);
        AppserverRecordDetailLoader bean = new AppserverRecordDetailLoader(this.mappingAppserver, false, (MarcXmlToDetailConverter)detailFromMarcXmlConstructor, (ByIdLoadable)this.fondLoader);
        ChunkingAllByIdsLoader chunking = ChunkingAllByIdsLoader.of((AllByIdsLoadable)bean, Identified::getId, BasicIdentified::getId).withChunkSize(50);
        RecordFieldsLoadingRecordDetailLoader portaroRecordDetailLoader = new RecordFieldsLoadingRecordDetailLoader(this.recordFieldsLoader());
        return new SwitchingAllByIdsLoader(this.recordDetailPortaroLoadEnabled(), (AllByIdsLoadable)portaroRecordDetailLoader, (AllByIdsLoadable)chunking);
    }

    @Bean
    public RichRecordLoader richRecordLoader() {
        return new DelegatingRichRecordsByIdsLoader(this.recordDetailLoader(), this.internalRecordAllByIdsLoader, true);
    }

    @Bean
    public IdAndIdsLoadable<Record, UUID> nonDetailedRichRecordLoader() {
        return new DelegatingRichRecordsByIdsLoader(this.recordDetailLoader(), this.internalRecordAllByIdsLoader, false);
    }

    @Bean
    public KindedRecordLoader kindedRichRecordLoader() {
        return new KindedDelegatingRecordsByIdsLoader(this.kindedInternalRecordAllByIdsLoader, this.recordDetailLoader());
    }

    @Bean
    public IdAndIdsLoadable<Record, Integer> authorityByKindedIdLoader() {
        return new ByIdLoadableByAllByIdsLoadable(arg_0 -> ((KindedRecordLoader)this.kindedRichRecordLoader()).getDetailedAuthoritiesByKindedIds(arg_0), Record.class);
    }

    @Bean
    public IdAndIdsLoadable<Record, Integer> nonDetailedAuthorityByKindedIdLoader() {
        return new ByIdLoadableByAllByIdsLoadable(arg_0 -> ((KindedRecordLoader)this.kindedRichRecordLoader()).getAuthoritiesByKindedIds(arg_0), Record.class);
    }

    @Bean
    public IdAndIdsLoadable<Record, Integer> nonDetailedDocumentByKindedIdLoader() {
        return new ByIdLoadableByAllByIdsLoadable(arg_0 -> ((KindedRecordLoader)this.kindedRichRecordLoader()).getDocumentsByKindedIds(arg_0), Record.class);
    }

    @Bean
    public IdAndIdsLoadable<Record, Integer> documentByKindedIdLoader() {
        return new ByIdLoadableByAllByIdsLoadable(arg_0 -> ((KindedRecordLoader)this.kindedRichRecordLoader()).getDetailedDocumentsByKindedIds(arg_0), Record.class);
    }

    @Bean
    public IdAndIdsLoadable<Record, UUID> nonDetailedDocumentLoader() {
        RecordDelegatingDocumentLoader documentLoader = new RecordDelegatingDocumentLoader(this.richRecordLoader(), false);
        return new ByIdLoadableByAllByIdsLoadable((AllByIdsLoadable)documentLoader, Record.class);
    }

    @Bean
    public DocumentLoader detailedDocumentLoader() {
        return new RecordDelegatingDocumentLoader(this.richRecordLoader(), true);
    }

    @Bean
    public IdAndIdsLoadable<Record, UUID> authorityLoader() {
        return new RecordLoaderDelegatingAuthorityLoader(this.richRecordLoader());
    }

    @Bean
    public Converter<List<RecordOperationEntity>, List<? extends RecordOperation>> entitiesToRecordOperationsConverter() {
        return new EntitiesToRecordOperationsConverter((ByIdLoadable)this.recordOperationTypeLoader(), this.departmentLoader, (AllByIdsLoadable)this.nonDetailedRichRecordLoader(), this.basicUserLoader);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, RecordOperation> recordOperationSearchLoader() {
        SpringDbRecordOperationEntitySearchLoader pureSearchLoader = new SpringDbRecordOperationEntitySearchLoader(this.jdbcTemplate, this.queryFactory);
        ParametersConvertingPageSearchLoader paramsConvertingSearchLoader = new ParametersConvertingPageSearchLoader((PageSearchLoader)pureSearchLoader).withExpandingParam(RecordConstants.SearchParams.OPERATED_SUBKIND, RecordConstants.SearchParams.OPERATED_FOND, this.subkindToEnabledFondsExpander).withExpandingParam(RecordConstants.SearchParams.OPERATED_ROOT_FOND, RecordConstants.SearchParams.OPERATED_FOND, this.enabledIncludableFondsExpander);
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new ResultConvertingPageSearchLoader((PageSearchLoader)paramsConvertingSearchLoader, this.entitiesToRecordOperationsConverter()));
    }

    @Bean
    public CachingRecordEditLevelProvider recordEditLevelProvider() {
        RecordOperationSearchDelegatingRecordEditLevelProvider bean = new RecordOperationSearchDelegatingRecordEditLevelProvider(this.recordOperationSearchLoader(), (ByIdLoadable)this.recordOperationTypeLoader(), (UserByBasicUserLoader)this.userLoader);
        CachingRecordEditLevelProvider cached = new CachingRecordEditLevelProvider((RecordEditLevelProvider)bean);
        this.cacheService.registerSpringCacheCleaner(RecordOperationType.class.getSimpleName(), "recordEditLevel");
        return cached;
    }

    @Bean
    public RecordHoldingUpserter recordHoldingUpserter() {
        AppserverRecordHoldingUpserter bean = new AppserverRecordHoldingUpserter(this.appserverXmlMapper, this.mappingAppserver, this.recordHoldingLoader, (ByIdLoadable)this.recordOperationTypeLoader(), this.recordOperationSaver());
        AuthorityHoldingDepartmentReplacingRecordHoldingUpserter authorityHoldingDepartmentReplacing = new AuthorityHoldingDepartmentReplacingRecordHoldingUpserter((RecordHoldingUpserter)bean, this.realRootDepartmentProvider);
        return new ExternalRecordSavingRecordHoldingUpserter(this.recordSaver(), (RecordHoldingUpserter)authorityHoldingDepartmentReplacing);
    }

    @Bean
    public OrBooleanProvider recordProcessingEnabledProvider() {
        return new OrBooleanProvider();
    }

    @Bean
    public RecordSaver recordSaver() {
        AppserverRecordSaver pure = new AppserverRecordSaver(this.mappingAppserver, (DetailToMarcXmlConverter)new StringBuilderDetailToMarcXmlConverter((Converter)new InstantToStringConverter(this.databaseColumnsTimeZoneProvider, MarcConstants.MARCXML_INSTANT_FORMATTER), DateRangeToStringConverter.ofInternalFormat(), DatetimeRangeToTimezonedStringConverter.ofInternalFormat()), (ByIdLoadable)this.authorityLoader(), List.of(this.recordCache, this.recordEditLevelProvider()), this.recordEntityLoader(), this.dbProcInvalidator());
        return new AfterSaveNotifierRecordSaver((RecordSaver)new SecuredRecordSaver((RecordSaver)pure, this.securityManager), this.recordDatabaseQueue(), (Provider)this.recordProcessingEnabledProvider());
    }

    @Bean
    public SimpleJpaRepository<RecordFieldEntity, UUID> recordFieldEntityRepository() {
        return new SimpleJpaRepository(RecordFieldEntity.class, this.entityManager);
    }

    @Bean
    public DependentRecordFieldDbProcInvalidator dbProcInvalidator() {
        return new DependentRecordFieldDbProcInvalidator(this.notAutoCommittingJdbcTemplate, this.queryFactory);
    }

    @Bean
    public DatabaseQueue<RecordIdFondPair> recordDatabaseQueue() {
        return new DbSchedulerQueue((SchedulerClient)this.lazyScheduler, this.taskRegistrar);
    }

    @Bean
    public Codebook<RecordOperationType, Integer> recordOperationTypeLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(RecordOperationTypeEntity.class).convertedEachBy((Converter)new EntityToRecordOperationTypeConverter()).staticCached(RecordOperationType.class.getSimpleName()).build();
    }

    @Bean
    public Saver<RecordOperation, RecordOperation> recordOperationSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new RecordOperationToEntityConverter()).build();
    }

    @ConstructorProperties(value={"appserverXmlMapper", "mappingAppserver", "jdbcTemplate", "queryFactory", "modelBeanBuilder", "departmentLoader", "fondLoader", "codebookLoaderBuilderFactory", "securityManager", "settingLoader", "databaseColumnsTimeZoneProvider", "basicUserLoader", "userLoader", "subkindToEnabledFondsExpander", "enabledIncludableFondsExpander", "realRootDepartmentProvider", "recordHoldingLoader", "saverBuilderFactory", "cacheService", "fieldTypesByFondLoader", "recordFieldStringToInstantConverter", "recordFieldStringToDateRangeConverter", "recordFieldStringToDatetimeRangeConverter", "legacyRecordFieldsLoader", "newRecordFieldsLoader", "internalRecordAllByIdsLoader", "kindedInternalRecordAllByIdsLoader", "recordCache", "lazyScheduler", "taskRegistrar", "notAutoCommittingJdbcTemplate", "entityManager"})
    @Generated
    public RecordLoadConfig(@NonNull ObjectMapper appserverXmlMapper, @NonNull MappingAppserverService mappingAppserver, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull Codebook<Fond, Integer> fondLoader, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull SecurityManager securityManager, @NonNull SettingLoader settingLoader, @NonNull @NonNull Provider<@NonNull ZoneId> databaseColumnsTimeZoneProvider, @NonNull AllByIdsLoadable<BasicUser, Integer> basicUserLoader, @NonNull UserLoader userLoader, @NonNull Function<String, List<Fond>> subkindToEnabledFondsExpander, @NonNull Function<Fond, List<Fond>> enabledIncludableFondsExpander, @NonNull Provider<Department> realRootDepartmentProvider, @NonNull RecordHoldingLoader recordHoldingLoader, @NonNull SaverBuilderFactory saverBuilderFactory, @NonNull CacheService cacheService, @NonNull FieldTypesByFondLoader fieldTypesByFondLoader, @NonNull @NonNull Converter<@NonNull String, @NonNull Instant> recordFieldStringToInstantConverter, @NonNull StringToDateRangeConverter recordFieldStringToDateRangeConverter, @NonNull TimezonedStringToDatetimeRangeConverter recordFieldStringToDatetimeRangeConverter, @NonNull RecordFieldsLoader legacyRecordFieldsLoader, @NonNull RecordFieldsLoader newRecordFieldsLoader, @NonNull InternalRecordLoader internalRecordAllByIdsLoader, @NonNull KindedInternalRecordLoader kindedInternalRecordAllByIdsLoader, @NonNull DynamicCache<Record> recordCache, @NonNull LazyScheduler lazyScheduler, @NonNull DynamicTaskRegistrar taskRegistrar, @NonNull NamedParameterJdbcOperations notAutoCommittingJdbcTemplate, @NonNull EntityManager entityManager) {
        Objects.requireNonNull(appserverXmlMapper, "appserverXmlMapper is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(databaseColumnsTimeZoneProvider, "databaseColumnsTimeZoneProvider is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(userLoader, "userLoader is marked non-null but is null");
        Objects.requireNonNull(subkindToEnabledFondsExpander, "subkindToEnabledFondsExpander is marked non-null but is null");
        Objects.requireNonNull(enabledIncludableFondsExpander, "enabledIncludableFondsExpander is marked non-null but is null");
        Objects.requireNonNull(realRootDepartmentProvider, "realRootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(recordHoldingLoader, "recordHoldingLoader is marked non-null but is null");
        Objects.requireNonNull(saverBuilderFactory, "saverBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(fieldTypesByFondLoader, "fieldTypesByFondLoader is marked non-null but is null");
        Objects.requireNonNull(recordFieldStringToInstantConverter, "recordFieldStringToInstantConverter is marked non-null but is null");
        Objects.requireNonNull(recordFieldStringToDateRangeConverter, "recordFieldStringToDateRangeConverter is marked non-null but is null");
        Objects.requireNonNull(recordFieldStringToDatetimeRangeConverter, "recordFieldStringToDatetimeRangeConverter is marked non-null but is null");
        Objects.requireNonNull(legacyRecordFieldsLoader, "legacyRecordFieldsLoader is marked non-null but is null");
        Objects.requireNonNull(newRecordFieldsLoader, "newRecordFieldsLoader is marked non-null but is null");
        Objects.requireNonNull(internalRecordAllByIdsLoader, "internalRecordAllByIdsLoader is marked non-null but is null");
        Objects.requireNonNull(kindedInternalRecordAllByIdsLoader, "kindedInternalRecordAllByIdsLoader is marked non-null but is null");
        Objects.requireNonNull(recordCache, "recordCache is marked non-null but is null");
        Objects.requireNonNull(lazyScheduler, "lazyScheduler is marked non-null but is null");
        Objects.requireNonNull(taskRegistrar, "taskRegistrar is marked non-null but is null");
        Objects.requireNonNull(notAutoCommittingJdbcTemplate, "notAutoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        this.appserverXmlMapper = appserverXmlMapper;
        this.mappingAppserver = mappingAppserver;
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.modelBeanBuilder = modelBeanBuilder;
        this.departmentLoader = departmentLoader;
        this.fondLoader = fondLoader;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.securityManager = securityManager;
        this.settingLoader = settingLoader;
        this.databaseColumnsTimeZoneProvider = databaseColumnsTimeZoneProvider;
        this.basicUserLoader = basicUserLoader;
        this.userLoader = userLoader;
        this.subkindToEnabledFondsExpander = subkindToEnabledFondsExpander;
        this.enabledIncludableFondsExpander = enabledIncludableFondsExpander;
        this.realRootDepartmentProvider = realRootDepartmentProvider;
        this.recordHoldingLoader = recordHoldingLoader;
        this.saverBuilderFactory = saverBuilderFactory;
        this.cacheService = cacheService;
        this.fieldTypesByFondLoader = fieldTypesByFondLoader;
        this.recordFieldStringToInstantConverter = recordFieldStringToInstantConverter;
        this.recordFieldStringToDateRangeConverter = recordFieldStringToDateRangeConverter;
        this.recordFieldStringToDatetimeRangeConverter = recordFieldStringToDatetimeRangeConverter;
        this.legacyRecordFieldsLoader = legacyRecordFieldsLoader;
        this.newRecordFieldsLoader = newRecordFieldsLoader;
        this.internalRecordAllByIdsLoader = internalRecordAllByIdsLoader;
        this.kindedInternalRecordAllByIdsLoader = kindedInternalRecordAllByIdsLoader;
        this.recordCache = recordCache;
        this.lazyScheduler = lazyScheduler;
        this.taskRegistrar = taskRegistrar;
        this.notAutoCommittingJdbcTemplate = notAutoCommittingJdbcTemplate;
        this.entityManager = entityManager;
    }
}

