/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.app.PortaroUrls;
import cz.kpsys.portaro.appserver.dml.TableWriteGenerator;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.auth.context.AuthenticatedContextualFunction;
import cz.kpsys.portaro.auth.context.AuthenticatedContextualProvider;
import cz.kpsys.portaro.commons.cache.CacheBackedRepository;
import cz.kpsys.portaro.commons.cache.CacheDeletableById;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.cache.DynamicCache;
import cz.kpsys.portaro.commons.cache.GuavaTimedDynamicCache;
import cz.kpsys.portaro.commons.contextual.ContextualFunction;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.convert.ChainingConverter;
import cz.kpsys.portaro.commons.convert.IdToObjectConverter;
import cz.kpsys.portaro.commons.convert.ListToModifiedListConverter;
import cz.kpsys.portaro.commons.date.StringToDateRangeConverter;
import cz.kpsys.portaro.commons.date.TimezonedStringToDatetimeRangeConverter;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.BasicIdentified;
import cz.kpsys.portaro.commons.object.Identified;
import cz.kpsys.portaro.commons.object.LabeledIdentified;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.StaticAllValuesProvider;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdsLoadableRepository;
import cz.kpsys.portaro.commons.object.repo.ChunkingAllByIdsLoader;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.CompositeByIdLoader;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.DispatchingByStringIdLoader;
import cz.kpsys.portaro.commons.object.repo.GenericHookableDeleter;
import cz.kpsys.portaro.commons.object.repo.GenericHookableSaver;
import cz.kpsys.portaro.commons.object.repo.HookableSaver;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.TransactionalByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.TransactionalDeleter;
import cz.kpsys.portaro.commons.util.StringUtil;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.contextual.ContextualVisibleDepartmentsLoader;
import cz.kpsys.portaro.database.JpaAllValuesProvider;
import cz.kpsys.portaro.database.ScalarValueDatabaseLoader;
import cz.kpsys.portaro.datatype.DatatypedAcceptableValuesRegistry;
import cz.kpsys.portaro.datatype.ScalarDatatype;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.file.CacheCleaningIdentifiedFileDeleter;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.directory.AllIdsByDirectoryProvider;
import cz.kpsys.portaro.file.security.FileSecurityActions;
import cz.kpsys.portaro.file.security.IdentifiedFileDeletionCommand;
import cz.kpsys.portaro.file.security.IdentifiedFileSaveCommand;
import cz.kpsys.portaro.filter.Filter;
import cz.kpsys.portaro.filter.FilterLoader;
import cz.kpsys.portaro.filter.LazyFilter;
import cz.kpsys.portaro.formconfig.valueeditor.AuthenticatedAcceptableValuesResolver;
import cz.kpsys.portaro.hierarchy.HierarchyLoader;
import cz.kpsys.portaro.id.IDdFile;
import cz.kpsys.portaro.prop.CompositeObjectPropertiesGenerator;
import cz.kpsys.portaro.prop.ObjectPropertiesGenerator;
import cz.kpsys.portaro.record.DelegatingRichRecordsByIdsLoader;
import cz.kpsys.portaro.record.IdsToRecordsConverter;
import cz.kpsys.portaro.record.InternalRecordLoader;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RecordConstants;
import cz.kpsys.portaro.record.RecordDescriptor;
import cz.kpsys.portaro.record.RecordEntity;
import cz.kpsys.portaro.record.RecordHeaderResponse;
import cz.kpsys.portaro.record.RecordIdFondPair;
import cz.kpsys.portaro.record.RecordSecurityActions;
import cz.kpsys.portaro.record.RecordSettingKeys;
import cz.kpsys.portaro.record.RecordStatus;
import cz.kpsys.portaro.record.RecordToEntityConverter;
import cz.kpsys.portaro.record.SimilarRecordsLoader;
import cz.kpsys.portaro.record.SpringDbSimilarRecordsLoader;
import cz.kpsys.portaro.record.authority.RecordHierarchyLoader;
import cz.kpsys.portaro.record.authority.SpringDbAllAuthorityIdsByDirectoryLoader;
import cz.kpsys.portaro.record.authority.SpringDbAuthorityHierarchyLoader;
import cz.kpsys.portaro.record.authority.SpringDbAuthoritySearchLoader;
import cz.kpsys.portaro.record.detail.AppserverRecordDetailLoader;
import cz.kpsys.portaro.record.detail.FieldId;
import cz.kpsys.portaro.record.detail.FieldType;
import cz.kpsys.portaro.record.detail.FieldTypeId;
import cz.kpsys.portaro.record.detail.FieldTypeLoader;
import cz.kpsys.portaro.record.detail.FieldTypeLoaderByStringIdAdapter;
import cz.kpsys.portaro.record.detail.IdentifiedFieldContainer;
import cz.kpsys.portaro.record.detail.IndicatorType;
import cz.kpsys.portaro.record.detail.RecordNameResolver;
import cz.kpsys.portaro.record.detail.appservermarc.MarcXmlToDetailConverterImpl;
import cz.kpsys.portaro.record.detail.convert.MarcXmlToDetailConverter;
import cz.kpsys.portaro.record.detail.spec.RecordIdFieldTypeId;
import cz.kpsys.portaro.record.document.AuthoritySourceDocumentProvider;
import cz.kpsys.portaro.record.document.CachedAllRecordIdsByDirectoryLoader;
import cz.kpsys.portaro.record.document.CompositeDocumentContentTypeResolver;
import cz.kpsys.portaro.record.document.DocumentContentTypeResolver;
import cz.kpsys.portaro.record.document.SpringDbAuthoritySourceDocumentProvider;
import cz.kpsys.portaro.record.document.SpringDbDocumentIdSearchLoader;
import cz.kpsys.portaro.record.edit.FieldTypesByFondLoader;
import cz.kpsys.portaro.record.edit.RecordEntryFieldTypeIdResolver;
import cz.kpsys.portaro.record.edit.RecordValidator;
import cz.kpsys.portaro.record.edit.authorityfield008.AuthorityField008Definitions;
import cz.kpsys.portaro.record.edit.authorityfield008.AuthorityField008DefinitionsLoader;
import cz.kpsys.portaro.record.edit.authorityfield008.AuthorityField008EditFormData;
import cz.kpsys.portaro.record.edit.field007.Field007CodeEntity;
import cz.kpsys.portaro.record.edit.field007.Field007Definitions;
import cz.kpsys.portaro.record.edit.field007.Field007DefinitionsLoader;
import cz.kpsys.portaro.record.edit.field007.Field007DocumentCategoryEntity;
import cz.kpsys.portaro.record.edit.field007.Field007LabelEntity;
import cz.kpsys.portaro.record.edit.field008.Field008CodeEntity;
import cz.kpsys.portaro.record.edit.field008.Field008Definitions;
import cz.kpsys.portaro.record.edit.field008.Field008DefinitionsLoader;
import cz.kpsys.portaro.record.edit.field008.Field008EditFormData;
import cz.kpsys.portaro.record.evaluation.DocumentRating;
import cz.kpsys.portaro.record.evaluation.DocumentRatingRowMapper;
import cz.kpsys.portaro.record.evaluation.RatingSaver;
import cz.kpsys.portaro.record.evaluation.RatingSaverEvaluatedCheckingProxy;
import cz.kpsys.portaro.record.evaluation.SpringDbRatingLoaderAndSaver;
import cz.kpsys.portaro.record.file.IdentifiedFileSaverRecordPrimaryImageSavingDecorator;
import cz.kpsys.portaro.record.file.PrimaryImageToRecordsSaveCommand;
import cz.kpsys.portaro.record.file.PrimaryImageToRecordsSaver;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.record.holding.RecordHolding;
import cz.kpsys.portaro.record.holding.RecordHoldingLoader;
import cz.kpsys.portaro.record.link.RecordLinkLoader;
import cz.kpsys.portaro.record.link.SearchElsewhereItemsRecordLinkLoader;
import cz.kpsys.portaro.record.link.SpringDbObalkyKnihRecordLinkLoader;
import cz.kpsys.portaro.record.list.RecordIdStorage;
import cz.kpsys.portaro.record.list.RecordIdStorageImpl;
import cz.kpsys.portaro.record.operation.EntitiesToRecordOperationRecordIdsConverter;
import cz.kpsys.portaro.record.operation.RecordOperation;
import cz.kpsys.portaro.record.operation.RecordOperationEntity;
import cz.kpsys.portaro.record.operation.RecordOperationToEntityConverter;
import cz.kpsys.portaro.record.operation.RecordOperationType;
import cz.kpsys.portaro.record.operation.SpringDbRecordOperationEntitySearchLoader;
import cz.kpsys.portaro.record.prop.DetailDelegatingRecordPropertiesGenerator;
import cz.kpsys.portaro.record.prop.DetailRecordPropertiesGenerator;
import cz.kpsys.portaro.record.prop.ReusingRecordPropertiesGenerator;
import cz.kpsys.portaro.record.prop.SimpleDetailRecordPropertiesGenerator;
import cz.kpsys.portaro.record.revision.ConvertingRecordRevisionLoader;
import cz.kpsys.portaro.record.revision.EntityToRecordRevisionConverter;
import cz.kpsys.portaro.record.revision.RecordRevisionEntityLoader;
import cz.kpsys.portaro.record.revision.RecordRevisionLoader;
import cz.kpsys.portaro.record.revision.SpringDbRecordRevisionEntityLoader;
import cz.kpsys.portaro.record.view.show.RecordShowListener;
import cz.kpsys.portaro.record.view.show.SpringDbRecordShowCountSaver;
import cz.kpsys.portaro.search.CoreSearchParams;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoaderImpl;
import cz.kpsys.portaro.search.ParametersConvertingPageSearchLoader;
import cz.kpsys.portaro.search.ResultConvertingPageSearchLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingKey;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.view.web.rest.record.AssignableRecordDepartmentsAuthenticatedContextualProvider;
import cz.kpsys.portaro.view.web.rest.record.RecordHoldingCreationRequest;
import cz.kpsys.portaro.view.web.rest.record.VisibleRecordHoldingResolver;
import jakarta.persistence.EntityManager;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class RecordConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecordConfig.class);
    private final @NonNull ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider;
    @NonNull
    private final Codebook<RecordStatus, Integer> recordStatusLoader;
    @NonNull
    private final Codebook<Fond, Integer> fondLoader;
    @NonNull
    private final AllValuesProvider<Fond> enabledFondsProvider;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final CacheDeletableById recordCache;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final NamedParameterJdbcOperations notAutoCommittingJdbcTemplate;
    @NonNull
    private final NamedParameterJdbcOperations notCriticalJdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final TransactionTemplateFactory readonlyTransactionTemplateFactory;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final FilterLoader filterLoader;
    @NonNull
    private final HttpServletRequest httpServletRequest;
    private final @NonNull ByIdLoadable<@Nullable AllValuesProvider<? extends LabeledIdentified<?>>, ScalarDatatype> acceptableValuesProviderLoader;
    @NonNull
    private final Saver<IdentifiedFileSaveCommand, IdentifiedFile> loadedIdentifiedFileSaver;
    @NonNull
    private final Saver<IdentifiedFile, IdentifiedFile> identifiedFileSaver;
    @NonNull
    private final Deleter<IDdFile> pureIdentifiedFileDeleter;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final SaverBuilderFactory saverBuilderFactory;
    @NonNull
    private final AuthenticatedContextualProvider<Department, List<Department>> editableDepartmentsAuthenticatedContextualProvider;
    @NonNull
    private final HierarchyLoader<Department> contextHierarchyLoader;
    @NonNull
    private final RecordHoldingLoader recordHoldingLoader;
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final @NonNull Function<@NonNull IDdFile, IdentifiedFile> fullIdentifiedFileConverter;
    @NonNull
    private final Function<String, List<Fond>> subkindToEnabledFondsExpander;
    @NonNull
    private final Function<Fond, List<Fond>> enabledIncludableFondsExpander;
    @NonNull
    private final DatatypedAcceptableValuesRegistry allowedDatatypeToAllValuesProviderMap;
    @NonNull
    private final DatatypedAcceptableValuesRegistry allDatatypeToAllValuesProviderMap;
    @NonNull
    private final Codebook<IndicatorType, FieldTypeId> indicatorTypeLoader;
    @NonNull
    private final RecordEntryFieldTypeIdResolver recordEntryFieldTypeIdResolver;
    @NonNull
    private final IdAndIdsLoadable<Record, UUID> richRecordLoader;
    @NonNull
    private final ByIdLoadable<RecordIdFondPair, UUID> recordFondPairsLoader;
    @NonNull
    private final FieldTypeLoader fieldTypeLoader;
    @NonNull
    private final InternalRecordLoader internalRecordAllByIdsLoader;
    @NonNull
    private final @NonNull Converter<@NonNull String, @NonNull Instant> recordFieldStringToInstantConverter;
    @NonNull
    private final StringToDateRangeConverter recordFieldStringToDateRangeConverter;
    @NonNull
    private final TimezonedStringToDatetimeRangeConverter recordFieldStringToDatetimeRangeConverter;
    @NonNull
    private final IdAndIdsLoadable<Record, Integer> authorityByKindedIdLoader;
    @NonNull
    private final IdAndIdsLoadable<Record, Integer> documentByKindedIdLoader;
    @NonNull
    private final IdAndIdsLoadable<Record, Integer> nonDetailedDocumentByKindedIdLoader;
    @NonNull
    private final IdAndIdsLoadable<Record, Integer> nonDetailedAuthorityByKindedIdLoader;
    @NonNull
    private final IdAndIdsLoadable<Record, UUID> nonDetailedRichRecordLoader;
    @NonNull
    private final Codebook<RecordOperationType, Integer> recordOperationTypeLoader;
    @NonNull
    private final FieldTypesByFondLoader fieldTypesByFondLoader;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final Runnable saveTransactionAuthenticator;

    @Bean
    public Saver<Record, RecordEntity> recordHeaderSaver() {
        HookableSaver saver = this.saverBuilderFactory.jpaSaver(Record.class).intermediateConverting((Converter)new RecordToEntityConverter(), RecordEntity.class).build();
        saver.addPostSuccessHook(entity -> this.recordCache.deleteFromCacheById((Object)entity.getId()));
        return saver;
    }

    @Bean
    public RatingSaver ratingSaver() {
        return new RatingSaverEvaluatedCheckingProxy((RatingSaver)this.ratingLoader(), this.byUserEvaluatedDocuments());
    }

    @Bean
    public SpringDbRatingLoaderAndSaver ratingLoader() {
        return new SpringDbRatingLoaderAndSaver(this.jdbcTemplate, this.queryFactory, this.recordCache);
    }

    @Bean
    public RecordNameResolver recordNameResolver() {
        return new RecordNameResolver(this.recordEntryFieldTypeIdResolver);
    }

    @Bean
    public RowMapper<DocumentRating> documentRatingRowMapper() {
        return new DocumentRatingRowMapper();
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
    public RecordIdStorage byUserEvaluatedDocuments() {
        return new RecordIdStorageImpl();
    }

    @Bean
    public RecordShowListener recordShowCountSaver() {
        return new SpringDbRecordShowCountSaver(this.jdbcTemplate, this.queryFactory, this.executorService);
    }

    @Bean
    public SimilarRecordsLoader similarRecordsLoader() {
        return new SpringDbSimilarRecordsLoader(this.notAutoCommittingJdbcTemplate, this.queryFactory, this.readonlyTransactionTemplateFactory.get(), this.settingLoader.getOnRootProvidedList(RecordSettingKeys.FORBIDDEN_RECORDS), this.enabledFondsProvider, (AllByIdsLoadable)this.richRecordLoader, (HierarchyLoader)this.departmentAccessor);
    }

    @Bean
    public ObjectPropertiesGenerator<Record> recordPropertiesGenerator() {
        return CompositeObjectPropertiesGenerator.of(List.of(new ReusingRecordPropertiesGenerator(), new DetailDelegatingRecordPropertiesGenerator(this.detailRecordPropertiesGenerator())));
    }

    @Bean
    public DetailRecordPropertiesGenerator detailRecordPropertiesGenerator() {
        return new SimpleDetailRecordPropertiesGenerator();
    }

    @Bean
    public RecordHierarchyLoader recordHierarchyLoader() {
        return new SpringDbAuthorityHierarchyLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public ByIdsLoadableRepository<Record, UUID> externalRecordRepository() {
        return CacheBackedRepository.of((DynamicCache)new GuavaTimedDynamicCache(BasicIdentified::getId, Duration.ofMinutes(5L), false), BasicIdentified::getId);
    }

    @Bean
    public IdAndIdsLoadable<Record, UUID> recordLoader() {
        return CompositeByIdLoader.of((IdAndIdsLoadable[])new IdAndIdsLoadable[]{this.richRecordLoader, this.externalRecordRepository()});
    }

    @Bean
    public ByIdLoadable<FieldType<?>, FieldTypeId> subfieldTypeLoader() {
        return arg_0 -> ((FieldTypeLoader)this.fieldTypeLoader).getSubfieldTypeById(arg_0);
    }

    @Bean
    public RecordValidator recordValidator() {
        return new RecordValidator(this.recordEntryFieldTypeIdResolver, this.fieldTypesByFondLoader);
    }

    @Bean
    public DynamicCache<Record> exportedRecordCache() {
        return new GuavaTimedDynamicCache(BasicIdentified::getId, Duration.ofSeconds(10L), false).throwWhenCacheIsFull();
    }

    @Bean
    public IdAndIdsLoadable<Record, UUID> exportedRecordLoader() {
        return new DelegatingRichRecordsByIdsLoader(this.exportedRecordDetailLoader(), this.internalRecordAllByIdsLoader, true);
    }

    @Bean
    public AllByIdsLoadable<IdentifiedFieldContainer, Record> exportedRecordDetailLoader() {
        MarcXmlToDetailConverterImpl detailFromMarcXmlConstructor = new MarcXmlToDetailConverterImpl(false, this.fieldTypesByFondLoader, this.recordFieldStringToInstantConverter, this.recordFieldStringToDateRangeConverter, this.recordFieldStringToDatetimeRangeConverter, (ByIdLoadable)this.fondLoader);
        AppserverRecordDetailLoader bean = new AppserverRecordDetailLoader(this.mappingAppserver, true, (MarcXmlToDetailConverter)detailFromMarcXmlConstructor, (ByIdLoadable)this.fondLoader);
        return ChunkingAllByIdsLoader.of((AllByIdsLoadable)bean, Identified::getId, BasicIdentified::getId).withChunkSize(50);
    }

    @Bean
    public Converter<List<String>, List<Record>> stringIdsToRecordsConverter() {
        return new IdsToRecordsConverter().withAuthoritySupport((AllByIdsLoadable)this.authorityByKindedIdLoader).withDocumentSupport((AllByIdsLoadable)this.documentByKindedIdLoader).withRecordSupport((AllByIdsLoadable)this.richRecordLoader);
    }

    @Bean
    public Converter<List<String>, List<RecordIdFondPair>> stringIdsToRecordHeadersConverter() {
        IdsToRecordsConverter stringIdsToNonDetailedRecordsConverter = new IdsToRecordsConverter().withAuthoritySupport((AllByIdsLoadable)this.nonDetailedAuthorityByKindedIdLoader).withDocumentSupport((AllByIdsLoadable)this.nonDetailedDocumentByKindedIdLoader).withRecordSupport((AllByIdsLoadable)this.nonDetailedRichRecordLoader);
        return new ChainingConverter((Converter)stringIdsToNonDetailedRecordsConverter, (Converter)new ListToModifiedListConverter(Record::idFondPair));
    }

    @Bean
    public Converter<List<UUID>, List<? extends Record>> idsToRecordsConverter() {
        return arg_0 -> ((IdAndIdsLoadable)this.richRecordLoader).getAllByIds(arg_0);
    }

    @Bean
    public ByIdLoadable<@NonNull Record, String> recordStringIdPrefixDispatchingLoader() {
        return new DispatchingByStringIdLoader(":").addUuid((ByIdLoadable)this.recordLoader()).addPrefixedIntegerId("dkid", (ByIdLoadable)this.documentByKindedIdLoader).addPrefixedStringId("f1", kpwIdZaz -> {
            UUID recordId = (UUID)this.recordIdByField1ValueLoader().getById(kpwIdZaz);
            return (Record)this.recordLoader().getById((Object)recordId);
        });
    }

    @Bean
    public ByIdLoadable<@NonNull UUID, String> recordIdStringIdPrefixDispatchingLoader() {
        return new DispatchingByStringIdLoader(":").addUuid(x -> x).addPrefixedIntegerId("dkid", kindedId -> (UUID)((Record)this.documentByKindedIdLoader.getById(kindedId)).getId()).addPrefixedStringId("f1", kpwIdZaz -> (UUID)this.recordIdByField1ValueLoader().getById(kpwIdZaz));
    }

    @Bean
    public ByIdLoadable<@NonNull UUID, String> recordIdByField1ValueLoader() {
        return new TransactionalByIdLoadable(field1Value -> {
            StringUtil.assertHasTrimmedLength((String)field1Value, () -> "Given field 001 value cannot be empty.");
            ScalarValueDatabaseLoader loader = ScalarValueDatabaseLoader.ofQuery(UUID.class, (NamedParameterJdbcOperations)this.notAutoCommittingJdbcTemplate, (QueryFactory)this.queryFactory, (String)"kat1_1", (String)"record_id", (Consumer)new /* Unavailable Anonymous Inner Class!! */);
            return (UUID)loader.get();
        }, this.readonlyTransactionTemplateFactory.get());
    }

    @Bean
    public AuthoritySourceDocumentProvider authoritySourceDocumentProvider() {
        return new SpringDbAuthoritySourceDocumentProvider(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public TableWriteGenerator<RecordOperation> recordOperationTableWriteGenerator() {
        return this.modelBeanBuilder.modelTableWriteGenerator((Converter)new RecordOperationToEntityConverter());
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, UUID> recordOperationRecordIdSearchLoader() {
        SpringDbRecordOperationEntitySearchLoader pureSearchLoader = new SpringDbRecordOperationEntitySearchLoader(this.jdbcTemplate, this.queryFactory);
        ParametersConvertingPageSearchLoader paramsConvertingSearchLoader = new ParametersConvertingPageSearchLoader((PageSearchLoader)pureSearchLoader).withExpandingParam(RecordConstants.SearchParams.OPERATED_SUBKIND, RecordConstants.SearchParams.OPERATED_FOND, this.subkindToEnabledFondsExpander).withExpandingParam(RecordConstants.SearchParams.OPERATED_ROOT_FOND, RecordConstants.SearchParams.OPERATED_FOND, this.enabledIncludableFondsExpander);
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new ResultConvertingPageSearchLoader((PageSearchLoader)paramsConvertingSearchLoader, this.entitiesToRecordOperationRecordIdsConverter()));
    }

    @Bean
    public Converter<List<RecordOperationEntity>, List<? extends UUID>> entitiesToRecordOperationRecordIdsConverter() {
        return new EntitiesToRecordOperationRecordIdsConverter();
    }

    @Bean
    public RecordRevisionLoader recordRevisionLoader() {
        return new ConvertingRecordRevisionLoader((RecordRevisionEntityLoader)new SpringDbRecordRevisionEntityLoader(this.jdbcTemplate, this.queryFactory), (Converter)new ListToModifiedListConverter((Converter)new EntityToRecordRevisionConverter((ByIdLoadable)this.nonDetailedDocumentByKindedIdLoader, (ByIdLoadable)this.nonDetailedAuthorityByKindedIdLoader)));
    }

    @Bean
    public DocumentContentTypeResolver documentContentTypeResolver() {
        return new CompositeDocumentContentTypeResolver();
    }

    @Bean
    public RecordLinkLoader externalDetailRecordLinkLoader() {
        return new SpringDbObalkyKnihRecordLinkLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public RecordLinkLoader searchElsewhereRecordLinkLoader() {
        return new SearchElsewhereItemsRecordLinkLoader(this.settingLoader.getOnRootProvidedList(SettingKeys.SEARCH_ELSEWHERE_ITEMS));
    }

    @Bean
    public Saver<IdentifiedFileSaveCommand, IdentifiedFile> primaryCoverSavingLoadedIdentifiedFileSaver() {
        return new IdentifiedFileSaverRecordPrimaryImageSavingDecorator(this.loadedIdentifiedFileSaver, this.identifiedFileSaver, this.allRecordIdsByDirectoryProvider(), (AllIdsByDirectoryProvider)this.allAuthorityIdsByDirectoryProvider(), (AllByIdsLoadable)this.nonDetailedRichRecordLoader, this.recordHeaderSaver(), this.primaryImageToRecordsSaver());
    }

    @Bean
    public Saver<PrimaryImageToRecordsSaveCommand, List<Record>> primaryImageToRecordsSaver() {
        return new GenericHookableSaver((Saver)new PrimaryImageToRecordsSaver(this.notAutoCommittingJdbcTemplate, this.queryFactory)).addPreHook(this.saveTransactionAuthenticator);
    }

    @Bean
    public Deleter<IDdFile> identifiedFileDeleter() {
        GenericHookableDeleter saver = new GenericHookableDeleter((Deleter)new TransactionalDeleter((Deleter)new CacheCleaningIdentifiedFileDeleter(this.pureIdentifiedFileDeleter, this.fullIdentifiedFileConverter, this.recordCache, this.allRecordIdsByDirectoryProvider(), (AllIdsByDirectoryProvider)this.allAuthorityIdsByDirectoryProvider()), this.defaultTransactionTemplateFactory.get()));
        saver.addPreHook(this.saveTransactionAuthenticator);
        return saver;
    }

    @Bean
    public Deleter<IdentifiedFileDeletionCommand> securedIdentifiedFileDeleter() {
        Deleter delegate = this.identifiedFileDeleter();
        return cmd -> {
            this.securityManager.throwIfCannot(FileSecurityActions.FILES_MANAGE, cmd.currentAuth(), cmd.ctx());
            delegate.delete((Object)cmd.file());
        };
    }

    @Bean
    public AllIdsByDirectoryProvider allRecordIdsByDirectoryProvider() {
        return new CachedAllRecordIdsByDirectoryLoader(this.jdbcTemplate, this.queryFactory, (List)this.settingLoader.getOnRoot(RecordSettingKeys.FORBIDDEN_RECORDS), (List)this.settingLoader.getOnRoot(RecordSettingKeys.FORBIDDEN_RECORD_STATUSES));
    }

    @Bean
    public SpringDbAllAuthorityIdsByDirectoryLoader allAuthorityIdsByDirectoryProvider() {
        return new SpringDbAllAuthorityIdsByDirectoryLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, UUID> notCriticalAuthorityIdSearchSqlLoader() {
        SpringDbAuthoritySearchLoader pureSearchLoader = new SpringDbAuthoritySearchLoader(this.notCriticalJdbcTemplate, this.queryFactory);
        ParametersConvertingPageSearchLoader paramsConvertingSearchLoader = new ParametersConvertingPageSearchLoader((PageSearchLoader)pureSearchLoader).withExpandingParam(CoreSearchParams.SUBKIND, RecordConstants.SearchParams.FOND, this.subkindToEnabledFondsExpander).withExpandingParam(RecordConstants.SearchParams.ROOT_FOND, RecordConstants.SearchParams.FOND, this.enabledIncludableFondsExpander);
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)paramsConvertingSearchLoader);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Record> notCriticalDetailedAuthoritySearchSqlLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new ResultConvertingPageSearchLoader((PageSearchLoader)this.notCriticalAuthorityIdSearchSqlLoader(), this.idsToRecordsConverter()));
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, UUID> documentIdSearchSqlLoader() {
        SpringDbDocumentIdSearchLoader pureSearchLoader = new SpringDbDocumentIdSearchLoader(this.jdbcTemplate, this.queryFactory, this.departmentAccessor);
        ParametersConvertingPageSearchLoader paramsConvertingSearchLoader = new ParametersConvertingPageSearchLoader((PageSearchLoader)pureSearchLoader).withExpandingParam(CoreSearchParams.SUBKIND, RecordConstants.SearchParams.FOND, this.subkindToEnabledFondsExpander).withExpandingParam(RecordConstants.SearchParams.ROOT_FOND, RecordConstants.SearchParams.FOND, this.enabledIncludableFondsExpander);
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)paramsConvertingSearchLoader);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Record> nonDetailedRecordSearchSqlLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new ResultConvertingPageSearchLoader((PageSearchLoader)this.documentIdSearchSqlLoader(), arg_0 -> ((IdAndIdsLoadable)this.nonDetailedRichRecordLoader).getAllByIds(arg_0)));
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Record> detailedRecordSearchSqlLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new ResultConvertingPageSearchLoader((PageSearchLoader)this.documentIdSearchSqlLoader(), this.idsToRecordsConverter()));
    }

    @Bean
    public Field007DefinitionsLoader field007DefinitionsLoader() {
        Field007DefinitionsLoader bean = new Field007DefinitionsLoader((AllValuesProvider)new JpaAllValuesProvider((JpaRepository)new SimpleJpaRepository(Field007DocumentCategoryEntity.class, this.entityManager)), (AllValuesProvider)new JpaAllValuesProvider((JpaRepository)new SimpleJpaRepository(Field007CodeEntity.class, this.entityManager)), (AllValuesProvider)new JpaAllValuesProvider((JpaRepository)new SimpleJpaRepository(Field007LabelEntity.class, this.entityManager)));
        this.cacheService.registerSpringCacheCleaner(Field007Definitions.class.getSimpleName(), "field007definitions");
        return bean;
    }

    @Bean
    public Field008DefinitionsLoader field008DefinitionsLoader() {
        Field008DefinitionsLoader bean = new Field008DefinitionsLoader(this.acceptableValuesProviderLoader, (AllValuesProvider)new JpaAllValuesProvider((JpaRepository)new SimpleJpaRepository(Field008CodeEntity.class, this.entityManager)), StaticAllValuesProvider.of((List)Field008EditFormData.getLabelEntities()), StaticAllValuesProvider.of((List)Field008EditFormData.getDocumentTypeEntities()), (Provider)StaticProvider.of((Object)Field008EditFormData.getPublicationStatus()), (Provider)StaticProvider.of((Object)Field008EditFormData.getModifiedRecord()), (Provider)StaticProvider.of((Object)Field008EditFormData.getCatalogingSource()));
        this.cacheService.registerSpringCacheCleaner(Field008Definitions.class.getSimpleName(), "field008definitions");
        return bean;
    }

    @Bean
    public AuthorityField008DefinitionsLoader authorityField008DefinitionsLoader() {
        AuthorityField008DefinitionsLoader bean = new AuthorityField008DefinitionsLoader((Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getDirectOrIndirectGeographicSubdivision()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getRomanizationScheme()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getLanguageOfCatalog()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getKindOfRecord()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getDescriptiveCatalogingRules()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getSubjectHeadingSystemThesaurus()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getTypeOfSeries()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getNumberedOrUnnumberedSeries()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getHeadingUseMainOrAddedEntry()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getHeadingUseSubjectAddedEntry()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getHeadingUseSeriesAddedEntry()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getTypeOfSubjectSubdivision()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getTypeOfGovernmentAgency()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getReferenceEvaluation()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getRecordUpdateInProcess()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getUndifferentiatedPersonalName()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getLevelOfEstablishment()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getModifiedRecord()), (Provider)StaticProvider.of((Object)AuthorityField008EditFormData.getCatalogingSource()));
        this.cacheService.registerSpringCacheCleaner(AuthorityField008Definitions.class.getSimpleName(), "authorityField008definitions");
        return bean;
    }

    @Bean
    public ContextualProvider<Department, Converter<UUID, @NonNull String>> recordIdToRecordDetailUrlConverterProvider() {
        return this.serverUrlProvider.andThen(PortaroUrls::getUuidToRecordDetailUrlConverter);
    }

    @Bean
    public AuthenticatedAcceptableValuesResolver<RecordHoldingCreationRequest, Department> assignableDepartmentsAuthenticatedContextualProvider() {
        return new RecordHoldingCreationRequest.AssignableDepartmentsAuthenticatedContextualProvider(this.assignableRecordDepartmentsAuthenticatedContextualProvider());
    }

    @Bean
    public AuthenticatedAcceptableValuesResolver<Record, Department> assignableRecordDepartmentsAuthenticatedContextualProvider() {
        return new AssignableRecordDepartmentsAuthenticatedContextualProvider(this.recordHoldingLoader, this.assignableDepartmentsLoader());
    }

    @Bean
    public ContextualVisibleDepartmentsLoader assignableDepartmentsLoader() {
        return ContextualVisibleDepartmentsLoader.ofSettingsKey((HierarchyLoader)this.contextHierarchyLoader, (SettingLoader)this.settingLoader, (SettingKey)RecordSettingKeys.HOLDING_ASSIGNABLE_FROM_CONTEXTS, (ContextualFunction)this.editableDepartmentsAuthenticatedContextualProvider);
    }

    @Bean
    public AuthenticatedContextualFunction<Record, Department, List<RecordHolding>> visibleRecordHoldingsResolver() {
        return new VisibleRecordHoldingResolver(this.assignableDepartmentsLoader(), this.recordHoldingLoader);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerModule() {
        Function<String, AllValuesProvider> acceptableIndicatorsByTypeIdLoader = indicatorTypeIdString -> {
            FieldTypeId fieldTypeId = FieldTypeId.parse((String)indicatorTypeIdString);
            IndicatorType indicatorType = (IndicatorType)this.indicatorTypeLoader.getById((Object)fieldTypeId);
            return indicatorType.toFallbackingCodebook();
        };
        this.allowedDatatypeToAllValuesProviderMap.registerPrefixedPrefixRemoving("Indicator_", acceptableIndicatorsByTypeIdLoader);
        this.allDatatypeToAllValuesProviderMap.registerPrefixedPrefixRemoving("Indicator_", acceptableIndicatorsByTypeIdLoader);
        this.converterRegisterer.registerForStringSerializedAndSeserializedObject(FieldId.class, (Converter)new FieldId.FieldIdToStringConverter(), (Converter)new FieldId.StringToFieldIdConverter()).registerForStringSerializedAndSeserializedObject(FieldTypeId.class, (Converter)new FieldTypeId.FieldTypeIdToStringConverter(), (Converter)new FieldTypeId.StringToFieldTypeIdConverter()).registerForStringSerializedAndSeserializedObject(RecordIdFieldTypeId.class, (Converter)new RecordIdFieldTypeId.RecordIdFieldTypeIdToStringConverter(), (Converter)new RecordIdFieldTypeId.StringToRecordIdFieldTypeIdConverter(this.recordFondPairsLoader)).registerForStringId(FieldType.class, (ByIdLoadable)new FieldTypeLoaderByStringIdAdapter(this.fieldTypeLoader)).registerForIntegerId(RecordOperationType.class, (ByIdLoadable)this.recordOperationTypeLoader).registerForIntegerId(RecordStatus.class, (ByIdLoadable)this.recordStatusLoader).registerForUuidId(RecordIdFondPair.class, this.recordFondPairsLoader).registerToJsonSerializedObject(RecordIdFondPair.class, RecordHeaderResponse.class, (Converter)new RecordHeaderResponse.RecordIdFondPairToHeaderResponseConverter()).registerForUuidIdWithCustomFromStringConversion(Record.class, (ByIdLoadable)this.recordLoader(), (Converter)new IdToObjectConverter(this.recordStringIdPrefixDispatchingLoader())).registerForUuidIdWithCustomFromStringConversion(RecordDescriptor.class, (ByIdLoadable)this.recordLoader(), (Converter)new IdToObjectConverter(this.recordStringIdPrefixDispatchingLoader()));
        this.registerPermissions();
    }

    private void registerPermissions() {
        LazyFilter recordAccessFilter = new LazyFilter(Integer.valueOf(3), this.filterLoader);
        this.permissionRegistry.add(RecordSecurityActions.RECORD_HEADERS_SHOW, PermissionResolver.allowing());
        this.permissionRegistry.add(RecordSecurityActions.RECORDS_SHOW, PermissionResolver.allowing());
        this.permissionRegistry.add(RecordSecurityActions.RECORD_SHOW, this.permissionFactory.webAccessFilter((Filter)recordAccessFilter, this.httpServletRequest));
        this.permissionRegistry.add(RecordSecurityActions.FILES_MANAGE_OF_RECORD, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{PermissionResolver.withoutSubject((PermissionResolver)this.permissionRegistry.getLazy(FileSecurityActions.FILES_MANAGE)), (auth, ctx, record) -> !record.isDeleted() ? PermissionResult.allow() : PermissionResult.pointless((Text)Texts.ofNative((String)"Record is already deleted"))}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_OPERATION_SEARCH, this.permissionFactory.edit());
        this.permissionRegistry.add(RecordSecurityActions.RECORD_REQUEST_SEARCH, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_ADMIN"}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_OPERATIONS_SHOW_OF_RECORD, this.permissionFactory.edit());
        this.permissionRegistry.add(RecordSecurityActions.RECORD_REVISIONS_SHOW_OF_RECORD, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_ADMIN"}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_INFORMATION_SHOW_OF_RECORD, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_ADMIN"}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_UTILITY_ACTION_OF_FOND, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_ADMIN"}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_UTILITY_ACTION_OF_RECORD, (PermissionResolver)PermissionResolver.adaptingSubject(RecordIdFondPair::fond, (PermissionResolver)this.permissionRegistry.getLazy(RecordSecurityActions.RECORD_UTILITY_ACTION_OF_FOND)));
    }

    @ConstructorProperties(value={"serverUrlProvider", "recordStatusLoader", "fondLoader", "enabledFondsProvider", "cacheService", "recordCache", "jdbcTemplate", "notAutoCommittingJdbcTemplate", "notCriticalJdbcTemplate", "queryFactory", "entityManager", "readonlyTransactionTemplateFactory", "mappingAppserver", "settingLoader", "converterRegisterer", "permissionRegistry", "securityManager", "permissionFactory", "filterLoader", "httpServletRequest", "acceptableValuesProviderLoader", "loadedIdentifiedFileSaver", "identifiedFileSaver", "pureIdentifiedFileDeleter", "modelBeanBuilder", "saverBuilderFactory", "editableDepartmentsAuthenticatedContextualProvider", "contextHierarchyLoader", "recordHoldingLoader", "executorService", "departmentAccessor", "fullIdentifiedFileConverter", "subkindToEnabledFondsExpander", "enabledIncludableFondsExpander", "allowedDatatypeToAllValuesProviderMap", "allDatatypeToAllValuesProviderMap", "indicatorTypeLoader", "recordEntryFieldTypeIdResolver", "richRecordLoader", "recordFondPairsLoader", "fieldTypeLoader", "internalRecordAllByIdsLoader", "recordFieldStringToInstantConverter", "recordFieldStringToDateRangeConverter", "recordFieldStringToDatetimeRangeConverter", "authorityByKindedIdLoader", "documentByKindedIdLoader", "nonDetailedDocumentByKindedIdLoader", "nonDetailedAuthorityByKindedIdLoader", "nonDetailedRichRecordLoader", "recordOperationTypeLoader", "fieldTypesByFondLoader", "defaultTransactionTemplateFactory", "saveTransactionAuthenticator"})
    @Generated
    public RecordConfig(@NonNull ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider, @NonNull Codebook<RecordStatus, Integer> recordStatusLoader, @NonNull Codebook<Fond, Integer> fondLoader, @NonNull AllValuesProvider<Fond> enabledFondsProvider, @NonNull CacheService cacheService, @NonNull CacheDeletableById recordCache, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull NamedParameterJdbcOperations notAutoCommittingJdbcTemplate, @NonNull NamedParameterJdbcOperations notCriticalJdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull EntityManager entityManager, @NonNull TransactionTemplateFactory readonlyTransactionTemplateFactory, @NonNull MappingAppserverService mappingAppserver, @NonNull SettingLoader settingLoader, @NonNull ConverterRegisterer converterRegisterer, @NonNull PermissionRegistry permissionRegistry, @NonNull SecurityManager securityManager, @NonNull PermissionFactory permissionFactory, @NonNull FilterLoader filterLoader, @NonNull HttpServletRequest httpServletRequest, @NonNull ByIdLoadable<@Nullable AllValuesProvider<? extends LabeledIdentified<?>>, ScalarDatatype> acceptableValuesProviderLoader, @NonNull Saver<IdentifiedFileSaveCommand, IdentifiedFile> loadedIdentifiedFileSaver, @NonNull Saver<IdentifiedFile, IdentifiedFile> identifiedFileSaver, @NonNull Deleter<IDdFile> pureIdentifiedFileDeleter, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull SaverBuilderFactory saverBuilderFactory, @NonNull AuthenticatedContextualProvider<Department, List<Department>> editableDepartmentsAuthenticatedContextualProvider, @NonNull HierarchyLoader<Department> contextHierarchyLoader, @NonNull RecordHoldingLoader recordHoldingLoader, @NonNull ExecutorService executorService, @NonNull DepartmentAccessor departmentAccessor, @NonNull @NonNull Function<@NonNull IDdFile, IdentifiedFile> fullIdentifiedFileConverter, @NonNull Function<String, List<Fond>> subkindToEnabledFondsExpander, @NonNull Function<Fond, List<Fond>> enabledIncludableFondsExpander, @NonNull DatatypedAcceptableValuesRegistry allowedDatatypeToAllValuesProviderMap, @NonNull DatatypedAcceptableValuesRegistry allDatatypeToAllValuesProviderMap, @NonNull Codebook<IndicatorType, FieldTypeId> indicatorTypeLoader, @NonNull RecordEntryFieldTypeIdResolver recordEntryFieldTypeIdResolver, @NonNull IdAndIdsLoadable<Record, UUID> richRecordLoader, @NonNull ByIdLoadable<RecordIdFondPair, UUID> recordFondPairsLoader, @NonNull FieldTypeLoader fieldTypeLoader, @NonNull InternalRecordLoader internalRecordAllByIdsLoader, @NonNull @NonNull Converter<@NonNull String, @NonNull Instant> recordFieldStringToInstantConverter, @NonNull StringToDateRangeConverter recordFieldStringToDateRangeConverter, @NonNull TimezonedStringToDatetimeRangeConverter recordFieldStringToDatetimeRangeConverter, @NonNull IdAndIdsLoadable<Record, Integer> authorityByKindedIdLoader, @NonNull IdAndIdsLoadable<Record, Integer> documentByKindedIdLoader, @NonNull IdAndIdsLoadable<Record, Integer> nonDetailedDocumentByKindedIdLoader, @NonNull IdAndIdsLoadable<Record, Integer> nonDetailedAuthorityByKindedIdLoader, @NonNull IdAndIdsLoadable<Record, UUID> nonDetailedRichRecordLoader, @NonNull Codebook<RecordOperationType, Integer> recordOperationTypeLoader, @NonNull FieldTypesByFondLoader fieldTypesByFondLoader, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull Runnable saveTransactionAuthenticator) {
        Objects.requireNonNull(serverUrlProvider, "serverUrlProvider is marked non-null but is null");
        Objects.requireNonNull(recordStatusLoader, "recordStatusLoader is marked non-null but is null");
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        Objects.requireNonNull(enabledFondsProvider, "enabledFondsProvider is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(recordCache, "recordCache is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(notAutoCommittingJdbcTemplate, "notAutoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(notCriticalJdbcTemplate, "notCriticalJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(readonlyTransactionTemplateFactory, "readonlyTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(filterLoader, "filterLoader is marked non-null but is null");
        Objects.requireNonNull(httpServletRequest, "httpServletRequest is marked non-null but is null");
        Objects.requireNonNull(acceptableValuesProviderLoader, "acceptableValuesProviderLoader is marked non-null but is null");
        Objects.requireNonNull(loadedIdentifiedFileSaver, "loadedIdentifiedFileSaver is marked non-null but is null");
        Objects.requireNonNull(identifiedFileSaver, "identifiedFileSaver is marked non-null but is null");
        Objects.requireNonNull(pureIdentifiedFileDeleter, "pureIdentifiedFileDeleter is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(saverBuilderFactory, "saverBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(editableDepartmentsAuthenticatedContextualProvider, "editableDepartmentsAuthenticatedContextualProvider is marked non-null but is null");
        Objects.requireNonNull(contextHierarchyLoader, "contextHierarchyLoader is marked non-null but is null");
        Objects.requireNonNull(recordHoldingLoader, "recordHoldingLoader is marked non-null but is null");
        Objects.requireNonNull(executorService, "executorService is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(fullIdentifiedFileConverter, "fullIdentifiedFileConverter is marked non-null but is null");
        Objects.requireNonNull(subkindToEnabledFondsExpander, "subkindToEnabledFondsExpander is marked non-null but is null");
        Objects.requireNonNull(enabledIncludableFondsExpander, "enabledIncludableFondsExpander is marked non-null but is null");
        Objects.requireNonNull(allowedDatatypeToAllValuesProviderMap, "allowedDatatypeToAllValuesProviderMap is marked non-null but is null");
        Objects.requireNonNull(allDatatypeToAllValuesProviderMap, "allDatatypeToAllValuesProviderMap is marked non-null but is null");
        Objects.requireNonNull(indicatorTypeLoader, "indicatorTypeLoader is marked non-null but is null");
        Objects.requireNonNull(recordEntryFieldTypeIdResolver, "recordEntryFieldTypeIdResolver is marked non-null but is null");
        Objects.requireNonNull(richRecordLoader, "richRecordLoader is marked non-null but is null");
        Objects.requireNonNull(recordFondPairsLoader, "recordFondPairsLoader is marked non-null but is null");
        Objects.requireNonNull(fieldTypeLoader, "fieldTypeLoader is marked non-null but is null");
        Objects.requireNonNull(internalRecordAllByIdsLoader, "internalRecordAllByIdsLoader is marked non-null but is null");
        Objects.requireNonNull(recordFieldStringToInstantConverter, "recordFieldStringToInstantConverter is marked non-null but is null");
        Objects.requireNonNull(recordFieldStringToDateRangeConverter, "recordFieldStringToDateRangeConverter is marked non-null but is null");
        Objects.requireNonNull(recordFieldStringToDatetimeRangeConverter, "recordFieldStringToDatetimeRangeConverter is marked non-null but is null");
        Objects.requireNonNull(authorityByKindedIdLoader, "authorityByKindedIdLoader is marked non-null but is null");
        Objects.requireNonNull(documentByKindedIdLoader, "documentByKindedIdLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentByKindedIdLoader, "nonDetailedDocumentByKindedIdLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedAuthorityByKindedIdLoader, "nonDetailedAuthorityByKindedIdLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedRichRecordLoader, "nonDetailedRichRecordLoader is marked non-null but is null");
        Objects.requireNonNull(recordOperationTypeLoader, "recordOperationTypeLoader is marked non-null but is null");
        Objects.requireNonNull(fieldTypesByFondLoader, "fieldTypesByFondLoader is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(saveTransactionAuthenticator, "saveTransactionAuthenticator is marked non-null but is null");
        this.serverUrlProvider = serverUrlProvider;
        this.recordStatusLoader = recordStatusLoader;
        this.fondLoader = fondLoader;
        this.enabledFondsProvider = enabledFondsProvider;
        this.cacheService = cacheService;
        this.recordCache = recordCache;
        this.jdbcTemplate = jdbcTemplate;
        this.notAutoCommittingJdbcTemplate = notAutoCommittingJdbcTemplate;
        this.notCriticalJdbcTemplate = notCriticalJdbcTemplate;
        this.queryFactory = queryFactory;
        this.entityManager = entityManager;
        this.readonlyTransactionTemplateFactory = readonlyTransactionTemplateFactory;
        this.mappingAppserver = mappingAppserver;
        this.settingLoader = settingLoader;
        this.converterRegisterer = converterRegisterer;
        this.permissionRegistry = permissionRegistry;
        this.securityManager = securityManager;
        this.permissionFactory = permissionFactory;
        this.filterLoader = filterLoader;
        this.httpServletRequest = httpServletRequest;
        this.acceptableValuesProviderLoader = acceptableValuesProviderLoader;
        this.loadedIdentifiedFileSaver = loadedIdentifiedFileSaver;
        this.identifiedFileSaver = identifiedFileSaver;
        this.pureIdentifiedFileDeleter = pureIdentifiedFileDeleter;
        this.modelBeanBuilder = modelBeanBuilder;
        this.saverBuilderFactory = saverBuilderFactory;
        this.editableDepartmentsAuthenticatedContextualProvider = editableDepartmentsAuthenticatedContextualProvider;
        this.contextHierarchyLoader = contextHierarchyLoader;
        this.recordHoldingLoader = recordHoldingLoader;
        this.executorService = executorService;
        this.departmentAccessor = departmentAccessor;
        this.fullIdentifiedFileConverter = fullIdentifiedFileConverter;
        this.subkindToEnabledFondsExpander = subkindToEnabledFondsExpander;
        this.enabledIncludableFondsExpander = enabledIncludableFondsExpander;
        this.allowedDatatypeToAllValuesProviderMap = allowedDatatypeToAllValuesProviderMap;
        this.allDatatypeToAllValuesProviderMap = allDatatypeToAllValuesProviderMap;
        this.indicatorTypeLoader = indicatorTypeLoader;
        this.recordEntryFieldTypeIdResolver = recordEntryFieldTypeIdResolver;
        this.richRecordLoader = richRecordLoader;
        this.recordFondPairsLoader = recordFondPairsLoader;
        this.fieldTypeLoader = fieldTypeLoader;
        this.internalRecordAllByIdsLoader = internalRecordAllByIdsLoader;
        this.recordFieldStringToInstantConverter = recordFieldStringToInstantConverter;
        this.recordFieldStringToDateRangeConverter = recordFieldStringToDateRangeConverter;
        this.recordFieldStringToDatetimeRangeConverter = recordFieldStringToDatetimeRangeConverter;
        this.authorityByKindedIdLoader = authorityByKindedIdLoader;
        this.documentByKindedIdLoader = documentByKindedIdLoader;
        this.nonDetailedDocumentByKindedIdLoader = nonDetailedDocumentByKindedIdLoader;
        this.nonDetailedAuthorityByKindedIdLoader = nonDetailedAuthorityByKindedIdLoader;
        this.nonDetailedRichRecordLoader = nonDetailedRichRecordLoader;
        this.recordOperationTypeLoader = recordOperationTypeLoader;
        this.fieldTypesByFondLoader = fieldTypesByFondLoader;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.saveTransactionAuthenticator = saveTransactionAuthenticator;
    }
}

