/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.action.ActionSaver;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.context.AuthenticatedContextualProvider;
import cz.kpsys.portaro.auth.context.TypedAuthenticatedContextualObjectModifier;
import cz.kpsys.portaro.auth.department.AuthContextualDepartmentsLoader;
import cz.kpsys.portaro.auth.department.CurrentAuthDepartmentsLoader;
import cz.kpsys.portaro.auth.password.PasswordChecker;
import cz.kpsys.portaro.business.command.CommandInterceptor;
import cz.kpsys.portaro.business.command.SequentialInterceptor;
import cz.kpsys.portaro.commons.cache.CacheDeletableById;
import cz.kpsys.portaro.commons.cache.CacheDeleter;
import cz.kpsys.portaro.commons.cache.CompositeCacheDeleter;
import cz.kpsys.portaro.commons.cache.DynamicCache;
import cz.kpsys.portaro.commons.cache.GuavaTimedDynamicCache;
import cz.kpsys.portaro.commons.contextual.ContextIgnoringContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualFunction;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.convert.ChainingConverter;
import cz.kpsys.portaro.commons.convert.EToEConverter;
import cz.kpsys.portaro.commons.convert.IdToObjectConverter;
import cz.kpsys.portaro.commons.convert.ListToModifiedListConverter;
import cz.kpsys.portaro.commons.convert.ObjectToStringByToStringConverter;
import cz.kpsys.portaro.commons.convert.StringToAnyListConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerToAnyConverter;
import cz.kpsys.portaro.commons.date.DatetimeRangeToBase64StringConverter;
import cz.kpsys.portaro.commons.io.BasicFileZipper;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.io.FileZipper;
import cz.kpsys.portaro.commons.json.FromStringConvertingJsonDeserializer;
import cz.kpsys.portaro.commons.json.ToStringConvertingJsonSerializer;
import cz.kpsys.portaro.commons.localization.ContextualLocaleLocalizer;
import cz.kpsys.portaro.commons.localization.MultiText;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadableByAllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ChunkingAllByIdsLoader;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.GenericHookableSaver;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadableConverting;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.TransactionalIdAndIdsLoadable;
import cz.kpsys.portaro.commons.property.Property;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.LoanConfig;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.contextual.ContextualVisibleDepartmentsLoader;
import cz.kpsys.portaro.conversation.ActionResponse;
import cz.kpsys.portaro.database.FlushingJpaSaver;
import cz.kpsys.portaro.database.IdAndIdsLoadableJpa;
import cz.kpsys.portaro.database.IntegerValueDatabaseLoader;
import cz.kpsys.portaro.databaseproperties.DatabaseProperties;
import cz.kpsys.portaro.datatype.DatatypedAcceptableValuesRegistry;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.event.Eventer;
import cz.kpsys.portaro.exemplar.Exemplar;
import cz.kpsys.portaro.exemplar.edit.AppserverExemplarSaver;
import cz.kpsys.portaro.exemplar.edit.JpaExemplarSaver;
import cz.kpsys.portaro.exemplar.loancategory.LoanCategory;
import cz.kpsys.portaro.export.CsvFileExporter;
import cz.kpsys.portaro.export.Exporter;
import cz.kpsys.portaro.export.ExporterResolver;
import cz.kpsys.portaro.export.ObjectToJsonFileExporter;
import cz.kpsys.portaro.export.SearchedItemsExporter;
import cz.kpsys.portaro.export.StaticExportDescriptorLoader;
import cz.kpsys.portaro.export.SubjectConvertingExporter;
import cz.kpsys.portaro.export.XlsFileExporterByCsvExporter;
import cz.kpsys.portaro.file.directory.DirectoryInsightLoader;
import cz.kpsys.portaro.file.export.DataZippingFilesExporter;
import cz.kpsys.portaro.file.filecategory.FileCategoryBySystemTypeLoader;
import cz.kpsys.portaro.finance.AmountTypeLoader;
import cz.kpsys.portaro.finance.Currency;
import cz.kpsys.portaro.hierarchy.HierarchyLoadScope;
import cz.kpsys.portaro.hierarchy.HierarchyLoader;
import cz.kpsys.portaro.loan.ActiveLoanEntity;
import cz.kpsys.portaro.loan.ActiveLoanEntityRowMapper;
import cz.kpsys.portaro.loan.ByExemplarQLoanPageSearchLoader;
import cz.kpsys.portaro.loan.CheckLoansAndReservations;
import cz.kpsys.portaro.loan.CirculationsDeleter;
import cz.kpsys.portaro.loan.EnablableStaticLoanSetting;
import cz.kpsys.portaro.loan.EntitiesToLoansConverter;
import cz.kpsys.portaro.loan.Loan;
import cz.kpsys.portaro.loan.LoanAuthContextualDepartmentsLoader;
import cz.kpsys.portaro.loan.LoanConstants;
import cz.kpsys.portaro.loan.LoanEntity;
import cz.kpsys.portaro.loan.LoanId;
import cz.kpsys.portaro.loan.LoanQuantityLoader;
import cz.kpsys.portaro.loan.LoanSecurityActions;
import cz.kpsys.portaro.loan.LoanService;
import cz.kpsys.portaro.loan.LoanSetting;
import cz.kpsys.portaro.loan.LoanSettingKeys;
import cz.kpsys.portaro.loan.LoanState;
import cz.kpsys.portaro.loan.LoanType;
import cz.kpsys.portaro.loan.LoansProviderService;
import cz.kpsys.portaro.loan.PozRezUpdater;
import cz.kpsys.portaro.loan.ReaderCatLoanCatSettingLoader;
import cz.kpsys.portaro.loan.ReaderCatLoanCatSettingLoaderAppserver;
import cz.kpsys.portaro.loan.ReservationsDeleter;
import cz.kpsys.portaro.loan.SearchingDepartmentedRecordLoansCountLoader;
import cz.kpsys.portaro.loan.SearchingLoansProviderService;
import cz.kpsys.portaro.loan.SecuredLoansProviderService;
import cz.kpsys.portaro.loan.SpringDbAllByIdsLoanLoader;
import cz.kpsys.portaro.loan.SpringDbLoanIdSearchLoader;
import cz.kpsys.portaro.loan.availability.AppserverDataBackedExemplarAvailability;
import cz.kpsys.portaro.loan.availability.AppserverExemplarAvailabilityService;
import cz.kpsys.portaro.loan.availability.DocumentAvailability;
import cz.kpsys.portaro.loan.availability.DocumentAvailabilityService;
import cz.kpsys.portaro.loan.availability.DocumentAvailabilityServiceAppserver;
import cz.kpsys.portaro.loan.availability.ExemplarAvailabilityService;
import cz.kpsys.portaro.loan.availability.ExemplarHolderService;
import cz.kpsys.portaro.loan.availability.ExternalRecordSupportingDocumentAvailabilityService;
import cz.kpsys.portaro.loan.availability.LastReturnDateLoader;
import cz.kpsys.portaro.loan.availability.LastUserLoanDateLoader;
import cz.kpsys.portaro.loan.availability.ReservationsCountLoader;
import cz.kpsys.portaro.loan.availability.ServiceDelegatingExemplarFreeResolver;
import cz.kpsys.portaro.loan.availability.SlotTestingDocumentAvailabilityService;
import cz.kpsys.portaro.loan.availability.SpringDbLastReturnDateLoader;
import cz.kpsys.portaro.loan.availability.SpringDbLastUserLoanDateLoader;
import cz.kpsys.portaro.loan.availability.SpringDbReservationsCountLoader;
import cz.kpsys.portaro.loan.availability.timeslot.RecordBasedSlotAvailabilityResolver;
import cz.kpsys.portaro.loan.cancellation.AppserverCancellationService;
import cz.kpsys.portaro.loan.cancellation.CancelabilityService;
import cz.kpsys.portaro.loan.cancellation.CancelabilityServiceImpl;
import cz.kpsys.portaro.loan.cancellation.CancellationService;
import cz.kpsys.portaro.loan.export.LoanExportDto;
import cz.kpsys.portaro.loan.export.LoanToLoanExportDtoConverter;
import cz.kpsys.portaro.loan.export.UserActiveLoansExporterDelegatingToLoansExporter;
import cz.kpsys.portaro.loan.ill.IllSettingKeys;
import cz.kpsys.portaro.loan.lending.AppserverLendingService;
import cz.kpsys.portaro.loan.lending.CommandToLendingDataConverter;
import cz.kpsys.portaro.loan.lending.FallbackingLendingService;
import cz.kpsys.portaro.loan.lending.InterceptingLendingService;
import cz.kpsys.portaro.loan.lending.InternalLendingService;
import cz.kpsys.portaro.loan.lending.LendingService;
import cz.kpsys.portaro.loan.lending.LendingServiceVerifyingLenderProxy;
import cz.kpsys.portaro.loan.lending.SecuredLendingService;
import cz.kpsys.portaro.loan.lending.check.CheckDebtsOfExternalLendingLender;
import cz.kpsys.portaro.loan.lending.check.CheckExemplarIsFree;
import cz.kpsys.portaro.loan.lending.check.CheckOnlyOneExemplarOfRecord;
import cz.kpsys.portaro.loan.lending.check.FillLendingOnDifferentDepartment;
import cz.kpsys.portaro.loan.lending.check.FillLendingOnDifferentLocation;
import cz.kpsys.portaro.loan.lending.check.FillLendingUserHasDebt;
import cz.kpsys.portaro.loan.lending.check.InternalOnlyPassingLendingCommandInterceptor;
import cz.kpsys.portaro.loan.lending.command.InternalLendingCommand;
import cz.kpsys.portaro.loan.lending.command.LendingCommand;
import cz.kpsys.portaro.loan.lending.exceptions.UserHasActiveLoansException;
import cz.kpsys.portaro.loan.lending.extern.EnabledExternalLoanServicesProvider;
import cz.kpsys.portaro.loan.lending.extern.ExternalErrorHandlersProvider;
import cz.kpsys.portaro.loan.lending.extern.ExternalLoanRecord;
import cz.kpsys.portaro.loan.lending.extern.ExternalLoanRecordFondResolver;
import cz.kpsys.portaro.loan.lending.extern.ExternalLoanService;
import cz.kpsys.portaro.loan.lending.extern.MailSendingExternalLendingService;
import cz.kpsys.portaro.loan.lending.extern.ProvidedFondIdComparingExternalLoanRecordFondResolver;
import cz.kpsys.portaro.loan.lending.extern.SpringDbExternalLoanRecordLoader;
import cz.kpsys.portaro.loan.lending.internal.InternalErrorHandlersProvider;
import cz.kpsys.portaro.loan.lending.webapi.LendingApiController;
import cz.kpsys.portaro.loan.lending.webapi.LendingRequest;
import cz.kpsys.portaro.loan.migration.LoanMigrationCommand;
import cz.kpsys.portaro.loan.migration.LoanMigrator;
import cz.kpsys.portaro.loan.notice.ExemplarAwareLoanStateChanger;
import cz.kpsys.portaro.loan.notice.InterceptingLoanReadyProcessor;
import cz.kpsys.portaro.loan.notice.LoanReadyNotice;
import cz.kpsys.portaro.loan.notice.LoanReadyNoticeFileGenerator;
import cz.kpsys.portaro.loan.notice.LoanReadyNoticeMailSender;
import cz.kpsys.portaro.loan.notice.LoanReadyNoticeMultipleSender;
import cz.kpsys.portaro.loan.notice.LoanReadyNoticeSendDebtCreator;
import cz.kpsys.portaro.loan.notice.LoanReadyNoticeSender;
import cz.kpsys.portaro.loan.notice.LoanReadyNoticeSenderByPrintTypeDispatcher;
import cz.kpsys.portaro.loan.notice.LoanReadyNoticeSmsSender;
import cz.kpsys.portaro.loan.notice.LoanReadyProcessor;
import cz.kpsys.portaro.loan.notice.NoticeSendingDebtCreatingStateChangingLoanProcessor;
import cz.kpsys.portaro.loan.penalty.AppserverDelayedReturnPenaltyService;
import cz.kpsys.portaro.loan.penalty.DelayedReturnPenaltyService;
import cz.kpsys.portaro.loan.quantum.LoanQuantityChangeLoader;
import cz.kpsys.portaro.loan.quantum.LoanQuantityChangesSummingLoanQuantityLoader;
import cz.kpsys.portaro.loan.quantum.SpringDbLoanQuantityChangeLoader;
import cz.kpsys.portaro.loan.reminder.LoanReminder;
import cz.kpsys.portaro.loan.reminder.LoanReminderEntity;
import cz.kpsys.portaro.loan.reminder.LoanReminderFromEntityConverter;
import cz.kpsys.portaro.loan.reminder.LoanReminderType;
import cz.kpsys.portaro.loan.reminder.SpringDbLoanReminderIdSearchLoader;
import cz.kpsys.portaro.loan.renewal.AppserverRenewabilityService;
import cz.kpsys.portaro.loan.renewal.AppserverRenewalService;
import cz.kpsys.portaro.loan.renewal.RenewabilityService;
import cz.kpsys.portaro.loan.renewal.RenewalAppserverRequestCreator;
import cz.kpsys.portaro.loan.renewal.RenewalService;
import cz.kpsys.portaro.loan.request.AppserverStandardLoanRequestService;
import cz.kpsys.portaro.loan.request.NotAnonymousLoanRequest;
import cz.kpsys.portaro.loan.request.StandardLoanRequestService;
import cz.kpsys.portaro.loan.request.form.BuildingPreferenceSavingStandardLoanRequestServiceProxy;
import cz.kpsys.portaro.loan.request.form.LoanRequestFormFactory;
import cz.kpsys.portaro.loan.resolving.EntitiesToLoanRulesConverter;
import cz.kpsys.portaro.loan.resolving.FirstRuleMatchingLoanRuleValueResolver;
import cz.kpsys.portaro.loan.resolving.LoanRule;
import cz.kpsys.portaro.loan.resolving.LoanRuleEntity;
import cz.kpsys.portaro.loan.resolving.LoanRuleGroupedValue;
import cz.kpsys.portaro.loan.resolving.LoanRulePriceResolver;
import cz.kpsys.portaro.loan.resolving.LoanRuleValueResolver;
import cz.kpsys.portaro.loan.returning.AppserverReturningService;
import cz.kpsys.portaro.loan.returning.FallbackingReturningService;
import cz.kpsys.portaro.loan.returning.FillReturningDifferentLocation;
import cz.kpsys.portaro.loan.returning.FillReturningOnDifferentDepartment;
import cz.kpsys.portaro.loan.returning.InterceptingReturningService;
import cz.kpsys.portaro.loan.returning.LoanReturnCommand;
import cz.kpsys.portaro.loan.returning.LoanReturnRequest;
import cz.kpsys.portaro.loan.returning.ReturningResult;
import cz.kpsys.portaro.loan.returning.ReturningService;
import cz.kpsys.portaro.loan.returning.SecuredReturningService;
import cz.kpsys.portaro.loan.returning.StandardReturningService;
import cz.kpsys.portaro.loan.returning.webapi.ReturningApiController;
import cz.kpsys.portaro.loan.returning.webapi.ReturningResultToResponseConverter;
import cz.kpsys.portaro.loan.timeslot.TimeslotOccupationLoader;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.mail.MailService;
import cz.kpsys.portaro.messages.sms.SmsSender;
import cz.kpsys.portaro.payment.DepartmentedTypedUserAmount;
import cz.kpsys.portaro.payment.TransactionCreator;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RecordSettingKeys;
import cz.kpsys.portaro.record.ViewableRecord;
import cz.kpsys.portaro.record.document.CompositeDownloadLinkContextualResolver;
import cz.kpsys.portaro.record.document.ContextIgnoringDownloadLinkContextualResolver;
import cz.kpsys.portaro.record.view.downloadlink.DownloadLinkContextualResolver;
import cz.kpsys.portaro.record.view.downloadlink.DownloadLinkResolver;
import cz.kpsys.portaro.record.view.downloadlink.DownloadLinkResolverBy856Fields;
import cz.kpsys.portaro.record.view.downloadlink.DownloadLinkResolverByDirectoryInsight;
import cz.kpsys.portaro.record.view.downloadlink.RecordMediaViewerUrlGenerator;
import cz.kpsys.portaro.search.ItemCustomizableContextualSearchFunction;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoaderImpl;
import cz.kpsys.portaro.search.RangePaging;
import cz.kpsys.portaro.search.ResultConvertingPageSearchLoader;
import cz.kpsys.portaro.search.StaticParamsModifier;
import cz.kpsys.portaro.search.TransactionalPageSearchLoader;
import cz.kpsys.portaro.search.field.StaticSearchFields;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.security.SecurityAccessor;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.security.export.SecuredExporter;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.SettingKey;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sip2.server.impl.handler.DebtAmountLendingPermissionResolver;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.template.TemplateEngine;
import cz.kpsys.portaro.template.TemplateLoadingExportDescriptorLoader;
import cz.kpsys.portaro.template.Templates;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.Library;
import cz.kpsys.portaro.user.User;
import cz.kpsys.portaro.user.UserByBasicUserLoader;
import cz.kpsys.portaro.user.UserLoader;
import cz.kpsys.portaro.user.deletion.ReaderDeleter;
import cz.kpsys.portaro.user.deletion.ReaderDeletionCommand;
import cz.kpsys.portaro.user.deletion.exceptions.ReaderHasReservationException;
import cz.kpsys.portaro.user.deletion.exceptions.ReaderHasReservationReadyException;
import cz.kpsys.portaro.user.locale.UserLocaleResolver;
import cz.kpsys.portaro.user.role.reader.PrintType;
import cz.kpsys.portaro.user.role.reader.ReaderCategory;
import cz.kpsys.portaro.user.sec.SecurityActions;
import cz.kpsys.portaro.userpreferences.UserPrefAccessor;
import cz.kpsys.portaro.view.ViewableItemsTypedConverter;
import cz.kpsys.portaro.view.web.page.LoanConfirmationPrintPageController;
import cz.kpsys.portaro.view.web.rest.loan.AvailabilityApiController;
import cz.kpsys.portaro.view.web.rest.loan.CancellationApiController;
import cz.kpsys.portaro.view.web.rest.loan.LoanApiController;
import cz.kpsys.portaro.view.web.rest.loan.LoanRequestApiController;
import cz.kpsys.portaro.view.web.rest.loan.RenewalApiController;
import cz.kpsys.portaro.view.web.rest.loan.migration.LoanMigrationApiController;
import cz.kpsys.portaro.view.web.rest.user.DelayedReturnPenaltyApiController;
import cz.kpsys.portaro.web.page.ModelAndPageViewFactory;
import jakarta.persistence.EntityManager;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.ListCrudRepository;
import org.springframework.format.FormatterRegistry;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class LoanConfig {
    public static final int SEARCHED_LOANS_LIMIT_ITEMS = 400;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final NamedParameterJdbcOperations notAutoCommittingJdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final TransactionTemplateFactory readonlyTransactionTemplateFactory;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final Runnable saveTransactionAuthenticator;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final DmlAppserverService dmlAppserverService;
    @NonNull
    private final ObjectMapper appserverXmlMapper;
    @NonNull
    private final IdAndIdsLoadable<Record, UUID> nonDetailedDocumentLoader;
    @NonNull
    private final AllByIdsLoadable<Record, UUID> detailedDocumentLoader;
    @NonNull
    private final DynamicCache<Record> recordCache;
    @NonNull
    private final UserLoader userLoader;
    @NonNull
    private final IdAndIdsLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final SettingLoader settingLoader;
    private final @NonNull ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider;
    @NonNull
    private final @NonNull ContextualProvider<Department, Converter<UUID, @NonNull String>> recordIdToRecordDetailUrlConverterProvider;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final UserLocaleResolver userLocaleResolver;
    @NonNull
    private final UserPrefAccessor userPrefAccessor;
    @NonNull
    private final ContextualLocaleLocalizer<Department> localizer;
    @NonNull
    private final TemplateEngine templateEngine;
    @NonNull
    private final MailService mailService;
    @NonNull
    private final SmsSender smsSender;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final ObjectMapper objectMapper;
    @NonNull
    private final AllByIdsLoadable<Exemplar, Integer> exemplarLoader;
    @NonNull
    private final PageSearchLoader<MapBackedParams, Integer, RangePaging> exemplarIdSearchLoader;
    @NonNull
    private final ByIdLoadable<Location, Integer> locationLoader;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final ByIdLoadable<LoanCategory, String> loanCategoryLoader;
    @NonNull
    private final ByIdLoadable<ReaderCategory, String> readerCategoryLoader;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final AmountTypeLoader amountTypeLoader;
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final DirectoryInsightLoader directoryInsightLoader;
    @NonNull
    private final SecurityAccessor securityAccessor;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader;
    @NonNull
    private final ExporterResolver exporterResolver;
    @NonNull
    private final TemplateLoadingExportDescriptorLoader templateLoadingExportDescriptorLoader;
    @NonNull
    private final StaticExportDescriptorLoader staticExportDescriptorLoader;
    @NonNull
    private final FormatterRegistry conversionService;
    @NonNull
    private final SimpleModule objectMapperModule;
    @NonNull
    private final ActionSaver actionSaver;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final AppserverExemplarSaver pureExemplarSaver;
    @NonNull
    private final JpaExemplarSaver basicJpaExemplarSaver;
    @NonNull
    private final ViewableItemsTypedConverter<Record, ViewableRecord> recordsToViewableRecordParagraphItemsConverter;
    @NonNull
    private final TimeslotOccupationLoader timeslotOccupationLoader;
    @NonNull
    private final PasswordChecker passwordChecker;
    @NonNull
    private final FileDataStreamer securedFileThumbnailDataStreamer;
    @NonNull
    private final RecordBasedSlotAvailabilityResolver recordBasedSlotAvailabilityResolver;
    @NonNull
    private final AuthContextualDepartmentsLoader loanAuthContextualDepartmentsLoader;
    @NonNull
    private final ModelAndPageViewFactory modelAndPageViewFactory;
    @NonNull
    private final DatatypedAcceptableValuesRegistry allowedDatatypeToAllValuesProviderMap;
    @NonNull
    private final DatatypedAcceptableValuesRegistry allDatatypeToAllValuesProviderMap;
    @NonNull
    private final Eventer eventer;
    @NonNull
    private final @NonNull Provider<@NonNull Currency> defaultCurrencyProvider;
    @NonNull
    private final AuthenticatedContextualProvider<Department, List<Department>> editableDepartmentsAuthenticatedContextualProvider;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, DepartmentedTypedUserAmount> typedUserBilanceSearchLoader;
    @NonNull
    private final DatabaseProperties databaseProperties;
    @NonNull
    private final TransactionCreator transactionCreator;
    @NonNull
    private final FileCategoryBySystemTypeLoader fileCategoryBySystemTypeLoader;
    @NonNull
    private final SequentialInterceptor<ReaderDeletionCommand> additionalFieldsAskingReaderDeletionInterceptor;
    @NonNull
    private final ReaderDeleter readerDeleter;

    @Bean
    public LoanApiController loanApiController() {
        return new LoanApiController((PageSearchLoader)this.loanSearchLoader(), this.securedLoansProviderService(), (HierarchyLoader)this.departmentAccessor, this.loanService(), this.loanReadyProcessor(), this.loanReadyNoticeSender(), this.userLoader);
    }

    @Bean
    public AvailabilityApiController availabilityController() {
        return new AvailabilityApiController(this.documentAvailabilityService(), this.exemplarAvailabilityService());
    }

    @Bean
    public LoanRequestApiController loanRequestApiController() {
        return new LoanRequestApiController(this.loanService(), this.loanRequestFormFactory(), this.standardLoanRequestService(), this.documentAvailabilityService());
    }

    @Bean
    public CancellationApiController cancellationApiController() {
        return new CancellationApiController(this.loanService());
    }

    @Bean
    public LendingApiController lendingApiController() {
        return new LendingApiController(this.lendingService(), this.departmentAccessor, this.securityAccessor);
    }

    @Bean
    public DelayedReturnPenaltyApiController delayedReturnPenaltyApiController() {
        return new DelayedReturnPenaltyApiController(this.delayedReturnPenaltyService(), this.securityManager);
    }

    @Bean
    public RenewalApiController renewalApiController() {
        return new RenewalApiController(this.actionSaver, this.renewalService(), (PageSearchLoader)this.loanSearchLoader());
    }

    @Bean
    public ReturningApiController returningApiController() {
        return new ReturningApiController(this.returningService(), this.departmentAccessor, this.securityAccessor, this.returningResultToResponseConverter());
    }

    @Bean
    public ContextualFunction<@NonNull ReturningResult, @NonNull Department, @NonNull ActionResponse> returningResultToResponseConverter() {
        return new ReturningResultToResponseConverter((UserByBasicUserLoader)this.userLoader);
    }

    @Bean
    public LoanConfirmationPrintPageController loanConfirmationPrintPageController() {
        return new LoanConfirmationPrintPageController(this.templateEngine, this.modelAndPageViewFactory, this.securedLoansProviderService(), (Converter)new ListToModifiedListConverter((Converter)new LoanToLoanExportDtoConverter()));
    }

    @Bean
    public LoanMigrationApiController loanMigrationApiController() {
        return new LoanMigrationApiController(this.loanMigrator());
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<LendingRequest> lendingRequestPreValidationModifier() {
        return new LendingRequest.LendingRequestPreValidationModifier();
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<LendingRequest> lendingRequestDefaulter() {
        return new LendingRequest.LendingRequestDefaulter();
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<LoanReturnRequest> loanReturnRequestPreValidationModifier() {
        return new LoanReturnRequest.LoanReturnRequestPreValidationModifier();
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<LoanReturnRequest> loanReturnRequestDefaulter() {
        return new LoanReturnRequest.LoanReturnRequestDefaulter(this.loanQuantityLoader());
    }

    @Bean
    public ContextualProvider<Department, @NonNull LoanSetting> loanSettingProvider() {
        return department -> new EnablableStaticLoanSetting((Boolean)this.settingLoader.getOn(LoanSettingKeys.LOANS_ENABLED, department), (String)this.settingLoader.getOn(LoanSettingKeys.ORDERING_TYPE, department), (String)this.settingLoader.getOn(LoanSettingKeys.RESERVING_TYPE, department));
    }

    @Bean
    public ContextualProvider<Department, @NonNull Boolean> lendingToExpiredReaderAllowed() {
        return ContextIgnoringContextualProvider.of((Object)false);
    }

    @Bean
    public LoanService loanService() {
        return new LoanService(this.securityManager, this.externalLendingService(), this.cancellationService(), this.loanQuantityLoader(), this.renewabilityService(), this.cancelabilityService(), this.timeslotOccupationLoader);
    }

    @Bean
    public LoansProviderService loansProviderService() {
        return new SearchingLoansProviderService(this.loanSettingProvider(), (PageSearchLoader)this.loanSearchLoader(), this.loanAuthContextualDepartmentsLoader(), this.settingLoader.getOnRootProvidedList(RecordSettingKeys.FORBIDDEN_RECORDS));
    }

    @Bean
    public AuthContextualDepartmentsLoader loanAuthContextualDepartmentsLoader() {
        return new LoanAuthContextualDepartmentsLoader(this.currentAuthEditableDepartmentsLoader, (HierarchyLoader)this.departmentAccessor, this.settingLoader.getDepartmentedProvider(LoanSettingKeys.EDITABLE_SUBDEPARTMENTS_ONLY_LOANS_SHOW_ENABLED), ContextualVisibleDepartmentsLoader.ofSettingsKey((HierarchyLoader)this.departmentAccessor, (SettingLoader)this.settingLoader, (SettingKey)LoanSettingKeys.LOANS_PROVIDED_TO_DEPARTMENTS));
    }

    @Bean
    public LoansProviderService securedLoansProviderService() {
        return new SecuredLoansProviderService(this.loansProviderService(), this.securityManager);
    }

    @Bean
    public LoanRequestFormFactory loanRequestFormFactory() {
        return new LoanRequestFormFactory((ByIdLoadable)this.nonDetailedDocumentLoader, this.settingLoader.getDepartmentedProvider(LoanSettingKeys.DEFAULT_LOAN_REQUEST_INTEREST_DAYS), this.translator, this.documentAvailabilityService(), this.exemplarAvailabilityService(), this.userLocaleResolver, this.userPrefAccessor, this.settingLoader.getDepartmentedProvider(LoanSettingKeys.RESERVATION_DATE_TO_REQUIRED));
    }

    @Bean
    public Codebook<LoanRule<LoanRuleGroupedValue>, Integer> sortedLoanCombinationValueEntityLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(LoanRuleEntity.class).converted((Converter)new EntitiesToLoanRulesConverter(this.readerCategoryLoader, this.loanCategoryLoader, this.defaultCurrencyProvider)).sorted(LoanRule.priorityComparator()).staticCached(LoanRuleEntity.class.getSimpleName()).build();
    }

    @Bean
    public LoanRuleValueResolver<Boolean> loanLendableResolver() {
        return new FirstRuleMatchingLoanRuleValueResolver((AllValuesProvider)this.sortedLoanCombinationValueEntityLoader(), LoanRuleGroupedValue::lendable);
    }

    @Bean
    public LoanRuleValueResolver<Integer> loanPeriodDaysResolver() {
        return new FirstRuleMatchingLoanRuleValueResolver((AllValuesProvider)this.sortedLoanCombinationValueEntityLoader(), LoanRuleGroupedValue::loanPeriodDays);
    }

    @Bean
    public LoanRulePriceResolver loanPriceResolver() {
        FirstRuleMatchingLoanRuleValueResolver delegate = new FirstRuleMatchingLoanRuleValueResolver((AllValuesProvider)this.sortedLoanCombinationValueEntityLoader(), LoanRuleGroupedValue::loanPrice);
        return new LoanRulePriceResolver((LoanRuleValueResolver)delegate, this.defaultCurrencyProvider);
    }

    @Bean
    public LendingService lendingService() {
        AppserverLendingService pureService = new AppserverLendingService(this.mappingAppserver, this.circulatingAffectedExemplarCacheDeleter(), this.appserverXmlMapper, (ByIdLoadable)this.nonDetailedLoanLoader(), this.externalLoanRecordLoader(), this.externalErrorHandlersProvider(), this.directErrorHandlersProvider());
        LendingServiceVerifyingLenderProxy lenderVerifying = new LendingServiceVerifyingLenderProxy((LendingService)pureService, this.settingLoader.getDepartmentedProvider(LoanSettingKeys.LENDER_READER_VERIFYING_ENABLED), (UserByBasicUserLoader)this.userLoader, this.passwordChecker);
        InterceptingLendingService intercepting = new InterceptingLendingService((LendingService)lenderVerifying, this.lendingInterceptor());
        return new SecuredLendingService((LendingService)intercepting, this.securityManager);
    }

    @Bean
    public LendingService lendingServiceWithoutVerification() {
        AppserverLendingService pureService = new AppserverLendingService(this.mappingAppserver, this.circulatingAffectedExemplarCacheDeleter(), this.appserverXmlMapper, (ByIdLoadable)this.nonDetailedLoanLoader(), this.externalLoanRecordLoader(), this.externalErrorHandlersProvider(), this.directErrorHandlersProvider());
        return new InterceptingLendingService((LendingService)pureService, this.lendingInterceptor());
    }

    @Bean
    public LendingService directLendingService() {
        InternalLendingService pureService = new InternalLendingService((Function)new CommandToLendingDataConverter(this.userLoader, this.loanSearchLoader()), this.loanIdGenerator(), (ByIdLoadable)this.loanLoader(), (ByIdLoadable)this.loanEntityLoader(), this.loanEntitySaver(), this.loanLendableResolver(), this.loanPeriodDaysResolver(), this.lendingService());
        LendingServiceVerifyingLenderProxy lenderVerifying = new LendingServiceVerifyingLenderProxy((LendingService)pureService, this.settingLoader.getDepartmentedProvider(LoanSettingKeys.LENDER_READER_VERIFYING_ENABLED), (UserByBasicUserLoader)this.userLoader, this.passwordChecker);
        InterceptingLendingService intercepting = new InterceptingLendingService((LendingService)lenderVerifying, this.lendingInterceptor());
        FallbackingLendingService fallback = new FallbackingLendingService(this.settingLoader.getDepartmentedProvider(IllSettingKeys.ILL_PORTARO_PROCESS_ENABLED), (LendingService)intercepting, this.lendingService());
        return new SecuredLendingService((LendingService)fallback, this.securityManager);
    }

    private CommandInterceptor<LendingCommand> lendingInterceptor() {
        return new SequentialInterceptor().add((CommandInterceptor)new InternalOnlyPassingLendingCommandInterceptor((CommandInterceptor)CheckExemplarIsFree.forLoan((ExemplarHolderService)this.exemplarHolderService(), InternalLendingCommand::lender, InternalLendingCommand::exemplar))).add((CommandInterceptor)new CheckDebtsOfExternalLendingLender(this.settingLoader.getDepartmentedProvider(LoanSettingKeys.EXT_LOANS_CHECK_DEBTS), this.debtAmountLendingPermissionResolver())).add((CommandInterceptor)new CheckOnlyOneExemplarOfRecord(this.userLoader, this.loanSearchLoader(), this.loanAuthContextualDepartmentsLoader, this.settingLoader.getDepartmentedProvider(LoanSettingKeys.LENDING_MAX_ONE_PHYSICAL_EXEMPLAR_OF_ONE_RECORD_BY_NON_LIBRARIAN), this.settingLoader.getDepartmentedProvider(LoanSettingKeys.LENDING_WARN_MAX_ONE_EXEMPLAR_OF_SAME_RECORD))).add((CommandInterceptor)new FillLendingOnDifferentDepartment(this.settingLoader.getDepartmentedProvider(LoanSettingKeys.LENDING_CHECK_DIFFERENT_DEPARTMENT))).add((CommandInterceptor)new FillLendingOnDifferentLocation(this.settingLoader.getDepartmentedProvider(LoanSettingKeys.LENDING_CHECK_DIFFERENT_LOCATION))).add((CommandInterceptor)new FillLendingUserHasDebt(this.settingLoader.getDepartmentedProvider(LoanSettingKeys.LENDING_CHECK_USER_HAS_DEBT)));
    }

    @Bean
    public ReturningService returningService() {
        AppserverReturningService appserverService = new AppserverReturningService(this.appserverXmlMapper, this.mappingAppserver, this.circulatingAffectedExemplarCacheDeleter(), (ByIdLoadable)this.loanLoader(), this.defaultCurrencyProvider);
        StandardReturningService standardService = new StandardReturningService((ByIdLoadable)this.loanEntityLoader(), this.loanEntitySaver(), this.circulatingAffectedExemplarCacheDeleter());
        FallbackingReturningService fallbackService = new FallbackingReturningService((ContextualProvider)ContextIgnoringContextualProvider.of((Object)false), (ReturningService)standardService, (ReturningService)appserverService);
        InterceptingReturningService intercepting = new InterceptingReturningService((ReturningService)fallbackService, this.returningInterceptor());
        return new SecuredReturningService((ReturningService)intercepting, this.securityManager);
    }

    public CommandInterceptor<LoanReturnCommand> returningInterceptor() {
        return new SequentialInterceptor().add((CommandInterceptor)new FillReturningOnDifferentDepartment(this.settingLoader.getDepartmentedProvider(LoanSettingKeys.RETURNING_CHECK_DIFFERENT_DEPARTMENT))).add((CommandInterceptor)new FillReturningDifferentLocation(this.settingLoader.getDepartmentedProvider(LoanSettingKeys.RETURNING_CHECK_DIFFERENT_LOCATION)));
    }

    @Bean
    public CacheDeleter<Exemplar> circulatingAffectedExemplarCacheDeleter() {
        return CompositeCacheDeleter.of((CacheDeleter[])new CacheDeleter[]{exemplar -> this.documentAvailabilityCache().deleteFromCacheById((Object)exemplar.getRecordId()), exemplar -> this.exemplarAvailabilityCache().deleteFromCacheById((Object)AppserverDataBackedExemplarAvailability.createId((Integer)((Integer)exemplar.getId())))});
    }

    @Bean
    public ExemplarAwareLoanStateChanger stateChanger() {
        return new ExemplarAwareLoanStateChanger(this.dmlAppserverService);
    }

    @Bean
    public LoanReadyProcessor loanReadyProcessor() {
        LoanReadyNoticeSendDebtCreator debtCreator = new LoanReadyNoticeSendDebtCreator(this.defaultTransactionTemplateFactory.get(), this.readerCatLoanCatSettingLoader(), this.amountTypeLoader, this.departmentAccessor, this.editableDepartmentsAuthenticatedContextualProvider, this.defaultCurrencyProvider, this.transactionCreator);
        NoticeSendingDebtCreatingStateChangingLoanProcessor loanProcessor = new NoticeSendingDebtCreatingStateChangingLoanProcessor(this.loanReadyNoticeSender(), this.stateChanger(), debtCreator);
        SequentialInterceptor interceptor = new SequentialInterceptor().add((CommandInterceptor)CheckExemplarIsFree.forNoticingLender((ExemplarHolderService)this.exemplarHolderService(), LoanReadyNotice::waitingLoan));
        return new InterceptingLoanReadyProcessor((LoanReadyProcessor)loanProcessor, (CommandInterceptor)interceptor);
    }

    @Bean
    public ExternalErrorHandlersProvider externalErrorHandlersProvider() {
        return new ExternalErrorHandlersProvider();
    }

    @Bean
    public InternalErrorHandlersProvider directErrorHandlersProvider() {
        return new InternalErrorHandlersProvider((ByIdLoadable)this.basicUserLoader);
    }

    @Bean
    public LoanReadyNoticeSender loanReadyNoticeSender() {
        LoanReadyNoticeMailSender mail = new LoanReadyNoticeMailSender(this.templateEngine, this.mailService, this.settingLoader.getDepartmentedProvider(CoreSettingKeys.DEFAULT_LOCALE), this.recordsToViewableRecordParagraphItemsConverter);
        LoanReadyNoticeSmsSender sms = new LoanReadyNoticeSmsSender(this.templateEngine, this.smsSender, this.settingLoader.getDepartmentedProvider(CoreSettingKeys.DEFAULT_LOCALE), this.recordsToViewableRecordParagraphItemsConverter);
        LoanReadyNoticeFileGenerator post = new LoanReadyNoticeFileGenerator(this.serverUrlProvider.throwingWhenNull());
        Map<PrintType, LoanReadyNoticeMultipleSender> map = Map.of(PrintType.EMAIL, mail, PrintType.SMS, sms, PrintType.POST, post, PrintType.EMAIL_AND_SMS, new LoanReadyNoticeMultipleSender(List.of(mail, sms)));
        return new LoanReadyNoticeSenderByPrintTypeDispatcher(map);
    }

    @Bean
    public ExemplarHolderService exemplarHolderService() {
        return new ExemplarHolderService(this.loanSearchLoader());
    }

    @Bean
    public StandardLoanRequestService standardLoanRequestService() {
        return new BuildingPreferenceSavingStandardLoanRequestServiceProxy((StandardLoanRequestService)new AppserverStandardLoanRequestService(this.mappingAppserver, (Converter)new DatetimeRangeToBase64StringConverter(this.objectMapper), this.appserverXmlMapper), this.userPrefAccessor);
    }

    @Bean
    public LendingService externalLendingService() {
        AppserverLendingService pureService = new AppserverLendingService(this.mappingAppserver, this.circulatingAffectedExemplarCacheDeleter(), this.appserverXmlMapper, (ByIdLoadable)this.nonDetailedLoanLoader(), this.externalLoanRecordLoader(), this.externalErrorHandlersProvider(), this.directErrorHandlersProvider());
        MailSendingExternalLendingService mailSendingService = new MailSendingExternalLendingService((LendingService)pureService, this.mailService, this.templateEngine, this.userLocaleResolver, this.externalLoanRecordLoader(), this.localizer);
        InterceptingLendingService interceptor = new InterceptingLendingService((LendingService)mailSendingService, this.lendingInterceptor());
        return new SecuredLendingService((LendingService)interceptor, this.securityManager);
    }

    @Bean
    @NonNull
    public ByIdLoadable<ExternalLoanRecord, Integer> externalLoanRecordLoader() {
        return new SpringDbExternalLoanRecordLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public RenewalService renewalService() {
        AppserverRenewalService bean = new AppserverRenewalService(this.mappingAppserver, this.appserverXmlMapper, this.renewalAppserverRequestCreator());
        bean.setEnabledProvider(this.settingLoader.getOnRootProvider(LoanSettingKeys.RENEWAL_ENABLED));
        return bean;
    }

    @Bean
    public DelayedReturnPenaltyService delayedReturnPenaltyService() {
        return new AppserverDelayedReturnPenaltyService(this.appserverXmlMapper, this.mappingAppserver);
    }

    @Bean
    public RenewabilityService renewabilityService() {
        AppserverRenewabilityService bean = new AppserverRenewabilityService(this.mappingAppserver, this.appserverXmlMapper, this.renewalAppserverRequestCreator());
        bean.setEnabledProvider(this.settingLoader.getDepartmentedProvider(LoanSettingKeys.RENEWAL_ENABLED));
        return bean;
    }

    @Bean
    public RenewalAppserverRequestCreator renewalAppserverRequestCreator() {
        RenewalAppserverRequestCreator creator = new RenewalAppserverRequestCreator();
        creator.setRenewalByReaderOfDelayedLoansAllowed(this.settingLoader.getDepartmentedProvider(LoanSettingKeys.DELAYED_LOANS_RENEWAL_ENABLED));
        creator.setRenewalByReaderWithDebtsAllowed(this.settingLoader.getDepartmentedProvider(LoanSettingKeys.DEBTOR_LOANS_RENEWAL_BY_READER_ENABLED));
        creator.setRenewalByExpiredReaderAllowed(this.settingLoader.getDepartmentedProvider(LoanSettingKeys.EXPIRED_READER_LOANS_RENEWAL_BY_READER_ENABLED));
        return creator;
    }

    @Bean
    public DynamicCache<AppserverDataBackedExemplarAvailability> exemplarAvailabilityCache() {
        return GuavaTimedDynamicCache.ofIdentified((Duration)Duration.ofSeconds(5L), (boolean)true);
    }

    @Bean
    public DynamicCache<DocumentAvailability> documentAvailabilityCache() {
        return GuavaTimedDynamicCache.ofIdentified((Duration)Duration.ofSeconds(5L), (boolean)true);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Bean
    public CancelabilityService cancelabilityService() {
        @NonNull ContextIgnoringContextualProvider unprocessedOrdersCancellingEnabled = ContextIgnoringContextualProvider.of((Object)true);
        @NonNull ContextualProvider processedOrdersCancellingEnabled = this.settingLoader.getDepartmentedProvider(LoanSettingKeys.PROCESSED_ORDERS_CANCELLING_ENABLED);
        @NonNull ContextIgnoringContextualProvider unsentReservationsCancellingEnabled = ContextIgnoringContextualProvider.of((Object)true);
        @NonNull ContextualProvider sentReservationsCancellingEnabled = this.settingLoader.getDepartmentedProvider(LoanSettingKeys.SENT_RESERVATIONS_CANCELLING_ENABLED);
        @NonNull ContextIgnoringContextualProvider pickupReadySeekedIllCancellingEnabled = ContextIgnoringContextualProvider.of((Object)false);
        return new CancelabilityServiceImpl((ContextualProvider)unprocessedOrdersCancellingEnabled, processedOrdersCancellingEnabled, (ContextualProvider)unsentReservationsCancellingEnabled, sentReservationsCancellingEnabled, (ContextualProvider)pickupReadySeekedIllCancellingEnabled);
    }

    @Bean
    public AllByIdsLoadable<LoanReminder, Integer> allByIdsLoanReminderLoader() {
        LoanReminderFromEntityConverter loanReminderFromEntityConverter = new LoanReminderFromEntityConverter((AllByIdsLoadable)this.loanLoader());
        return ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)this.modelBeanBuilder.allByIdsLoader(LoanReminderEntity.class, (Converter)loanReminderFromEntityConverter).build());
    }

    @Bean
    public PageSearchLoader<MapBackedParams, LoanReminder, RangePaging> loanReminderSearchLoader() {
        SpringDbLoanReminderIdSearchLoader idSearchLoader = new SpringDbLoanReminderIdSearchLoader(this.jdbcTemplate, this.queryFactory);
        return ResultConvertingPageSearchLoader.createConvertingFromIds((PageSearchLoader)idSearchLoader, (AllByIdsLoadable)this.allByIdsLoanReminderLoader());
    }

    @Bean
    public IdAndIdsLoadable<Loan, LoanId> loanLoader() {
        return this.createLoanLoader(this.detailedDocumentLoader);
    }

    @Bean
    public IdAndIdsLoadable<Loan, LoanId> nonDetailedLoanLoader() {
        return this.createLoanLoader((AllByIdsLoadable)this.nonDetailedDocumentLoader);
    }

    @Bean
    public RowMapper<ActiveLoanEntity> activeLoanEntityRowMapper() {
        return new ActiveLoanEntityRowMapper();
    }

    @NonNull
    private ByIdLoadableByAllByIdsLoadable<Loan, LoanId> createLoanLoader(AllByIdsLoadable<Record, UUID> documentLoader) {
        SpringDbAllByIdsLoanLoader entityLoader = new SpringDbAllByIdsLoanLoader(this.notAutoCommittingJdbcTemplate, this.queryFactory, this.databaseProperties, this.activeLoanEntityRowMapper());
        EntitiesToLoansConverter entitiesToLoansConverter = new EntitiesToLoansConverter(this.locationLoader, documentLoader, this.exemplarLoader, (AllByIdsLoadable)this.basicUserLoader, this.departmentAccessor, this.loanCategoryLoader, (ByIdLoadable)LoanType.CODEBOOK);
        IdAndIdsLoadableConverting convertingLoader = new IdAndIdsLoadableConverting((AllByIdsLoadable)entityLoader, (Converter)EToEConverter.create(), (Converter)entitiesToLoansConverter);
        TransactionalIdAndIdsLoadable transactionalLoader = new TransactionalIdAndIdsLoadable((IdAndIdsLoadable)convertingLoader, this.readonlyTransactionTemplateFactory.get());
        ChunkingAllByIdsLoader allByIdsLoanLoader = ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)transactionalLoader);
        return new ByIdLoadableByAllByIdsLoadable((AllByIdsLoadable)allByIdsLoanLoader, Loan.class);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Loan> loanSearchLoader() {
        ParameterizedSearchLoaderImpl springDbLoanIdSearchLoader = new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)ResultConvertingPageSearchLoader.createConvertingFromIds((PageSearchLoader)this.loanIdSearchLoader(), (AllByIdsLoadable)this.loanLoader()));
        1 pageSearchLoader = new /* Unavailable Anonymous Inner Class!! */;
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)pageSearchLoader);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, LoanId> loanIdSearchLoader() {
        TransactionalPageSearchLoader transactional = new TransactionalPageSearchLoader((PageSearchLoader)new SpringDbLoanIdSearchLoader(this.notAutoCommittingJdbcTemplate, this.queryFactory, this.departmentAccessor, this.databaseProperties), this.readonlyTransactionTemplateFactory.get());
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)transactional);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Loan> byExemplarQLoanSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new ByExemplarQLoanPageSearchLoader(this.loanSearchLoader(), this.exemplarIdSearchLoader));
    }

    @Bean
    public ContextualProvider<Department, @NonNull Integer> loanIdGenerator() {
        return ContextIgnoringContextualProvider.of((Provider)IntegerValueDatabaseLoader.ofSequenceValueDbDependent((String)"seq_id_vypuc", (String)"vypuc2_id_vypuc_seq", (NamedParameterJdbcOperations)this.jdbcTemplate, (QueryFactory)this.queryFactory, (DatabaseProperties)this.databaseProperties));
    }

    @Bean
    public JpaRepository<LoanEntity, Integer> loanEntityJpaRepository() {
        return new SimpleJpaRepository(LoanEntity.class, this.entityManager);
    }

    @Bean
    public IdAndIdsLoadableJpa<LoanEntity, Integer> loanEntityLoader() {
        return new IdAndIdsLoadableJpa((ListCrudRepository)this.loanEntityJpaRepository());
    }

    @Bean
    public Saver<LoanEntity, LoanEntity> loanEntitySaver() {
        GenericHookableSaver saver = new GenericHookableSaver((Saver)new FlushingJpaSaver(this.loanEntityJpaRepository()));
        saver.addPreHook(this.saveTransactionAuthenticator);
        return saver;
    }

    @Bean
    public LoanQuantityChangeLoader loanQuantityChangeLoader() {
        return new SpringDbLoanQuantityChangeLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public LoanQuantityLoader loanQuantityLoader() {
        return new LoanQuantityChangesSummingLoanQuantityLoader(this.loanQuantityChangeLoader());
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Loan> nonDetailedLoanSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)ResultConvertingPageSearchLoader.createConvertingFromIds((PageSearchLoader)this.loanIdSearchLoader(), (AllByIdsLoadable)this.nonDetailedLoanLoader()));
    }

    @Bean
    public DocumentAvailabilityService documentAvailabilityService() {
        CompositeDownloadLinkContextualResolver downloadLinkResolver = new CompositeDownloadLinkContextualResolver(List.of(new DownloadLinkResolverByDirectoryInsight(this.directoryInsightLoader, (ContextualFunction)new RecordMediaViewerUrlGenerator(this.serverUrlProvider.throwingWhenNull(), this.recordIdToRecordDetailUrlConverterProvider), this.fileCategoryBySystemTypeLoader), new ContextIgnoringDownloadLinkContextualResolver((DownloadLinkResolver)new DownloadLinkResolverBy856Fields())));
        DocumentAvailabilityServiceAppserver bean = new DocumentAvailabilityServiceAppserver(this.mappingAppserver, this.documentAvailabilityCache(), this.securityManager, (Converter)StringToIntegerToAnyConverter.nullConvertingToNull((Converter)new IdToObjectConverter(this.departmentLoader)), (Converter)StringToAnyListConverter.create((Converter)StringToIntegerToAnyConverter.nullConvertingToNull((Converter)new IdToObjectConverter(this.departmentLoader))), this.lastReturnDateLoader(), this.lastUserLoanDateLoader(), (ReservationsCountLoader)new SpringDbReservationsCountLoader(this.jdbcTemplate, this.queryFactory), this.preparedOrReadyToPrepareLoansCountProvider(), this.loanSettingProvider(), this.executorService, this.authenticationHolder, (DownloadLinkContextualResolver)downloadLinkResolver, (ExternalLoanRecordFondResolver)new ProvidedFondIdComparingExternalLoanRecordFondResolver(this.settingLoader.getOnRootProvider(SettingKeys.EXTERNAL_RESOURCES_FOND)), this.appserverXmlMapper, (Provider)StaticProvider.of((Object)CoreConstants.CZECH_TIME_ZONE_ID));
        bean = new ExternalRecordSupportingDocumentAvailabilityService((DocumentAvailabilityService)bean);
        return new SlotTestingDocumentAvailabilityService(Boolean.valueOf(false), (DocumentAvailabilityService)bean, this.recordBasedSlotAvailabilityResolver);
    }

    @Bean
    public ContextualFunction<Record, Department, Integer> preparedOrReadyToPrepareLoansCountProvider() {
        return (recordId, ctx) -> (Integer)this.familyDepartmentedRecordLoansCountLoader().getOn(recordId, (Consumer)StaticParamsModifier.of((Property)LoanConstants.SearchParams.LOAN_STATE, (Object)LoanState.processedOrReadyToProcess()), ctx);
    }

    @Bean
    public ItemCustomizableContextualSearchFunction<Record, Department, Integer> familyDepartmentedRecordLoansCountLoader() {
        return new SearchingDepartmentedRecordLoansCountLoader((PageSearchLoader)this.loanIdSearchLoader(), (HierarchyLoader)this.departmentAccessor, HierarchyLoadScope.FAMILY);
    }

    @Bean
    public ExemplarAvailabilityService exemplarAvailabilityService() {
        return new AppserverExemplarAvailabilityService(this.mappingAppserver, this.exemplarAvailabilityCache(), this.securityManager, this.loanSettingProvider(), this.appserverXmlMapper, (Converter)StringToAnyListConverter.create((Converter)StringToIntegerToAnyConverter.nullConvertingToNull((Converter)new IdToObjectConverter(this.departmentLoader))));
    }

    @Bean
    public ContextualFunction<Exemplar, Department, @NonNull Boolean> exemplarFreeResolver() {
        return new ServiceDelegatingExemplarFreeResolver(this.exemplarAvailabilityService());
    }

    @Bean
    public LastReturnDateLoader lastReturnDateLoader() {
        return new SpringDbLastReturnDateLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public LastUserLoanDateLoader lastUserLoanDateLoader() {
        return new SpringDbLastUserLoanDateLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public CancellationService cancellationService() {
        return new AppserverCancellationService(this.appserverXmlMapper, (CacheDeletableById)this.recordCache, this.mappingAppserver, this.cancelabilityService());
    }

    @Bean
    public ReaderCatLoanCatSettingLoader readerCatLoanCatSettingLoader() {
        return new ReaderCatLoanCatSettingLoaderAppserver(this.appserverXmlMapper, this.mappingAppserver);
    }

    @Bean
    public EnabledExternalLoanServicesProvider enabledExternalLoadServicesProvider() {
        return new EnabledExternalLoanServicesProvider(this.settingLoader.getOnRootProvider(LoanSettingKeys.PALMKNIHY_ENABLED), this.settingLoader.getOnRootProvider(LoanSettingKeys.PALMKNIHY_PDF_ENABLED), this.settingLoader.getOnRootProvider(LoanSettingKeys.PALMKNIHY_AUDIO_ENABLED), this.settingLoader.getOnRootProvider(LoanSettingKeys.FLEXIBOOKS_ENABLED), this.settingLoader.getOnRootProvider(LoanSettingKeys.LEVNAKNIHOVNA_ENABLED));
    }

    @Bean
    public Consumer<@NonNull User> reservationsDeleter() {
        return new ReservationsDeleter(this.queryFactory, this.notAutoCommittingJdbcTemplate, this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public Consumer<@NonNull User> pozRezUpdater() {
        return new PozRezUpdater(this.queryFactory, this.notAutoCommittingJdbcTemplate, this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public Consumer<@NonNull User> circulationsDeleter() {
        return new CirculationsDeleter(this.queryFactory, this.notAutoCommittingJdbcTemplate, this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public LoanMigrator loanMigrator() {
        return new LoanMigrator(this.delayedReturnPenaltyService(), this.loanIdSearchLoader(), this.notAutoCommittingJdbcTemplate, this.queryFactory, this.eventer, this.securityManager);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerExports() {
        SubjectConvertingExporter loansCsvExporter = SubjectConvertingExporter.createForListItemConverting((Exporter)new CsvFileExporter("loans.csv", Templates.TEMPLATE_LOANS_CSV, LoanExportDto.class, "loans", this.templateEngine), (Converter)new LoanToLoanExportDtoConverter(), Loan.class);
        this.exporterResolver.addStatic("loans-csv:", (Exporter)loansCsvExporter);
        XlsFileExporterByCsvExporter loansXlsExporter = new XlsFileExporterByCsvExporter("loans.xls", (Exporter)loansCsvExporter);
        this.exporterResolver.addStatic("loans-xls:", (Exporter)loansXlsExporter);
        SubjectConvertingExporter loansCoversExporter = SubjectConvertingExporter.createForList((Exporter)new DataZippingFilesExporter("covers.zip", this.securedFileThumbnailDataStreamer, (FileZipper)new BasicFileZipper()), (Converter)new ListToModifiedListConverter(loan -> loan.getDocument().getCover()).allowNullTargetValues(), Loan.class);
        this.exporterResolver.addStatic("loans-covers-zip:", (Exporter)loansCoversExporter);
        SearchedItemsExporter searchedLoansCsvExporter = SearchedItemsExporter.of((Exporter)loansCsvExporter, (int)400);
        this.exporterResolver.addStatic("searched-loans-csv:", (Exporter)searchedLoansCsvExporter);
        SearchedItemsExporter searchedLoansXlsExporter = SearchedItemsExporter.of((Exporter)new XlsFileExporterByCsvExporter("loans.xls", (Exporter)loansCsvExporter), (int)400);
        this.exporterResolver.addStatic("searched-loans-xls:", (Exporter)searchedLoansXlsExporter);
        UserActiveLoansExporterDelegatingToLoansExporter userActiveLoansCsvExporter = new UserActiveLoansExporterDelegatingToLoansExporter((Exporter)loansCsvExporter, this.securedLoansProviderService(), (UserByBasicUserLoader)this.userLoader);
        this.exporterResolver.addStatic("user-active-loans-csv:", (Exporter)userActiveLoansCsvExporter);
        UserActiveLoansExporterDelegatingToLoansExporter userActiveLoansXlsExporter = new UserActiveLoansExporterDelegatingToLoansExporter((Exporter)loansXlsExporter, this.securedLoansProviderService(), (UserByBasicUserLoader)this.userLoader);
        this.exporterResolver.addStatic("user-active-loans-xls:", (Exporter)userActiveLoansXlsExporter);
        UserActiveLoansExporterDelegatingToLoansExporter userActiveLoansCoversExporter = new UserActiveLoansExporterDelegatingToLoansExporter((Exporter)loansCoversExporter, this.securedLoansProviderService(), (UserByBasicUserLoader)this.userLoader);
        this.exporterResolver.addStatic("user-active-loans-covers-zip:", (Exporter)userActiveLoansCoversExporter);
        ObjectToJsonFileExporter personalDataEvidenceExporter = new ObjectToJsonFileExporter("data.json", BasicUser.class, this.objectMapper).withData("userData", arg_0 -> ((UserLoader)this.userLoader).getUser(arg_0)).withData("loanData", user -> this.nonDetailedLoanSearchLoader().getContent(RangePaging.forAll(), p -> p.set((Property)LoanConstants.SearchParams.LENDER, List.of(user))));
        SecuredExporter securedPersonalDataEvidenceExporter = new SecuredExporter((Exporter)personalDataEvidenceExporter, this.securityManager, SecurityActions.USER_PERSONAL_DATA_EVIDENCE_EXPORT);
        this.exporterResolver.addStatic("personal-data-evidence-json:", (Exporter)securedPersonalDataEvidenceExporter);
        this.templateLoadingExportDescriptorLoader.registerTemplated(List.of("user", "csv", "download"), "user-active-loans-csv:", Templates.TEMPLATE_LOANS_CSV.getType(), (Text)MultiText.ofTexts((Text)Texts.ofMessageCoded((String)"user.export.ActiveLoans"), (Text)Texts.ofMessageCoded((String)"export.CsvButton")).withDelimiter(" - ")).registerTemplated(List.of("user", "xls", "download"), "user-active-loans-xls:", Templates.TEMPLATE_LOANS_CSV.getType(), (Text)MultiText.ofTexts((Text)Texts.ofMessageCoded((String)"user.export.ActiveLoans"), (Text)Texts.ofMessageCoded((String)"export.XlsButton")).withDelimiter(" - ")).registerTemplated(List.of("loans", "csv", "download"), "loans-csv:", Templates.TEMPLATE_LOANS_CSV.getType(), Texts.ofMessageCoded((String)"export.CsvButton")).registerTemplated(List.of("loans", "xls", "download"), "loans-xls:", Templates.TEMPLATE_LOANS_CSV.getType(), Texts.ofMessageCoded((String)"export.XlsButton")).registerTemplated(List.of("searched-loans", "csv", "download"), "searched-loans-csv:", Templates.TEMPLATE_LOANS_CSV.getType(), Texts.ofMessageCoded((String)"export.CsvButton"), Texts.ofArgumentedMessageCoded((String)"export.LimitXRecords", (Object[])new Object[]{400})).registerTemplated(List.of("searched-loans", "xls", "download"), "searched-loans-xls:", Templates.TEMPLATE_LOANS_CSV.getType(), Texts.ofMessageCoded((String)"export.XlsButton"), Texts.ofArgumentedMessageCoded((String)"export.LimitXRecords", (Object[])new Object[]{400}));
        this.staticExportDescriptorLoader.with(List.of("user", "zip", "download"), "user-active-loans-covers-zip:", Texts.ofNative((String)"Aktivn\u00ed v\u00fdp\u016fj\u010dky - ob\u00e1lky")).with(List.of("user", "json", "download"), "personal-data-evidence-json:", Texts.ofMessageCoded((String)"gdpr.ExportOsobnichDat"));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerModule() {
        StaticSearchFields.CODEBOOK.add((Object)LoanConstants.SearchFields.RECORD_LOAN_SOURCE);
        this.pureExemplarSaver.withCacheDeletable(this.circulatingAffectedExemplarCacheDeleter());
        this.basicJpaExemplarSaver.withCacheDeletable(this.circulatingAffectedExemplarCacheDeleter());
        this.allowedDatatypeToAllValuesProviderMap.registerEquals(LoanConstants.Datatype.EXTERNAL_LOAN_SERVICE, (AllValuesProvider)this.enabledExternalLoadServicesProvider());
        this.allDatatypeToAllValuesProviderMap.registerEquals(LoanConstants.Datatype.EXTERNAL_LOAN_SERVICE, (AllValuesProvider)ExternalLoanService.CODEBOOK);
        ChainingConverter stringToLoanConverter = new ChainingConverter(LoanId::fromString, (Converter)new IdToObjectConverter((ByIdLoadable)this.loanLoader()));
        this.conversionService.addConverter(String.class, Loan.class, (Converter)stringToLoanConverter);
        this.objectMapperModule.addDeserializer(Loan.class, (JsonDeserializer)new FromStringConvertingJsonDeserializer(Loan.class, (Converter)stringToLoanConverter));
        this.objectMapperModule.addSerializer(LoanId.class, (JsonSerializer)new ToStringConvertingJsonSerializer(LoanId.class, (Converter)new ObjectToStringByToStringConverter()));
        this.converterRegisterer.registerForStringId(ExternalLoanService.class, (ByIdLoadable)ExternalLoanService.CODEBOOK);
        this.converterRegisterer.registerForIntegerId(LoanReminderType.class, (ByIdLoadable)LoanReminderType.CODEBOOK);
        this.readerDeleter.addRelatedItemDeleter(this.reservationsDeleter());
        this.readerDeleter.addRelatedItemDeleter(this.pozRezUpdater());
        this.readerDeleter.addRelatedItemDeleter(this.circulationsDeleter());
    }

    @Bean
    public PermissionResolver<BasicUser> debtAmountLendingPermissionResolver() {
        return new DebtAmountLendingPermissionResolver(this.settingLoader.getDepartmentedProvider(LoanSettingKeys.LENDING_RELAXED_DEBT_LIMIT_VALUE).andThen(BigDecimal::valueOf), this.settingLoader.getDepartmentedProvider(LoanSettingKeys.LENDING_RELAXED_DEBT_LIMIT_AMOUNT_TYPES), this.typedUserBilanceSearchLoader);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(LoanSecurityActions.LOAN_SEARCH, this.permissionFactory.edit());
        this.permissionRegistry.add(LoanSecurityActions.LOANS_SHOW_USER_LOANS, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.edit(), this.permissionFactory.currentEvidedAuthenticActiveIsSubjectUser()}));
        this.permissionRegistry.add(LoanSecurityActions.LOANS_SHOW_OF_DOCUMENT, this.permissionFactory.edit());
        this.permissionRegistry.add(LoanSecurityActions.LOAN_LEND_INTERNAL, (PermissionResolver)PermissionResolver.adaptingSubject(arg_0 -> ((UserLoader)this.userLoader).getUser(arg_0), (PermissionResolver)PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvidedActiveUnblockedReaderWithLendingAllowedAndActiveRegistration(this.lendingToExpiredReaderAllowed()), this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6102))})));
        this.permissionRegistry.add(LoanSecurityActions.LOAN_LEND_INTERNAL_FORCE, (PermissionResolver)PermissionResolver.adaptingSubject(arg_0 -> ((UserLoader)this.userLoader).getUser(arg_0), (PermissionResolver)PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvidedActiveUnblockedReaderWithLendingAllowedAndActiveRegistration((ContextualProvider)ContextIgnoringContextualProvider.of((Object)true)), this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6102))})));
        this.permissionRegistry.add(LoanSecurityActions.LOAN_LEND_EXTERNAL, (PermissionResolver)PermissionResolver.adaptingSubject(arg_0 -> ((UserLoader)this.userLoader).getUser(arg_0), (PermissionResolver)this.permissionFactory.subjectUserIsEvidedActiveUnblockedReaderWithLendingAllowedAndActiveRegistration((ContextualProvider)ContextIgnoringContextualProvider.of((Object)false))));
        this.permissionRegistry.add(LoanSecurityActions.LOAN_RETURN_ANY, this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6103)));
        this.permissionRegistry.add(LoanSecurityActions.LOAN_RETURN, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{PermissionResolver.withoutSubject((PermissionResolver)this.permissionRegistry.getLazy(LoanSecurityActions.LOAN_RETURN_ANY)), PermissionResolver.adaptingSubject(loan -> loan.getExemplar().getDepartment(), (PermissionResolver)this.permissionFactory.editSubjectWithDepartment())}));
        this.permissionRegistry.add(LoanSecurityActions.LOAN_CANCEL, (auth, ctx, loan) -> {
            if (loan != null && !auth.getRole().contains("ROLE_LIBRARIAN") && !auth.getActiveUser().equals((Object)loan.getUser())) {
                return PermissionResult.forbid();
            }
            return PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_READER"}), this.permissionFactory.currentEvidedAuthenticEditWithLoanLicence()}).can(auth, ctx, null);
        });
        this.permissionRegistry.add(LoanSecurityActions.LOAN_RENEW, (PermissionResolver)PermissionResolver.adaptingSubject(arg_0 -> ((UserLoader)this.userLoader).getUser(arg_0), (PermissionResolver)PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvidedActiveUnblockedReaderWithLendingAllowed(), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveIsSubjectUser(), this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6114))})})));
        this.permissionRegistry.add(LoanSecurityActions.LOAN_REQUEST_STANDARD, (PermissionResolver)PermissionResolver.adaptingSubject(NotAnonymousLoanRequest::getRequester, (PermissionResolver)PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{(auth, ctx, requester) -> !(requester instanceof Library) ? PermissionResult.allow() : PermissionResult.forbid(), this.permissionFactory.currentEvidedAuthenticActive(), this.permissionFactory.subjectUserIsEvidedActiveUnblockedReaderWithLendingAllowed(), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveIsSubjectUser(), this.permissionFactory.currentEvidedAuthenticEditWithLoanLicence()})})));
        this.permissionRegistry.add(LoanSecurityActions.LOAN_MIGRATE_FROM_USER_TO_ANY, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.enabled(this.settingLoader.getDepartmentedProvider(LoanSettingKeys.LOAN_MIGRATION_ENABLED), Texts.ofNative((String)"Loan migration is not enabled")), this.permissionFactory.currentEvidedAuthenticEditWithLoanLicence(), this.permissionFactory.editOnReadableDepartmentsOfUser()}));
        this.permissionRegistry.add(LoanSecurityActions.LOAN_MIGRATE, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{PermissionResolver.adaptingSubject(LoanMigrationCommand::source, (PermissionResolver)this.permissionRegistry.getLazy(LoanSecurityActions.LOAN_MIGRATE_FROM_USER_TO_ANY)), PermissionResolver.adaptingSubject(LoanMigrationCommand::target, (PermissionResolver)PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticEditWithLoanLicence(), this.permissionFactory.editOnReadableDepartmentsOfUser()}))}));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerInterceptors() {
        this.additionalFieldsAskingReaderDeletionInterceptor.add((CommandInterceptor)CheckLoansAndReservations.of((LoansProviderService)this.loansProviderService(), ReaderDeletionCommand::user, ReaderDeletionCommand::ctx, ReaderDeletionCommand::currentAuth, ReaderDeletionCommand::ignoreActiveUserLoans, UserHasActiveLoansException::new, ReaderHasReservationException::new, ReaderHasReservationReadyException::new));
    }

    @ConstructorProperties(value={"jdbcTemplate", "notAutoCommittingJdbcTemplate", "queryFactory", "readonlyTransactionTemplateFactory", "defaultTransactionTemplateFactory", "entityManager", "codebookLoaderBuilderFactory", "saveTransactionAuthenticator", "modelBeanBuilder", "mappingAppserver", "dmlAppserverService", "appserverXmlMapper", "nonDetailedDocumentLoader", "detailedDocumentLoader", "recordCache", "userLoader", "basicUserLoader", "settingLoader", "serverUrlProvider", "recordIdToRecordDetailUrlConverterProvider", "translator", "userLocaleResolver", "userPrefAccessor", "localizer", "templateEngine", "mailService", "smsSender", "securityManager", "objectMapper", "exemplarLoader", "exemplarIdSearchLoader", "locationLoader", "departmentLoader", "departmentAccessor", "loanCategoryLoader", "readerCategoryLoader", "authenticationHolder", "amountTypeLoader", "executorService", "directoryInsightLoader", "securityAccessor", "permissionRegistry", "permissionFactory", "currentAuthEditableDepartmentsLoader", "exporterResolver", "templateLoadingExportDescriptorLoader", "staticExportDescriptorLoader", "conversionService", "objectMapperModule", "actionSaver", "converterRegisterer", "pureExemplarSaver", "basicJpaExemplarSaver", "recordsToViewableRecordParagraphItemsConverter", "timeslotOccupationLoader", "passwordChecker", "securedFileThumbnailDataStreamer", "recordBasedSlotAvailabilityResolver", "loanAuthContextualDepartmentsLoader", "modelAndPageViewFactory", "allowedDatatypeToAllValuesProviderMap", "allDatatypeToAllValuesProviderMap", "eventer", "defaultCurrencyProvider", "editableDepartmentsAuthenticatedContextualProvider", "typedUserBilanceSearchLoader", "databaseProperties", "transactionCreator", "fileCategoryBySystemTypeLoader", "additionalFieldsAskingReaderDeletionInterceptor", "readerDeleter"})
    @Generated
    public LoanConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull NamedParameterJdbcOperations notAutoCommittingJdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull TransactionTemplateFactory readonlyTransactionTemplateFactory, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull EntityManager entityManager, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull Runnable saveTransactionAuthenticator, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull MappingAppserverService mappingAppserver, @NonNull DmlAppserverService dmlAppserverService, @NonNull ObjectMapper appserverXmlMapper, @NonNull IdAndIdsLoadable<Record, UUID> nonDetailedDocumentLoader, @NonNull AllByIdsLoadable<Record, UUID> detailedDocumentLoader, @NonNull DynamicCache<Record> recordCache, @NonNull UserLoader userLoader, @NonNull IdAndIdsLoadable<BasicUser, Integer> basicUserLoader, @NonNull SettingLoader settingLoader, @NonNull ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider, @NonNull @NonNull ContextualProvider<Department, Converter<UUID, @NonNull String>> recordIdToRecordDetailUrlConverterProvider, @NonNull Translator<Department> translator, @NonNull UserLocaleResolver userLocaleResolver, @NonNull UserPrefAccessor userPrefAccessor, @NonNull ContextualLocaleLocalizer<Department> localizer, @NonNull TemplateEngine templateEngine, @NonNull MailService mailService, @NonNull SmsSender smsSender, @NonNull SecurityManager securityManager, @NonNull ObjectMapper objectMapper, @NonNull AllByIdsLoadable<Exemplar, Integer> exemplarLoader, @NonNull PageSearchLoader<MapBackedParams, Integer, RangePaging> exemplarIdSearchLoader, @NonNull ByIdLoadable<Location, Integer> locationLoader, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull DepartmentAccessor departmentAccessor, @NonNull ByIdLoadable<LoanCategory, String> loanCategoryLoader, @NonNull ByIdLoadable<ReaderCategory, String> readerCategoryLoader, @NonNull AuthenticationHolder authenticationHolder, @NonNull AmountTypeLoader amountTypeLoader, @NonNull ExecutorService executorService, @NonNull DirectoryInsightLoader directoryInsightLoader, @NonNull SecurityAccessor securityAccessor, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader, @NonNull ExporterResolver exporterResolver, @NonNull TemplateLoadingExportDescriptorLoader templateLoadingExportDescriptorLoader, @NonNull StaticExportDescriptorLoader staticExportDescriptorLoader, @NonNull FormatterRegistry conversionService, @NonNull SimpleModule objectMapperModule, @NonNull ActionSaver actionSaver, @NonNull ConverterRegisterer converterRegisterer, @NonNull AppserverExemplarSaver pureExemplarSaver, @NonNull JpaExemplarSaver basicJpaExemplarSaver, @NonNull ViewableItemsTypedConverter<Record, ViewableRecord> recordsToViewableRecordParagraphItemsConverter, @NonNull TimeslotOccupationLoader timeslotOccupationLoader, @NonNull PasswordChecker passwordChecker, @NonNull FileDataStreamer securedFileThumbnailDataStreamer, @NonNull RecordBasedSlotAvailabilityResolver recordBasedSlotAvailabilityResolver, @NonNull AuthContextualDepartmentsLoader loanAuthContextualDepartmentsLoader, @NonNull ModelAndPageViewFactory modelAndPageViewFactory, @NonNull DatatypedAcceptableValuesRegistry allowedDatatypeToAllValuesProviderMap, @NonNull DatatypedAcceptableValuesRegistry allDatatypeToAllValuesProviderMap, @NonNull Eventer eventer, @NonNull @NonNull Provider<@NonNull Currency> defaultCurrencyProvider, @NonNull AuthenticatedContextualProvider<Department, List<Department>> editableDepartmentsAuthenticatedContextualProvider, @NonNull ParameterizedSearchLoader<MapBackedParams, DepartmentedTypedUserAmount> typedUserBilanceSearchLoader, @NonNull DatabaseProperties databaseProperties, @NonNull TransactionCreator transactionCreator, @NonNull FileCategoryBySystemTypeLoader fileCategoryBySystemTypeLoader, @NonNull SequentialInterceptor<ReaderDeletionCommand> additionalFieldsAskingReaderDeletionInterceptor, @NonNull ReaderDeleter readerDeleter) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(notAutoCommittingJdbcTemplate, "notAutoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(readonlyTransactionTemplateFactory, "readonlyTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(saveTransactionAuthenticator, "saveTransactionAuthenticator is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(dmlAppserverService, "dmlAppserverService is marked non-null but is null");
        Objects.requireNonNull(appserverXmlMapper, "appserverXmlMapper is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentLoader, "nonDetailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(detailedDocumentLoader, "detailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(recordCache, "recordCache is marked non-null but is null");
        Objects.requireNonNull(userLoader, "userLoader is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(serverUrlProvider, "serverUrlProvider is marked non-null but is null");
        Objects.requireNonNull(recordIdToRecordDetailUrlConverterProvider, "recordIdToRecordDetailUrlConverterProvider is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(userLocaleResolver, "userLocaleResolver is marked non-null but is null");
        Objects.requireNonNull(userPrefAccessor, "userPrefAccessor is marked non-null but is null");
        Objects.requireNonNull(localizer, "localizer is marked non-null but is null");
        Objects.requireNonNull(templateEngine, "templateEngine is marked non-null but is null");
        Objects.requireNonNull(mailService, "mailService is marked non-null but is null");
        Objects.requireNonNull(smsSender, "smsSender is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(objectMapper, "objectMapper is marked non-null but is null");
        Objects.requireNonNull(exemplarLoader, "exemplarLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarIdSearchLoader, "exemplarIdSearchLoader is marked non-null but is null");
        Objects.requireNonNull(locationLoader, "locationLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(loanCategoryLoader, "loanCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(readerCategoryLoader, "readerCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(amountTypeLoader, "amountTypeLoader is marked non-null but is null");
        Objects.requireNonNull(executorService, "executorService is marked non-null but is null");
        Objects.requireNonNull(directoryInsightLoader, "directoryInsightLoader is marked non-null but is null");
        Objects.requireNonNull(securityAccessor, "securityAccessor is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(currentAuthEditableDepartmentsLoader, "currentAuthEditableDepartmentsLoader is marked non-null but is null");
        Objects.requireNonNull(exporterResolver, "exporterResolver is marked non-null but is null");
        Objects.requireNonNull(templateLoadingExportDescriptorLoader, "templateLoadingExportDescriptorLoader is marked non-null but is null");
        Objects.requireNonNull(staticExportDescriptorLoader, "staticExportDescriptorLoader is marked non-null but is null");
        Objects.requireNonNull(conversionService, "conversionService is marked non-null but is null");
        Objects.requireNonNull(objectMapperModule, "objectMapperModule is marked non-null but is null");
        Objects.requireNonNull(actionSaver, "actionSaver is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(pureExemplarSaver, "pureExemplarSaver is marked non-null but is null");
        Objects.requireNonNull(basicJpaExemplarSaver, "basicJpaExemplarSaver is marked non-null but is null");
        Objects.requireNonNull(recordsToViewableRecordParagraphItemsConverter, "recordsToViewableRecordParagraphItemsConverter is marked non-null but is null");
        Objects.requireNonNull(timeslotOccupationLoader, "timeslotOccupationLoader is marked non-null but is null");
        Objects.requireNonNull(passwordChecker, "passwordChecker is marked non-null but is null");
        Objects.requireNonNull(securedFileThumbnailDataStreamer, "securedFileThumbnailDataStreamer is marked non-null but is null");
        Objects.requireNonNull(recordBasedSlotAvailabilityResolver, "recordBasedSlotAvailabilityResolver is marked non-null but is null");
        Objects.requireNonNull(loanAuthContextualDepartmentsLoader, "loanAuthContextualDepartmentsLoader is marked non-null but is null");
        Objects.requireNonNull(modelAndPageViewFactory, "modelAndPageViewFactory is marked non-null but is null");
        Objects.requireNonNull(allowedDatatypeToAllValuesProviderMap, "allowedDatatypeToAllValuesProviderMap is marked non-null but is null");
        Objects.requireNonNull(allDatatypeToAllValuesProviderMap, "allDatatypeToAllValuesProviderMap is marked non-null but is null");
        Objects.requireNonNull(eventer, "eventer is marked non-null but is null");
        Objects.requireNonNull(defaultCurrencyProvider, "defaultCurrencyProvider is marked non-null but is null");
        Objects.requireNonNull(editableDepartmentsAuthenticatedContextualProvider, "editableDepartmentsAuthenticatedContextualProvider is marked non-null but is null");
        Objects.requireNonNull(typedUserBilanceSearchLoader, "typedUserBilanceSearchLoader is marked non-null but is null");
        Objects.requireNonNull(databaseProperties, "databaseProperties is marked non-null but is null");
        Objects.requireNonNull(transactionCreator, "transactionCreator is marked non-null but is null");
        Objects.requireNonNull(fileCategoryBySystemTypeLoader, "fileCategoryBySystemTypeLoader is marked non-null but is null");
        Objects.requireNonNull(additionalFieldsAskingReaderDeletionInterceptor, "additionalFieldsAskingReaderDeletionInterceptor is marked non-null but is null");
        Objects.requireNonNull(readerDeleter, "readerDeleter is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.notAutoCommittingJdbcTemplate = notAutoCommittingJdbcTemplate;
        this.queryFactory = queryFactory;
        this.readonlyTransactionTemplateFactory = readonlyTransactionTemplateFactory;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.entityManager = entityManager;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.saveTransactionAuthenticator = saveTransactionAuthenticator;
        this.modelBeanBuilder = modelBeanBuilder;
        this.mappingAppserver = mappingAppserver;
        this.dmlAppserverService = dmlAppserverService;
        this.appserverXmlMapper = appserverXmlMapper;
        this.nonDetailedDocumentLoader = nonDetailedDocumentLoader;
        this.detailedDocumentLoader = detailedDocumentLoader;
        this.recordCache = recordCache;
        this.userLoader = userLoader;
        this.basicUserLoader = basicUserLoader;
        this.settingLoader = settingLoader;
        this.serverUrlProvider = serverUrlProvider;
        this.recordIdToRecordDetailUrlConverterProvider = recordIdToRecordDetailUrlConverterProvider;
        this.translator = translator;
        this.userLocaleResolver = userLocaleResolver;
        this.userPrefAccessor = userPrefAccessor;
        this.localizer = localizer;
        this.templateEngine = templateEngine;
        this.mailService = mailService;
        this.smsSender = smsSender;
        this.securityManager = securityManager;
        this.objectMapper = objectMapper;
        this.exemplarLoader = exemplarLoader;
        this.exemplarIdSearchLoader = exemplarIdSearchLoader;
        this.locationLoader = locationLoader;
        this.departmentLoader = departmentLoader;
        this.departmentAccessor = departmentAccessor;
        this.loanCategoryLoader = loanCategoryLoader;
        this.readerCategoryLoader = readerCategoryLoader;
        this.authenticationHolder = authenticationHolder;
        this.amountTypeLoader = amountTypeLoader;
        this.executorService = executorService;
        this.directoryInsightLoader = directoryInsightLoader;
        this.securityAccessor = securityAccessor;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.currentAuthEditableDepartmentsLoader = currentAuthEditableDepartmentsLoader;
        this.exporterResolver = exporterResolver;
        this.templateLoadingExportDescriptorLoader = templateLoadingExportDescriptorLoader;
        this.staticExportDescriptorLoader = staticExportDescriptorLoader;
        this.conversionService = conversionService;
        this.objectMapperModule = objectMapperModule;
        this.actionSaver = actionSaver;
        this.converterRegisterer = converterRegisterer;
        this.pureExemplarSaver = pureExemplarSaver;
        this.basicJpaExemplarSaver = basicJpaExemplarSaver;
        this.recordsToViewableRecordParagraphItemsConverter = recordsToViewableRecordParagraphItemsConverter;
        this.timeslotOccupationLoader = timeslotOccupationLoader;
        this.passwordChecker = passwordChecker;
        this.securedFileThumbnailDataStreamer = securedFileThumbnailDataStreamer;
        this.recordBasedSlotAvailabilityResolver = recordBasedSlotAvailabilityResolver;
        this.loanAuthContextualDepartmentsLoader = loanAuthContextualDepartmentsLoader;
        this.modelAndPageViewFactory = modelAndPageViewFactory;
        this.allowedDatatypeToAllValuesProviderMap = allowedDatatypeToAllValuesProviderMap;
        this.allDatatypeToAllValuesProviderMap = allDatatypeToAllValuesProviderMap;
        this.eventer = eventer;
        this.defaultCurrencyProvider = defaultCurrencyProvider;
        this.editableDepartmentsAuthenticatedContextualProvider = editableDepartmentsAuthenticatedContextualProvider;
        this.typedUserBilanceSearchLoader = typedUserBilanceSearchLoader;
        this.databaseProperties = databaseProperties;
        this.transactionCreator = transactionCreator;
        this.fileCategoryBySystemTypeLoader = fileCategoryBySystemTypeLoader;
        this.additionalFieldsAskingReaderDeletionInterceptor = additionalFieldsAskingReaderDeletionInterceptor;
        this.readerDeleter = readerDeleter;
    }
}

