<#ftl outputFormat="HTML">
<#import "../../../../freemarker/_localization.ftl" as loc>


<div class="money-container dluhyAKredity panel panel-default" ng-cloak>

    <div class="panel-heading">
        <span>${loc.loc("konto.StavKonta")?noEsc}</span>
    </div>

    <table class="table table-condensed table-hover">

        <div jp-loading="xs" ng-show="!$ctrl.userFinanceService.transactionResolved"></div>

        <tr ng-show="$ctrl.userFinanceService.groups.length === 0 && $ctrl.userFinanceService.transactionResolved">
            <td class="text-muted" colspan="2">${loc.loc("konto.zadneDluhy")?noEsc}</td>
        </tr>

        <tr ng-repeat-start="g in $ctrl.userFinanceService.groups" ng-class="{'active': g.expanded}">
            <td>
                <button type="button" class="btn btn-xs btn-default" ng-click="g.expanded = !g.expanded">
                    <span ng-hide="g.expanded" class="glyphicon glyphicon-zoom-in"></span>
                    <span ng-show="g.expanded" class="glyphicon glyphicon-zoom-out"></span>
                </button>
                {{g|loc}}
            </td>
            <td style="text-align: right;" data-qa="user-finance-sum" ng-class="{'text-success': !g.debt(), 'text-danger': g.debt()}">
                {{g.sum}}Kč
            </td>
        </tr>

        <tr class="text-muted" ng-show="g.expanded" ng-repeat-end ng-repeat="a in $ctrl.userFinanceService.getAllByGroup(g)">
            <td>
                <span ng-bind="a.date|jpDate:'d.M.yyyy'"></span>
                -
                <span ng-bind="a.department|loc"></span>
            </td>
            <td style="text-align: right;" ng-class="{'text-success': !a.debt, 'text-danger': a.debt}">
                {{a.sum}}Kč
                <button ng-if="$ctrl.userFinanceService.isForgivable(a)" type="button" class="btn btn-xs btn-default"
                        ng-click="$ctrl.userFinanceService.forgive(a)" title="Smazat (vynulovat)">
                    <span class="glyphicon glyphicon-trash"></span>
                </button>
            </td>
        </tr>

        <tfoot ng-show="$ctrl.userFinanceService.groups.length > 1">
            <tr ng-if="$ctrl.userFinanceService.getCreditsSum() !== 0 && $ctrl.userFinanceService.getDebtsSum() !== 0">
                <td>Celkový kredit</td>
                <td style="text-align: right;">
                    <span class="text-success">{{$ctrl.userFinanceService.getCreditsSum()}}Kč</span>
                </td>
            </tr>
            <tr ng-if="$ctrl.userFinanceService.getCreditsSum() !== 0 && $ctrl.userFinanceService.getDebtsSum() !== 0">
                <td>Celkový dluh</td>
                <td style="text-align: right;">
                    <span class="text-danger"> - {{-$ctrl.userFinanceService.getDebtsSum()}}Kč</span>
                </td>
            </tr>
            <tr>
                <td>${loc.loc("commons.soucet")?noEsc}</td>
                <td style="text-align: right;">
                    <span ng-if="$ctrl.userFinanceService.getCreditsSum() !== 0 && $ctrl.userFinanceService.getDebtsSum() !== 0">
                        <span class="text-success">{{$ctrl.userFinanceService.getCreditsSum()}}</span>
                        <span class="text-danger"> - {{-$ctrl.userFinanceService.getDebtsSum()}}</span>
                        <span> = </span>
                    </span>
                    <span ng-class="{'text-success': $ctrl.userFinanceService.sum > 0, 'text-danger': $ctrl.userFinanceService.sum < 0}">{{$ctrl.userFinanceService.sum}}Kč</span>
                </td>
            </tr>
        </tfoot>

    </table>

    <div ng-repeat="paymentProviderName in $ctrl.enabledPaymentProviderNames" ng-show="$ctrl.canShowPayButtonOf(paymentProviderName)">
        <button type="button" ng-click="$ctrl.userFinanceService.payAllUserDebts(paymentProviderName)" class="btn btn-sm btn-block" ng-class="{'btn-primary': $first, 'btn-default': !$first}" ng-switch="paymentProviderName">
            <span ng-switch-when="cash">${loc.loc("payment.payByCash")}</span>
            <span ng-switch-when="terminal-virtual">${loc.loc("payment.PayManuallyViaTerminal")}</span>
            <span ng-switch-when="gateway-csob">${loc.loc("payment.payOnline")}</span>
            <span ng-switch-when="gateway-gopay">${loc.loc("payment.payOnline")}</span>
            <span ng-switch-when="gateway-gpwebpay">${loc.loc("payment.payOnline")}</span>
        </button>
    </div>

</div>
