<#ftl outputFormat="HTML">
<#import "../../../../../freemarker/_localization.ftl" as loc>


<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="${loc.loc("commons.zavrit")?noEsc}" ng-click="$ctrl.close()">&times;</button>
    <h1>${loc.loc("commons.UzivatelskeNastaveni")?noEsc}</h1>
</div>

<div class="modal-body">
    <div class="modal-body-block text-center">
        <p>
            <strong ng-bind-html="$ctrl.message"></strong>
        </p>
    </div>
    <table class="table">
        <tr class="sr-only">
            <#-- table columns header -->
            <td><#-- empty because first column is made of row header cells, https://www.w3.org/WAI/tutorials/tables/two-headers/ --></td>
            <th scope="col">${loc.loc("commons.Value")?noEsc}</th>
            <th scope="col">${loc.loc("commons.Uprava")?noEsc}</th>
        </tr>

        <tr class="user-preference-{{preference.keyId}}" ng-repeat="preference in $ctrl.userPreferences">
            <th scope="row">{{preference.keyText | loc}}</th>

            <td>
                <#-- default user preference value -->
                <div ng-class="{'text-muted': preference.customized, 'overwritten-value': preference.customized}" aria-hidden="{{preference.customized}}">
                    <span ng-if="!preference.datatype.nestedDatatype">
                        <kp-svelte-component-wrapper
                                component="::$ctrl.kpDatatypedValue"
                                props="{
                                        value: preference.defaultValue,
                                        datatype: preference.datatype,
                                    }">
                        </kp-svelte-component-wrapper>
                    </span>
                    <span ng-if="preference.datatype.nestedDatatype">
                        <kp-svelte-component-wrapper
                                component="::$ctrl.kpDatatypedValue"
                                props="{
                                        value: preference.defaultValue,
                                        datatype: preference.datatype,
                                        fallback: '${loc.loc("commons.Vse")?esc}'
                                    }">
                        </kp-svelte-component-wrapper>
                    </span>
                </div>

                <div ng-if="preference.customized || preference.state === 'EDITING'">
                    <span class="glyphicon glyphicon-arrow-down" aria-hidden="true"></span>
                </div>

                <#-- edited user preference value -->
                <div ng-if="preference.customized && preference.state === 'NORMAL'">
                    <kp-svelte-component-wrapper
                            component="::$ctrl.kpDatatypedValue"
                            props="{
                                        value: preference.customValue,
                                        datatype: preference.datatype,
                                        fallback: '${loc.loc("commons.Vse")?esc}'
                                    }"
                    >
                    </kp-svelte-component-wrapper>
                </div>

                <div ng-if="preference.state === 'EDITING'" ng-init="preferenceEditorLabelContext = $ctrl.createPreferenceEditorLabelContext(preference)">
                    <form tabindex="-1" id="user-preference-{{preference.keyId}}-form">
                        <div class="form-group" ng-init="valueEditorSvelteContext = $ctrl.setPreferenceEditorLabelContext(preferenceEditorLabelContext)">
                            <label for="{{preferenceEditorLabelContext.editorId}}" id="{{preferenceEditorLabelContext.labelId}}" class="sr-only">
                                {{preferenceEditorLabelContext.labelText}}
                            </label>
                            <kp-svelte-component-wrapper
                                    component="::$ctrl.kpValueEditorComponent"
                                    props="{
                                        type: preference.editor.type,
                                        options: preference.editor.options,
                                        validations: preference.editor.validations,
                                        editorId: preferenceEditorLabelContext.editorId,
                                        model: preference.editedValue
                                    }"
                                    additional-context="valueEditorSvelteContext"
                                    ng-on-model-change="preference.editedValue = $event.originalEvent.detail">
                            </kp-svelte-component-wrapper>
                        </div>
                    </form>
                    <button type="button" class="btn btn-primary btn-sm" data-qa="user-preferences-{{preference.keyId}}-save-button" ng-click="$ctrl.save(preference)">OK</button>
                </div>

                <div ng-show="preference.state === 'PROCESSING'"><span jp-loading="xs"></span></div>
            </td>

            <td>
                <div ng-if="preference.editable">
                    <button class="btn btn-default btn-sm"
                            type="button"
                            data-qa="user-preferences-{{preference.keyId}}-change-button"
                            ng-click="$ctrl.togglePreferenceEditing(preference)"
                            aria-expanded="{{preference.state === 'EDITING'}}"
                            aria-controls="user-preference-{{preference.keyId}}-form">
                        ${loc.loc("commons.Change")?noEsc}
                    </button>
                    <button type="button"
                            class="btn btn-default btn-sm"
                            ng-if="preference.customized"
                            ng-click="$ctrl.setToDefault(preference)">
                        ${loc.loc("commons.SetDefault")?noEsc}
                    </button>
                </div>
            </td>
        </tr>
    </table>
</div>


<div class="modal-footer">
    <button type="button" class="btn btn-default" data-dismiss="modal" ng-click="$ctrl.close()">
        ${loc.loc("commons.zavrit")?noEsc}
    </button>
</div>
