<#ftl outputFormat="HTML">
<#import "../../../../../../freemarker/_localization.ftl" as loc>

<div class="selectable-loan-card">

    <div class="panel panel-default">

        <div class="panel-heading">
            <span>{{$ctrl.loan.state | loc}}</span>
            <span>#</span><span>{{$ctrl.loan.loanRealizationId}}</span>
            <span> - {{$ctrl.loan.document | loc}}</span>
        </div>

        <div class="panel-body">
            <div class="row">
                <div class="col-lg-12">
                    <span>Uživatel: </span><a ui-sref="user({userId: $ctrl.loan.user.id})" target="_blank" ng-click="$event.stopPropagation()">{{$ctrl.loan.user | loc}}</a>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-6">
                    <div ng-show="$ctrl.loan.exemplar.accessNumber"><small class="text-muted">${loc.loc('exemplar.AccessNumber.abbr')} </small> <small>{{$ctrl.loan.exemplar.accessNumber}}</small></div>
                    <div ng-show="$ctrl.loan.exemplar.barCode"><small class="text-muted">${loc.loc('exemplar.BarCode.abbr')} </small> <small>{{$ctrl.loan.exemplar.barCode}}</small></div>
                    <div ng-show="$ctrl.loan.exemplar.signature"><small class="text-muted">${loc.loc('exemplar.Signature.abbr')} </small> <small>{{$ctrl.loan.exemplar.signature}}</small></div>
                </div>
                <div class="col-sm-6">
                    <div class="" ng-show="$ctrl.loan.department"><small class="text-muted">${loc.loc('department.Department.abbr')} </small>{{$ctrl.loan.department | loc}}</div>
                    <div class="" ng-show="$ctrl.loan.lendDate"><small class="text-muted">${loc.loc('loan.LoanDate.abbr')} </small>{{$ctrl.loan.lendDate | jpDate:'d.M.yyyy'}}</div>
                    <div class="" ng-show="$ctrl.loan.endDate"><small class="text-muted">${loc.loc('loan.EndDate.abbr')} </small>{{$ctrl.loan.endDate | jpDate:'d.M.yyyy'}}</div>
                </div>
            </div>

        </div>
    </div>

</div>